/*	$OpenBSD: asinh.c,v 1.1 2009/04/09 01:24:43 martynas Exp $	*/

/*
 * Copyright (c) 2009 Gaston H. Gonnet <gonnet@inf.ethz.ch>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* This program was generated automatically by a program written
   by Gaston H. Gonnet on enigma on 2002-09-01 17:26:21.
   Do not edit, rerun the original maple program.       */
#include "header.h"
#define DBL_MAX_EXP 1024
#define N 1042
#define F asinh
#define Fs "asinh"
#define Fn fpaccuracy_asinh

static struct input_point { double arg_m, val, eps;
	int arg_e, val_e; } input_points[N] = {
 -8049513536839553.,-8457992901755234.,-.499998377437422951383,-43,50,
 -8049513536834720.,-8457992901754559.,.499982993084000931896,-43,50,
 -8049513536834098.,-8457992901754471.,-.499812493651608759430,-43,50,
 -8049513536834012.,-8457992901754459.,-.470845310145070802963,-43,50,
 -8049513536834005.,-8457992901754458.,-.491743330092207406303,-43,50,
 -8049513536833955.,-8457992901754451.,-.498157758286015525938,-43,50,
 -7986428235692289.,-8449134294088925.,-.499999315314612273724,-43,50,
 -7986428235649445.,-8449134294082886.,.499976648961511308181,-43,50,
 -7986428235638734.,-8449134294081376.,.499970645093378129567,-43,50,
 -7986428235635315.,-8449134294080894.,.498848385485675354254,-43,50,
 -7986428235635279.,-8449134294080888.,-.425995253397660123464,-43,50,
 -7986428235635251.,-8449134294080884.,-.478651416973571901056,-43,50,
 -7986428235635088.,-8449134294080861.,-.499471226361640683681,-43,50,
 -7986428235634556.,-8449134294080786.,-.499938334299804306260,-43,50,
 -7815961442923339.,-8424842288088658.,.499956602326580262630,-43,50,
 -7815961442923096.,-8424842288088622.,-.495584112167520932846,-43,50,
 -7815961442923075.,-8424842288088619.,-.470507383790416860743,-43,50,
 -7815961442923047.,-8424842288088615.,-.437071745954265454702,-43,50,
 -7815961442922860.,-8424842288088588.,-.499483736119598067774,-43,50,
 -7815961442919750.,-8424842288088141.,.499974609353584322852,-43,50,
 -7815961442916161.,-8424842288087624.,.499992616617988570897,-43,50,
 -6688361407871022.,-8249428261093779.,-.499989896804883379080,-43,50,
 -6688361407870024.,-8249428261093611.,-.499628255251940449693,-43,50,
 -6688361407869727.,-8249428261093562.,.496471351507633179399,-43,50,
 -6688361407869715.,-8249428261093559.,-.483484219936377789151,-43,50,
 -6688361407869685.,-8249428261093554.,-.433373148546389354300,-43,50,
 -6688361407869626.,-8249428261093545.,.498511958520653981084,-43,50,
 -6593216446354147.,-8233296828062500.,-.499943868904088085418,-43,50,
 -6593216446352806.,-8233296828062272.,.497608952365089370266,-43,50,
 -6593216446352794.,-8233296828062269.,-.453195944088667463624,-43,50,
 -6593216446352724.,-8233296828062257.,-.499557840068841327593,-43,50,
 -6593216446352033.,-8233296828062140.,.499926872476537937141,-43,50,
 -6593216446338617.,-8233296828059848.,-.499947360226206133294,-43,50,
 -6593216446144492.,-8233296828026698.,-.499990474691957466345,-43,50,
 -6319743896468655.,-8185600797170068.,-.498743624412731123481,-43,50,
 -6319743896468610.,-8185600797170060.,-.481734143854571357491,-43,50,
 -6319743896468481.,-8185600797170037.,-.499640299587530315347,-43,50,
 -6319743896450609.,-8185600797166853.,-.499786149777286863662,-43,50,
 -6319743896424918.,-8185600797162276.,-.499995793650098637918,-43,50,
 -5890506482728112.,-8106408795123866.,-.499800717563959350665,-43,50,
 -5890506482727777.,-8106408795123802.,-.468626254601300188140,-43,50,
 -5890506482727772.,-8106408795123802.,.487062916487722305859,-43,50,
 -5890506482727751.,-8106408795123797.,-.499042564938374360938,-43,50,
 -5890506482726961.,-8106408795123647.,.499846467137907612869,-43,50,
 -5890506482721635.,-8106408795122629.,.499951511765477248180,-43,50,
 -5890506482718972.,-8106408795122119.,-.499995965575573018031,-43,50,
 -5703853854996304.,-8070154946620235.,.499989717731483294573,-43,50,
 -5703853854990321.,-8070154946619054.,.499942367778425507008,-43,50,
 -5703853854989784.,-8070154946618948.,.499770977746280796721,-43,50,
 -5703853854989475.,-8070154946618887.,.494085764492084007298,-43,50,
 -5703853854989455.,-8070154946618883.,.441937854249207780216,-43,50,
 -5703853854989247.,-8070154946618842.,.499599587724115615020,-43,50,
 -5703853854955497.,-8070154946612179.,-.499998927165243440432,-43,50,
 -5176976928861494.,-7961031992803924.,.499858016574962574587,-43,50,
 -5176976928861356.,-7961031992803893.,-.487653033347752385742,-43,50,
 -5176976928861264.,-7961031992803873.,-.479327066629117900902,-43,50,
 -5176976928861255.,-7961031992803872.,.478009169245550218016,-43,50,
 -5176976928854767.,-7961031992802461.,.499953431780588984430,-43,50,
 -5176976928851884.,-7961031992801834.,.499994324593518790676,-43,50,
 -5162726732165711.,-7957928561101458.,-.499993294037675983250,-43,50,
 -5162726732160424.,-7957928561100305.,-.499945726885506055192,-43,50,
 -5162726732158975.,-7957928561099989.,-.498986974115806583363,-43,50,
 -5162726732158920.,-7957928561099978.,.495528368468641334330,-43,50,
 -5162726732158599.,-7957928561099908.,.499881549736786554763,-43,50,
 -4714366116129085.,-7855640256670336.,-.499994080238576206793,-43,50,
 -4714366116089093.,-7855640256660786.,.499990009006871938561,-43,50,
 -4714366116088176.,-7855640256660566.,-.499535259850950718123,-43,50,
 -4714366116088155.,-7855640256660561.,-.484257212572386654193,-43,50,
 -8805554747255301.,-7778652598475765.,-.499499859184161891244,-44,50,
 -8805554747255129.,-7778652598475744.,.492799667518490193929,-44,50,
 -8805554747255082.,-7778652598475737.,-.497676624603384796857,-44,50,
 -8805554747254777.,-7778652598475698.,-.499703626670091974858,-44,50,
 -8805554747254253.,-7778652598475631.,-.499907394152035057755,-44,50,
 -8805554747219708.,-7778652598471214.,-.499982094638414445396,-44,50,
 -8805554747209838.,-7778652598469953.,.499996565548212768592,-44,50,
 -7326121376011185.,-7571558996803307.,.499998670971317895715,-44,50,
 -7326121375985333.,-7571558996799333.,-.499967589902990600786,-44,50,
 -7326121375981572.,-7571558996798756.,.499921274519533109797,-44,50,
 -7326121375981097.,-7571558996798683.,.499109578343003298781,-44,50,
 -7326121375981045.,-7571558996798675.,.490599666340807465044,-44,50,
 -7326121375980876.,-7571558996798649.,.462942452334062744384,-44,50,
 -7326121375980635.,-7571558996798611.,-.499574639828365241327,-44,50,
 -7326121375975462.,-7571558996797816.,-.499993385411129189145,-44,50,
 -7309643749936985.,-7569023821944676.,.499992678062403470240,-44,50,
 -7309643749920183.,-7569023821942088.,.494167925882756729606,-44,50,
 -7309643749920170.,-7569023821942086.,.496544088140842753263,-44,50,
 -7309643749920157.,-7569023821942084.,.498920250398932338070,-44,50,
 -7309643749919735.,-7569023821942019.,.499131056009620636438,-44,50,
 -7309643749918047.,-7569023821941759.,.499974278489899502867,-44,50,
 -7309643749884800.,-7569023821936638.,.499994798903673640631,-44,50,
 -5313564293881324.,-7209940121267594.,.499996394383468562657,-44,50,
 -5313564293865042.,-7209940121264143.,-.499062971079767433376,-44,50,
 -5313564293864976.,-7209940121264130.,.485709297820226410319,-44,50,
 -5313564293864971.,-7209940121264128.,-.454838257566130614292,-44,50,
 -5313564293864924.,-7209940121264118.,-.495985278197837916132,-44,50,
 -5313564293864773.,-7209940121264087.,.499478549134932616022,-44,50,
 -5313564293862805.,-7209940121263670.,.499960749157764477174,-44,50,
 -5016941336691976.,-7145266104836713.,.499995808628173511229,-44,50,
 -5016941336680288.,-7145266104834089.,-.499987945882430006979,-44,50,
 -5016941336665463.,-7145266104830763.,.499947110767919096293,-44,50,
 -5016941336662353.,-7145266104830065.,.440574297592673491050,-44,50,
 -5016941336662326.,-7145266104830059.,.499865916258319735896,-44,50,
 -5010586419820424.,-7143839041775667.,-.499963382882730113331,-44,50,
 -5010586419818319.,-7143839041775195.,.499501685401434675203,-44,50,
 -5010586419818159.,-7143839041775159.,.451955087274390228258,-44,50,
 -5010586419818141.,-7143839041775155.,.496606094985169569767,-44,50,
 -5010586419816975.,-7143839041774892.,-.499889738830057794424,-44,50,
 -5010586419807300.,-7143839041772718.,-.499973091677482373869,-44,50,
 -5010586419767928.,-7143839041763872.,.499997828282774890407,-44,50,
 -4928523203117215.,-7125246533553625.,.497643240891611087017,-44,50,
 -4928523203117158.,-7125246533553611.,-.481035115352005657718,-44,50,
 -4928523203117018.,-7125246533553579.,-.498841604370776027721,-44,50,
 -4928523203116786.,-7125246533553526.,-.499778071885595365353,-44,50,
 -4928523203115661.,-7125246533553270.,.499991212830078991824,-44,50,
 -4928523203111393.,-7125246533552294.,-.499995180266263950638,-44,50,
 -4893070997072180.,-7117118412618844.,-.499998724786081073949,-44,50,
 -4893070997051050.,-7117118412613982.,-.499981460109267506732,-44,50,
 -4893070997032684.,-7117118412609756.,-.494665916169921725753,-44,50,
 -4893070997032671.,-7117118412609754.,.496626096362713979670,-44,50,
 -4893070997032558.,-7117118412609728.,.497856666839036035870,-44,50,
 -4893070997032332.,-7117118412609675.,-.499682192206518467030,-44,50,
 -4893070997030724.,-7117118412609305.,-.499870180390504331324,-44,50,
 -4893070997029920.,-7117118412609120.,-.499964174436900744880,-44,50,
 -6151338406595080.,-6594371338568627.,-.499997952687017514637,-45,50,
 -6151338406593430.,-6594371338568325.,-.499955782038347388183,-45,50,
 -6151338406584355.,-6594371338566664.,-.499723842022713009112,-45,50,
 -6151338406583530.,-6594371338566513.,-.499702756445240064141,-45,50,
 -6151338406583481.,-6594371338566505.,.468783344395756048428,-45,50,
 -6151338406583459.,-6594371338566501.,.495450573344797948760,-45,50,
 -5862093320205521.,-6540145638572425.,-.499996061725090632946,-45,50,
 -5862093320179170.,-6540145638567365.,.499965182054256392605,-45,50,
 -5862093320177608.,-6540145638567065.,.499279799397188173993,-45,50,
 -5862093320177603.,-6540145638567064.,.459584903806224751597,-45,50,
 -5862093320177457.,-6540145638567035.,-.499506047449546046460,-45,50,
 -5862093320176676.,-6540145638566885.,-.499848738744241151517,-45,50,
 -5862093320173401.,-6540145638566257.,.499994649450145144161,-45,50,
 -7736772544919273.,-6072156728456010.,.499989686399102492935,-46,50,
 -7736772544892232.,-6072156728452074.,-.499986355566888991522,-46,50,
 -7736772544890837.,-6072156728451871.,-.499911157477157307325,-46,50,
 -7736772544890315.,-6072156728451796.,.461407303752926467564,-46,50,
 -7736772544890301.,-6072156728451794.,.498684044092501195063,-46,50,
 -5060143069587560.,-5594142191504750.,.499971721284396965116,-46,50,
 -5060143069584562.,-5594142191504082.,-.498812562152648132814,-46,50,
 -5060143069584544.,-5594142191504078.,-.494135483132731363465,-46,50,
 -5060143069584400.,-5594142191504046.,-.456718850972884470404,-46,50,
 -5060143069584382.,-5594142191504042.,-.452041771952839516488,-46,50,
 -5060143069584135.,-5594142191503987.,-.498972965398561757088,-46,50,
 -5060143069581573.,-5594142191503417.,-.499935384705728330628,-46,50,
 -5060143069575159.,-5594142191501991.,.499997107802392191811,-46,50,
 -4942874542602395.,-8015541920850406.,.499996391422665143491,-48,51,
 -4942874542597890.,-8015541920848356.,-.499994125711181977764,-48,51,
 -4942874542575365.,-8015541920838111.,-.499946683458684265189,-48,51,
 -4942874542575044.,-8015541920837966.,.499832017386534638387,-48,51,
 -4942874542574723.,-8015541920837820.,.499610718241204407625,-48,51,
 -4916353069589487.,-8003446840592745.,-.499996545027703602892,-48,51,
 -4916353069560196.,-8003446840579352.,.499988498365053253079,-48,51,
 -4916353069549266.,-8003446840574353.,-.499948781988448713052,-48,51,
 -4916353069549137.,-8003446840574295.,.488341070853013370848,-48,51,
 -4916353069549126.,-8003446840574289.,-.481649716889116152458,-48,51,
 -4916353069549067.,-8003446840574263.,.497490603403289662173,-48,51,
 -5263775657351826.,-6600943044222433.,.499974181708568408034,-49,51,
 -5263775657348751.,-6600943044221124.,-.499482737748511128323,-49,51,
 -5263775657348617.,-6600943044221068.,.499565318461431462514,-49,51,
 -5263775657346567.,-6600943044220196.,.499927372598364087275,-49,51,
 -5263775657335024.,-6600943044215285.,-.499985210937221070010,-49,51,
 -5263775657290902.,-6600943044196517.,-.499997502215075129364,-49,51,
 -5153546050517367.,-6553562956347260.,-.499879143233061026518,-49,51,
 -5153546050516994.,-6553562956347098.,-.484328147247438672876,-49,51,
 -5153546050516987.,-6553562956347095.,-.443821828287812196844,-49,51,
 -5153546050516948.,-6553562956347079.,.496141948773038594576,-49,51,
 -5153546050516750.,-6553562956346993.,.499034970776235295452,-49,51,
 -5153546050514602.,-6553562956346059.,-.499883153948925775505,-49,51,
 -5153546050462067.,-6553562956323240.,-.499959236564643470900,-49,51,
 -5153546050434417.,-6553562956311230.,-.499999187715398479993,-49,51,
 -4896645647483411.,-6439134606258295.,.499999666630194560633,-49,51,
 -4896645647468426.,-6439134606251449.,.494635442612508681492,-49,51,
 -4896645647468345.,-6439134606251411.,-.499988147731400476401,-49,51,
 -4837866588197715.,-6412120679870855.,-.499996114369096437314,-49,51,
 -4837866588170914.,-6412120679858465.,.499961661212017298023,-49,51,
 -4837866588169560.,-6412120679857839.,.499511785323225597457,-49,51,
 -4837866588169028.,-6412120679857593.,.460930297945980653502,-49,51,
 -4837866588169002.,-6412120679857581.,.481601127510934608858,-49,51,
 -4837866588168976.,-6412120679857568.,-.497728042924047696513,-49,51,
 -4837866588168883.,-6412120679857526.,.499286847443652727852,-49,51,
 -4837866588166560.,-6412120679856452.,.499992120011127270590,-49,51,
 -4716555872204105.,-6355329303928547.,.499956409212763123726,-49,51,
 -4716555872202563.,-6355329303927815.,-.499767932270604650892,-49,51,
 -4716555872202428.,-6355329303927752.,.498310675976504922269,-49,51,
 -4716555872202314.,-6355329303927697.,-.458867388168973829028,-49,51,
 -4716555872202312.,-6355329303927697.,.489252294916204705792,-49,51,
 -4716555872202293.,-6355329303927688.,.496389284225420556634,-49,51,
 -4716555872200462.,-6355329303926820.,.499959148876114212538,-49,51,
 -4716555872182247.,-6355329303918185.,.499972866920482138742,-49,51,
 -4716555872145817.,-6355329303900914.,-.499999598352719597326,-49,51,
 -4707537845203007.,-6351050184878840.,-.499997075745459014972,-49,51,
 -4707537845168429.,-6351050184862417.,-.499580299865471196408,-49,51,
 -4707537845168389.,-6351050184862399.,.498627134729258219686,-49,51,
 -4707537845168229.,-6351050184862323.,.491456873109767404228,-49,51,
 -4707537845168170.,-6351050184862294.,-.486187160861777207968,-49,51,
 -4707537845166193.,-6351050184861355.,-.499784705775885228613,-49,51,
 -4707537845163957.,-6351050184860293.,-.499989111188979446715,-49,51,
 -8956367348707684.,-6239414756929438.,-.499993037358492825778,-50,51,
 -8956367348676460.,-6239414756921650.,.499989847039090657836,-50,51,
 -8956367348675542.,-6239414756921420.,-.499818495885978551081,-50,51,
 -8956367348675081.,-6239414756921306.,.499188425595006009345,-50,51,
 -8956367348675053.,-6239414756921299.,.483943726682975862414,-50,51,
 -8956367348675045.,-6239414756921297.,.479588098422399768772,-50,51,
 -8772453526432969.,-6193066425573640.,.498893314401061142710,-50,51,
 -8772453526432938.,-6193066425573632.,.391538814216170236346,-50,51,
 -8772453526432914.,-6193066425573625.,-.498025960120500652960,-50,51,
 -8772453526432643.,-6193066425573557.,.498971796329065203663,-50,51,
 -8772453526429057.,-6193066425572644.,.499835097737383316647,-50,51,
 -8772453526428405.,-6193066425572478.,.499992061669252591017,-50,51,
 -8298192411077068.,-6068990242780960.,-.499997642287870610939,-50,51,
 -8298192411061880.,-6068990242776877.,.499979294882313250828,-50,51,
 -8298192411035301.,-6068990242769730.,.499938952591379155063,-50,51,
 -8298192411034375.,-6068990242769481.,.498093986784105354658,-50,51,
 -8298192411034282.,-6068990242769455.,-.494531911508206049585,-50,51,
 -8298192411034256.,-6068990242769449.,.496776977141304501443,-50,51,
 -8298192411033806.,-6068990242769327.,-.499799950075297433559,-50,51,
 -7900377053080465.,-5959420236766677.,.499998565566729879679,-50,51,
 -7900377053043066.,-5959420236756124.,.499993522176866060090,-50,51,
 -7900377053038023.,-5959420236754700.,-.499953676777944565170,-50,51,
 -7900377053036974.,-5959420236754405.,.499859011871762028681,-50,51,
 -7900377053035280.,-5959420236753926.,-.498536894078746007977,-50,51,
 -7900377053035273.,-5959420236753925.,.476676345979518149096,-50,51,
 -7900377053035078.,-5959420236753869.,-.499526252396719470847,-50,51,
 -7846976255503947.,-5944301825548779.,.499997334048302975539,-50,51,
 -7846976255472953.,-5944301825539974.,-.499987004082306891457,-50,51,
 -7846976255461272.,-5944301825536656.,-.453778601801325446628,-50,51,
 -7846976255461251.,-5944301825536650.,-.488624045128197475192,-50,51,
 -7846976255461244.,-5944301825536649.,.499760807096181991257,-50,51,
 -7846976255460297.,-5944301825536380.,.499825815181826155259,-50,51,
 -7846976255457456.,-5944301825535572.,-.499979160370387378896,-50,51,
 -7688073522783041.,-5898710965378458.,-.499991135121175836485,-50,51,
 -7688073522778814.,-5898710965377233.,-.498544511868831053744,-50,51,
 -7688073522778745.,-5898710965377214.,.497930486245087026939,-50,51,
 -7688073522778500.,-5898710965377143.,.499906928824911310656,-50,51,
 -7668040568186134.,-5892897917711304.,.499998801945632644399,-50,51,
 -7668040568136276.,-5892897917696818.,.499983680983218283760,-50,51,
 -7668040568133378.,-5892897917695976.,.499822349217314591641,-50,51,
 -7668040568132077.,-5892897917695598.,.499059791476169018409,-50,51,
 -7668040568131929.,-5892897917695555.,.499741683451176438976,-50,51,
 -6448237341710964.,-5507693984738736.,-.499990190296234193578,-50,51,
 -6448237341697473.,-5507693984734095.,-.499587593427808336353,-50,51,
 -6448237341697348.,-5507693984734052.,-.498694381271339271915,-50,51,
 -6448237341697255.,-5507693984734021.,.493970168573598511384,-50,51,
 -6448237341697252.,-5507693984734019.,-.474008394334621847081,-50,51,
 -6448237341697223.,-5507693984734009.,-.497801169114061290643,-50,51,
 -6448237341695287.,-5507693984733343.,-.499967099118854930198,-50,51,
 -6448237341674020.,-5507693984726027.,-.499999541620287920097,-50,51,
 -5630902860407256.,-5207698589898891.,.499997148641001459044,-50,51,
 -5630902860361897.,-5207698589881103.,-.499896676429481702130,-50,51,
 -5630902860360854.,-5207698589880694.,-.499673769973165428845,-50,51,
 -5630902860360803.,-5207698589880675.,.499378356806528271426,-50,51,
 -5630902860360604.,-5207698589880596.,-.465104521051432561102,-50,51,
 -5630902860360599.,-5207698589880595.,.495586863927044785291,-50,51,
 -5630902860357674.,-5207698589879447.,-.499952923376761900578,-50,51,
 -5630902860353451.,-5207698589877792.,.499990830870161427301,-50,51,
 -4917964729984043.,-4909626108725700.,-.499992782478341728421,-50,51,
 -4917964729963605.,-4909626108716579.,.496850354123900349492,-50,51,
 -4917964729963596.,-4909626108716574.,-.486221786575209808181,-50,51,
 -4917964729963578.,-4909626108716566.,-.452366067973409168574,-50,51,
 -4917964729963484.,-4909626108716524.,-.497786204163551890651,-50,51,
 -4917964729962776.,-4909626108716208.,-.499461272464825083300,-50,51,
 -4917964729962599.,-4909626108716129.,-.499880039533389289620,-50,51,
 -4917964729960177.,-4909626108715048.,-.499960569431820842410,-50,51,
 -4831850099959063.,-4870867728729063.,.499997047177905715112,-50,51,
 -4831850099955139.,-4870867728727281.,-.499995187599101301069,-50,51,
 -4831850099948375.,-4870867728724211.,-.498962431073687463619,-50,51,
 -4831850099948342.,-4870867728724197.,.478866380433250103542,-50,51,
 -4831850099948331.,-4870867728724192.,.471475984268917520517,-50,51,
 -4831850099947833.,-4870867728723965.,-.499471042068665473900,-50,51,
 -4831850099947291.,-4870867728723719.,-.499979653037470259348,-50,51,
 -4681019096835127.,-4801376171896567.,-.499993994886150589586,-50,51,
 -4681019096820370.,-4801376171889665.,-.499634410528710374564,-50,51,
 -4681019096820355.,-4801376171889658.,-.483980456885030496073,-50,51,
 -4681019096820340.,-4801376171889651.,-.468326503241329365862,-50,51,
 -4681019096818326.,-4801376171888709.,-.499855660487406163075,-50,51,
 -4681019096816793.,-4801376171887993.,.499978402302537939911,-50,51,
 -4531746129751087.,-4730486380021339.,.499984828095256624130,-50,51,
 -4531746129746050.,-4730486380018909.,-.486548813431601383565,-50,51,
 -4531746129746048.,-4730486380018909.,.477919507537128050969,-50,51,
 -4531746129746021.,-4730486380018896.,.498241840615014655615,-50,51,
 -4531746129745233.,-4730486380018516.,.498760302327740579199,-50,51,
 -4531746129743460.,-4730486380017661.,.499926841408919405689,-50,51,
 -4531746129735636.,-4730486380013888.,.499998476176339429766,-50,51,
 -7166361094597619.,-8442591155485561.,.499035336844431225757,-51,52,
 -7166361094597614.,-8442591155485558.,.496713566860577453893,-51,52,
 -7166361094597459.,-8442591155485465.,.424738697362054686662,-51,52,
 -7166361094597424.,-8442591155485444.,.408486307475544653243,-51,52,
 -7166361094596760.,-8442591155485045.,-.499844746353718435140,-51,52,
 -7166361094593314.,-8442591155482980.,.499991381451084784068,-51,52,
 -6982521428629155.,-8331066694058304.,.499960785616771840900,-51,52,
 -6982521428628202.,-8331066694057719.,.499848750489670407844,-51,52,
 -6982521428626801.,-8331066694056858.,-.495069361879617319869,-51,52,
 -6982521428626788.,-8331066694056851.,.484992068912834238648,-51,52,
 -6982521428626498.,-8331066694056672.,-.498252936482824720557,-51,52,
 -6982521428626296.,-8331066694056549.,.499624680452431917374,-51,52,
 -6982521428620679.,-8331066694053100.,-.499986336437591276751,-51,52,
 -6982521428584869.,-8331066694031118.,-.499998831195783956248,-51,52,
 -5383107157246921.,-7231919413599899.,-.493025076719990526685,-51,52,
 -5383107157246864.,-7231919413599855.,-.499780959289457665780,-51,52,
 -5383107157246566.,-7231919413599626.,.499986531845045809841,-51,52,
 -5383107157237981.,-7231919413593000.,.499999661966705470065,-51,52,
 -8553544359437601.,-6294490081681967.,-.499304544674754699017,-52,52,
 -8553544359437513.,-6294490081681927.,.498743422998671935551,-52,52,
 -8553544359437367.,-6294490081681858.,-.481767903360596322539,-52,52,
 -8553544359437352.,-6294490081681851.,-.493464272507044992208,-52,52,
 -8553544359437337.,-6294490081681845.,.494839358346515933247,-52,52,
 -8553544359435549.,-6294490081681011.,-.499367843840283050063,-52,52,
 -8553544359417081.,-6294490081672407.,-.499937528249592608625,-52,52,
 -8553544359415029.,-6294490081671452.,.499999174380533618297,-52,52,
 -8099766831127673.,-6078583505707359.,.499995915044406274476,-52,52,
 -8099766831126463.,-6078583505706771.,.499962323377924166617,-52,52,
 -8099766831116783.,-6078583505702067.,.499693592461539273888,-52,52,
 -8099766831116178.,-6078583505701773.,.499676796921845160775,-52,52,
 -8099766831115929.,-6078583505701651.,-.498677223055734911287,-52,52,
 -8099766831115894.,-6078583505701634.,-.490413731887697117219,-52,52,
 -8099766831115892.,-6078583505701634.,.481487039036192452355,-52,52,
 -7588440847589921.,-5823946931908695.,-.499617342763824095539,-52,52,
 -7588440847589680.,-5823946931908573.,.499085239871852003888,-52,52,
 -7588440847589586.,-5823946931908525.,.473682927705637415994,-52,52,
 -7588440847589584.,-5823946931908524.,.494419048723382305940,-52,52,
 -7588440847589053.,-5823946931908253.,.499859178941689006944,-52,52,
 -7588440847583700.,-5823946931905520.,-.499912916209867444883,-52,52,
 -7588440847568268.,-5823946931897645.,.499996867149127039728,-52,52,
 -7221316242094492.,-5633159563017300.,-.499981118126766775249,-52,52,
 -7221316242030058.,-5633159562983203.,-.499892424243953950033,-52,52,
 -7221316242029304.,-5633159562982805.,.499674061753087206649,-52,52,
 -7221316242028807.,-5633159562982541.,-.499285429556069038575,-52,52,
 -7221316242025294.,-5633159562980682.,-.499978976405915145280,-52,52,
 -6207868236596493.,-5068246230465688.,-.499993940096122623418,-52,52,
 -6207868236509438.,-5068246230414568.,-.499974398764487680498,-52,52,
 -6207868236499176.,-5068246230408542.,-.499857194386192171285,-52,52,
 -6207868236498677.,-5068246230408249.,-.479582541619450401034,-52,52,
 -6207868236498660.,-5068246230408239.,-.496927894130131265254,-52,52,
 -6207868236498597.,-5068246230408203.,.497615799506913472957,-52,52,
 -6207868236498253.,-5068246230408001.,.499568666354797820839,-52,52,
 -6207868236497158.,-5068246230407358.,.499970960585117058474,-52,52,
 -4503599627376596.,-7938707516159450.,.499980679927574738579,-52,53,
 -4503599627370855.,-7938707516151330.,-.499957739044789355998,-52,53,
 -4503599627370517.,-7938707516150852.,-.495773656948745994797,-52,53,
 -4503599627370497.,-7938707516150824.,-.211502409486879560797,-52,53,
 -9007199254740990.,-7938707516150821.,-.383075284740689463194,-53,53,
 -9007199254740986.,-7938707516150819.,.445351840005501262447,-53,53,
 -9007199254740976.,-7938707516150811.,-.483580348129019175791,-53,53,
 -9007199254740894.,-7938707516150754.,.499175709168061290383,-53,53,
 -9007199254619348.,-7938707516064807.,-.499997900313343486584,-53,53,
 -8871213671119477.,-7842187351465019.,-.499999833264849990682,-53,53,
 -8871213671078609.,-7842187351435902.,-.499980274038145244031,-53,53,
 -8871213671077903.,-7842187351435400.,.499971126385946561451,-53,53,
 -8871213671077823.,-7842187351435343.,.497132758163290915408,-53,53,
 -8871213671077771.,-7842187351435305.,-.454712181181299535566,-53,53,
 -8871213671077750.,-7842187351435290.,-.492957252839661521718,-53,53,
 -8108579655013549.,-7287186729325581.,.499962404918949877161,-53,53,
 -8108579655010862.,-7287186729323584.,.499769968664462151344,-53,53,
 -8108579655010714.,-7287186729323474.,.494549097602856042576,-53,53,
 -8108579655009721.,-7287186729322735.,-.499939584564271190309,-53,53,
 -8108579655003206.,-7287186729317894.,.499965991143294964375,-53,53,
 -8108579654910119.,-7287186729248711.,.499998464678217928110,-53,53,
 -7881394195513142.,-7117278534572360.,-.499990543475111041497,-53,53,
 -7881394195508575.,-7117278534568924.,.499838116265221039343,-53,53,
 -7881394195508090.,-7117278534568559.,.497630299362600914194,-53,53,
 -7881394195507993.,-7117278534568486.,.497188735983245671742,-53,53,
 -7881394195507989.,-7117278534568482.,-.492520194465379170010,-53,53,
 -7881394195507961.,-7117278534568461.,-.420482707605734512141,-53,53,
 -7881394195506340.,-7117278534567242.,.499973228145462737343,-53,53,
 -7881394195483699.,-7117278534550203.,.499999668477296813488,-53,53,
 -7552125243356088.,-6867226039586465.,.499998000520535593851,-53,53,
 -7552125243337608.,-6867226039572304.,.499911017801313440635,-53,53,
 -7552125243332328.,-6867226039568258.,.499886168223158906357,-53,53,
 -7552125243332067.,-6867226039568057.,-.498978696470019135657,-53,53,
 -7552125243331960.,-6867226039567976.,.493823830265786158925,-53,53,
 -7109328173648671.,-6523792058321349.,.499949160504041237057,-53,53,
 -7109328173647927.,-6523792058320764.,-.496236421031280552662,-53,53,
 -7109328173647741.,-6523792058320618.,-.495282816411445416199,-53,53,
 -7109328173647713.,-6523792058320597.,.483355360628226633356,-53,53,
 -7109328173633972.,-6523792058309810.,-.499959253143420067706,-53,53,
 -7109328173497654.,-6523792058202807.,-.499993862252244594802,-53,53,
 -7006352136063411.,-6442736009157264.,.499997082793832953262,-53,53,
 -7006352135993091.,-6442736009101759.,.499981357614951965897,-53,53,
 -7006352135985544.,-6442736009095802.,.499908578883131687917,-53,53,
 -7006352135983147.,-6442736009093909.,-.499452020931407721738,-53,53,
 -7006352135983109.,-6442736009093880.,.494717481451469707188,-53,53,
 -7006352135983033.,-6442736009093820.,.483056486217408540797,-53,53,
 -7006352135983019.,-6442736009093808.,-.466460012904628602797,-53,53,
 -7006352135979027.,-6442736009090658.,.499978237779789936556,-53,53,
 -6828286958433415.,-6301511571394747.,.499914227655678479173,-53,53,
 -6828286958433351.,-6301511571394695.,-.498867411341382035427,-53,53,
 -6828286958433031.,-6301511571394440.,-.492775606324067720267,-53,53,
 -6828286958433026.,-6301511571394437.,.491694578129362422379,-53,53,
 -6828286958433006.,-6301511571394421.,.429575315943093641109,-53,53,
 -6828286958430131.,-6301511571392130.,.499931376844208020077,-53,53,
 -6828286958416995.,-6301511571381662.,.499999978191789491939,-53,53,
 -6595469068503650.,-6114824937364083.,-.499994077970364273509,-53,53,
 -6595469068461621.,-6114824937330173.,-.499990794640123736072,-53,53,
 -6595469068459628.,-6114824937328566.,.499961776736773086016,-53,53,
 -6595469068453649.,-6114824937323742.,.499819491885042688790,-53,53,
 -6595469068453473.,-6114824937323599.,-.499181184147007854580,-53,53,
 -6595469068453416.,-6114824937323554.,.489778824183804763489,-53,53,
 -6595469068453406.,-6114824937323545.,-.441982577863406789331,-53,53,
 -6595469068453385.,-6114824937323528.,-.498681522162537152220,-53,53,
 -6056160701838673.,-5673485487638135.,.499998380760070142529,-53,53,
 -6056160701828458.,-5673485487629657.,-.481962206219358094034,-53,53,
 -6056160701828452.,-5673485487629653.,.497196700926161812888,-53,53,
 -6056160701828405.,-5673485487629613.,-.499391859767212448489,-53,53,
 -6056160701828117.,-5673485487629374.,-.499764316779873355200,-53,53,
 -6056160701827829.,-5673485487629136.,.499863226211004220450,-53,53,
 -6056160701822551.,-5673485487624756.,.499981879288513684810,-53,53,
 -5587044502249112.,-5279501853760305.,-.499990748557556971152,-53,53,
 -5587044502246988.,-5279501853758501.,.461660190493951790820,-53,53,
 -5587044502246975.,-5279501853758489.,-.491022736902980192575,-53,53,
 -5587044502246935.,-5279501853758455.,-.499277898124264575257,-53,53,
 -5587044502246449.,-5279501853758042.,-.499578106957468068291,-53,53,
 -5587044502245963.,-5279501853757629.,-.499878315780689608136,-53,53,
 -5587044502222462.,-5279501853737658.,-.499991899660160545862,-53,53,
 -5574097035223585.,-5268495637054045.,.499695326420762061174,-53,53,
 -5574097035223545.,-5268495637054010.,-.486677003862872197227,-53,53,
 -5574097035223438.,-5268495637053920.,.499777012628738396247,-53,53,
 -5574097035222997.,-5268495637053544.,-.499977928741855383511,-53,53,
 -5574097035210816.,-5268495637043187.,.499988195060783863546,-53,53,
 -5574097035186307.,-5268495637022345.,-.499997852090911720232,-53,53,
 -5292230209317053.,-5027139926275839.,-.499961232675768627532,-53,53,
 -5292230209316770.,-5027139926275596.,.499869708658931197556,-53,53,
 -5292230209316516.,-5027139926275377.,.496184405124728653624,-53,53,
 -5292230209316509.,-5027139926275370.,-.468484087492317476048,-53,53,
 -5292230209316487.,-5027139926275352.,.499700649996979453443,-53,53,
 -5292230209311081.,-5027139926270690.,-.499995219065096488921,-53,53,
 -5268565944194047.,-5006725126043653.,.499726834852767341597,-53,53,
 -5268565944193857.,-5006725126043488.,-.496248306276407463662,-53,53,
 -5268565944193550.,-5006725126043224.,.499728702533848973206,-53,53,
 -5268565944185101.,-5006725126035931.,.499760454690646639643,-53,53,
 -5268565944125958.,-5006725125984880.,.499982803268577665708,-53,53,
 -5268565944121485.,-5006725125981019.,.499999625489829997374,-53,53,
 -4510984822817272.,-8681950456459860.,.499996479669963659347,-53,54,
 -4510984822804487.,-8681950456436996.,-.499991691142124981808,-53,54,
 -4510984822793884.,-8681950456418035.,-.499669004329898488515,-53,54,
 -4510984822793525.,-8681950456417394.,.488364179318510186278,-53,54,
 -4510984822793492.,-8681950456417334.,-.498808257838642821695,-53,54,
 -4510984822791702.,-8681950456414133.,-.499979848960575972625,-53,54,
 -8854767244026722.,-8532172044330444.,.499997178654182899654,-54,54,
 -8854767244014241.,-8532172044319243.,.499957046584608882376,-54,54,
 -8854767244014202.,-8532172044319207.,-.499722591672791728563,-54,54,
 -8854767244013578.,-8532172044318647.,-.494596803787121805940,-54,54,
 -8854767244013110.,-8532172044318227.,-.490752462867829737467,-54,54,
 -8854767244011111.,-8532172044316433.,-.499972895516496233854,-54,54,
 -8644717199277042.,-8343230238323457.,-.499991363375340637692,-54,54,
 -8644717199272572.,-8343230238319428.,.499540284219876353501,-54,54,
 -8644717199267655.,-8343230238314995.,.499025097025121175980,-54,54,
 -8644717199267614.,-8343230238314958.,.463226617735873844012,-54,54,
 -8644717199267594.,-8343230238314940.,.494544432716740711882,-54,54,
 -8644717199234191.,-8343230238284825.,.499993133908480676524,-54,54,
 -8607732457385214.,-8309872713771801.,-.499908296254837539098,-54,54,
 -8607732457383290.,-8309872713770065.,-.499349253092188741898,-54,54,
 -8607732457383116.,-8309872713769909.,.498622302789902406095,-54,54,
 -8607732457383106.,-8309872713769899.,-.478505768711108912767,-54,54,
 -8607732457378306.,-8309872713765568.,-.499980088971615829006,-54,54,
 -8607732457306821.,-8309872713701068.,-.499999157475200152077,-54,54,
 -7684108841960325.,-7468328964608132.,-.499996584996253722661,-54,54,
 -7684108841958155.,-7468328964606137.,.499987871836915321559,-54,54,
 -7684108841918010.,-7468328964569211.,.499700338901906467711,-54,54,
 -7684108841897395.,-7468328964550249.,.499552698394775180353,-54,54,
 -7684108841897183.,-7468328964550053.,-.499527160879970303961,-54,54,
 -7492339963690391.,-7291599651577146.,.499997083585069604376,-54,54,
 -7492339963689152.,-7291599651576001.,-.499967945323242090941,-54,54,
 -7492339963682957.,-7291599651570281.,-.499793089446319312610,-54,54,
 -7492339963682931.,-7291599651570257.,-.493335535570305569256,-54,54,
 -7298995560614378.,-7112741838357260.,.499994599642438684697,-54,54,
 -7298995560589797.,-7112741838334477.,-.499990411339797280821,-54,54,
 -7298995560588253.,-7112741838333047.,.499888485040357264130,-54,54,
 -7298995560586709.,-7112741838331616.,.499767381463198752929,-54,54,
 -7298995560586668.,-7112741838331578.,.499116497236666901038,-54,54,
 -7298995560586559.,-7112741838331476.,-.478223658389820176680,-54,54,
 -7298995560586545.,-7112741838331464.,.497163844557251946067,-54,54,
 -6300104505906038.,-6178271756513480.,.499966323258672780087,-54,54,
 -6300104505904718.,-6178271756512234.,.499389724321183079383,-54,54,
 -6300104505904611.,-6178271756512132.,-.499141863621745649139,-54,54,
 -6300104505902631.,-6178271756510264.,.499993238028823536290,-54,54,
 -6300104505864494.,-6178271756474264.,-.499998986022066404932,-54,54,
 -4924871031178034.,-4865499871834126.,-.499994543508059080305,-54,54,
 -4924871031072518.,-4865499871732345.,-.499962945626496389721,-54,54,
 -4924871031069015.,-4865499871728966.,-.497317745260591213827,-54,54,
 -4924871031066981.,-4865499871727004.,-.495781822390784872092,-54,54,
 -4698780735359664.,-4647068726804068.,.499996818366227444504,-54,54,
 -4698780735313949.,-4647068726759833.,.499972668059825002229,-54,54,
 -4698780735304806.,-4647068726750986.,.499967841288320028177,-54,54,
 -4698780735304528.,-4647068726750717.,.499858321252728047583,-54,54,
 -4698780735304343.,-4647068726750537.,-.489423193878309121237,-54,54,
 -4698780735304342.,-4647068726750537.,.478202311445308114041,-54,54,
 -4698780735304281.,-4647068726750477.,-.496641863814015727896,-54,54,
 -4698780735304250.,-4647068726750448.,.499748801218149878369,-54,54,
 -4517699360177115.,-8943273890877863.,-.499995074937339075684,-54,55,
 -4517699360174435.,-8943273890872664.,-.495068587029461566702,-54,55,
 -4517699360174385.,-8943273890872567.,-.498708018223476010155,-54,55,
 -4517699360173819.,-8943273890871469.,-.499906379335290147216,-54,55,
 -4514338150834686.,-8936753245913095.,-.499744033998992094641,-54,55,
 -4514338150834536.,-8936753245912804.,-.497855899685852657871,-54,55,
 -4514338150834336.,-8936753245912416.,-.495338387267444665724,-54,55,
 -4514338150834319.,-8936753245912384.,.484875601288166850371,-54,55,
 -4514338150834303.,-8936753245912352.,-.474922997718309724936,-54,55,
 -4514338150833119.,-8936753245910056.,.499980675820462648417,-54,55,
 -4514338150756853.,-8936753245762099.,.499983762730720215054,-54,55,
 -8341071156525238.,-8268302907373242.,.499999763389578711368,-55,55,
 -8341071156520775.,-8268302907368894.,.499959419569105202983,-55,55,
 -8341071156516312.,-8268302907364546.,.499919075866980535923,-55,55,
 -8341071156515303.,-8268302907363562.,-.499417851473874981859,-55,55,
 -8341071156515264.,-8268302907363525.,.495652376309900193635,-55,55,
 -8341071156515227.,-8268302907363488.,-.457742535792663721749,-55,55,
 -8341071156515225.,-8268302907363487.,.490722604093684406443,-55,55,
 -6979532375187906.,-6936599112831540.,.499999510544592876874,-55,55,
 -6979532375154375.,-6936599112798620.,-.499986218524630508603,-55,55,
 -6979532375143198.,-6936599112787647.,-.499981460276523112818,-55,55,
 -6979532375142595.,-6936599112787056.,.494203282447425881872,-55,55,
 -6979532375142592.,-6936599112787053.,.439447982659987466824,-55,55,
 -6979532375142431.,-6936599112786894.,-.499086439265806972028,-55,55,
 -6979532375142157.,-6936599112786626.,.499929513481901971034,-55,55,
 -5360050515984730.,-5340472647600854.,.499202613761639464934,-55,55,
 -5360050515984549.,-5340472647600674.,-.471176491087610016182,-55,55,
 -5360050515984546.,-5340472647600672.,.496165291704944962674,-55,55,
 -5360050515984087.,-5340472647600218.,.499458058966280402778,-55,55,
 -5360050515982801.,-5340472647598946.,.499968949380518509145,-55,55,
 -5360050515974901.,-5340472647591132.,.499996969955118445072,-55,55,
 -5003579018628366.,-4987633124986140.,-.499992397202541002885,-55,55,
 -5003579018619740.,-4987633124977597.,.499945387829820808986,-55,55,
 -5003579018617032.,-4987633124974914.,-.242712678207336269306,-55,55,
 -5003579018617005.,-4987633124974887.,-.499378766753358691745,-55,55,
 -5003579018615427.,-4987633124973325.,.499914280450518673457,-55,55,
 -5003579018594388.,-4987633124952486.,.499994395487693566879,-55,55,
 -5370993780301471.,-5369751207383751.,-.499998945389797013371,-57,57,
 -5370993780294264.,-5369751207376549.,-.499909027108967149956,-57,57,
 -5370993780293180.,-5369751207375466.,-.251942123900312041581,-57,57,
 -5370993780293065.,-5369751207375351.,-.331724232877235820465,-57,57,
 -5370993780292830.,-5369751207375116.,-.494757238177895538261,-57,57,
 -5370993780292823.,-5369751207375109.,-.499613540463446885741,-57,57,
 -5370993780292822.,-5369751207375109.,.499692702067188637080,-57,57,
 -5370993780291381.,-5369751207373669.,.499988188713245142504,-57,57,
 -4503599627370496.,-4503599627370496.,0.000000000000000000000,-1074,1074,
 0.,0.,0.000000000000000000000,0,0,
 4503599627370496.,4503599627370496.,0.000000000000000000000,-1074,1074,
 6940259249792698.,6937579443066098.,-.499995311707063475542,-57,57,
 6940259249799609.,6937579443073001.,-.499962021375513254125,-57,57,
 6940259249803895.,6937579443077282.,-.461307314053012562288,-57,57,
 6940259249803914.,6937579443077301.,-.483301145261815842202,-57,57,
 6940259249803928.,6937579443077315.,-.499507126152513072746,-57,57,
 6940259249806520.,6937579443079904.,-.499928731059867858676,-57,57,
 6940259249821206.,6937579443094572.,.499997314550116240847,-57,57,
 6175493946645766.,6167959128096405.,.499616193543645924749,-56,56,
 6175493946646302.,6167959128096940.,-.458030523743370324374,-56,56,
 6175493946646313.,6167959128096951.,-.498206109359338749201,-56,56,
 6175493946646314.,6167959128096951.,.498141564675573205120,-56,56,
 6175493946646861.,6167959128097497.,-.499680738227764093591,-56,56,
 6175493946657813.,6167959128108409.,-.499954707949644933482,-56,56,
 6175493946659182.,6167959128109773.,-.499988954174801241330,-56,56,
 6175493946689026.,6167959128139507.,.499994942761903942519,-56,56,
 6823990675690883.,6813831520980387.,-.499988353680577387933,-56,56,
 6823990675691332.,6813831520980834.,-.499962627390220109748,-56,56,
 6823990675704802.,6813831520994244.,-.499190838801066655642,-56,56,
 6823990675709292.,6813831520998714.,-.498933575990301479093,-56,56,
 6823990675709453.,6813831520998874.,-.216073571689554659375,-56,56,
 6823990675709513.,6813831520998934.,-.483330712943943324138,-56,56,
 6823990675709517.,6813831520998937.,.498852144305763932225,-56,56,
 6823990675768561.,6813831521057719.,-.499991995025971682971,-56,56,
 7740553500857480.,7725743343305588.,-.499997764736438881832,-56,56,
 7740553500861326.,7725743343309411.,.499889658851401518359,-56,56,
 7740553500862149.,7725743343310230.,-.207882741148087607135,-56,56,
 7740553500862198.,7725743343310279.,-.488175387077614620000,-56,56,
 7740553500862200.,7725743343310281.,-.499615903238003552400,-56,56,
 8359220028871712.,8340583310853756.,-.499998849382449732840,-56,56,
 8359220028898582.,8340583310880447.,-.499991466525109682768,-56,56,
 8359220028906688.,8340583310888499.,-.499765942169654659890,-56,56,
 8359220028906689.,8340583310888499.,.493572353601910058432,-56,56,
 8359220028906706.,8340583310888516.,.380323381718510028479,-56,56,
 8513798801093425.,8494113361064110.,-.496980102040517975699,-56,56,
 8513798801093426.,8494113361064110.,.496112109795509936587,-56,56,
 8513798801093441.,8494113361064125.,.392495287335928428173,-56,56,
 8513798801093570.,8494113361064254.,-.498609385816487460270,-56,56,
 8513798801093715.,8494113361064397.,.499761330407509290016,-56,56,
 8513798801094294.,8494113361064973.,-.499848016532867876991,-56,56,
 8513798801099216.,8494113361069861.,-.499981359629801622661,-56,56,
 8513798801129906.,8494113361100338.,.499999887025128022125,-56,56,
 4515336917406404.,9007199254740903.,.007328022441504456988,-55,56,
 4515336917406405.,9007199254740905.,-.008195894608243719165,-55,56,
 4515336917406432.,9007199254740959.,-.427341654951447044262,-55,56,
 4515336917406448.,9007199254740990.,.324275672252578277036,-55,56,
 4515336917406449.,4503599627370496.,.154375877601414900924,-55,55,
 4515336917406662.,4503599627370708.,-.498921288196875152951,-55,55,
 4515336917406791.,4503599627370835.,.499786062094226334243,-55,55,
 4515336917416840.,4503599627380806.,.499864845449742200591,-55,55,
 4515336917433846.,4503599627397680.,.499998170346575358227,-55,55,
 6216155809165103.,6185721712250362.,.499995480784687349405,-55,55,
 6216155809169224.,6185721712254424.,-.499938782116647687175,-55,55,
 6216155809171834.,6185721712256995.,.499617532773337969916,-55,55,
 6216155809171837.,6185721712256998.,.455938861870894704508,-55,55,
 6216155809173345.,6185721712258485.,-.499873045095807654629,-55,55,
 7082784227659771.,7037939197319788.,.499962130060781747278,-55,55,
 7082784227659980.,7037939197319994.,-.425172003298537670065,-55,55,
 7082784227659984.,7037939197319997.,.499705812330946843751,-55,55,
 7082784227667545.,7037939197327416.,.499996805816627486882,-55,55,
 4550658943385812.,9007199254740903.,-.004131792712235797730,-54,55,
 4550658943385845.,9007199254740967.,-.014252269458048385720,-54,55,
 4550658943385846.,9007199254740969.,-.075165011177618898670,-54,55,
 4550658943385857.,9007199254740990.,.254794829907103771898,-54,55,
 4550658943385858.,4503599627370496.,.096941044093766476112,-54,54,
 4550658943386600.,4503599627371215.,.498313866129469483218,-54,54,
 4550658943389949.,4503599627374462.,.499927856604682384344,-54,54,
 4550658943390146.,4503599627374654.,-.499977202783592494046,-54,54,
 4550658943400620.,4503599627384808.,.499994410548945623724,-54,54,
 4579785905347744.,4531834057078710.,.499998995629820799960,-54,54,
 4579785905353096.,4531834057083898.,-.499989379848868728732,-54,54,
 4579785905372720.,4531834057102917.,-.499946759752439009292,-54,54,
 4579785905373985.,4531834057104143.,-.499383474433900210754,-54,54,
 4579785905374017.,4531834057104174.,-.485930490141523935672,-54,54,
 4579785905374504.,4531834057104646.,-.499942885443546074436,-54,54,
 5299073463126767.,5225483985352742.,-.499996682692146508358,-54,54,
 5299073463165099.,5225483985389515.,.499982362687135274898,-54,54,
 5299073463172480.,5225483985396597.,-.499969498924359404085,-54,54,
 5299073463176884.,5225483985400821.,.499923740298154883758,-54,54,
 5299073463177622.,5225483985401530.,-.496006956698725567640,-54,54,
 5299073463177647.,5225483985401553.,.487870729717231758380,-54,54,
 5299073463177819.,5225483985401718.,.496949212258773895264,-54,54,
 5299073463178311.,5225483985402190.,.499662080921760297693,-54,54,
 5354986034456645.,5279101399477957.,-.499412138063810446054,-54,54,
 5354986034456717.,5279101399478026.,-.484118540267133160971,-54,54,
 5354986034456838.,5279101399478141.,.499916533807668692189,-54,54,
 5354986034459781.,5279101399480963.,-.499957656322799564680,-54,54,
 5354986034474689.,5279101399495253.,-.499999937041849630237,-54,54,
 6318840445920685.,6195954472381817.,-.499970332244233258890,-54,54,
 6318840445922122.,6195954472383173.,-.499743101575406002722,-54,54,
 6318840445925954.,6195954472386789.,-.499137153290369748451,-54,54,
 6318840445926220.,6195954472387040.,-.492832043110398772054,-54,54,
 6318840445926238.,6195954472387056.,.492557024495722859049,-54,54,
 6318840445926433.,6195954472387241.,-.499061409771632578708,-54,54,
 6318840445933689.,6195954472394087.,.499998286996706166003,-54,54,
 6779876501357253.,6629236626677568.,.499991575992382179895,-54,54,
 6779876501422365.,6629236626738507.,.499984924755498007497,-54,54,
 6779876501426297.,6629236626742187.,.499800222948781359426,-54,54,
 6779876501427280.,6629236626743107.,.499754047455727754536,-54,54,
 6779876501427436.,6629236626743254.,-.498218692501965129792,-54,54,
 6779876501427592.,6629236626743400.,-.496191432460074820455,-54,54,
 6779876501427623.,6629236626743429.,-.482968066682569337928,-54,54,
 7852441927951931.,7622902283067773.,-.499996707145520364022,-54,54,
 7852441928002205.,7622902283113858.,.461867383309733095058,-54,54,
 7852441928002301.,7622902283113946.,.464658864998439584329,-54,54,
 7852441928003381.,7622902283114936.,.496063033984550580958,-54,54,
 7852441928003513.,7622902283115057.,.499901321303584224817,-54,54,
 7852441928006382.,7622902283117687.,.499992581210519394640,-54,54,
 8717776617240196.,8409045954958573.,.499962510151714643654,-54,54,
 8717776617240927.,8409045954959232.,-.499839511504789311203,-54,54,
 8717776617241027.,8409045954959322.,-.486132537724003377698,-54,54,
 8717776617241207.,8409045954959484.,-.461459984919082430993,-54,54,
 8717776617250410.,8409045954967767.,.499992811255475743168,-54,54,
 4693609247292052.,9007199254740533.,.000497703484413627096,-53,54,
 4693609247292308.,9007199254740987.,.051766296164956804086,-53,54,
 4693609247292310.,9007199254740991.,-.400958167954747272400,-53,54,
 4693609247292311.,4503599627370496.,.186339799992700284155,-53,53,
 4693609247292317.,4503599627370502.,-.492746896186857041042,-53,53,
 4693609247292750.,4503599627370885.,.499829862851254418938,-53,53,
 4693609247294897.,4503599627372789.,.499973746468891463534,-53,53,
 4693609247302036.,4503599627379120.,.499986407053366178225,-53,53,
 4693609247309175.,4503599627385451.,.499999065581443939977,-53,53,
 5205590995512103.,4952283729482407.,.499936150394565901330,-53,53,
 5205590995513057.,4952283729483233.,.478349864460256120902,-53,53,
 5205590995513072.,4952283729483246.,.465431841096206464680,-53,53,
 5205590995513109.,4952283729483279.,-.499765949868489415440,-53,53,
 5205590995529056.,4952283729497085.,.499986139040135903908,-53,53,
 5205590995552589.,4952283729517460.,.499996523425090103515,-53,53,
 6059040276377478.,5675874953966719.,.499999193918202576272,-53,53,
 6059040276408600.,5675874953992543.,-.426016890542991695545,-53,53,
 6059040276408618.,5675874953992558.,-.490751428486967467643,-53,53,
 6059040276408806.,5675874953992713.,.499798952986237241755,-53,53,
 6059040276409223.,5675874953993060.,-.499884509389748752012,-53,53,
 6059040276412189.,5675874953995520.,.499968849132006957185,-53,53,
 6059040276418538.,5675874954000788.,.499992102507892102108,-53,53,
 6179968525016255.,5775901530674446.,-.499996279803844854817,-53,53,
 6179968525017549.,5775901530675513.,-.499988653352346350308,-53,53,
 6179968525061545.,5775901530711791.,-.499729396549742958948,-53,53,
 6179968525077073.,5775901530724595.,-.499637913885535762489,-53,53,
 6179968525077244.,5775901530724736.,-.497318513921248355054,-53,53,
 6179968525077643.,5775901530725065.,-.491906580676100809591,-53,53,
 6179968525077666.,5775901530725083.,.473317666102234273960,-53,53,
 6179968525077683.,5775901530725097.,.491092109373163076268,-53,53,
 6230674196577543.,5817657251583800.,.499993959609905140059,-53,53,
 6230674196596919.,5817657251599736.,-.499950992086135350436,-53,53,
 6230674196597133.,5817657251599911.,.495611135215786541287,-53,53,
 6230674196597144.,5817657251599921.,-.457888007773419870884,-53,53,
 7103100048438295.,6518902460928010.,.499994692771540594110,-53,53,
 7103100048445167.,6518902460933406.,.499802979630746367928,-53,53,
 7103100048445265.,6518902460933483.,.450906182775787063218,-53,53,
 7103100048445274.,6518902460933491.,-.482155767955811241549,-53,53,
 7103100048445302.,6518902460933513.,-.496126281343027924059,-53,53,
 7103100048479811.,6518902460960610.,-.499999395154511446247,-53,53,
 7302452754205629.,6674596249927648.,-.499996835883543639779,-53,53,
 7302452754242768.,6674596249956496.,.499971563525442538898,-53,53,
 7302452754243552.,6674596249957105.,.499028490255954420600,-53,53,
 7302452754244784.,6674596249958062.,.497546517922938578492,-53,53,
 7302452754244802.,6674596249958076.,.479667722872143924706,-53,53,
 7302452754244829.,6674596249958097.,.452849530295926314703,-53,53,
 7302452754250151.,6674596249962232.,-.499980873661238380932,-53,53,
 7511273082104834.,6835886557382947.,.497200671581892616042,-53,53,
 7511273082104877.,6835886557382981.,-.478795543967275975550,-53,53,
 7511273082104890.,6835886557382991.,-.494794399830993373679,-53,53,
 7511273082105084.,6835886557383139.,.497222674201920284626,-53,53,
 7511273082118709.,6835886557393603.,.498421813029212061340,-53,53,
 7511273082136209.,6835886557407043.,.499961979917677127321,-53,53,
 7511273082136584.,6835886557407331.,.499994983353297422896,-53,53,
 7913137471603089.,7141146806808684.,-.499998168956750439405,-53,53,
 7913137471605031.,7141146806810142.,.445345420575789471002,-53,53,
 7913137471605059.,7141146806810163.,.480602691690463042100,-53,53,
 7913137471605075.,7141146806810176.,-.499250296244023760301,-53,53,
 7913137471605670.,7141146806810622.,.499966714934730891355,-53,53,
 8575032706761609.,7629425332103623.,.499993515056634063877,-53,53,
 8575032706780885.,7629425332117585.,-.499993112102661111230,-53,53,
 8575032706797169.,7629425332129378.,.488605017137128062922,-53,53,
 8575032706797227.,7629425332129420.,.496179242830201591835,-53,53,
 8575032706797256.,7629425332129441.,.499966355676687698957,-53,53,
 8668443273554275.,7696904744747150.,.499998377273729216910,-53,53,
 8668443273583462.,7696904744768180.,.499979731244518337362,-53,53,
 8668443273592962.,7696904744775025.,.499459727419353092387,-53,53,
 8668443273592987.,7696904744775044.,-.487383746279682332884,-53,53,
 8668443273593191.,7696904744775190.,.499973508335255027372,-53,53,
 9007199254619348.,7938707516064807.,.499997900313343486584,-53,53,
 9007199254740894.,7938707516150754.,-.499175709168061290383,-53,53,
 9007199254740976.,7938707516150811.,.483580348129019175791,-53,53,
 9007199254740986.,7938707516150819.,-.445351840005501262447,-53,53,
 9007199254740991.,7938707516150822.,.090182065927237046473,-53,53,
 4503599627370497.,7938707516150824.,.211502409486879560797,-52,53,
 4503599627370517.,7938707516150852.,.495773656948745994797,-52,53,
 4503599627370855.,7938707516151330.,.499957739044789355998,-52,53,
 4503599627376596.,7938707516159450.,-.499980679927574738579,-52,53,
 5292635657778132.,9007199254739107.,-.000025263875370449667,-52,53,
 5292635657778723.,9007199254739873.,.000126206934453873865,-52,53,
 5292635657779314.,9007199254740639.,.000277677694665648072,-52,53,
 5292635657779493.,9007199254740871.,.003707649370287839216,-52,53,
 5292635657779547.,9007199254740941.,-.006430794929580057652,-52,53,
 5292635657779584.,9007199254740989.,-.050414543801950892365,-52,53,
 5292635657779586.,4503599627370496.,-.229098724573204454776,-52,52,
 5292635657779587.,4503599627370496.,.418955549090680934396,-52,52,
 5292635657779601.,4503599627370505.,.491715380385068925597,-52,52,
 5292635657857434.,4503599627420945.,.499997246374756244074,-52,52,
 6467001089589151.,5218359911743574.,.499995107182421267775,-52,52,
 6467001089631088.,5218359911767540.,.499991319558147049012,-52,52,
 6467001089645134.,5218359911775567.,.455566249043734113948,-52,52,
 6467001089645302.,5218359911775663.,.463578251546623799906,-52,52,
 6467001089646023.,5218359911776075.,.497963095602453862279,-52,52,
 6467001089646065.,5218359911776099.,.499966096226111819794,-52,52,
 7316025708206033.,5683042220340215.,-.499740562024795897440,-52,52,
 7316025708206115.,5683042220340257.,.486147587999273558186,-52,52,
 7316025708206117.,5683042220340259.,-.465416115658680332154,-52,52,
 7316025708206157.,5683042220340280.,-.496690188817801787645,-52,52,
 7316025708207664.,5683042220341070.,-.499940895148273714802,-52,52,
 7316025708218152.,5683042220346567.,.499997118839987566561,-52,52,
 8219998205379889.,6136680860132486.,.499993981547921744155,-52,52,
 8219998205385733.,6136680860135295.,-.499571679204495314702,-52,52,
 8219998205388655.,6136680860136699.,-.499354510156494676755,-52,52,
 8219998205388705.,6136680860136723.,-.474710136972839883248,-52,52,
 8219998205388707.,6136680860136723.,.486275637954503970643,-52,52,
 8219998205388732.,6136680860136735.,.498597824546286970750,-52,52,
 9007199254739982.,6501556188073668.,-.499963143083624017542,-52,52,
 9007199254740664.,6501556188073972.,.499708987905813389752,-52,52,
 9007199254740986.,6501556188074117.,-.497513261105594228832,-52,52,
 9007199254740991.,6501556188074119.,-.261445283605803837314,-52,52,
 4503599627370497.,6501556188074120.,.080195502894069920951,-51,52,
 4503599627382229.,6501556188084614.,-.499999697028964821531,-51,52,
 5429564584135173.,7267644684200750.,.499984324196906471033,-51,52,
 5429564584138603.,7267644684203378.,.497826726091369927520,-51,52,
 5429564584138616.,7267644684203388.,.458168402830549423371,-51,52,
 5429564584138804.,7267644684203533.,-.499967348943591227405,-51,52,
 5429564584177787.,7267644684233401.,-.499999416463791278268,-51,52,
 6534651015198467.,8047849474018236.,.499998273834036650471,-51,52,
 6534651015229832.,8047849474038673.,.499961984918880933609,-51,52,
 6534651015231313.,8047849474039638.,.499067554442953982986,-51,52,
 6534651015231356.,8047849474039667.,-.482727489793906223791,-51,52,
 6534651015231755.,8047849474039927.,-.499848946790305576763,-51,52,
 6534651015235380.,8047849474042288.,.499987439497107550560,-51,52,
 8166963590622378.,9007199254725075.,.000004417348374531550,-51,52,
 8166963590652295.,9007199254740979.,.010564502788436041749,-51,52,
 8166963590652310.,9007199254740987.,-.015368632189157828373,-51,52,
 8166963590652319.,4503599627370496.,-.115464256587860341858,-51,51,
 8166963590652320.,4503599627370496.,.150337972246219348278,-51,51,
 8166963590652325.,4503599627370497.,.479349116416617345262,-51,51,
 8166963590652532.,4503599627370553.,-.499589514929569251041,-51,51,
 8166963590653766.,4503599627370881.,-.499639133706192158120,-51,51,
 8166963590662404.,4503599627373177.,-.499986466432182923586,-51,51,
 8166963590663021.,4503599627373340.,.499988724001029984958,-51,51,
 5007882989883048.,4949414173530254.,-.499803543239240008300,-50,51,
 5007882989885756.,4949414173531442.,-.499305641157330809494,-50,51,
 5007882989885902.,4949414173531506.,-.449057231387422167132,-50,51,
 5007882989885911.,4949414173531509.,.499245752776418148369,-50,51,
 5007882989889973.,4949414173533291.,.499992604700219823759,-50,51,
 5007882989914133.,4949414173543891.,-.499996605786566739360,-50,51,
 5396246731121406.,5113787625582647.,-.499998043313662633355,-50,51,
 5396246731153808.,5113787625595883.,-.499981308231211120316,-50,51,
 5396246731167042.,5113787625601289.,-.499604147491290675855,-50,51,
 5396246731167113.,5113787625601318.,-.496579606312577310095,-50,51,
 5396246731167135.,5113787625601326.,.490273068418780790377,-50,51,
 5396246731167140.,5113787625601329.,-.467260414596824537891,-50,51,
 5396246731169020.,5113787625602097.,-.499850028592964408443,-50,51,
 5396246731170009.,5113787625602501.,-.499972969250232952219,-50,51,
 5569985055088831.,5183685286350651.,-.499997683678668069788,-50,51,
 5569985055105353.,5183685286357198.,-.499984045995828504340,-50,51,
 5569985055108775.,5183685286358554.,-.499860173001312381197,-50,51,
 5569985055108934.,5183685286358617.,-.494594335555508251894,-50,51,
 5569985055108972.,5183685286358632.,-.436732059939785737705,-50,51,
 5569985055108987.,5183685286358638.,-.492839056407290861450,-50,51,
 5916628998625667.,5317093511158613.,.499990956323977150013,-50,51,
 5916628998680198.,5317093511179001.,.499885291159623924813,-50,51,
 5916628998680420.,5317093511179085.,-.498959833226087787516,-50,51,
 5916628998680519.,5317093511179122.,-.484931307615279566362,-50,51,
 5916628998680527.,5317093511179125.,-.493898699485139346153,-50,51,
 5916628998680535.,5317093511179127.,.497133908644996971149,-50,51,
 5916628998684547.,5317093511180627.,.499986885416586460168,-50,51,
 6272704229709347.,5446497661106879.,.499998221158981106850,-50,51,
 6272704229721078.,5446497661111024.,.498940987857570990709,-50,51,
 6272704229721112.,5446497661111037.,-.487593488833272592077,-50,51,
 6272704229721126.,5446497661111041.,.459127608999891126150,-50,51,
 6272704229721228.,5446497661111077.,.499524178926903944362,-50,51,
 6272704229721378.,5446497661111131.,-.499892630004990953749,-50,51,
 6272704229724794.,5446497661112338.,-.499944759079722372057,-50,51,
 6272704229728210.,5446497661113545.,-.499996888791248056822,-50,51,
 7436919125132944.,5824736360344390.,.499954229385892164605,-50,51,
 7436919125134955.,5824736360344993.,-.456411306529789412160,-50,51,
 7436919125134975.,5824736360344999.,-.468906239757000229986,-50,51,
 7436919125135025.,5824736360345013.,.499856427174903857168,-50,51,
 7436919125152792.,5824736360350332.,.499982488528966783412,-50,51,
 7436919125162716.,5824736360353303.,.499996612286893132000,-50,51,
 7464505152264810.,5832979996181187.,-.499991373100600999443,-50,51,
 7464505152270670.,5832979996182935.,-.499906625057648864813,-50,51,
 7464505152284968.,5832979996187200.,-.499017257391782672404,-50,51,
 7464505152285025.,5832979996187217.,-.496286057662562051864,-50,51,
 7464505152285072.,5832979996187231.,-.476490156131545805698,-50,51,
 7464505152285082.,5832979996187234.,-.493554857933468378391,-50,51,
 7464505152285320.,5832979996187305.,-.499694760820378720807,-50,51,
 4542341907301367.,6271200366428583.,.499995463203411887098,-49,51,
 4542341907340914.,6271200366448040.,-.499810564350703457623,-49,51,
 4542341907341101.,6271200366448131.,.498875461319391872671,-49,51,
 4542341907341225.,6271200366448193.,-.496648243585917223253,-49,51,
 4542341907341237.,6271200366448198.,.407010752713481950947,-49,51,
 4542341907342471.,6271200366448805.,.499944205419691428680,-49,51,
 4542341907346270.,6271200366450674.,.499988115932236911377,-49,51,
 4574407728078037.,6286921250283625.,-.499997946277901093243,-49,51,
 4574407728078956.,6286921250284074.,-.499963362195223659372,-49,51,
 4574407728089065.,6286921250289013.,-.499582943150432187685,-49,51,
 4574407728090903.,6286921250289911.,-.499513777206539555127,-49,51,
 4574407728091116.,6286921250290015.,-.433129265615784023622,-49,51,
 4574407728091122.,6286921250290017.,.498318185414872359606,-49,51,
 5043885832660153.,6505423276213103.,.498839197264884457565,-49,51,
 5043885832660189.,6505423276213119.,.471555022059044128238,-49,51,
 5043885832660216.,6505423276213131.,.451091890654589987307,-49,51,
 5043885832660739.,6505423276213363.,.499157900844704578566,-49,51,
 5043885832662204.,6505423276214013.,.499954659663725652172,-49,51,
 5043885832674812.,6505423276219607.,.499985733996906745750,-49,51,
 5043885832681116.,6505423276222405.,-.499998734015648672913,-49,51,
 5090857167508273.,6526168560678787.,-.499997977465781211759,-49,51,
 5090857167548442.,6526168560696447.,-.499990100077099960084,-49,51,
 5090857167556610.,6526168560700038.,-.499963620304611407433,-49,51,
 5090857167557165.,6526168560700282.,-.498370244375756496675,-49,51,
 5090857167557190.,6526168560700292.,.492692520305104913392,-49,51,
 5090857167557281.,6526168560700333.,-.499839016257009851712,-49,51,
 5215472194836517.,6580302619871856.,-.499304989809608348194,-49,51,
 5215472194836694.,6580302619871931.,.479789957314637347449,-49,51,
 5215472194836708.,6580302619871937.,.489435885335655350901,-49,51,
 5215472194836722.,6580302619871943.,.499081813356657408318,-49,51,
 5215472194838383.,6580302619872657.,-.499354869407630785353,-49,51,
 5215472194859531.,6580302619881735.,-.499920191316858105417,-49,51,
 5215472194862641.,6580302619883069.,.499996670039360658104,-49,51,
 5336471118719892.,6631656004655392.,-.498343143920042485551,-49,51,
 5336471118719899.,6631656004655394.,.439107034073327642175,-49,51,
 5336471118720004.,6631656004655439.,-.499140296026577729450,-49,51,
 5336471118720116.,6631656004655486.,-.499937448134088520036,-49,51,
 5336471118721379.,6631656004656016.,-.499998190271136174421,-49,51,
 5698688785603693.,6778770018339179.,-.499998711357007278881,-49,51,
 5698688785647914.,6778770018356567.,.499991343010732839483,-49,51,
 5698688785648298.,6778770018356719.,-.499895675487332375779,-49,51,
 5698688785648377.,6778770018356750.,-.434768265231673691827,-49,51,
 5698688785648387.,6778770018356753.,.497526343661417250774,-49,51,
 7681428807456142.,9007199254728945.,-.000003102542242448078,-48,51,
 7681428807483341.,9007199254736913.,.000024852369609234286,-48,51,
 7681428807494039.,9007199254740047.,-.000037692148374608739,-48,51,
 7681428807497118.,9007199254740949.,-.000990448103951251998,-48,51,
 7681428807497264.,4503599627370496.,-.115003035418835340639,-48,50,
 7681428807497265.,4503599627370496.,.031472938475910795881,-48,50,
 7681428807497268.,4503599627370496.,.470900860160149091183,-48,50,
 7681428807497275.,4503599627370497.,.496232677423371113705,-48,50,
 7681428807498934.,4503599627370740.,.499873368780673655564,-48,50,
 5611538334468725.,4930302405066606.,-.499978309796888595885,-47,50,
 5611538334470804.,4930302405067022.,.499771271739449909651,-47,50,
 5611538334474234.,4930302405067710.,.479156102892886993175,-47,50,
 5611538334474244.,4930302405067712.,.484926904149279693392,-47,50,
 5611538334474269.,4930302405067717.,.499353907290245815901,-47,50,
 5611538334480855.,4930302405069039.,-.499996386031290649766,-47,50,
 6681749571160966.,5126781676953444.,-.499999914200843348282,-47,50,
 6681749571210418.,5126781676961774.,.499983217098834745016,-47,50,
 6681749571221993.,5126781676963724.,.498462637640305007024,-47,50,
 6681749571222064.,5126781676963736.,.459576420684610995119,-47,50,
 6681749571222082.,5126781676963739.,.491971464273288101286,-47,50,
 6681749571222088.,5126781676963741.,-.497230187863821344517,-47,50,
 6681749571222272.,5126781676963772.,-.499414186735618208804,-47,50,
 6681749571225050.,5126781676964240.,-.499779126327628038807,-47,50,
 6681749571226902.,5126781676964551.,.499977580502982658297,-47,50,
 5503336538673777.,5688664102696694.,-.499970361974365014880,-46,50,
 5503336538676754.,5688664102697302.,.499684525662520094200,-46,50,
 5503336538676798.,5688664102697312.,-.499312849195165677748,-46,50,
 5503336538676886.,5688664102697330.,-.497307598910753079445,-46,50,
 5503336538676891.,5688664102697331.,-.474466391508238277362,-46,50,
 5503336538677761.,5688664102697508.,.499903696515191128928,-46,50,
 5503336538682752.,5688664102698529.,.499996925080724439481,-46,50,
 6754291611842404.,5919259447014055.,.468498485186602649913,-46,50,
 6754291611842464.,5919259447014065.,.469595913290508663957,-46,50,
 6754291611843730.,5919259447014276.,.492751646262213814931,-46,50,
 6754291611844120.,5919259447014341.,.499884928923254234012,-46,50,
 6754291611844126.,5919259447014342.,.499994671733394771883,-46,50,
 7484448101930119.,6034826483899691.,-.499940416800899812394,-46,50,
 7484448101930232.,6034826483899707.,.498115398674411369878,-46,50,
 7484448101958924.,6034826483904024.,-.499960205934411895862,-46,50,
 7484448102016534.,6034826483912690.,-.499999834225578375741,-46,50,
 5668088529102692.,6502254384884312.,-.499924841543303475063,-45,50,
 5668088529104001.,6502254384884572.,-.487298590602324975615,-45,50,
 5668088529104006.,6502254384884573.,-.494125839452932916588,-45,50,
 5668088529104011.,6502254384884573.,.499046911696458266363,-45,50,
 5668088529104157.,6502254384884602.,.499691245258294529421,-45,50,
 5668088529105768.,6502254384884922.,.499951665538276280882,-45,50,
 5668088529129057.,6502254384889548.,.499991958233299771614,-45,50,
 5668088529136820.,6502254384891091.,-.499994615092035108798,-45,50,
 6687091832564916.,6688393137409164.,.499975066581008869953,-45,50,
 6687091832579414.,6688393137411605.,.481992016353146515774,-45,50,
 6687091832579420.,6688393137411606.,.492192878657102242530,-45,50,
 6687091832579426.,6688393137411608.,-.497606259038942937093,-45,50,
 6687091832580406.,6688393137411773.,-.498132082738486380790,-45,50,
 6687091832583738.,6688393137412334.,-.499919883497801750946,-45,50,
 6687091832583934.,6688393137412366.,.499974951742945425385,-45,50,
 7525504069993309.,6821381352000673.,-.499991363781993079507,-45,50,
 7525504070172609.,6821381352027498.,-.499953851340353170992,-45,50,
 7525504070179781.,6821381352028571.,-.499952364136154755261,-45,50,
 7525504070179908.,6821381352028590.,-.499534044447246515076,-45,50,
 7525504070180670.,6821381352028704.,-.497024126320530577464,-45,50,
 7525504070180750.,6821381352028715.,.471743319151420963072,-45,50,
 7525504070180757.,6821381352028717.,-.480989529369789330562,-45,50,
 7525504070180797.,6821381352028723.,-.496605806633866838446,-45,50,
 4877516211311693.,7113533565012469.,-.499630015860714545475,-44,50,
 4877516211312044.,7113533565012550.,-.477183406330726423429,-44,50,
 4877516211312187.,7113533565012583.,-.468038491338699137699,-44,50,
 4877516211314093.,7113533565013023.,-.499995079019894383904,-44,50,
 7249885060642963.,7559781423383062.,.499993148953512861503,-44,50,
 7249885060729081.,7559781423396436.,.499982094310253821346,-44,50,
 7249885060733318.,7559781423397094.,.499911874476629126608,-44,50,
 7249885060733582.,7559781423397135.,.498727418944412923666,-44,50,
 7249885060733685.,7559781423397151.,.494477423035605527960,-44,50,
 7249885060733698.,7559781423397154.,-.486641508486881459601,-44,50,
 7249885060733743.,7559781423397161.,-.498207040680133601328,-44,50,
 7797320753747631.,7641740594521663.,-.499990812797866461631,-44,50,
 7797320753794253.,7641740594528395.,-.498895307880533533094,-44,50,
 7797320753794260.,7641740594528396.,-.488127694556490845589,-44,50,
 7797320753794288.,7641740594528400.,-.445057241260329169631,-44,50,
 7797320753794717.,7641740594528462.,-.499442081831667366153,-44,50,
 7797320753795181.,7641740594528529.,-.499988855786788156916,-44,50,
 4636307512456149.,7836842025838083.,-.499999427744850491364,-43,50,
 4636307512462507.,7836842025839626.,.499984449920680959472,-43,50,
 4636307512487939.,7836842025845802.,.499919939409240220101,-43,50,
 4636307512490035.,7836842025846312.,-.499770814462334770670,-43,50,
 4636307512490175.,7836842025846345.,.498341444335754878141,-43,50,
 4636307512490315.,7836842025846379.,.496453703132817908556,-43,50,
 4636307512490348.,7836842025846388.,-.489705550150881034388,-43,50,
 4636307512490352.,7836842025846388.,.481669085814727338944,-43,50,
 4636307512491118.,7836842025846574.,.499911873213283891636,-43,50,
 5062511894373474.,7935858597454498.,-.499992220766275027608,-43,50,
 5062511894378856.,7935858597455694.,.452089758858456755669,-43,50,
 5062511894378865.,7935858597455696.,.453681869191211646503,-43,50,
 5062511894379063.,7935858597455740.,.488708296510918978016,-43,50,
 5062511894379126.,7935858597455754.,.499853068839555591078,-43,50,
 5062511894431887.,7935858597467489.,-.499998852200847789909,-43,50,
 5233425285844448.,7973242036313864.,-.494902625503020856828,-43,50,
 5233425285844527.,7973242036313881.,-.499156598859805690242,-43,50,
 5233425285844778.,7973242036313934.,.499985840220099504928,-43,50,
 5233425285873927.,7973242036320205.,.499997602447000072463,-43,50,
 5359780702951679.,8000102668262265.,.499890790949450166152,-43,50,
 5359780702952355.,8000102668262408.,-.496666482386571965955,-43,50,
 5359780702952412.,8000102668262419.,.476996587760311557044,-43,50,
 5359780702952474.,8000102668262433.,-.499019020150240420465,-43,50,
 5359780702952931.,8000102668262529.,-.499650194592344033931,-43,50,
 5359780702956349.,8000102668263247.,-.499994514858697657455,-43,50,
 5536082176383106.,8036541247119254.,-.499963237884761278563,-43,50,
 5536082176383131.,8036541247119259.,-.415598294369912741676,-43,50,
 5536082176393122.,8036541247121291.,-.499992269933931722100,-43,50,
 5574784674263175.,8044384966418833.,-.499998692996206432182,-43,50,
 5574784674298127.,8044384966425891.,.499919342667191626074,-43,50,
 5574784674299147.,8044384966426098.,-.498137524660952968512,-43,50,
 5574784674299152.,8044384966426099.,-.488324077932262197322,-43,50,
 5574784674299350.,8044384966426139.,-.499711587476835728306,-43,50,
 5574784674301286.,8044384966426530.,-.499945014209724233312,-43,50,
 5574784674314635.,8044384966429225.,.499995057787853847252,-43,50,
 6204958457226241.,8164963116102409.,-.499999156873377354459,-43,50,
 6204958457252766.,8164963116107221.,.499995531740953941944,-43,50,
 6204958457255246.,8164963116107671.,.499618031264637112079,-43,50,
 6204958457260702.,8164963116108661.,.498787529583648207124,-43,50,
 6204958457260950.,8164963116108706.,.498749779486556221070,-43,50,
 6204958457260994.,8164963116108714.,.482614049630432689616,-43,50,
 6252030418334287.,8173472157342026.,.499909720948123897289,-43,50,
 6252030418335703.,8173472157342282.,-.499301167620142154069,-43,50,
 6252030418336175.,8173472157342367.,-.499038130489065082749,-43,50,
 6252030418336225.,8173472157342376.,-.494772978250979423837,-43,50,
 6252030418336236.,8173472157342377.,.486165355241389757304,-43,50,
 6252030418336247.,8173472157342379.,.467103688733755453132,-43,50,
 6252030418338274.,8173472157342745.,-.499987039596170480703,-43,50,
 6252030418357265.,8173472157346165.,-.499996922855237357407,-43,50,
 6552879593886736.,8226387497694503.,.499996745076726232597,-43,50,
 6552879593890263.,8226387497695110.,-.499948324429211115724,-43,50,
 6552879593891072.,8226387497695249.,-.499652197803892732071,-43,50,
 6552879593891223.,8226387497695274.,.444778846842443023366,-43,50,
 6552879593891235.,8226387497695277.,-.493412063516814215480,-43,50,
 6571276784293262.,8229544026666940.,-.499874675591490113517,-43,50,
 6571276784295118.,8229544026667258.,-.499518945339284891745,-43,50,
 6571276784295223.,8229544026667275.,.490802903621652301575,-43,50,
 6571276784295264.,8229544026667283.,-.484404755355583594214,-43,50,
 6571276784295276.,8229544026667285.,-.428367972617221903862,-43,50,
 6571276784298223.,8229544026667789.,.499998588098420565135,-43,50,
 7918677949290695.,8439542348588807.,-.499998965031674960373,-43,50,
 7918677949312301.,8439542348591878.,.499965568610340408672,-43,50,
 7918677949369917.,8439542348600070.,.499870950677547670610,-43,50,
 7918677949371823.,8439542348600342.,-.499854479766464486382,-43,50,
 7918677949372034.,8439542348600372.,-.499299425113437215773,-43,50,
 7918677949372048.,8439542348600373.,.491258730171569489347,-43,50,
 7918677949372055.,8439542348600374.,.486537807814071522190,-43,50,
 8009526533119381.,8452385912844443.,.499994740098240843594,-43,50,
 8009526533133872.,8452385912846481.,-.499984850605702851101,-43,50,
 8009526533139428.,8452385912847262.,-.493007183095830423348,-43,50,
 8009526533139556.,8452385912847279.,.499954145450928396764,-43,50,
 8289917000837890.,8491126200224776.,-.499898928991186469790,-43,50,
 8289917000838560.,8491126200224866.,.496490162209053206012,-43,50,
 8289917000838567.,8491126200224867.,.447198704952897487114,-43,50,
 8289917000838722.,8491126200224888.,.498602151423529449042,-43,50,
 8289917000838803.,8491126200224899.,.499658146030606335311,-43,50,
 8289917000842617.,8491126200225417.,.499998435185350903205,-43,50,
 6555195199606253.,9007199254735519.,.000011587813884931366,-42,50,
 6555195199637064.,9007199254740811.,.000198556733447703441,-42,50,
 6555195199637588.,9007199254740901.,.000785943221588877000,-42,50,
 6555195199638112.,9007199254740991.,.001373329702535713071,-42,50,
 6555195199638117.,4503599627370496.,-.069921219755233501560,-42,49,
 6555195199638118.,4503599627370496.,.015957203323466187519,-42,49,
 6555195199638124.,4503599627370497.,-.468772258204335953128,-42,49,
 6555195199640371.,4503599627370690.,-.499955600399398998287,-42,49,
 6555195199643678.,4503599627370973.,.499989520691204402085,-42,49 };
#include "trailer.h"
