; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=verify -S < %s 2>&1 | FileCheck %s

%struct.test = type { <vscale x 1 x i32>, <vscale x 1 x i32> }

define <vscale x 1 x i32> @load(%struct.test* %x) {
; CHECK-LABEL: define <vscale x 1 x i32> @load
; CHECK-SAME: (ptr [[X:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = load [[STRUCT_TEST:%.*]], ptr [[X]], align 4
; CHECK-NEXT:    [[B:%.*]] = extractvalue [[STRUCT_TEST]] [[A]], 1
; CHECK-NEXT:    ret <vscale x 1 x i32> [[B]]
;
  %a = load %struct.test, %struct.test* %x
  %b = extractvalue %struct.test %a, 1
  ret <vscale x 1 x i32> %b
}

define void @store(%struct.test* %x, <vscale x 1 x i32> %y, <vscale x 1 x i32> %z) {
; CHECK-LABEL: define void @store
; CHECK-SAME: (ptr [[X:%.*]], <vscale x 1 x i32> [[Y:%.*]], <vscale x 1 x i32> [[Z:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = insertvalue [[STRUCT_TEST:%.*]] undef, <vscale x 1 x i32> [[Y]], 0
; CHECK-NEXT:    [[B:%.*]] = insertvalue [[STRUCT_TEST]] [[A]], <vscale x 1 x i32> [[Z]], 1
; CHECK-NEXT:    store [[STRUCT_TEST]] [[B]], ptr [[X]], align 4
; CHECK-NEXT:    ret void
;
  %a = insertvalue %struct.test undef, <vscale x 1 x i32> %y, 0
  %b = insertvalue %struct.test %a, <vscale x 1 x i32> %z, 1
  store %struct.test %b, %struct.test* %x
  ret void
}
