; Check if a C2_tfrrp instruction with constant i32 0 input is generated
; The constant 0 is generated by a transfer immediate instruction.

; RUN: llc -march=hexagon -debug-only=isel 2>&1 < %s - | FileCheck %s
; REQUIRES: asserts

; CHECK: [[R0:%[0-9]+]]:intregs = A2_tfrsi 0
; CHECK-NEXT: predregs = C2_tfrrp killed [[R0]]:intregs

define void @test_false(i1 %0) {
  %2 = insertelement <1024 x i1> zeroinitializer, i1 %0, i64 0
  tail call void @llvm.masked.store.v1024f32.p0(<1024 x float> zeroinitializer, ptr null, i32 1, <1024 x i1> %2)
  ret void
}

declare void @llvm.masked.store.v1024f32.p0(<1024 x float>, ptr nocapture, i32 immarg, <1024 x i1>)
