/* ai.c generated by valac 0.38.0.11-8bd7f, the Vala compiler
 * generated from ai.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright © 2014 Nikhar Agrawal
 *
 * This file is part of Four-in-a-row.
 *
 * Four-in-a-row is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Four-in-a-row is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Four-in-a-row.  If not, see <http://www.gnu.org/licenses/>. */
/* Here NEG_INF is supposed to be the lowest possible int value. int.MIN
MAX_HEURIST_VALUE is the maximum value that the heuristic functions can return.
It is returned when AI wins. -1*MAX_HEURIST_VALUE is returned when Human wins
MAX_HEURIST_VALUE < NEG_INF/plies */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "ai.h"
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PLAYER (player_get_type ())

#define TYPE_DIFFICULTY (difficulty_get_type ())
#define _decision_tree_unref0(var) ((var == NULL) ? NULL : (var = (decision_tree_unref (var), NULL)))
enum  {
	DECISION_TREE_DUMMY_PROPERTY,
	DECISION_TREE_LAST_PROPERTY
};
static GParamSpec* decision_tree_properties[DECISION_TREE_LAST_PROPERTY];
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecDecisionTree ParamSpecDecisionTree;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PLAYER_NONE,
	PLAYER_HUMAN,
	PLAYER_AI
} Player;

typedef enum  {
	DIFFICULTY_EASY,
	DIFFICULTY_MEDIUM,
	DIFFICULTY_HARD
} Difficulty;

struct _DecisionTreePrivate {
	Player* board;
	gint board_length1;
	gint board_length2;
	gint plies;
	Player last_moving_player;
	gint next_move_in_column;
	Difficulty level;
};

struct _ParamSpecDecisionTree {
	GParamSpec parent_instance;
};


static gpointer decision_tree_parent_class = NULL;

#define NEG_INF -100000
#define MAX_HEURIST_VALUE 10000
#define BOARD_ROWS 6
#define BOARD_COLUMNS 7
GType player_get_type (void) G_GNUC_CONST;
GType difficulty_get_type (void) G_GNUC_CONST;
gint playgame (const gchar* moves_until_now);
#define DECISION_TREE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DECISION_TREE, DecisionTreePrivate))
static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta);
static gboolean decision_tree_board_full (DecisionTree* self);
static gint decision_tree_heurist (DecisionTree* self);
static gboolean decision_tree_move (DecisionTree* self, gint column);
static gboolean decision_tree_victory (DecisionTree* self, gint column);
static void decision_tree_unmove (DecisionTree* self, gint column);
static gboolean decision_tree_vertical_win (DecisionTree* self, gint i, gint j);
static gboolean decision_tree_horizontal_win (DecisionTree* self, gint i, gint j);
static gboolean decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j);
static gboolean decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j);
static gint decision_tree_immediate_win (DecisionTree* self, Player p);
static void decision_tree_set_level (DecisionTree* self, const gchar* vstr);
static gint decision_tree_heurist_easy (DecisionTree* self);
static gint decision_tree_heurist_medium (DecisionTree* self);
static gint decision_tree_heurist_hard (DecisionTree* self);
static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p);
static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j);
static void decision_tree_finalize (DecisionTree * obj);


GType player_get_type (void) {
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_HUMAN, "PLAYER_HUMAN", "human"}, {PLAYER_AI, "PLAYER_AI", "ai"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}


GType difficulty_get_type (void) {
	static volatile gsize difficulty_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_EASY, "DIFFICULTY_EASY", "easy"}, {DIFFICULTY_MEDIUM, "DIFFICULTY_MEDIUM", "medium"}, {DIFFICULTY_HARD, "DIFFICULTY_HARD", "hard"}, {0, NULL, NULL}};
		GType difficulty_type_id;
		difficulty_type_id = g_enum_register_static ("Difficulty", values);
		g_once_init_leave (&difficulty_type_id__volatile, difficulty_type_id);
	}
	return difficulty_type_id__volatile;
}


gint playgame (const gchar* moves_until_now) {
	gint result = 0;
	DecisionTree* t = NULL;
	DecisionTree* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_;
#line 32 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (moves_until_now != NULL, 0);
#line 34 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_new ();
#line 34 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	t = _tmp0_;
#line 35 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = moves_until_now;
#line 35 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_playgame (t, _tmp1_);
#line 35 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp2_;
#line 35 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_decision_tree_unref0 (t);
#line 35 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 156 "ai.c"
}


DecisionTree* decision_tree_construct (GType object_type) {
	DecisionTree* self = NULL;
#line 52 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self = (DecisionTree*) g_type_create_instance (object_type);
#line 164 "ai.c"
	{
		gint i = 0;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		i = 0;
#line 169 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 176 "ai.c"
				gint _tmp2_;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 180 "ai.c"
					gint _tmp1_;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 186 "ai.c"
				}
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_ROWS)) {
#line 54 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 196 "ai.c"
				}
				{
					gint j = 0;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					j = 0;
#line 202 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 209 "ai.c"
							gint _tmp5_;
							Player* _tmp6_;
							gint _tmp6__length1;
							gint _tmp6__length2;
							gint _tmp7_;
							gint _tmp8_;
							Player _tmp9_;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 219 "ai.c"
								gint _tmp4_;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp4_ = j;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								j = _tmp4_ + 1;
#line 225 "ai.c"
							}
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp5_ = j;
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 55 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								break;
#line 235 "ai.c"
							}
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp6_ = self->priv->board;
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp6__length1 = self->priv->board_length1;
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp6__length2 = self->priv->board_length2;
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp7_ = i;
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp8_ = j;
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_] = PLAYER_NONE;
#line 56 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 251 "ai.c"
						}
					}
				}
			}
		}
	}
#line 52 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return self;
#line 260 "ai.c"
}


DecisionTree* decision_tree_new (void) {
#line 52 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return decision_tree_construct (TYPE_DECISION_TREE);
#line 267 "ai.c"
}


void decision_tree_print_board (DecisionTree* self) {
	FILE* _tmp12_;
#line 60 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 275 "ai.c"
	{
		gint i = 0;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		i = 0;
#line 280 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 287 "ai.c"
				gint _tmp2_;
				FILE* _tmp11_;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 292 "ai.c"
					gint _tmp1_;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 298 "ai.c"
				}
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_ROWS)) {
#line 62 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 308 "ai.c"
				}
				{
					gint j = 0;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					j = 0;
#line 314 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 321 "ai.c"
							gint _tmp5_;
							FILE* _tmp6_;
							Player* _tmp7_;
							gint _tmp7__length1;
							gint _tmp7__length2;
							gint _tmp8_;
							gint _tmp9_;
							Player _tmp10_;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 332 "ai.c"
								gint _tmp4_;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp4_ = j;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								j = _tmp4_ + 1;
#line 338 "ai.c"
							}
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp5_ = j;
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 64 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								break;
#line 348 "ai.c"
							}
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp6_ = stdout;
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp7_ = self->priv->board;
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp7__length1 = self->priv->board_length1;
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp7__length2 = self->priv->board_length2;
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp8_ = i;
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp9_ = j;
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 65 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							fprintf (_tmp6_, "%d\t", (gint) _tmp10_);
#line 366 "ai.c"
						}
					}
				}
#line 66 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp11_ = stdout;
#line 66 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				fprintf (_tmp11_, "\n");
#line 374 "ai.c"
			}
		}
	}
#line 68 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp12_ = stdout;
#line 68 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	fprintf (_tmp12_, "\n");
#line 382 "ai.c"
}


static gint decision_tree_negamax (DecisionTree* self, gint height, gint alpha, gint beta) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint max = 0;
	gint next = 0;
	gint _tmp30_;
	gint _tmp31_;
#line 73 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 76 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = height;
#line 76 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp1_ == 0) {
#line 76 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 402 "ai.c"
	} else {
		gboolean _tmp2_;
#line 76 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp2_ = decision_tree_board_full (self);
#line 76 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = _tmp2_;
#line 409 "ai.c"
	}
#line 76 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp0_) {
#line 413 "ai.c"
		Player _tmp3_;
#line 78 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp3_ = self->priv->last_moving_player;
#line 78 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		if (_tmp3_ == PLAYER_HUMAN) {
#line 419 "ai.c"
			gint _tmp4_;
#line 79 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp4_ = decision_tree_heurist (self);
#line 79 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			result = _tmp4_;
#line 79 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			return result;
#line 427 "ai.c"
		} else {
			Player _tmp5_;
#line 80 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp5_ = self->priv->last_moving_player;
#line 80 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (_tmp5_ == PLAYER_AI) {
#line 434 "ai.c"
				gint _tmp6_;
#line 81 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp6_ = decision_tree_heurist (self);
#line 81 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				result = -1 * _tmp6_;
#line 81 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				return result;
#line 442 "ai.c"
			} else {
#line 83 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				result = 0;
#line 83 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				return result;
#line 448 "ai.c"
			}
		}
	}
#line 88 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	max = NEG_INF;
#line 92 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	next = -1;
#line 456 "ai.c"
	{
		gint column = 0;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		column = 0;
#line 461 "ai.c"
		{
			gboolean _tmp7_ = FALSE;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp7_ = TRUE;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 468 "ai.c"
				gint _tmp9_;
				gint _tmp10_;
				gboolean _tmp11_;
				gint _tmp12_ = 0;
				gint _tmp13_;
				gboolean _tmp14_;
				gint temp = 0;
				gint _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp28_;
				gint _tmp29_;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp7_) {
#line 485 "ai.c"
					gint _tmp8_;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp8_ = column;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					column = _tmp8_ + 1;
#line 491 "ai.c"
				}
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp7_ = FALSE;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp9_ = column;
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp9_ < BOARD_COLUMNS)) {
#line 94 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 501 "ai.c"
				}
#line 97 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp10_ = column;
#line 97 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp11_ = decision_tree_move (self, _tmp10_);
#line 97 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp11_) {
#line 98 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					continue;
#line 511 "ai.c"
				}
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp13_ = column;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp14_ = decision_tree_victory (self, _tmp13_);
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp14_) {
#line 519 "ai.c"
					gint _tmp15_;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp15_ = height;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp12_ = MAX_HEURIST_VALUE * _tmp15_;
#line 525 "ai.c"
				} else {
					gint _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp16_ = height;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp17_ = beta;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp18_ = alpha;
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp19_ = decision_tree_negamax (self, _tmp16_ - 1, -1 * _tmp17_, -1 * _tmp18_);
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp12_ = -1 * _tmp19_;
#line 541 "ai.c"
				}
#line 103 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				temp = _tmp12_;
#line 105 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp20_ = column;
#line 105 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				decision_tree_unmove (self, _tmp20_);
#line 107 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp21_ = temp;
#line 107 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp22_ = max;
#line 107 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp21_ > _tmp22_) {
#line 555 "ai.c"
					gint _tmp23_;
					gint _tmp24_;
#line 109 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp23_ = column;
#line 109 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					next = _tmp23_;
#line 110 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp24_ = temp;
#line 110 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					max = _tmp24_;
#line 566 "ai.c"
				}
#line 113 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp25_ = temp;
#line 113 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp26_ = alpha;
#line 113 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp25_ > _tmp26_) {
#line 574 "ai.c"
					gint _tmp27_;
#line 114 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp27_ = temp;
#line 114 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					alpha = _tmp27_;
#line 580 "ai.c"
				}
#line 116 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp28_ = alpha;
#line 116 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp29_ = beta;
#line 116 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp28_ >= _tmp29_) {
#line 117 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 590 "ai.c"
				}
			}
		}
	}
#line 121 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp30_ = height;
#line 121 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp31_ = self->priv->plies;
#line 121 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp30_ == _tmp31_) {
#line 601 "ai.c"
		gint _tmp32_;
#line 122 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp32_ = next;
#line 122 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		self->priv->next_move_in_column = _tmp32_;
#line 607 "ai.c"
	}
#line 124 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = max;
#line 124 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 613 "ai.c"
}


static gboolean decision_tree_victory (DecisionTree* self, gint column) {
	gboolean result = FALSE;
	gint row = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
#line 128 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 628 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		row = 0;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 637 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 642 "ai.c"
				gint _tmp1_;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp1_ = row;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				row = _tmp1_ + 1;
#line 648 "ai.c"
			}
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp3_ = row;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (_tmp3_ < BOARD_ROWS) {
#line 656 "ai.c"
				Player* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint _tmp5_;
				gint _tmp6_;
				Player _tmp7_;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5_ = row;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp6_ = column;
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ == PLAYER_NONE;
#line 677 "ai.c"
			} else {
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 681 "ai.c"
			}
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 132 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				break;
#line 687 "ai.c"
			}
		}
	}
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11_ = row;
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp12_ = column;
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp13_ = decision_tree_vertical_win (self, _tmp11_, _tmp12_);
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp13_) {
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp10_ = TRUE;
#line 701 "ai.c"
	} else {
		gint _tmp14_;
		gint _tmp15_;
		gboolean _tmp16_;
#line 135 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp14_ = row;
#line 135 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp15_ = column;
#line 135 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp16_ = decision_tree_horizontal_win (self, _tmp14_, _tmp15_);
#line 135 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp10_ = _tmp16_;
#line 714 "ai.c"
	}
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp10_) {
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp9_ = TRUE;
#line 720 "ai.c"
	} else {
		gint _tmp17_;
		gint _tmp18_;
		gboolean _tmp19_;
#line 136 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp17_ = row;
#line 136 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp18_ = column;
#line 136 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp19_ = decision_tree_forward_diagonal_win (self, _tmp17_, _tmp18_);
#line 136 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp9_ = _tmp19_;
#line 733 "ai.c"
	}
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp9_) {
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp8_ = TRUE;
#line 739 "ai.c"
	} else {
		gint _tmp20_;
		gint _tmp21_;
		gboolean _tmp22_;
#line 137 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp20_ = row;
#line 137 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp21_ = column;
#line 137 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp22_ = decision_tree_backward_diagonal_win (self, _tmp20_, _tmp21_);
#line 137 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp8_ = _tmp22_;
#line 752 "ai.c"
	}
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp8_;
#line 134 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 758 "ai.c"
}


static gboolean decision_tree_forward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp30_;
#line 140 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 142 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	count = 0;
#line 770 "ai.c"
	{
		gint k = 0;
		gint _tmp0_;
		gint l = 0;
		gint _tmp1_;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp1_ = j;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		l = _tmp1_;
#line 784 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 791 "ai.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 797 "ai.c"
					gint _tmp3_;
					gint _tmp4_;
					gint _tmp5_;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp3_ = k;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp3_ - 1;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp4_ = l;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					l = _tmp4_ + 1;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp5_ = count;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp5_ + 1;
#line 813 "ai.c"
				}
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp8_ = k;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp8_ >= 0) {
#line 821 "ai.c"
					gint _tmp9_;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp9_ = l;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp7_ = _tmp9_ < BOARD_COLUMNS;
#line 827 "ai.c"
				} else {
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp7_ = FALSE;
#line 831 "ai.c"
				}
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp7_) {
#line 835 "ai.c"
					Player* _tmp10_;
					gint _tmp10__length1;
					gint _tmp10__length2;
					gint _tmp11_;
					gint _tmp12_;
					Player _tmp13_;
					Player _tmp14_;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->board;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10__length1 = self->priv->board_length1;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10__length2 = self->priv->board_length2;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp11_ = k;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp12_ = l;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp14_ = self->priv->last_moving_player;
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6_ = _tmp13_ == _tmp14_;
#line 859 "ai.c"
				} else {
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6_ = FALSE;
#line 863 "ai.c"
				}
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 144 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 869 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_;
		gint l = 0;
		gint _tmp16_;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp15_ + 1;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp16_ = j;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		l = _tmp16_ - 1;
#line 887 "ai.c"
		{
			gboolean _tmp17_ = FALSE;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp17_ = TRUE;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 894 "ai.c"
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp17_) {
#line 900 "ai.c"
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp18_ = k;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp18_ + 1;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp19_ = l;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					l = _tmp19_ - 1;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp20_ = count;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp20_ + 1;
#line 916 "ai.c"
				}
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp17_ = FALSE;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp23_ = k;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp23_ < BOARD_ROWS) {
#line 924 "ai.c"
					gint _tmp24_;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp24_ = l;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp22_ = _tmp24_ >= 0;
#line 930 "ai.c"
				} else {
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp22_ = FALSE;
#line 934 "ai.c"
				}
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp22_) {
#line 938 "ai.c"
					Player* _tmp25_;
					gint _tmp25__length1;
					gint _tmp25__length2;
					gint _tmp26_;
					gint _tmp27_;
					Player _tmp28_;
					Player _tmp29_;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp25_ = self->priv->board;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp25__length1 = self->priv->board_length1;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp25__length2 = self->priv->board_length2;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp26_ = k;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp27_ = l;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp29_ = self->priv->last_moving_player;
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp21_ = _tmp28_ == _tmp29_;
#line 962 "ai.c"
				} else {
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp21_ = FALSE;
#line 966 "ai.c"
				}
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp21_) {
#line 145 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 972 "ai.c"
				}
			}
		}
	}
#line 147 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp30_ = count;
#line 147 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp30_ >= 4;
#line 147 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 983 "ai.c"
}


static gboolean decision_tree_backward_diagonal_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp30_;
#line 150 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 152 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	count = 0;
#line 995 "ai.c"
	{
		gint k = 0;
		gint _tmp0_;
		gint l = 0;
		gint _tmp1_;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp1_ = j;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		l = _tmp1_;
#line 1009 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1016 "ai.c"
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp8_;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 1022 "ai.c"
					gint _tmp3_;
					gint _tmp4_;
					gint _tmp5_;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp3_ = k;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp3_ - 1;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp4_ = l;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					l = _tmp4_ - 1;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp5_ = count;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp5_ + 1;
#line 1038 "ai.c"
				}
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp8_ = k;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp8_ >= 0) {
#line 1046 "ai.c"
					gint _tmp9_;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp9_ = l;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp7_ = _tmp9_ >= 0;
#line 1052 "ai.c"
				} else {
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp7_ = FALSE;
#line 1056 "ai.c"
				}
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp7_) {
#line 1060 "ai.c"
					Player* _tmp10_;
					gint _tmp10__length1;
					gint _tmp10__length2;
					gint _tmp11_;
					gint _tmp12_;
					Player _tmp13_;
					Player _tmp14_;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->board;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10__length1 = self->priv->board_length1;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10__length2 = self->priv->board_length2;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp11_ = k;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp12_ = l;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp14_ = self->priv->last_moving_player;
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6_ = _tmp13_ == _tmp14_;
#line 1084 "ai.c"
				} else {
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6_ = FALSE;
#line 1088 "ai.c"
				}
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp6_) {
#line 154 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1094 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp15_;
		gint l = 0;
		gint _tmp16_;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp15_ + 1;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp16_ = j;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		l = _tmp16_ + 1;
#line 1112 "ai.c"
		{
			gboolean _tmp17_ = FALSE;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp17_ = TRUE;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1119 "ai.c"
				gboolean _tmp21_ = FALSE;
				gboolean _tmp22_ = FALSE;
				gint _tmp23_;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp17_) {
#line 1125 "ai.c"
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp18_ = k;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp18_ + 1;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp19_ = l;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					l = _tmp19_ + 1;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp20_ = count;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp20_ + 1;
#line 1141 "ai.c"
				}
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp17_ = FALSE;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp23_ = k;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp23_ < BOARD_ROWS) {
#line 1149 "ai.c"
					gint _tmp24_;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp24_ = l;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp22_ = _tmp24_ < BOARD_COLUMNS;
#line 1155 "ai.c"
				} else {
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp22_ = FALSE;
#line 1159 "ai.c"
				}
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp22_) {
#line 1163 "ai.c"
					Player* _tmp25_;
					gint _tmp25__length1;
					gint _tmp25__length2;
					gint _tmp26_;
					gint _tmp27_;
					Player _tmp28_;
					Player _tmp29_;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp25_ = self->priv->board;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp25__length1 = self->priv->board_length1;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp25__length2 = self->priv->board_length2;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp26_ = k;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp27_ = l;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp29_ = self->priv->last_moving_player;
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp21_ = _tmp28_ == _tmp29_;
#line 1187 "ai.c"
				} else {
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp21_ = FALSE;
#line 1191 "ai.c"
				}
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp21_) {
#line 155 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1197 "ai.c"
				}
			}
		}
	}
#line 157 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp30_ = count;
#line 157 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp30_ >= 4;
#line 157 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 1208 "ai.c"
}


static gboolean decision_tree_horizontal_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp22_;
#line 160 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 162 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	count = 0;
#line 1220 "ai.c"
	{
		gint k = 0;
		gint _tmp0_;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = j;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 1228 "ai.c"
		{
			gboolean _tmp1_ = FALSE;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp1_ = TRUE;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1235 "ai.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp5_;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp1_) {
#line 1240 "ai.c"
					gint _tmp2_;
					gint _tmp3_;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp2_ = k;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp2_ - 1;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp3_ = count;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp3_ + 1;
#line 1251 "ai.c"
				}
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp1_ = FALSE;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5_ = k;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp5_ >= 0) {
#line 1259 "ai.c"
					Player* _tmp6_;
					gint _tmp6__length1;
					gint _tmp6__length2;
					gint _tmp7_;
					gint _tmp8_;
					Player _tmp9_;
					Player _tmp10_;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6_ = self->priv->board;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6__length1 = self->priv->board_length1;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6__length2 = self->priv->board_length2;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp7_ = i;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp8_ = k;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->last_moving_player;
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp4_ = _tmp9_ == _tmp10_;
#line 1283 "ai.c"
				} else {
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp4_ = FALSE;
#line 1287 "ai.c"
				}
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp4_) {
#line 164 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1293 "ai.c"
				}
			}
		}
	}
	{
		gint k = 0;
		gint _tmp11_;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp11_ = j;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp11_ + 1;
#line 1305 "ai.c"
		{
			gboolean _tmp12_ = FALSE;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp12_ = TRUE;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1312 "ai.c"
				gboolean _tmp15_ = FALSE;
				gint _tmp16_;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp12_) {
#line 1317 "ai.c"
					gint _tmp13_;
					gint _tmp14_;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp13_ = k;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp13_ + 1;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp14_ = count;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp14_ + 1;
#line 1328 "ai.c"
				}
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp12_ = FALSE;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp16_ = k;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp16_ < BOARD_COLUMNS) {
#line 1336 "ai.c"
					Player* _tmp17_;
					gint _tmp17__length1;
					gint _tmp17__length2;
					gint _tmp18_;
					gint _tmp19_;
					Player _tmp20_;
					Player _tmp21_;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp17_ = self->priv->board;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp17__length1 = self->priv->board_length1;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp17__length2 = self->priv->board_length2;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp18_ = i;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp19_ = k;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp21_ = self->priv->last_moving_player;
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp15_ = _tmp20_ == _tmp21_;
#line 1360 "ai.c"
				} else {
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp15_ = FALSE;
#line 1364 "ai.c"
				}
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp15_) {
#line 165 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1370 "ai.c"
				}
			}
		}
	}
#line 167 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp22_ = count;
#line 167 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp22_ >= 4;
#line 167 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 1381 "ai.c"
}


static gboolean decision_tree_vertical_win (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
	gint count = 0;
	gint _tmp11_;
#line 170 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 172 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	count = 0;
#line 1393 "ai.c"
	{
		gint k = 0;
		gint _tmp0_;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = i;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = _tmp0_;
#line 1401 "ai.c"
		{
			gboolean _tmp1_ = FALSE;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp1_ = TRUE;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1408 "ai.c"
				gboolean _tmp4_ = FALSE;
				gint _tmp5_;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp1_) {
#line 1413 "ai.c"
					gint _tmp2_;
					gint _tmp3_;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp2_ = k;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp2_ + 1;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp3_ = count;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					count = _tmp3_ + 1;
#line 1424 "ai.c"
				}
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp1_ = FALSE;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5_ = k;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp5_ < BOARD_ROWS) {
#line 1432 "ai.c"
					Player* _tmp6_;
					gint _tmp6__length1;
					gint _tmp6__length2;
					gint _tmp7_;
					gint _tmp8_;
					Player _tmp9_;
					Player _tmp10_;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6_ = self->priv->board;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6__length1 = self->priv->board_length1;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp6__length2 = self->priv->board_length2;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp7_ = k;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp8_ = j;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp9_ = _tmp6_[(_tmp7_ * _tmp6__length2) + _tmp8_];
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp10_ = self->priv->last_moving_player;
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp4_ = _tmp9_ == _tmp10_;
#line 1456 "ai.c"
				} else {
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp4_ = FALSE;
#line 1460 "ai.c"
				}
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp4_) {
#line 174 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1466 "ai.c"
				}
			}
		}
	}
#line 176 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11_ = count;
#line 176 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp11_ >= 4;
#line 176 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 1477 "ai.c"
}


static gboolean decision_tree_board_full (DecisionTree* self) {
	gboolean result = FALSE;
#line 180 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1485 "ai.c"
	{
		gint i = 0;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		i = 0;
#line 1490 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1497 "ai.c"
				gint _tmp2_;
				Player* _tmp3_;
				gint _tmp3__length1;
				gint _tmp3__length2;
				gint _tmp4_;
				Player _tmp5_;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 1506 "ai.c"
					gint _tmp1_;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp1_ = i;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					i = _tmp1_ + 1;
#line 1512 "ai.c"
				}
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = i;
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ < BOARD_COLUMNS)) {
#line 182 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1522 "ai.c"
				}
#line 183 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp3_ = self->priv->board;
#line 183 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp3__length1 = self->priv->board_length1;
#line 183 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp3__length2 = self->priv->board_length2;
#line 183 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4_ = i;
#line 183 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5_ = _tmp3_[(0 * _tmp3__length2) + _tmp4_];
#line 183 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp5_ == PLAYER_NONE) {
#line 184 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					result = FALSE;
#line 184 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					return result;
#line 1540 "ai.c"
				}
			}
		}
	}
#line 185 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 185 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 1549 "ai.c"
}


static gboolean decision_tree_move (DecisionTree* self, gint column) {
	gboolean result = FALSE;
	gint row = 0;
	gint _tmp8_;
	Player _tmp9_ = 0;
	Player _tmp10_;
	Player player = 0;
	Player* _tmp11_;
	gint _tmp11__length1;
	gint _tmp11__length2;
	gint _tmp12_;
	gint _tmp13_;
	Player _tmp14_;
	Player _tmp15_;
	Player _tmp16_;
#line 189 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1570 "ai.c"
	{
		gboolean _tmp0_ = FALSE;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		row = BOARD_ROWS - 1;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp0_ = TRUE;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 1579 "ai.c"
			gboolean _tmp2_ = FALSE;
			gint _tmp3_;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp0_) {
#line 1584 "ai.c"
				gint _tmp1_;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp1_ = row;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				row = _tmp1_ - 1;
#line 1590 "ai.c"
			}
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp0_ = FALSE;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp3_ = row;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (_tmp3_ >= 0) {
#line 1598 "ai.c"
				Player* _tmp4_;
				gint _tmp4__length1;
				gint _tmp4__length2;
				gint _tmp5_;
				gint _tmp6_;
				Player _tmp7_;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4_ = self->priv->board;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4__length1 = self->priv->board_length1;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4__length2 = self->priv->board_length2;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5_ = row;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp6_ = column;
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = _tmp7_ != PLAYER_NONE;
#line 1619 "ai.c"
			} else {
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 1623 "ai.c"
			}
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp2_) {
#line 193 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				break;
#line 1629 "ai.c"
			}
		}
	}
#line 195 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp8_ = row;
#line 195 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp8_ < 0) {
#line 196 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		result = FALSE;
#line 196 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return result;
#line 1641 "ai.c"
	}
#line 199 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp10_ = self->priv->last_moving_player;
#line 199 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp10_ != PLAYER_AI) {
#line 199 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp9_ = PLAYER_AI;
#line 1649 "ai.c"
	} else {
#line 199 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp9_ = PLAYER_HUMAN;
#line 1653 "ai.c"
	}
#line 199 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	player = _tmp9_;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11_ = self->priv->board;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11__length1 = self->priv->board_length1;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11__length2 = self->priv->board_length2;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp12_ = row;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp13_ = column;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp14_ = player;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
#line 200 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 201 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp16_ = player;
#line 201 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp16_;
#line 203 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 203 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 1681 "ai.c"
}


static void decision_tree_unmove (DecisionTree* self, gint column) {
	Player _tmp0_;
	gint row = 0;
	Player* _tmp9_;
	gint _tmp9__length1;
	gint _tmp9__length2;
	gint _tmp10_;
	gint _tmp11_;
	Player _tmp12_;
	Player _tmp13_ = 0;
	Player _tmp14_;
#line 207 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 207 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 207 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_vala_return_if_fail (_tmp0_ != PLAYER_NONE, "last_moving_player != Player.NONE");
#line 1702 "ai.c"
	{
		gboolean _tmp1_ = FALSE;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		row = 0;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp1_ = TRUE;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 1711 "ai.c"
			gboolean _tmp3_ = FALSE;
			gint _tmp4_;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp1_) {
#line 1716 "ai.c"
				gint _tmp2_;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = row;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				row = _tmp2_ + 1;
#line 1722 "ai.c"
			}
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp1_ = FALSE;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp4_ = row;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (_tmp4_ < BOARD_ROWS) {
#line 1730 "ai.c"
				Player* _tmp5_;
				gint _tmp5__length1;
				gint _tmp5__length2;
				gint _tmp6_;
				gint _tmp7_;
				Player _tmp8_;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5_ = self->priv->board;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5__length1 = self->priv->board_length1;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp5__length2 = self->priv->board_length2;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp6_ = row;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp7_ = column;
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp3_ = _tmp8_ == PLAYER_NONE;
#line 1751 "ai.c"
			} else {
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp3_ = FALSE;
#line 1755 "ai.c"
			}
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp3_) {
#line 212 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				break;
#line 1761 "ai.c"
			}
		}
	}
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp9_ = self->priv->board;
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp9__length1 = self->priv->board_length1;
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp9__length2 = self->priv->board_length2;
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp10_ = row;
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp11_ = column;
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_] = PLAYER_NONE;
#line 214 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 216 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp14_ = self->priv->last_moving_player;
#line 216 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp14_ == PLAYER_AI) {
#line 216 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp13_ = PLAYER_HUMAN;
#line 1785 "ai.c"
	} else {
#line 216 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp13_ = PLAYER_AI;
#line 1789 "ai.c"
	}
#line 216 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp13_;
#line 1793 "ai.c"
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
#line 1118 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp0_ = index;
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	_tmp1_ = ((gchar*) self)[_tmp0_];
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	result = _tmp1_;
#line 1119 "/home/mcatanzaro/Projects/GNOME/install/share/vala-0.38/vapi/glib-2.0.vapi"
	return result;
#line 1811 "ai.c"
}


void decision_tree_update_board (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	Player _tmp3_ = 0;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	Player move = 0;
#line 220 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 220 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (vstr != NULL);
#line 222 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->next_move_in_column = -1;
#line 225 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 225 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = strlen (_tmp0_);
#line 225 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp2_ = _tmp1_;
#line 225 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp2_ == 2) {
#line 225 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return;
#line 1840 "ai.c"
	}
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp4_ = vstr;
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp5_ = strlen (_tmp4_);
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp6_ = _tmp5_;
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if ((_tmp6_ % 2) == 0) {
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp3_ = PLAYER_AI;
#line 1852 "ai.c"
	} else {
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp3_ = PLAYER_HUMAN;
#line 1856 "ai.c"
	}
#line 227 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	move = _tmp3_;
#line 1860 "ai.c"
	{
		gint i = 0;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		i = 1;
#line 1865 "ai.c"
		{
			gboolean _tmp7_ = FALSE;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp7_ = TRUE;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 1872 "ai.c"
				gint _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint column = 0;
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint row = 0;
				Player* _tmp28_;
				gint _tmp28__length1;
				gint _tmp28__length2;
				gint _tmp29_;
				gint _tmp30_;
				Player _tmp31_;
				Player _tmp32_;
				Player _tmp33_ = 0;
				Player _tmp34_;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp7_) {
#line 1897 "ai.c"
					gint _tmp8_;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp8_ = i;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					i = _tmp8_ + 1;
#line 1903 "ai.c"
				}
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp7_ = FALSE;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp9_ = i;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp10_ = vstr;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp11_ = strlen (_tmp10_);
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp12_ = _tmp11_;
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp9_ < (_tmp12_ - 1))) {
#line 229 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 1919 "ai.c"
				}
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp13_ = vstr;
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp14_ = i;
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp16_ = g_strdup_printf ("%c", _tmp15_);
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp17_ = _tmp16_;
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp18_ = atoi (_tmp17_);
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp19_ = _tmp18_ - 1;
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_g_free0 (_tmp17_);
#line 231 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				column = _tmp19_;
#line 1939 "ai.c"
				{
					gboolean _tmp20_ = FALSE;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					row = BOARD_ROWS - 1;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp20_ = TRUE;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					while (TRUE) {
#line 1948 "ai.c"
						gboolean _tmp22_ = FALSE;
						gint _tmp23_;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						if (!_tmp20_) {
#line 1953 "ai.c"
							gint _tmp21_;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp21_ = row;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							row = _tmp21_ - 1;
#line 1959 "ai.c"
						}
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						_tmp20_ = FALSE;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						_tmp23_ = row;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						if (_tmp23_ >= 0) {
#line 1967 "ai.c"
							Player* _tmp24_;
							gint _tmp24__length1;
							gint _tmp24__length2;
							gint _tmp25_;
							gint _tmp26_;
							Player _tmp27_;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp24_ = self->priv->board;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp24__length1 = self->priv->board_length1;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp24__length2 = self->priv->board_length2;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp25_ = row;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp26_ = column;
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp22_ = _tmp27_ != PLAYER_NONE;
#line 1988 "ai.c"
						} else {
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp22_ = FALSE;
#line 1992 "ai.c"
						}
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						if (!_tmp22_) {
#line 235 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							break;
#line 1998 "ai.c"
						}
					}
				}
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp28_ = self->priv->board;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp28__length1 = self->priv->board_length1;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp28__length2 = self->priv->board_length2;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp29_ = row;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp30_ = column;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp31_ = move;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_] = _tmp31_;
#line 237 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp32_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
#line 239 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp34_ = move;
#line 239 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (_tmp34_ == PLAYER_HUMAN) {
#line 239 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp33_ = PLAYER_AI;
#line 2024 "ai.c"
				} else {
#line 239 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp33_ = PLAYER_HUMAN;
#line 2028 "ai.c"
				}
#line 239 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				move = _tmp33_;
#line 2032 "ai.c"
			}
		}
	}
#line 242 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = PLAYER_HUMAN;
#line 2038 "ai.c"
}


static gint decision_tree_immediate_win (DecisionTree* self, Player p) {
	gint result = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_;
	Player _tmp1_ = 0;
	Player _tmp2_;
	gboolean player_wins = FALSE;
	gint i = 0;
	Player _tmp12_;
	gint _tmp13_ = 0;
	gboolean _tmp14_;
#line 247 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 249 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 249 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	old_last_moving_player = _tmp0_;
#line 251 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp2_ = p;
#line 251 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp2_ == PLAYER_AI) {
#line 251 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp1_ = PLAYER_HUMAN;
#line 2065 "ai.c"
	} else {
#line 251 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp1_ = PLAYER_AI;
#line 2069 "ai.c"
	}
#line 251 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp1_;
#line 253 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	player_wins = FALSE;
#line 2075 "ai.c"
	{
		gboolean _tmp3_ = FALSE;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		i = 0;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp3_ = TRUE;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		while (TRUE) {
#line 2084 "ai.c"
			gint _tmp5_;
			gint _tmp6_;
			gboolean _tmp7_;
			gint _tmp8_;
			gboolean _tmp9_;
			gint _tmp10_;
			gboolean _tmp11_;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp3_) {
#line 2094 "ai.c"
				gint _tmp4_;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4_ = i;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				i = _tmp4_ + 1;
#line 2100 "ai.c"
			}
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp3_ = FALSE;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp5_ = i;
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!(_tmp5_ < BOARD_COLUMNS)) {
#line 255 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				break;
#line 2110 "ai.c"
			}
#line 257 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp6_ = i;
#line 257 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp7_ = decision_tree_move (self, _tmp6_);
#line 257 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (!_tmp7_) {
#line 258 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				continue;
#line 2120 "ai.c"
			}
#line 260 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp8_ = i;
#line 260 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp9_ = decision_tree_victory (self, _tmp8_);
#line 260 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			player_wins = _tmp9_;
#line 261 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp10_ = i;
#line 261 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			decision_tree_unmove (self, _tmp10_);
#line 263 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp11_ = player_wins;
#line 263 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			if (_tmp11_) {
#line 264 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				break;
#line 2138 "ai.c"
			}
		}
	}
#line 267 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp12_ = old_last_moving_player;
#line 267 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp12_;
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp14_ = player_wins;
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp14_) {
#line 2150 "ai.c"
		gint _tmp15_;
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp15_ = i;
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp13_ = _tmp15_;
#line 2156 "ai.c"
	} else {
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp13_ = -1;
#line 2160 "ai.c"
	}
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp13_;
#line 270 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2166 "ai.c"
}


gint decision_tree_playgame (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint temp = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp8_;
	gint _tmp9_;
#line 274 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 274 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (vstr != NULL, 0);
#line 277 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 277 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_set_level (self, _tmp0_);
#line 280 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = vstr;
#line 280 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_update_board (self, _tmp1_);
#line 284 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
#line 284 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	temp = _tmp2_;
#line 285 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp3_ = temp;
#line 285 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp3_ != -1) {
#line 2201 "ai.c"
		gint _tmp4_;
#line 286 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp4_ = temp;
#line 286 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		result = _tmp4_ + 1;
#line 286 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return result;
#line 2209 "ai.c"
	}
#line 290 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp5_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
#line 290 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	temp = _tmp5_;
#line 291 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp6_ = temp;
#line 291 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp6_ != -1) {
#line 2219 "ai.c"
		gint _tmp7_;
#line 292 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp7_ = temp;
#line 292 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		result = _tmp7_ + 1;
#line 292 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return result;
#line 2227 "ai.c"
	}
#line 295 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->plies;
#line 295 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_negamax (self, _tmp8_, NEG_INF, -1 * NEG_INF);
#line 298 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp9_ = self->priv->next_move_in_column;
#line 298 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp9_ + 1;
#line 298 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2239 "ai.c"
}


static gint decision_tree_heurist (DecisionTree* self) {
	gint result = 0;
	Difficulty _tmp0_;
#line 302 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 304 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->level;
#line 304 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp0_ == DIFFICULTY_EASY) {
#line 2252 "ai.c"
		gint _tmp1_;
#line 305 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp1_ = decision_tree_heurist_easy (self);
#line 305 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		result = _tmp1_;
#line 305 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return result;
#line 2260 "ai.c"
	} else {
		Difficulty _tmp2_;
#line 306 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp2_ = self->priv->level;
#line 306 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		if (_tmp2_ == DIFFICULTY_MEDIUM) {
#line 2267 "ai.c"
			gint _tmp3_;
#line 307 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp3_ = decision_tree_heurist_medium (self);
#line 307 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			result = _tmp3_;
#line 307 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			return result;
#line 2275 "ai.c"
		} else {
			gint _tmp4_;
#line 309 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp4_ = decision_tree_heurist_hard (self);
#line 309 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			result = _tmp4_;
#line 309 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			return result;
#line 2284 "ai.c"
		}
	}
}


static gint decision_tree_heurist_easy (DecisionTree* self) {
	gint result = 0;
	gint _tmp0_;
#line 312 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 314 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_heurist_hard (self);
#line 314 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = -1 * _tmp0_;
#line 314 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2301 "ai.c"
}


static gint decision_tree_heurist_medium (DecisionTree* self) {
	gint result = 0;
	gint32 _tmp0_;
#line 317 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 319 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = g_random_int_range ((gint32) 1, (gint32) 49);
#line 319 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = (gint) _tmp0_;
#line 319 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2316 "ai.c"
}


static gint decision_tree_heurist_hard (DecisionTree* self) {
	gint result = 0;
	gint count = 0;
	gint _tmp0_;
	gint _tmp1_;
	gint32 _tmp2_ = 0;
	gint _tmp3_;
#line 322 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 324 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = decision_tree_count_3_in_a_row (self, PLAYER_AI);
#line 324 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = decision_tree_count_3_in_a_row (self, PLAYER_HUMAN);
#line 324 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	count = _tmp0_ - _tmp1_;
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp3_ = count;
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp3_ == 0) {
#line 2339 "ai.c"
		gint32 _tmp4_;
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp4_ = g_random_int_range ((gint32) 1, (gint32) 49);
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp2_ = _tmp4_;
#line 2345 "ai.c"
	} else {
		gint _tmp5_;
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp5_ = count;
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp2_ = (gint32) (_tmp5_ * 100);
#line 2352 "ai.c"
	}
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = (gint) _tmp2_;
#line 325 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2358 "ai.c"
}


static gint decision_tree_count_3_in_a_row (DecisionTree* self, Player p) {
	gint result = 0;
	gint count = 0;
	Player old_last_moving_player = 0;
	Player _tmp0_;
	Player _tmp1_;
	Player _tmp27_;
#line 330 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 332 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	count = 0;
#line 334 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = self->priv->last_moving_player;
#line 334 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	old_last_moving_player = _tmp0_;
#line 336 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = p;
#line 336 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp1_;
#line 2381 "ai.c"
	{
		gint j = 0;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		j = 0;
#line 2386 "ai.c"
		{
			gboolean _tmp2_ = FALSE;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp2_ = TRUE;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2393 "ai.c"
				gint _tmp4_;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp2_) {
#line 2397 "ai.c"
					gint _tmp3_;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp3_ = j;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					j = _tmp3_ + 1;
#line 2403 "ai.c"
				}
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = FALSE;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp4_ = j;
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp4_ < BOARD_COLUMNS)) {
#line 338 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 2413 "ai.c"
				}
				{
					gint i = 0;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					i = 0;
#line 2419 "ai.c"
					{
						gboolean _tmp5_ = FALSE;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						_tmp5_ = TRUE;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 2426 "ai.c"
							gint _tmp7_;
							Player* _tmp8_;
							gint _tmp8__length1;
							gint _tmp8__length2;
							gint _tmp9_;
							gint _tmp10_;
							Player _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gboolean _tmp14_;
							Player* _tmp15_;
							gint _tmp15__length1;
							gint _tmp15__length2;
							gint _tmp16_;
							gint _tmp17_;
							Player _tmp18_;
							Player _tmp19_;
							gint _tmp20_;
							gboolean _tmp21_;
							Player* _tmp23_;
							gint _tmp23__length1;
							gint _tmp23__length2;
							gint _tmp24_;
							gint _tmp25_;
							Player _tmp26_;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!_tmp5_) {
#line 2454 "ai.c"
								gint _tmp6_;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp6_ = i;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								i = _tmp6_ + 1;
#line 2460 "ai.c"
							}
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp5_ = FALSE;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp7_ = i;
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!(_tmp7_ < BOARD_ROWS)) {
#line 340 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								break;
#line 2470 "ai.c"
							}
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp8_ = self->priv->board;
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp8__length1 = self->priv->board_length1;
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp8__length2 = self->priv->board_length2;
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp9_ = i;
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp10_ = j;
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 342 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp11_ != PLAYER_NONE) {
#line 343 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								break;
#line 2488 "ai.c"
							}
#line 345 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp12_ = i;
#line 345 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp13_ = j;
#line 345 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp14_ = decision_tree_all_adjacent_empty (self, _tmp12_, _tmp13_);
#line 345 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp14_) {
#line 346 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								continue;
#line 2500 "ai.c"
							}
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp15_ = self->priv->board;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp15__length1 = self->priv->board_length1;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp15__length2 = self->priv->board_length2;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp16_ = i;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp17_ = j;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp18_ = p;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_] = _tmp18_;
#line 348 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp19_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 350 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp20_ = j;
#line 350 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp21_ = decision_tree_victory (self, _tmp20_);
#line 350 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp21_) {
#line 2524 "ai.c"
								gint _tmp22_;
#line 351 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp22_ = count;
#line 351 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								count = _tmp22_ + 1;
#line 2530 "ai.c"
							}
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp23_ = self->priv->board;
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp23__length1 = self->priv->board_length1;
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp23__length2 = self->priv->board_length2;
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp24_ = i;
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp25_ = j;
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_] = PLAYER_NONE;
#line 353 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp26_ = _tmp23_[(_tmp24_ * _tmp23__length2) + _tmp25_];
#line 2546 "ai.c"
						}
					}
				}
			}
		}
	}
#line 356 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp27_ = old_last_moving_player;
#line 356 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = _tmp27_;
#line 357 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = count;
#line 357 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2561 "ai.c"
}


static gboolean decision_tree_all_adjacent_empty (DecisionTree* self, gint i, gint j) {
	gboolean result = FALSE;
#line 361 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 2569 "ai.c"
	{
		gint k = 0;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		k = -1;
#line 2574 "ai.c"
		{
			gboolean _tmp0_ = FALSE;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			_tmp0_ = TRUE;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			while (TRUE) {
#line 2581 "ai.c"
				gint _tmp2_;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!_tmp0_) {
#line 2585 "ai.c"
					gint _tmp1_;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					_tmp1_ = k;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					k = _tmp1_ + 1;
#line 2591 "ai.c"
				}
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp0_ = FALSE;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				_tmp2_ = k;
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
				if (!(_tmp2_ <= 1)) {
#line 363 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					break;
#line 2601 "ai.c"
				}
				{
					gint l = 0;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
					l = -1;
#line 2607 "ai.c"
					{
						gboolean _tmp3_ = FALSE;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						_tmp3_ = TRUE;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
						while (TRUE) {
#line 2614 "ai.c"
							gint _tmp5_;
							gboolean _tmp6_ = FALSE;
							gint _tmp7_;
							gboolean _tmp9_ = FALSE;
							gboolean _tmp10_ = FALSE;
							gboolean _tmp11_ = FALSE;
							gboolean _tmp12_ = FALSE;
							gint _tmp13_;
							gint _tmp14_;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!_tmp3_) {
#line 2626 "ai.c"
								gint _tmp4_;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp4_ = l;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								l = _tmp4_ + 1;
#line 2632 "ai.c"
							}
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp3_ = FALSE;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp5_ = l;
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (!(_tmp5_ <= 1)) {
#line 365 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								break;
#line 2642 "ai.c"
							}
#line 367 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp7_ = k;
#line 367 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp7_ == 0) {
#line 2648 "ai.c"
								gint _tmp8_;
#line 367 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp8_ = l;
#line 367 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp6_ = _tmp8_ == 0;
#line 2654 "ai.c"
							} else {
#line 367 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp6_ = FALSE;
#line 2658 "ai.c"
							}
#line 367 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp6_) {
#line 368 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								continue;
#line 2664 "ai.c"
							}
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp13_ = i;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							_tmp14_ = k;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if ((_tmp13_ + _tmp14_) >= 0) {
#line 2672 "ai.c"
								gint _tmp15_;
								gint _tmp16_;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp15_ = i;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp16_ = k;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp12_ = (_tmp15_ + _tmp16_) < BOARD_ROWS;
#line 2681 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp12_ = FALSE;
#line 2685 "ai.c"
							}
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp12_) {
#line 2689 "ai.c"
								gint _tmp17_;
								gint _tmp18_;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp17_ = j;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp18_ = l;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp11_ = (_tmp17_ + _tmp18_) >= 0;
#line 2698 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp11_ = FALSE;
#line 2702 "ai.c"
							}
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp11_) {
#line 2706 "ai.c"
								gint _tmp19_;
								gint _tmp20_;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp19_ = j;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp20_ = l;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp10_ = (_tmp19_ + _tmp20_) < BOARD_COLUMNS;
#line 2715 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp10_ = FALSE;
#line 2719 "ai.c"
							}
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp10_) {
#line 2723 "ai.c"
								Player* _tmp21_;
								gint _tmp21__length1;
								gint _tmp21__length2;
								gint _tmp22_;
								gint _tmp23_;
								gint _tmp24_;
								gint _tmp25_;
								Player _tmp26_;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp21_ = self->priv->board;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp21__length1 = self->priv->board_length1;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp21__length2 = self->priv->board_length2;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp22_ = i;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp23_ = k;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp24_ = j;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp25_ = l;
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp26_ = _tmp21_[((_tmp22_ + _tmp23_) * _tmp21__length2) + (_tmp24_ + _tmp25_)];
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp9_ = _tmp26_ != PLAYER_NONE;
#line 2750 "ai.c"
							} else {
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								_tmp9_ = FALSE;
#line 2754 "ai.c"
							}
#line 369 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
							if (_tmp9_) {
#line 370 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								result = FALSE;
#line 370 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
								return result;
#line 2762 "ai.c"
							}
						}
					}
				}
			}
		}
	}
#line 374 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = TRUE;
#line 374 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2774 "ai.c"
}


static void decision_tree_set_level (DecisionTree* self, const gchar* vstr) {
	const gchar* _tmp0_;
	gchar _tmp1_;
#line 378 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (self != NULL);
#line 378 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (vstr != NULL);
#line 380 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 380 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = string_get (_tmp0_, (glong) 0);
#line 380 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp1_ == 'a') {
#line 382 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		self->priv->level = DIFFICULTY_EASY;
#line 383 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		self->priv->plies = 4;
#line 2795 "ai.c"
	} else {
		const gchar* _tmp2_;
		gchar _tmp3_;
#line 385 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp2_ = vstr;
#line 385 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp3_ = string_get (_tmp2_, (glong) 0);
#line 385 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		if (_tmp3_ == 'b') {
#line 387 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			self->priv->level = DIFFICULTY_MEDIUM;
#line 388 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			self->priv->plies = 7;
#line 2809 "ai.c"
		} else {
#line 392 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			self->priv->level = DIFFICULTY_HARD;
#line 393 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			self->priv->plies = 7;
#line 2815 "ai.c"
		}
	}
}


gint decision_tree_playandcheck (DecisionTree* self, const gchar* vstr) {
	gint result = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint temp = 0;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp7_;
	gint _tmp8_;
#line 398 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 398 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (vstr != NULL, 0);
#line 400 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = vstr;
#line 400 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_set_level (self, _tmp0_);
#line 401 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp1_ = vstr;
#line 401 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_update_board (self, _tmp1_);
#line 403 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp2_ = decision_tree_immediate_win (self, PLAYER_AI);
#line 403 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	temp = _tmp2_;
#line 404 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp3_ = temp;
#line 404 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp3_ != -1) {
#line 405 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		result = 1000;
#line 405 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return result;
#line 2856 "ai.c"
	}
#line 407 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp4_ = decision_tree_immediate_win (self, PLAYER_HUMAN);
#line 407 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	temp = _tmp4_;
#line 408 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp5_ = temp;
#line 408 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (_tmp5_ != -1) {
#line 2866 "ai.c"
		gint _tmp6_;
#line 409 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		_tmp6_ = temp;
#line 409 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		result = _tmp6_ + 1;
#line 409 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return result;
#line 2874 "ai.c"
	}
#line 411 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp7_ = self->priv->plies;
#line 411 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_negamax (self, _tmp7_, NEG_INF, -1 * NEG_INF);
#line 413 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp8_ = self->priv->next_move_in_column;
#line 413 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	result = _tmp8_ + 1;
#line 413 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return result;
#line 2886 "ai.c"
}


static void value_decision_tree_init (GValue* value) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	value->data[0].v_pointer = NULL;
#line 2893 "ai.c"
}


static void value_decision_tree_free_value (GValue* value) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		decision_tree_unref (value->data[0].v_pointer);
#line 2902 "ai.c"
	}
}


static void value_decision_tree_copy_value (const GValue* src_value, GValue* dest_value) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (src_value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		dest_value->data[0].v_pointer = decision_tree_ref (src_value->data[0].v_pointer);
#line 2912 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2916 "ai.c"
	}
}


static gpointer value_decision_tree_peek_pointer (const GValue* value) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return value->data[0].v_pointer;
#line 2924 "ai.c"
}


static gchar* value_decision_tree_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (collect_values[0].v_pointer) {
#line 2931 "ai.c"
		DecisionTree * object;
		object = collect_values[0].v_pointer;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		if (object->parent_instance.g_class == NULL) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2938 "ai.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2942 "ai.c"
		}
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = decision_tree_ref (object);
#line 2946 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 2950 "ai.c"
	}
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return NULL;
#line 2954 "ai.c"
}


static gchar* value_decision_tree_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	DecisionTree ** object_p;
	object_p = collect_values[0].v_pointer;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (!object_p) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2965 "ai.c"
	}
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (!value->data[0].v_pointer) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		*object_p = NULL;
#line 2971 "ai.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		*object_p = value->data[0].v_pointer;
#line 2975 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		*object_p = decision_tree_ref (value->data[0].v_pointer);
#line 2979 "ai.c"
	}
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return NULL;
#line 2983 "ai.c"
}


GParamSpec* param_spec_decision_tree (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecDecisionTree* spec;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_DECISION_TREE), NULL);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return G_PARAM_SPEC (spec);
#line 2997 "ai.c"
}


gpointer value_get_decision_tree (const GValue* value) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE), NULL);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return value->data[0].v_pointer;
#line 3006 "ai.c"
}


void value_set_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree * old;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (v_object) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = v_object;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		decision_tree_ref (value->data[0].v_pointer);
#line 3026 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3030 "ai.c"
	}
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (old) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		decision_tree_unref (old);
#line 3036 "ai.c"
	}
}


void value_take_decision_tree (GValue* value, gpointer v_object) {
	DecisionTree * old;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	old = value->data[0].v_pointer;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (v_object) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_DECISION_TREE));
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = v_object;
#line 3055 "ai.c"
	} else {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		value->data[0].v_pointer = NULL;
#line 3059 "ai.c"
	}
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (old) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		decision_tree_unref (old);
#line 3065 "ai.c"
	}
}


static void decision_tree_class_init (DecisionTreeClass * klass) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	decision_tree_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	((DecisionTreeClass *) klass)->finalize = decision_tree_finalize;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_type_class_add_private (klass, sizeof (DecisionTreePrivate));
#line 3077 "ai.c"
}


static void decision_tree_instance_init (DecisionTree * self) {
	Player* _tmp0_;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv = DECISION_TREE_GET_PRIVATE (self);
#line 41 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	_tmp0_ = g_new0 (Player, BOARD_ROWS * BOARD_COLUMNS);
#line 41 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->board = _tmp0_;
#line 41 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->board_length1 = BOARD_ROWS;
#line 41 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->board_length2 = BOARD_COLUMNS;
#line 43 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->plies = 8;
#line 45 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->last_moving_player = PLAYER_NONE;
#line 47 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->next_move_in_column = -1;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->ref_count = 1;
#line 3101 "ai.c"
}


static void decision_tree_finalize (DecisionTree * obj) {
	DecisionTree * self;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DECISION_TREE, DecisionTree);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_signal_handlers_destroy (self);
#line 41 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	self->priv->board = (g_free (self->priv->board), NULL);
#line 3113 "ai.c"
}


GType decision_tree_get_type (void) {
	static volatile gsize decision_tree_type_id__volatile = 0;
	if (g_once_init_enter (&decision_tree_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_decision_tree_init, value_decision_tree_free_value, value_decision_tree_copy_value, value_decision_tree_peek_pointer, "p", value_decision_tree_collect_value, "p", value_decision_tree_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (DecisionTreeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decision_tree_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecisionTree), 0, (GInstanceInitFunc) decision_tree_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType decision_tree_type_id;
		decision_tree_type_id = g_type_register_fundamental (g_type_fundamental_next (), "DecisionTree", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&decision_tree_type_id__volatile, decision_tree_type_id);
	}
	return decision_tree_type_id__volatile;
}


gpointer decision_tree_ref (gpointer instance) {
	DecisionTree * self;
	self = instance;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	g_atomic_int_inc (&self->ref_count);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	return instance;
#line 3138 "ai.c"
}


void decision_tree_unref (gpointer instance) {
	DecisionTree * self;
	self = instance;
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		DECISION_TREE_GET_CLASS (self)->finalize (self);
#line 38 "/home/mcatanzaro/Projects/GNOME/four-in-a-row/src/ai.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 3151 "ai.c"
	}
}



