; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='default<O3>' -S %s | FileCheck %s

target triple = "arm64-apple-macosx"

declare void @llvm.assume(i1 noundef)

define i32 @earlycse_entry(ptr %p) {
; CHECK-LABEL: define i32 @earlycse_entry(
; CHECK-SAME: ptr nocapture [[P:%.*]]) local_unnamed_addr {
; CHECK-NEXT:    [[L_I:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[L_I]], i64 4) ]
; CHECK-NEXT:    [[L_ASSUME_ALIGNED_I_I:%.*]] = load i32, ptr [[L_I]], align 4
; CHECK-NEXT:    [[R_I_I:%.*]] = tail call i32 @swap(i32 [[L_ASSUME_ALIGNED_I_I]])
; CHECK-NEXT:    [[L_2_I:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    [[GEP_I:%.*]] = getelementptr i8, ptr [[L_2_I]], i64 4
; CHECK-NEXT:    store ptr [[GEP_I]], ptr [[P]], align 8
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[GEP_I]], i64 4) ]
; CHECK-NEXT:    [[L_ASSUME_ALIGNED_I_I2:%.*]] = load i32, ptr [[GEP_I]], align 4
; CHECK-NEXT:    [[R_I_I3:%.*]] = tail call i32 @swap(i32 [[L_ASSUME_ALIGNED_I_I2]])
; CHECK-NEXT:    [[L_2_I4:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    [[GEP_I5:%.*]] = getelementptr i8, ptr [[L_2_I4]], i64 4
; CHECK-NEXT:    store ptr [[GEP_I5]], ptr [[P]], align 8
; CHECK-NEXT:    ret i32 [[R_I_I3]]
;
  %r.1 = call i32 @earlycse_fn1(ptr %p)
  %r.2 = call i32 @earlycse_fn1(ptr %p)
  ret i32 %r.2
}

define i32 @earlycse_fn1(ptr %p) {
; CHECK-LABEL: define i32 @earlycse_fn1(
; CHECK-SAME: ptr nocapture [[P:%.*]]) local_unnamed_addr {
; CHECK-NEXT:    [[L:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[L]], i64 4) ]
; CHECK-NEXT:    [[L_ASSUME_ALIGNED_I:%.*]] = load i32, ptr [[L]], align 4
; CHECK-NEXT:    [[R_I:%.*]] = tail call i32 @swap(i32 [[L_ASSUME_ALIGNED_I]])
; CHECK-NEXT:    [[L_2:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr [[L_2]], i64 4
; CHECK-NEXT:    store ptr [[GEP]], ptr [[P]], align 8
; CHECK-NEXT:    ret i32 [[R_I]]
;
  %l = load ptr, ptr %p, align 8
  %r = call i32 @load_assume_aligned(ptr %l)
  %l.2 = load ptr, ptr %p, align 8
  %gep = getelementptr i8, ptr %l.2, i64 4
  store ptr %gep, ptr %p, align 8
  ret i32 %r
}

define i32 @load_assume_aligned(ptr %p) {
; CHECK-LABEL: define i32 @load_assume_aligned(
; CHECK-SAME: ptr [[P:%.*]]) local_unnamed_addr {
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[P]], i64 4) ]
; CHECK-NEXT:    [[DOT0_COPYLOAD:%.*]] = load i32, ptr [[P]], align 4
; CHECK-NEXT:    [[TMP2:%.*]] = tail call i32 @swap(i32 [[DOT0_COPYLOAD]])
; CHECK-NEXT:    ret i32 [[TMP2]]
;
  call void @llvm.assume(i1 true) [ "align"(ptr %p, i64 4) ]
  %l.assume_aligned = load i32, ptr %p, align 1
  %r = call i32 @swap(i32 %l.assume_aligned)
  ret i32 %r
}

declare i32 @swap(i32)

define void @sroa_align_entry(ptr %p) {
; CHECK-LABEL: define void @sroa_align_entry(
; CHECK-SAME: ptr [[P:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[P]], i64 8) ]
; CHECK-NEXT:    [[DOT0_COPYLOAD_I_I_I:%.*]] = load i64, ptr [[P]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = inttoptr i64 [[DOT0_COPYLOAD_I_I_I]] to ptr
; CHECK-NEXT:    store i32 0, ptr [[TMP2]], align 4
; CHECK-NEXT:    ret void
;
  %a = alloca ptr, align 8
  store ptr %p, ptr %a, align 8
  %r = call ptr @sroa_fn1(ptr %a)
  store i32 0, ptr %r, align 4
  ret void
}

define ptr @sroa_fn1(ptr %p) {
; CHECK-LABEL: define ptr @sroa_fn1(
; CHECK-SAME: ptr nocapture readonly [[P:%.*]]) local_unnamed_addr #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    [[L:%.*]] = load ptr, ptr [[P]], align 8
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[L]], i64 8) ]
; CHECK-NEXT:    [[L_FN3_I_I:%.*]] = load i64, ptr [[L]], align 8
; CHECK-NEXT:    [[I_I:%.*]] = inttoptr i64 [[L_FN3_I_I]] to ptr
; CHECK-NEXT:    ret ptr [[I_I]]
;
  %l = load ptr, ptr %p, align 8
  %r = call ptr @sroa_fn2(ptr %l)
  ret ptr %r
}

define ptr @sroa_fn2(ptr %p) {
; CHECK-LABEL: define ptr @sroa_fn2(
; CHECK-SAME: ptr [[P:%.*]]) local_unnamed_addr #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[P]], i64 8) ]
; CHECK-NEXT:    [[DOT0_COPYLOAD_I_I:%.*]] = load i64, ptr [[P]], align 8
; CHECK-NEXT:    [[TMP3:%.*]] = inttoptr i64 [[DOT0_COPYLOAD_I_I]] to ptr
; CHECK-NEXT:    ret ptr [[TMP3]]
;
  %r = call i64 @sroa_fn3(ptr %p)
  %i = inttoptr i64 %r to ptr
  ret ptr %i
}

define i64 @sroa_fn3(ptr %0) {
; CHECK-LABEL: define i64 @sroa_fn3(
; CHECK-SAME: ptr [[TMP0:%.*]]) local_unnamed_addr #[[ATTR3]] {
; CHECK-NEXT:    call void @llvm.assume(i1 true) [ "align"(ptr [[TMP0]], i64 8) ]
; CHECK-NEXT:    [[DOT0_COPYLOAD_I:%.*]] = load i64, ptr [[TMP0]], align 8
; CHECK-NEXT:    ret i64 [[DOT0_COPYLOAD_I]]
;
  call void @llvm.assume(i1 true) [ "align"(ptr %0, i64 8) ]
  %l.fn3 = load i64, ptr %0, align 1
  ret i64 %l.fn3
}
