; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main -mattr=+mve -verify-machineinstrs -o - %s | FileCheck %s

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_s8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vshlq_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 0, i32 0, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vshlq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 0, i32 0, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vshlq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 0, i32 0, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_u8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vshlq_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 0, i32 0, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_u16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vshlq_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 0, i32 0, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_u32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vshlq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 0, i32 0, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_r_s8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vshlq_r_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 0, i32 0, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_r_s16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vshlq_r_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 0, i32 0, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_r_s32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vshlq_r_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 0, i32 0, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_r_u8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vshlq_r_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 0, i32 0, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_r_u16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vshlq_r_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 0, i32 0, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_r_u32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vshlq_r_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vshl.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 0, i32 0, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_s8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vqshlq_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 1, i32 0, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vqshlq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 1, i32 0, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vqshlq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 1, i32 0, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_u8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vqshlq_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 1, i32 0, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_u16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vqshlq_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 1, i32 0, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_u32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vqshlq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 1, i32 0, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_r_s8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vqshlq_r_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 1, i32 0, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_r_s16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vqshlq_r_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 1, i32 0, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_r_s32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vqshlq_r_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 1, i32 0, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_r_u8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vqshlq_r_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 1, i32 0, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_r_u16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vqshlq_r_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 1, i32 0, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_r_u32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vqshlq_r_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqshl.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 1, i32 0, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_s8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vrshlq_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 0, i32 1, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vrshlq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 0, i32 1, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrshlq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 0, i32 1, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_u8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vrshlq_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 0, i32 1, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_u16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vrshlq_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 0, i32 1, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_u32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vrshlq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 0, i32 1, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_n_s8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vrshlq_n_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 0, i32 1, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_n_s16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vrshlq_n_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 0, i32 1, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_n_s32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vrshlq_n_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 0, i32 1, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_n_u8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vrshlq_n_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 0, i32 1, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_n_u16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vrshlq_n_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 0, i32 1, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_n_u32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vrshlq_n_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrshl.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 0, i32 1, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_s8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vqrshlq_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 1, i32 1, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_s16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vqrshlq_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 1, i32 1, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_s32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vqrshlq_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 1, i32 1, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_u8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vqrshlq_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> %a, <16 x i8> %b, i32 1, i32 1, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_u16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vqrshlq_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> %a, <8 x i16> %b, i32 1, i32 1, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_u32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vqrshlq_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> %a, <4 x i32> %b, i32 1, i32 1, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_n_s8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vqrshlq_n_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 1, i32 1, i32 0)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_n_s16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vqrshlq_n_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 1, i32 1, i32 0)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_n_s32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vqrshlq_n_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 1, i32 1, i32 0)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_n_u8(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: test_vqrshlq_n_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> %a, i32 %b, i32 1, i32 1, i32 1)
  ret <16 x i8> %0
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_n_u16(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: test_vqrshlq_n_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> %a, i32 %b, i32 1, i32 1, i32 1)
  ret <8 x i16> %0
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_n_u32(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: test_vqrshlq_n_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vqrshl.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> %a, i32 %b, i32 1, i32 1, i32 1)
  ret <4 x i32> %0
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_m_s8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 0, i32 0, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_m_s16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 0, i32 0, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_m_s32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 0, i32 0, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_m_u8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 0, i32 1, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_m_u16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 0, i32 1, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_m_u32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 0, i32 1, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_x_s8(<16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_x_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 0, i32 0, <16 x i1> %1, <16 x i8> undef)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_x_s16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_x_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 0, i32 0, <8 x i1> %1, <8 x i16> undef)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_x_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_x_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 0, i32 0, <4 x i1> %1, <4 x i32> undef)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_x_u8(<16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_x_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 0, i32 1, <16 x i1> %1, <16 x i8> undef)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_x_u16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_x_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 0, i32 1, <8 x i1> %1, <8 x i16> undef)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_x_u32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_x_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 0, i32 1, <4 x i1> %1, <4 x i32> undef)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_m_r_s8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_r_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 0, i32 0, i32 0, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_m_r_s16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_r_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 0, i32 0, i32 0, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_m_r_s32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_r_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 0, i32 0, i32 0, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vshlq_m_r_u8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_r_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 0, i32 0, i32 1, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vshlq_m_r_u16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_r_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 0, i32 0, i32 1, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vshlq_m_r_u32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vshlq_m_r_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vshlt.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 0, i32 0, i32 1, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_m_s8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 1, i32 0, i32 0, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_m_s16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 1, i32 0, i32 0, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_m_s32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 1, i32 0, i32 0, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_m_u8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 1, i32 0, i32 1, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_m_u16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 1, i32 0, i32 1, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_m_u32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 1, i32 0, i32 1, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_m_r_s8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_r_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 1, i32 0, i32 0, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_m_r_s16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_r_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 1, i32 0, i32 0, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_m_r_s32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_r_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 1, i32 0, i32 0, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqshlq_m_r_u8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_r_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 1, i32 0, i32 1, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqshlq_m_r_u16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_r_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 1, i32 0, i32 1, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqshlq_m_r_u32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqshlq_m_r_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqshlt.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 1, i32 0, i32 1, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_m_s8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 1, i32 0, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_m_s16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 1, i32 0, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_m_s32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 1, i32 0, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_m_u8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 1, i32 1, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_m_u16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 1, i32 1, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_m_u32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 1, i32 1, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_x_s8(<16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_x_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 1, i32 0, <16 x i1> %1, <16 x i8> undef)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_x_s16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_x_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 1, i32 0, <8 x i1> %1, <8 x i16> undef)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_x_s32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_x_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 1, i32 0, <4 x i1> %1, <4 x i32> undef)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_x_u8(<16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_x_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u8 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 0, i32 1, i32 1, <16 x i1> %1, <16 x i8> undef)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_x_u16(<8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_x_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u16 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 0, i32 1, i32 1, <8 x i1> %1, <8 x i16> undef)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_x_u32(<4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_x_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u32 q0, q0, q1
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 0, i32 1, i32 1, <4 x i1> %1, <4 x i32> undef)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_m_n_s8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_n_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 0, i32 1, i32 0, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_m_n_s16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_n_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 0, i32 1, i32 0, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_m_n_s32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_n_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 0, i32 1, i32 0, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vrshlq_m_n_u8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_n_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 0, i32 1, i32 1, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vrshlq_m_n_u16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_n_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 0, i32 1, i32 1, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vrshlq_m_n_u32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vrshlq_m_n_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vrshlt.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 0, i32 1, i32 1, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_m_s8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.s8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 1, i32 1, i32 0, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_m_s16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.s16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 1, i32 1, i32 0, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_m_s32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.s32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 1, i32 1, i32 0, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_m_u8(<16 x i8> %inactive, <16 x i8> %a, <16 x i8> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.u8 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> %a, <16 x i8> %b, i32 1, i32 1, i32 1, <16 x i1> %1, <16 x i8> %inactive)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_m_u16(<8 x i16> %inactive, <8 x i16> %a, <8 x i16> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.u16 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> %a, <8 x i16> %b, i32 1, i32 1, i32 1, <8 x i1> %1, <8 x i16> %inactive)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_m_u32(<4 x i32> %inactive, <4 x i32> %a, <4 x i32> %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r0
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.u32 q0, q1, q2
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> %a, <4 x i32> %b, i32 1, i32 1, i32 1, <4 x i1> %1, <4 x i32> %inactive)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_m_n_s8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_n_s8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.s8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 1, i32 1, i32 0, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_m_n_s16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_n_s16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.s16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 1, i32 1, i32 0, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_m_n_s32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_n_s32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.s32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 1, i32 1, i32 0, <4 x i1> %1)
  ret <4 x i32> %2
}

define arm_aapcs_vfpcc <16 x i8> @test_vqrshlq_m_n_u8(<16 x i8> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_n_u8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.u8 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 %0)
  %2 = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> %a, i32 %b, i32 1, i32 1, i32 1, <16 x i1> %1)
  ret <16 x i8> %2
}

define arm_aapcs_vfpcc <8 x i16> @test_vqrshlq_m_n_u16(<8 x i16> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_n_u16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.u16 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 %0)
  %2 = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> %a, i32 %b, i32 1, i32 1, i32 1, <8 x i1> %1)
  ret <8 x i16> %2
}

define arm_aapcs_vfpcc <4 x i32> @test_vqrshlq_m_n_u32(<4 x i32> %a, i32 %b, i16 zeroext %p) {
; CHECK-LABEL: test_vqrshlq_m_n_u32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmsr p0, r1
; CHECK-NEXT:    vpst
; CHECK-NEXT:    vqrshlt.u32 q0, r0
; CHECK-NEXT:    bx lr
entry:
  %0 = zext i16 %p to i32
  %1 = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 %0)
  %2 = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> %a, i32 %b, i32 1, i32 1, i32 1, <4 x i1> %1)
  ret <4 x i32> %2
}

declare <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8>, <16 x i8>, i32, i32, i32)
declare <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16>, <8 x i16>, i32, i32, i32)
declare <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32>, <4 x i32>, i32, i32, i32)
declare <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8>, i32, i32, i32, i32)
declare <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16>, i32, i32, i32, i32)
declare <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32>, i32, i32, i32, i32)
declare <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32)
declare <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8>, <16 x i8>, i32, i32, i32, <16 x i1>, <16 x i8>)
declare <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32)
declare <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16>, <8 x i16>, i32, i32, i32, <8 x i1>, <8 x i16>)
declare <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32)
declare <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32>, <4 x i32>, i32, i32, i32, <4 x i1>, <4 x i32>)
declare <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8>, i32, i32, i32, i32, <16 x i1>)
declare <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16>, i32, i32, i32, i32, <8 x i1>)
declare <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32>, i32, i32, i32, i32, <4 x i1>)
