; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -passes=infer-address-spaces -assume-default-is-flat-addrspace %s | FileCheck %s

declare void @llvm.fake.use(...)

@gv = internal addrspace(3) global float 0.0, align 4

define void @one_fake_use(ptr addrspace(1) %global.ptr) {
; CHECK-LABEL: define void @one_fake_use(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]]) {
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(1) [[GLOBAL_PTR]])
; CHECK-NEXT:    ret void
;
  %cast0 = addrspacecast ptr addrspace(1) %global.ptr to ptr
  call void (...) @llvm.fake.use(ptr %cast0)
  ret void
}

define void @one_fake_use_repeat_operands(ptr addrspace(1) %global.ptr) {
; CHECK-LABEL: define void @one_fake_use_repeat_operands(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]]) {
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(1) [[GLOBAL_PTR]], ptr addrspace(1) [[GLOBAL_PTR]])
; CHECK-NEXT:    ret void
;
  %cast0 = addrspacecast ptr addrspace(1) %global.ptr to ptr
  call void (...) @llvm.fake.use(ptr %cast0, ptr %cast0)
  ret void
}

define void @one_fake_use_refers_original_ptr(ptr addrspace(1) %global.ptr) {
; CHECK-LABEL: define void @one_fake_use_refers_original_ptr(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]]) {
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(1) [[GLOBAL_PTR]], ptr addrspace(1) [[GLOBAL_PTR]])
; CHECK-NEXT:    ret void
;
  %cast0 = addrspacecast ptr addrspace(1) %global.ptr to ptr
  call void (...) @llvm.fake.use(ptr %cast0, ptr addrspace(1) %global.ptr)
  ret void
}

define void @multiple_inferrable_fake_use(ptr addrspace(1) %global.ptr0, ptr addrspace(1) %global.ptr1) {
; CHECK-LABEL: define void @multiple_inferrable_fake_use(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR0:%.*]], ptr addrspace(1) [[GLOBAL_PTR1:%.*]]) {
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(1) [[GLOBAL_PTR0]], ptr addrspace(1) [[GLOBAL_PTR1]])
; CHECK-NEXT:    ret void
;
  %cast0 = addrspacecast ptr addrspace(1) %global.ptr0 to ptr
  %cast1 = addrspacecast ptr addrspace(1) %global.ptr1 to ptr
  call void (...) @llvm.fake.use(ptr %cast0, ptr %cast1)
  ret void
}

define void @multiple_fake_use_one_inferrable(ptr %flat.ptr0, ptr addrspace(1) %global.ptr1) {
; CHECK-LABEL: define void @multiple_fake_use_one_inferrable(
; CHECK-SAME: ptr [[FLAT_PTR0:%.*]], ptr addrspace(1) [[GLOBAL_PTR1:%.*]]) {
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr [[FLAT_PTR0]], ptr addrspace(1) [[GLOBAL_PTR1]])
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(1) [[GLOBAL_PTR1]], ptr [[FLAT_PTR0]])
; CHECK-NEXT:    ret void
;
  %cast1 = addrspacecast ptr addrspace(1) %global.ptr1 to ptr
  call void (...) @llvm.fake.use(ptr %flat.ptr0, ptr %cast1)
  call void (...) @llvm.fake.use(ptr %cast1, ptr %flat.ptr0)
  ret void
}

define void @vector_of_pointers(<2 x ptr addrspace(1)> %global.ptr) {
; CHECK-LABEL: define void @vector_of_pointers(
; CHECK-SAME: <2 x ptr addrspace(1)> [[GLOBAL_PTR:%.*]]) {
; CHECK-NEXT:    call void (...) @llvm.fake.use(<2 x ptr addrspace(1)> [[GLOBAL_PTR]])
; CHECK-NEXT:    ret void
;
  %cast0 = addrspacecast <2 x ptr addrspace(1)> %global.ptr to <2 x ptr>
  call void (...) @llvm.fake.use(<2 x ptr> %cast0)
  ret void
}

define void @use_global_var() {
; CHECK-LABEL: define void @use_global_var() {
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(3) @gv)
; CHECK-NEXT:    ret void
;
  call void (...) @llvm.fake.use(ptr addrspacecast (ptr addrspace(3) @gv to ptr))
  ret void
}

define void @use_gep_cast(ptr addrspace(1) %global.ptr) {
; CHECK-LABEL: define void @use_gep_cast(
; CHECK-SAME: ptr addrspace(1) [[GLOBAL_PTR:%.*]]) {
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr i8, ptr addrspace(1) [[GLOBAL_PTR]], i64 16
; CHECK-NEXT:    call void (...) @llvm.fake.use(ptr addrspace(1) [[GEP]], ptr addrspace(1) [[GLOBAL_PTR]])
; CHECK-NEXT:    ret void
;
  %cast0 = addrspacecast ptr addrspace(1) %global.ptr to ptr
  %gep = getelementptr i8, ptr %cast0, i64 16
  call void (...) @llvm.fake.use(ptr %gep, ptr %cast0)
  ret void
}
