; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32f -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECKIZFH,RV32IZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64f -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECKIZFH,RV64IZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinx -verify-machineinstrs \
; RUN:   -target-abi ilp32 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECKIZHINX,RV32IZHINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinx -verify-machineinstrs \
; RUN:   -target-abi lp64 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECKIZHINX,RV64IZHINX %s
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh -verify-machineinstrs \
; RUN:   -target-abi ilp32d -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=RV32IDZFH %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh -verify-machineinstrs \
; RUN:   -target-abi lp64d -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=RV64IDZFH %s
; RUN: llc -mtriple=riscv32 -mattr=+zdinx,+zhinx -verify-machineinstrs \
; RUN:   -target-abi ilp32 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=RV32IZDINXZHINX %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx,+zhinx -verify-machineinstrs \
; RUN:   -target-abi lp64 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefix=RV64IZDINXZHINX %s
; RUN: llc -mtriple=riscv32 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi ilp32f -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32-IZFHMIN,RV32IFZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zfhmin -verify-machineinstrs \
; RUN:   -target-abi lp64f -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK64-IZFHMIN,RV64IFZFHMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+zhinxmin -verify-machineinstrs \
; RUN:   -target-abi ilp32 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32-IZHINXMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zhinxmin -verify-machineinstrs \
; RUN:   -target-abi lp64 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK64-IZHINXMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfhmin -verify-machineinstrs \
; RUN:   -target-abi ilp32d -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32-IZFHMIN,RV32IDZFHMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfhmin -verify-machineinstrs \
; RUN:   -target-abi lp64d -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK64-IZFHMIN,RV64IDZFHMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+zdinx,+zhinxmin -verify-machineinstrs \
; RUN:   -target-abi ilp32 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32-IZDINXZHINXMIN %s
; RUN: llc -mtriple=riscv64 -mattr=+zdinx,+zhinxmin -verify-machineinstrs \
; RUN:   -target-abi lp64 -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK64-IZDINXZHINXMIN %s
; RUN: llc -mtriple=riscv32 -mattr=+d -verify-machineinstrs \
; RUN:   -target-abi ilp32d -disable-strictnode-mutation < %s \
; RUN:   | FileCheck -check-prefixes=CHECK32-D %s

; NOTE: The rounding mode metadata does not effect which instruction is
; selected. Dynamic rounding mode is always used for operations that
; support rounding mode.

define i16 @fcvt_si_h(half %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_si_h:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_si_h:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_si_h:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_si_h:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_si_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_si_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_si_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_si_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_si_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK32-IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_si_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_si_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_si_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_si_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_si_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_si_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call i16 @llvm.experimental.constrained.fptosi.i16.f16(half %a, metadata !"fpexcept.strict")
  ret i16 %1
}
declare i16 @llvm.experimental.constrained.fptosi.i16.f16(half, metadata)

define i16 @fcvt_ui_h(half %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_ui_h:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_ui_h:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_ui_h:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_ui_h:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_ui_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_ui_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_ui_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_ui_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_ui_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK32-IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_ui_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_ui_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_ui_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_ui_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_ui_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_ui_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call i16 @llvm.experimental.constrained.fptoui.i16.f16(half %a, metadata !"fpexcept.strict")
  ret i16 %1
}
declare i16 @llvm.experimental.constrained.fptoui.i16.f16(half, metadata)

define i32 @fcvt_w_h(half %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_w_h:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_w_h:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_w_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_w_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.w.h a0, fa0, rtz
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_w_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_w_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.w.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_w_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK32-IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_w_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.w.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_w_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_w_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_w_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_w_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.w.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_w_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    fcvt.w.s a0, fa0, rtz
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptosi.i32.f16(half %a, metadata !"fpexcept.strict")
  ret i32 %1
}
declare i32 @llvm.experimental.constrained.fptosi.i32.f16(half, metadata)

define i32 @fcvt_wu_h(half %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_wu_h:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_wu_h:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_wu_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_wu_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_wu_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_wu_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_wu_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK32-IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_wu_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_wu_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_wu_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_wu_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_wu_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_wu_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    fcvt.wu.s a0, fa0, rtz
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call i32 @llvm.experimental.constrained.fptoui.i32.f16(half %a, metadata !"fpexcept.strict")
  ret i32 %1
}
declare i32 @llvm.experimental.constrained.fptoui.i32.f16(half, metadata)

; Test where the fptoui has multiple uses, one of which causes a sext to be
; inserted on RV64.
; FIXME: We should not have an fcvt.wu.h and an fcvt.lu.h.
define i32 @fcvt_wu_h_multiple_use(half %x, ptr %y) strictfp {
; CHECKIZFH-LABEL: fcvt_wu_h_multiple_use:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; CHECKIZFH-NEXT:    seqz a1, a0
; CHECKIZFH-NEXT:    add a0, a0, a1
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_wu_h_multiple_use:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; CHECKIZHINX-NEXT:    seqz a1, a0
; CHECKIZHINX-NEXT:    add a0, a0, a1
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_wu_h_multiple_use:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV32IDZFH-NEXT:    seqz a1, a0
; RV32IDZFH-NEXT:    add a0, a0, a1
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_wu_h_multiple_use:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.wu.h a0, fa0, rtz
; RV64IDZFH-NEXT:    seqz a1, a0
; RV64IDZFH-NEXT:    add a0, a0, a1
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_wu_h_multiple_use:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV32IZDINXZHINX-NEXT:    seqz a1, a0
; RV32IZDINXZHINX-NEXT:    add a0, a0, a1
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_wu_h_multiple_use:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.wu.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    seqz a1, a0
; RV64IZDINXZHINX-NEXT:    add a0, a0, a1
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_wu_h_multiple_use:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK32-IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECK32-IZFHMIN-NEXT:    seqz a1, a0
; CHECK32-IZFHMIN-NEXT:    add a0, a0, a1
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_wu_h_multiple_use:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.wu.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    seqz a1, a0
; CHECK64-IZFHMIN-NEXT:    add a0, a0, a1
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_wu_h_multiple_use:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK32-IZHINXMIN-NEXT:    seqz a1, a0
; CHECK32-IZHINXMIN-NEXT:    add a0, a0, a1
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_wu_h_multiple_use:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    seqz a1, a0
; CHECK64-IZHINXMIN-NEXT:    add a0, a0, a1
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_wu_h_multiple_use:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK32-IZDINXZHINXMIN-NEXT:    seqz a1, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    add a0, a0, a1
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_wu_h_multiple_use:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.wu.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    seqz a1, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    add a0, a0, a1
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_wu_h_multiple_use:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    .cfi_def_cfa_offset 16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    .cfi_offset ra, -4
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    fcvt.wu.s a0, fa0, rtz
; CHECK32-D-NEXT:    seqz a1, a0
; CHECK32-D-NEXT:    add a0, a0, a1
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    .cfi_restore ra
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    .cfi_def_cfa_offset 0
; CHECK32-D-NEXT:    ret
  %a = call i32 @llvm.experimental.constrained.fptoui.i32.f16(half %x, metadata !"fpexcept.strict")
  %b = icmp eq i32 %a, 0
  %c = select i1 %b, i32 1, i32 %a
  ret i32 %c
}

define i64 @fcvt_l_h(half %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_l_h:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call __fixhfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_l_h:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_l_h:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    call __fixhfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_l_h:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_l_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -16
; RV32IDZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    call __fixhfdi
; RV32IDZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 16
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_l_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.l.h a0, fa0, rtz
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_l_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi sp, sp, -16
; RV32IZDINXZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    call __fixhfdi
; RV32IZDINXZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    addi sp, sp, 16
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_l_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.l.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_l_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    call __fixhfdi
; CHECK32-IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_l_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.l.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_l_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    call __fixhfdi
; CHECK32-IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_l_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_l_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZDINXZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    call __fixhfdi
; CHECK32-IZDINXZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_l_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.l.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_l_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    call __fixsfdi
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call i64 @llvm.experimental.constrained.fptosi.i64.f16(half %a, metadata !"fpexcept.strict")
  ret i64 %1
}
declare i64 @llvm.experimental.constrained.fptosi.i64.f16(half, metadata)

define i64 @fcvt_lu_h(half %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_lu_h:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call __fixunshfdi
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_lu_h:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_lu_h:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    call __fixunshfdi
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_lu_h:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_lu_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -16
; RV32IDZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    call __fixunshfdi
; RV32IDZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 16
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_lu_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.lu.h a0, fa0, rtz
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_lu_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi sp, sp, -16
; RV32IZDINXZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    call __fixunshfdi
; RV32IZDINXZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    addi sp, sp, 16
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_lu_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.lu.h a0, a0, rtz
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_lu_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    call __fixunshfdi
; CHECK32-IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_lu_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa5, fa0
; CHECK64-IZFHMIN-NEXT:    fcvt.lu.s a0, fa5, rtz
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_lu_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    call __fixunshfdi
; CHECK32-IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_lu_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_lu_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZDINXZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    call __fixunshfdi
; CHECK32-IZDINXZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_lu_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.lu.s a0, a0, rtz
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_lu_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    call __fixunssfdi
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call i64 @llvm.experimental.constrained.fptoui.i64.f16(half %a, metadata !"fpexcept.strict")
  ret i64 %1
}
declare i64 @llvm.experimental.constrained.fptoui.i64.f16(half, metadata)

define half @fcvt_h_si(i16 %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_si:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    slli a0, a0, 16
; RV32IZFH-NEXT:    srai a0, a0, 16
; RV32IZFH-NEXT:    fcvt.h.w fa0, a0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_si:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    slli a0, a0, 48
; RV64IZFH-NEXT:    srai a0, a0, 48
; RV64IZFH-NEXT:    fcvt.h.w fa0, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_si:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    slli a0, a0, 16
; RV32IZHINX-NEXT:    srai a0, a0, 16
; RV32IZHINX-NEXT:    fcvt.h.w a0, a0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_si:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    slli a0, a0, 48
; RV64IZHINX-NEXT:    srai a0, a0, 48
; RV64IZHINX-NEXT:    fcvt.h.w a0, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_si:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    slli a0, a0, 16
; RV32IDZFH-NEXT:    srai a0, a0, 16
; RV32IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_si:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    slli a0, a0, 48
; RV64IDZFH-NEXT:    srai a0, a0, 48
; RV64IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_si:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    slli a0, a0, 16
; RV32IZDINXZHINX-NEXT:    srai a0, a0, 16
; RV32IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_si:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    slli a0, a0, 48
; RV64IZDINXZHINX-NEXT:    srai a0, a0, 48
; RV64IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_si:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    slli a0, a0, 16
; CHECK32-IZFHMIN-NEXT:    srai a0, a0, 16
; CHECK32-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_si:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    slli a0, a0, 48
; CHECK64-IZFHMIN-NEXT:    srai a0, a0, 48
; CHECK64-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_si:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    slli a0, a0, 16
; CHECK32-IZHINXMIN-NEXT:    srai a0, a0, 16
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_si:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    slli a0, a0, 48
; CHECK64-IZHINXMIN-NEXT:    srai a0, a0, 48
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_si:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    slli a0, a0, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    srai a0, a0, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_si:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    slli a0, a0, 48
; CHECK64-IZDINXZHINXMIN-NEXT:    srai a0, a0, 48
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_si:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srai a0, a0, 16
; CHECK32-D-NEXT:    fcvt.s.w fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i16(i16 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.sitofp.f16.i16(i16, metadata, metadata)

define half @fcvt_h_si_signext(i16 signext %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_h_si_signext:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.h.w fa0, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_h_si_signext:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.h.w a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_si_signext:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_si_signext:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_si_signext:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_si_signext:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_si_signext:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_si_signext:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_si_signext:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_si_signext:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_si_signext:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_si_signext:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_si_signext:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fcvt.s.w fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i16(i16 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}

define half @fcvt_h_ui(i16 %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_ui:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    slli a0, a0, 16
; RV32IZFH-NEXT:    srli a0, a0, 16
; RV32IZFH-NEXT:    fcvt.h.wu fa0, a0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_ui:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    slli a0, a0, 48
; RV64IZFH-NEXT:    srli a0, a0, 48
; RV64IZFH-NEXT:    fcvt.h.wu fa0, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_ui:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    slli a0, a0, 16
; RV32IZHINX-NEXT:    srli a0, a0, 16
; RV32IZHINX-NEXT:    fcvt.h.wu a0, a0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_ui:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    slli a0, a0, 48
; RV64IZHINX-NEXT:    srli a0, a0, 48
; RV64IZHINX-NEXT:    fcvt.h.wu a0, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_ui:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    slli a0, a0, 16
; RV32IDZFH-NEXT:    srli a0, a0, 16
; RV32IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_ui:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    slli a0, a0, 48
; RV64IDZFH-NEXT:    srli a0, a0, 48
; RV64IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_ui:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    slli a0, a0, 16
; RV32IZDINXZHINX-NEXT:    srli a0, a0, 16
; RV32IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_ui:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    slli a0, a0, 48
; RV64IZDINXZHINX-NEXT:    srli a0, a0, 48
; RV64IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_ui:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    slli a0, a0, 16
; CHECK32-IZFHMIN-NEXT:    srli a0, a0, 16
; CHECK32-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_ui:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    slli a0, a0, 48
; CHECK64-IZFHMIN-NEXT:    srli a0, a0, 48
; CHECK64-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_ui:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    slli a0, a0, 16
; CHECK32-IZHINXMIN-NEXT:    srli a0, a0, 16
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_ui:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    slli a0, a0, 48
; CHECK64-IZHINXMIN-NEXT:    srli a0, a0, 48
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_ui:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    slli a0, a0, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    srli a0, a0, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_ui:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    slli a0, a0, 48
; CHECK64-IZDINXZHINXMIN-NEXT:    srli a0, a0, 48
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_ui:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fcvt.s.wu fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i16(i16 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.uitofp.f16.i16(i16, metadata, metadata)

define half @fcvt_h_ui_zeroext(i16 zeroext %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_h_ui_zeroext:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.h.wu fa0, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_h_ui_zeroext:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.h.wu a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_ui_zeroext:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_ui_zeroext:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_ui_zeroext:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_ui_zeroext:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_ui_zeroext:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_ui_zeroext:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_ui_zeroext:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_ui_zeroext:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_ui_zeroext:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_ui_zeroext:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_ui_zeroext:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fcvt.s.wu fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i16(i16 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}

define half @fcvt_h_w(i32 %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_h_w:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.h.w fa0, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_h_w:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.h.w a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_w:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_w:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_w:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_w:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_w:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_w:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_w:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_w:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_w:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_w:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_w:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fcvt.s.w fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.sitofp.f16.i32(i32, metadata, metadata)

define half @fcvt_h_w_load(ptr %p) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_h_w_load:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    lw a0, 0(a0)
; CHECKIZFH-NEXT:    fcvt.h.w fa0, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_h_w_load:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    lw a0, 0(a0)
; CHECKIZHINX-NEXT:    fcvt.h.w a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_w_load:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    lw a0, 0(a0)
; RV32IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_w_load:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    lw a0, 0(a0)
; RV64IDZFH-NEXT:    fcvt.h.w fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_w_load:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    lw a0, 0(a0)
; RV32IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_w_load:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    lw a0, 0(a0)
; RV64IZDINXZHINX-NEXT:    fcvt.h.w a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_w_load:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    lw a0, 0(a0)
; CHECK32-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_w_load:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    lw a0, 0(a0)
; CHECK64-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_w_load:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    lw a0, 0(a0)
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_w_load:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    lw a0, 0(a0)
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_w_load:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a0, 0(a0)
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_w_load:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    lw a0, 0(a0)
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.w a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_w_load:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    lw a0, 0(a0)
; CHECK32-D-NEXT:    fcvt.s.w fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %a = load i32, ptr %p
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}

define half @fcvt_h_wu(i32 %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_h_wu:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.h.wu fa0, a0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_h_wu:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.h.wu a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_wu:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_wu:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_wu:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_wu:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_wu:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_wu:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_wu:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_wu:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_wu:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_wu:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_wu:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fcvt.s.wu fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.uitofp.f16.i32(i32, metadata, metadata)

define half @fcvt_h_wu_load(ptr %p) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_wu_load:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    lw a0, 0(a0)
; RV32IZFH-NEXT:    fcvt.h.wu fa0, a0
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_wu_load:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    lwu a0, 0(a0)
; RV64IZFH-NEXT:    fcvt.h.wu fa0, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_wu_load:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    lw a0, 0(a0)
; RV32IZHINX-NEXT:    fcvt.h.wu a0, a0
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_wu_load:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    lwu a0, 0(a0)
; RV64IZHINX-NEXT:    fcvt.h.wu a0, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_wu_load:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    lw a0, 0(a0)
; RV32IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_wu_load:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    lwu a0, 0(a0)
; RV64IDZFH-NEXT:    fcvt.h.wu fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_wu_load:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    lw a0, 0(a0)
; RV32IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_wu_load:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    lwu a0, 0(a0)
; RV64IZDINXZHINX-NEXT:    fcvt.h.wu a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_wu_load:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    lw a0, 0(a0)
; CHECK32-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_wu_load:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    lwu a0, 0(a0)
; CHECK64-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_wu_load:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    lw a0, 0(a0)
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_wu_load:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    lwu a0, 0(a0)
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_wu_load:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a0, 0(a0)
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_wu_load:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    lwu a0, 0(a0)
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_wu_load:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    lw a0, 0(a0)
; CHECK32-D-NEXT:    fcvt.s.wu fa0, a0
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %a = load i32, ptr %p
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}

define half @fcvt_h_l(i64 %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_l:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call __floatdihf
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_l:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.h.l fa0, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_l:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    call __floatdihf
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_l:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    fcvt.h.l a0, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_l:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -16
; RV32IDZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    call __floatdihf
; RV32IDZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 16
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_l:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.l fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_l:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi sp, sp, -16
; RV32IZDINXZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    call __floatdihf
; RV32IZDINXZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    addi sp, sp, 16
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_l:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.l a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_l:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    call __floatdihf
; CHECK32-IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_l:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.l fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_l:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    call __floatdihf
; CHECK32-IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_l:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.l a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_l:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZDINXZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    call __floatdihf
; CHECK32-IZDINXZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_l:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.l a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_l:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    call __floatdisf
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.sitofp.f16.i64(i64 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.sitofp.f16.i64(i64, metadata, metadata)

define half @fcvt_h_lu(i64 %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_lu:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call __floatundihf
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_lu:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    fcvt.h.lu fa0, a0
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_lu:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    call __floatundihf
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_lu:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    fcvt.h.lu a0, a0
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_lu:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -16
; RV32IDZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    call __floatundihf
; RV32IDZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 16
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_lu:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.lu fa0, a0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_lu:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi sp, sp, -16
; RV32IZDINXZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    call __floatundihf
; RV32IZDINXZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    addi sp, sp, 16
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_lu:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.lu a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_lu:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    call __floatundihf
; CHECK32-IZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_lu:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.lu fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa5
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_lu:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    call __floatundihf
; CHECK32-IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_lu:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.lu a0, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_lu:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZDINXZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    call __floatundihf
; CHECK32-IZDINXZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_lu:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.lu a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_lu:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    call __floatundisf
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.uitofp.f16.i64(i64 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.uitofp.f16.i64(i64, metadata, metadata)

define half @fcvt_h_s(float %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_h_s:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.h.s fa0, fa0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_h_s:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.h.s a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_s:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.h.s fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_s:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.s fa0, fa0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_s:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.h.s a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_s:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.s a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_s:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_s:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa0, fa0
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_s:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_s:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_s:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_s:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_s:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.fptrunc.f16.f32(float %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.fptrunc.f16.f32(float, metadata, metadata)

define float @fcvt_s_h(half %a) nounwind strictfp {
; CHECKIZFH-LABEL: fcvt_s_h:
; CHECKIZFH:       # %bb.0:
; CHECKIZFH-NEXT:    fcvt.s.h fa0, fa0
; CHECKIZFH-NEXT:    ret
;
; CHECKIZHINX-LABEL: fcvt_s_h:
; CHECKIZHINX:       # %bb.0:
; CHECKIZHINX-NEXT:    fcvt.s.h a0, a0
; CHECKIZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_s_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_s_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_s_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_s_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_s_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_s_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_s_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_s_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_s_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_s_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_s_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call float @llvm.experimental.constrained.fpext.f32.f16(half %a, metadata !"fpexcept.strict")
  ret float %1
}
declare float @llvm.experimental.constrained.fpext.f32.f16(half, metadata)

define half @fcvt_h_d(double %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_d:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    call __truncdfhf2
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_d:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    call __truncdfhf2
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_d:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    call __truncdfhf2
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_d:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    call __truncdfhf2
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_d:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.h.d fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_d:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.h.d fa0, fa0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_d:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.h.d a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_d:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.h.d a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; RV32IFZFHMIN-LABEL: fcvt_h_d:
; RV32IFZFHMIN:       # %bb.0:
; RV32IFZFHMIN-NEXT:    addi sp, sp, -16
; RV32IFZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFZFHMIN-NEXT:    call __truncdfhf2
; RV32IFZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFZFHMIN-NEXT:    addi sp, sp, 16
; RV32IFZFHMIN-NEXT:    ret
;
; RV64IFZFHMIN-LABEL: fcvt_h_d:
; RV64IFZFHMIN:       # %bb.0:
; RV64IFZFHMIN-NEXT:    addi sp, sp, -16
; RV64IFZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFZFHMIN-NEXT:    call __truncdfhf2
; RV64IFZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFZFHMIN-NEXT:    addi sp, sp, 16
; RV64IFZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_d:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    call __truncdfhf2
; CHECK32-IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_d:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZHINXMIN-NEXT:    call __truncdfhf2
; CHECK64-IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZHINXMIN-NEXT:    ret
;
; RV32IDZFHMIN-LABEL: fcvt_h_d:
; RV32IDZFHMIN:       # %bb.0:
; RV32IDZFHMIN-NEXT:    fcvt.h.d fa0, fa0
; RV32IDZFHMIN-NEXT:    ret
;
; RV64IDZFHMIN-LABEL: fcvt_h_d:
; RV64IDZFHMIN:       # %bb.0:
; RV64IDZFHMIN-NEXT:    fcvt.h.d fa0, fa0
; RV64IDZFHMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_d:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.d a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_d:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.d a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_d:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    call __truncdfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.fptrunc.f16.f64(double %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}
declare half @llvm.experimental.constrained.fptrunc.f16.f64(double, metadata, metadata)

define double @fcvt_d_h(half %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_d_h:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -16
; RV32IZFH-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    call __extendsfdf2
; RV32IZFH-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 16
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_d_h:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call __extendsfdf2
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_d_h:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -16
; RV32IZHINX-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    fcvt.s.h a0, a0
; RV32IZHINX-NEXT:    call __extendsfdf2
; RV32IZHINX-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 16
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_d_h:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call __extendsfdf2
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_d_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    fcvt.d.h fa0, fa0
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_d_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    fcvt.d.h fa0, fa0
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_d_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    fcvt.d.h a0, a0
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_d_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    fcvt.d.h a0, a0
; RV64IZDINXZHINX-NEXT:    ret
;
; RV32IFZFHMIN-LABEL: fcvt_d_h:
; RV32IFZFHMIN:       # %bb.0:
; RV32IFZFHMIN-NEXT:    addi sp, sp, -16
; RV32IFZFHMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; RV32IFZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV32IFZFHMIN-NEXT:    call __extendsfdf2
; RV32IFZFHMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; RV32IFZFHMIN-NEXT:    addi sp, sp, 16
; RV32IFZFHMIN-NEXT:    ret
;
; RV64IFZFHMIN-LABEL: fcvt_d_h:
; RV64IFZFHMIN:       # %bb.0:
; RV64IFZFHMIN-NEXT:    addi sp, sp, -16
; RV64IFZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IFZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; RV64IFZFHMIN-NEXT:    call __extendsfdf2
; RV64IFZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IFZFHMIN-NEXT:    addi sp, sp, 16
; RV64IFZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_d_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK32-IZHINXMIN-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK32-IZHINXMIN-NEXT:    call __extendsfdf2
; CHECK32-IZHINXMIN-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_d_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    call __extendsfdf2
; CHECK64-IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZHINXMIN-NEXT:    ret
;
; RV32IDZFHMIN-LABEL: fcvt_d_h:
; RV32IDZFHMIN:       # %bb.0:
; RV32IDZFHMIN-NEXT:    fcvt.d.h fa0, fa0
; RV32IDZFHMIN-NEXT:    ret
;
; RV64IDZFHMIN-LABEL: fcvt_d_h:
; RV64IDZFHMIN:       # %bb.0:
; RV64IDZFHMIN-NEXT:    fcvt.d.h fa0, fa0
; RV64IDZFHMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_d_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.d.h a0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_d_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.d.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_d_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    fcvt.d.s fa0, fa0
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    ret
  %1 = call double @llvm.experimental.constrained.fpext.f64.f16(half %a, metadata !"fpexcept.strict")
  ret double %1
}
declare double @llvm.experimental.constrained.fpext.f64.f16(half, metadata)

; Make sure we select W version of addi on RV64.
define signext i32 @fcvt_h_w_demanded_bits(i32 signext %0, ptr %1) strictfp {
; RV32IZFH-LABEL: fcvt_h_w_demanded_bits:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi a0, a0, 1
; RV32IZFH-NEXT:    fcvt.h.w fa5, a0
; RV32IZFH-NEXT:    fsh fa5, 0(a1)
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_w_demanded_bits:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addiw a0, a0, 1
; RV64IZFH-NEXT:    fcvt.h.w fa5, a0
; RV64IZFH-NEXT:    fsh fa5, 0(a1)
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_w_demanded_bits:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi a0, a0, 1
; RV32IZHINX-NEXT:    fcvt.h.w a2, a0
; RV32IZHINX-NEXT:    sh a2, 0(a1)
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_w_demanded_bits:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addiw a0, a0, 1
; RV64IZHINX-NEXT:    fcvt.h.w a2, a0
; RV64IZHINX-NEXT:    sh a2, 0(a1)
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_w_demanded_bits:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi a0, a0, 1
; RV32IDZFH-NEXT:    fcvt.h.w fa5, a0
; RV32IDZFH-NEXT:    fsh fa5, 0(a1)
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_w_demanded_bits:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    addiw a0, a0, 1
; RV64IDZFH-NEXT:    fcvt.h.w fa5, a0
; RV64IDZFH-NEXT:    fsh fa5, 0(a1)
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_w_demanded_bits:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi a0, a0, 1
; RV32IZDINXZHINX-NEXT:    fcvt.h.w a2, a0
; RV32IZDINXZHINX-NEXT:    sh a2, 0(a1)
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_w_demanded_bits:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    addiw a0, a0, 1
; RV64IZDINXZHINX-NEXT:    fcvt.h.w a2, a0
; RV64IZDINXZHINX-NEXT:    sh a2, 0(a1)
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_w_demanded_bits:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi a0, a0, 1
; CHECK32-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECK32-IZFHMIN-NEXT:    fsh fa5, 0(a1)
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_w_demanded_bits:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    addiw a0, a0, 1
; CHECK64-IZFHMIN-NEXT:    fcvt.s.w fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECK64-IZFHMIN-NEXT:    fsh fa5, 0(a1)
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_w_demanded_bits:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi a0, a0, 1
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.w a2, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK32-IZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_w_demanded_bits:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    addiw a0, a0, 1
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.w a2, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK64-IZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_w_demanded_bits:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi a0, a0, 1
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.w a2, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK32-IZDINXZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_w_demanded_bits:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    addiw a0, a0, 1
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.w a2, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK64-IZDINXZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_w_demanded_bits:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    .cfi_def_cfa_offset 16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    .cfi_offset ra, -4
; CHECK32-D-NEXT:    .cfi_offset s0, -8
; CHECK32-D-NEXT:    .cfi_offset s1, -12
; CHECK32-D-NEXT:    mv s0, a1
; CHECK32-D-NEXT:    addi s1, a0, 1
; CHECK32-D-NEXT:    fcvt.s.w fa0, s1
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    sh a0, 0(s0)
; CHECK32-D-NEXT:    mv a0, s1
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    .cfi_restore ra
; CHECK32-D-NEXT:    .cfi_restore s0
; CHECK32-D-NEXT:    .cfi_restore s1
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    .cfi_def_cfa_offset 0
; CHECK32-D-NEXT:    ret
  %3 = add i32 %0, 1
  %4 = call half @llvm.experimental.constrained.sitofp.f16.i32(i32 %3, metadata !"round.dynamic", metadata !"fpexcept.strict")
  store half %4, ptr %1, align 2
  ret i32 %3
}

; Make sure we select W version of addi on RV64.
define signext i32 @fcvt_h_wu_demanded_bits(i32 signext %0, ptr %1) strictfp {
; RV32IZFH-LABEL: fcvt_h_wu_demanded_bits:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi a0, a0, 1
; RV32IZFH-NEXT:    fcvt.h.wu fa5, a0
; RV32IZFH-NEXT:    fsh fa5, 0(a1)
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_wu_demanded_bits:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addiw a0, a0, 1
; RV64IZFH-NEXT:    fcvt.h.wu fa5, a0
; RV64IZFH-NEXT:    fsh fa5, 0(a1)
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_wu_demanded_bits:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi a0, a0, 1
; RV32IZHINX-NEXT:    fcvt.h.wu a2, a0
; RV32IZHINX-NEXT:    sh a2, 0(a1)
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_wu_demanded_bits:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addiw a0, a0, 1
; RV64IZHINX-NEXT:    fcvt.h.wu a2, a0
; RV64IZHINX-NEXT:    sh a2, 0(a1)
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_wu_demanded_bits:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi a0, a0, 1
; RV32IDZFH-NEXT:    fcvt.h.wu fa5, a0
; RV32IDZFH-NEXT:    fsh fa5, 0(a1)
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_wu_demanded_bits:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    addiw a0, a0, 1
; RV64IDZFH-NEXT:    fcvt.h.wu fa5, a0
; RV64IDZFH-NEXT:    fsh fa5, 0(a1)
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_wu_demanded_bits:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi a0, a0, 1
; RV32IZDINXZHINX-NEXT:    fcvt.h.wu a2, a0
; RV32IZDINXZHINX-NEXT:    sh a2, 0(a1)
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_wu_demanded_bits:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    addiw a0, a0, 1
; RV64IZDINXZHINX-NEXT:    fcvt.h.wu a2, a0
; RV64IZDINXZHINX-NEXT:    sh a2, 0(a1)
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_wu_demanded_bits:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi a0, a0, 1
; CHECK32-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECK32-IZFHMIN-NEXT:    fsh fa5, 0(a1)
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_wu_demanded_bits:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    addiw a0, a0, 1
; CHECK64-IZFHMIN-NEXT:    fcvt.s.wu fa5, a0
; CHECK64-IZFHMIN-NEXT:    fcvt.h.s fa5, fa5
; CHECK64-IZFHMIN-NEXT:    fsh fa5, 0(a1)
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_wu_demanded_bits:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi a0, a0, 1
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.wu a2, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK32-IZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_wu_demanded_bits:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    addiw a0, a0, 1
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.wu a2, a0
; CHECK64-IZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK64-IZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_wu_demanded_bits:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi a0, a0, 1
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a2, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK32-IZDINXZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_wu_demanded_bits:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    addiw a0, a0, 1
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.wu a2, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.h.s a2, a2
; CHECK64-IZDINXZHINXMIN-NEXT:    sh a2, 0(a1)
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_wu_demanded_bits:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -16
; CHECK32-D-NEXT:    .cfi_def_cfa_offset 16
; CHECK32-D-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    sw s1, 4(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    .cfi_offset ra, -4
; CHECK32-D-NEXT:    .cfi_offset s0, -8
; CHECK32-D-NEXT:    .cfi_offset s1, -12
; CHECK32-D-NEXT:    mv s0, a1
; CHECK32-D-NEXT:    addi s1, a0, 1
; CHECK32-D-NEXT:    fcvt.s.wu fa0, s1
; CHECK32-D-NEXT:    call __truncsfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    sh a0, 0(s0)
; CHECK32-D-NEXT:    mv a0, s1
; CHECK32-D-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    lw s1, 4(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    .cfi_restore ra
; CHECK32-D-NEXT:    .cfi_restore s0
; CHECK32-D-NEXT:    .cfi_restore s1
; CHECK32-D-NEXT:    addi sp, sp, 16
; CHECK32-D-NEXT:    .cfi_def_cfa_offset 0
; CHECK32-D-NEXT:    ret
  %3 = add i32 %0, 1
  %4 = call half @llvm.experimental.constrained.uitofp.f16.i32(i32 %3, metadata !"round.dynamic", metadata !"fpexcept.strict")
  store half %4, ptr %1, align 2
  ret i32 %3
}

define half @fcvt_h_q(fp128 %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_h_q:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -32
; RV32IZFH-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    lw a1, 0(a0)
; RV32IZFH-NEXT:    lw a2, 4(a0)
; RV32IZFH-NEXT:    lw a3, 8(a0)
; RV32IZFH-NEXT:    lw a4, 12(a0)
; RV32IZFH-NEXT:    addi a0, sp, 8
; RV32IZFH-NEXT:    sw a1, 8(sp)
; RV32IZFH-NEXT:    sw a2, 12(sp)
; RV32IZFH-NEXT:    sw a3, 16(sp)
; RV32IZFH-NEXT:    sw a4, 20(sp)
; RV32IZFH-NEXT:    call __trunctfhf2
; RV32IZFH-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 32
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_h_q:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    call __trunctfhf2
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_h_q:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -32
; RV32IZHINX-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    lw a1, 0(a0)
; RV32IZHINX-NEXT:    lw a2, 4(a0)
; RV32IZHINX-NEXT:    lw a3, 8(a0)
; RV32IZHINX-NEXT:    lw a4, 12(a0)
; RV32IZHINX-NEXT:    addi a0, sp, 8
; RV32IZHINX-NEXT:    sw a1, 8(sp)
; RV32IZHINX-NEXT:    sw a2, 12(sp)
; RV32IZHINX-NEXT:    sw a3, 16(sp)
; RV32IZHINX-NEXT:    sw a4, 20(sp)
; RV32IZHINX-NEXT:    call __trunctfhf2
; RV32IZHINX-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 32
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_h_q:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    call __trunctfhf2
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_h_q:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -32
; RV32IDZFH-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    lw a1, 0(a0)
; RV32IDZFH-NEXT:    lw a2, 4(a0)
; RV32IDZFH-NEXT:    lw a3, 8(a0)
; RV32IDZFH-NEXT:    lw a4, 12(a0)
; RV32IDZFH-NEXT:    addi a0, sp, 8
; RV32IDZFH-NEXT:    sw a1, 8(sp)
; RV32IDZFH-NEXT:    sw a2, 12(sp)
; RV32IDZFH-NEXT:    sw a3, 16(sp)
; RV32IDZFH-NEXT:    sw a4, 20(sp)
; RV32IDZFH-NEXT:    call __trunctfhf2
; RV32IDZFH-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 32
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_h_q:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    addi sp, sp, -16
; RV64IDZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IDZFH-NEXT:    call __trunctfhf2
; RV64IDZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IDZFH-NEXT:    addi sp, sp, 16
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_h_q:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi sp, sp, -32
; RV32IZDINXZHINX-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    lw a1, 0(a0)
; RV32IZDINXZHINX-NEXT:    lw a2, 4(a0)
; RV32IZDINXZHINX-NEXT:    lw a3, 8(a0)
; RV32IZDINXZHINX-NEXT:    lw a4, 12(a0)
; RV32IZDINXZHINX-NEXT:    addi a0, sp, 8
; RV32IZDINXZHINX-NEXT:    sw a1, 8(sp)
; RV32IZDINXZHINX-NEXT:    sw a2, 12(sp)
; RV32IZDINXZHINX-NEXT:    sw a3, 16(sp)
; RV32IZDINXZHINX-NEXT:    sw a4, 20(sp)
; RV32IZDINXZHINX-NEXT:    call __trunctfhf2
; RV32IZDINXZHINX-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    addi sp, sp, 32
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_h_q:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    addi sp, sp, -16
; RV64IZDINXZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZDINXZHINX-NEXT:    call __trunctfhf2
; RV64IZDINXZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZDINXZHINX-NEXT:    addi sp, sp, 16
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_h_q:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, -32
; CHECK32-IZFHMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    lw a1, 0(a0)
; CHECK32-IZFHMIN-NEXT:    lw a2, 4(a0)
; CHECK32-IZFHMIN-NEXT:    lw a3, 8(a0)
; CHECK32-IZFHMIN-NEXT:    lw a4, 12(a0)
; CHECK32-IZFHMIN-NEXT:    addi a0, sp, 8
; CHECK32-IZFHMIN-NEXT:    sw a1, 8(sp)
; CHECK32-IZFHMIN-NEXT:    sw a2, 12(sp)
; CHECK32-IZFHMIN-NEXT:    sw a3, 16(sp)
; CHECK32-IZFHMIN-NEXT:    sw a4, 20(sp)
; CHECK32-IZFHMIN-NEXT:    call __trunctfhf2
; CHECK32-IZFHMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, 32
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_h_q:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZFHMIN-NEXT:    call __trunctfhf2
; CHECK64-IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZFHMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_h_q:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -32
; CHECK32-IZHINXMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    lw a1, 0(a0)
; CHECK32-IZHINXMIN-NEXT:    lw a2, 4(a0)
; CHECK32-IZHINXMIN-NEXT:    lw a3, 8(a0)
; CHECK32-IZHINXMIN-NEXT:    lw a4, 12(a0)
; CHECK32-IZHINXMIN-NEXT:    addi a0, sp, 8
; CHECK32-IZHINXMIN-NEXT:    sw a1, 8(sp)
; CHECK32-IZHINXMIN-NEXT:    sw a2, 12(sp)
; CHECK32-IZHINXMIN-NEXT:    sw a3, 16(sp)
; CHECK32-IZHINXMIN-NEXT:    sw a4, 20(sp)
; CHECK32-IZHINXMIN-NEXT:    call __trunctfhf2
; CHECK32-IZHINXMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 32
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_h_q:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZHINXMIN-NEXT:    call __trunctfhf2
; CHECK64-IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_h_q:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, -32
; CHECK32-IZDINXZHINXMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a1, 0(a0)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a2, 4(a0)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a3, 8(a0)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a4, 12(a0)
; CHECK32-IZDINXZHINXMIN-NEXT:    addi a0, sp, 8
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a1, 8(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a2, 12(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a3, 16(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a4, 20(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    call __trunctfhf2
; CHECK32-IZDINXZHINXMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, 32
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_h_q:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZDINXZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZDINXZHINXMIN-NEXT:    call __trunctfhf2
; CHECK64-IZDINXZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZDINXZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_h_q:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -32
; CHECK32-D-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    lw a1, 0(a0)
; CHECK32-D-NEXT:    lw a2, 4(a0)
; CHECK32-D-NEXT:    lw a3, 8(a0)
; CHECK32-D-NEXT:    lw a4, 12(a0)
; CHECK32-D-NEXT:    addi a0, sp, 8
; CHECK32-D-NEXT:    sw a1, 8(sp)
; CHECK32-D-NEXT:    sw a2, 12(sp)
; CHECK32-D-NEXT:    sw a3, 16(sp)
; CHECK32-D-NEXT:    sw a4, 20(sp)
; CHECK32-D-NEXT:    call __trunctfhf2
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    lui a1, 1048560
; CHECK32-D-NEXT:    or a0, a0, a1
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 32
; CHECK32-D-NEXT:    ret
  %1 = call half @llvm.experimental.constrained.fptrunc.f16.f128(fp128 %a, metadata !"round.dynamic", metadata !"fpexcept.strict")
  ret half %1
}

define fp128 @fcvt_q_h(half %a) nounwind strictfp {
; RV32IZFH-LABEL: fcvt_q_h:
; RV32IZFH:       # %bb.0:
; RV32IZFH-NEXT:    addi sp, sp, -32
; RV32IZFH-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IZFH-NEXT:    mv s0, a0
; RV32IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IZFH-NEXT:    addi a0, sp, 8
; RV32IZFH-NEXT:    call __extendsftf2
; RV32IZFH-NEXT:    lw a0, 8(sp)
; RV32IZFH-NEXT:    lw a1, 12(sp)
; RV32IZFH-NEXT:    lw a2, 16(sp)
; RV32IZFH-NEXT:    lw a3, 20(sp)
; RV32IZFH-NEXT:    sw a0, 0(s0)
; RV32IZFH-NEXT:    sw a1, 4(s0)
; RV32IZFH-NEXT:    sw a2, 8(s0)
; RV32IZFH-NEXT:    sw a3, 12(s0)
; RV32IZFH-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IZFH-NEXT:    addi sp, sp, 32
; RV32IZFH-NEXT:    ret
;
; RV64IZFH-LABEL: fcvt_q_h:
; RV64IZFH:       # %bb.0:
; RV64IZFH-NEXT:    addi sp, sp, -16
; RV64IZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IZFH-NEXT:    call __extendsftf2
; RV64IZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZFH-NEXT:    addi sp, sp, 16
; RV64IZFH-NEXT:    ret
;
; RV32IZHINX-LABEL: fcvt_q_h:
; RV32IZHINX:       # %bb.0:
; RV32IZHINX-NEXT:    addi sp, sp, -32
; RV32IZHINX-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IZHINX-NEXT:    mv s0, a0
; RV32IZHINX-NEXT:    fcvt.s.h a1, a1
; RV32IZHINX-NEXT:    addi a0, sp, 8
; RV32IZHINX-NEXT:    call __extendsftf2
; RV32IZHINX-NEXT:    lw a0, 8(sp)
; RV32IZHINX-NEXT:    lw a1, 12(sp)
; RV32IZHINX-NEXT:    lw a2, 16(sp)
; RV32IZHINX-NEXT:    lw a3, 20(sp)
; RV32IZHINX-NEXT:    sw a0, 0(s0)
; RV32IZHINX-NEXT:    sw a1, 4(s0)
; RV32IZHINX-NEXT:    sw a2, 8(s0)
; RV32IZHINX-NEXT:    sw a3, 12(s0)
; RV32IZHINX-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IZHINX-NEXT:    addi sp, sp, 32
; RV32IZHINX-NEXT:    ret
;
; RV64IZHINX-LABEL: fcvt_q_h:
; RV64IZHINX:       # %bb.0:
; RV64IZHINX-NEXT:    addi sp, sp, -16
; RV64IZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZHINX-NEXT:    call __extendsftf2
; RV64IZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZHINX-NEXT:    addi sp, sp, 16
; RV64IZHINX-NEXT:    ret
;
; RV32IDZFH-LABEL: fcvt_q_h:
; RV32IDZFH:       # %bb.0:
; RV32IDZFH-NEXT:    addi sp, sp, -32
; RV32IDZFH-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IDZFH-NEXT:    mv s0, a0
; RV32IDZFH-NEXT:    fcvt.s.h fa0, fa0
; RV32IDZFH-NEXT:    addi a0, sp, 8
; RV32IDZFH-NEXT:    call __extendsftf2
; RV32IDZFH-NEXT:    lw a0, 8(sp)
; RV32IDZFH-NEXT:    lw a1, 12(sp)
; RV32IDZFH-NEXT:    lw a2, 16(sp)
; RV32IDZFH-NEXT:    lw a3, 20(sp)
; RV32IDZFH-NEXT:    sw a0, 0(s0)
; RV32IDZFH-NEXT:    sw a1, 4(s0)
; RV32IDZFH-NEXT:    sw a2, 8(s0)
; RV32IDZFH-NEXT:    sw a3, 12(s0)
; RV32IDZFH-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IDZFH-NEXT:    addi sp, sp, 32
; RV32IDZFH-NEXT:    ret
;
; RV64IDZFH-LABEL: fcvt_q_h:
; RV64IDZFH:       # %bb.0:
; RV64IDZFH-NEXT:    addi sp, sp, -16
; RV64IDZFH-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IDZFH-NEXT:    fcvt.s.h fa0, fa0
; RV64IDZFH-NEXT:    call __extendsftf2
; RV64IDZFH-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IDZFH-NEXT:    addi sp, sp, 16
; RV64IDZFH-NEXT:    ret
;
; RV32IZDINXZHINX-LABEL: fcvt_q_h:
; RV32IZDINXZHINX:       # %bb.0:
; RV32IZDINXZHINX-NEXT:    addi sp, sp, -32
; RV32IZDINXZHINX-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; RV32IZDINXZHINX-NEXT:    mv s0, a0
; RV32IZDINXZHINX-NEXT:    fcvt.s.h a1, a1
; RV32IZDINXZHINX-NEXT:    addi a0, sp, 8
; RV32IZDINXZHINX-NEXT:    call __extendsftf2
; RV32IZDINXZHINX-NEXT:    lw a0, 8(sp)
; RV32IZDINXZHINX-NEXT:    lw a1, 12(sp)
; RV32IZDINXZHINX-NEXT:    lw a2, 16(sp)
; RV32IZDINXZHINX-NEXT:    lw a3, 20(sp)
; RV32IZDINXZHINX-NEXT:    sw a0, 0(s0)
; RV32IZDINXZHINX-NEXT:    sw a1, 4(s0)
; RV32IZDINXZHINX-NEXT:    sw a2, 8(s0)
; RV32IZDINXZHINX-NEXT:    sw a3, 12(s0)
; RV32IZDINXZHINX-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; RV32IZDINXZHINX-NEXT:    addi sp, sp, 32
; RV32IZDINXZHINX-NEXT:    ret
;
; RV64IZDINXZHINX-LABEL: fcvt_q_h:
; RV64IZDINXZHINX:       # %bb.0:
; RV64IZDINXZHINX-NEXT:    addi sp, sp, -16
; RV64IZDINXZHINX-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; RV64IZDINXZHINX-NEXT:    fcvt.s.h a0, a0
; RV64IZDINXZHINX-NEXT:    call __extendsftf2
; RV64IZDINXZHINX-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; RV64IZDINXZHINX-NEXT:    addi sp, sp, 16
; RV64IZDINXZHINX-NEXT:    ret
;
; CHECK32-IZFHMIN-LABEL: fcvt_q_h:
; CHECK32-IZFHMIN:       # %bb.0:
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, -32
; CHECK32-IZFHMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; CHECK32-IZFHMIN-NEXT:    mv s0, a0
; CHECK32-IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; CHECK32-IZFHMIN-NEXT:    addi a0, sp, 8
; CHECK32-IZFHMIN-NEXT:    call __extendsftf2
; CHECK32-IZFHMIN-NEXT:    lw a0, 8(sp)
; CHECK32-IZFHMIN-NEXT:    lw a1, 12(sp)
; CHECK32-IZFHMIN-NEXT:    lw a2, 16(sp)
; CHECK32-IZFHMIN-NEXT:    lw a3, 20(sp)
; CHECK32-IZFHMIN-NEXT:    sw a0, 0(s0)
; CHECK32-IZFHMIN-NEXT:    sw a1, 4(s0)
; CHECK32-IZFHMIN-NEXT:    sw a2, 8(s0)
; CHECK32-IZFHMIN-NEXT:    sw a3, 12(s0)
; CHECK32-IZFHMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; CHECK32-IZFHMIN-NEXT:    addi sp, sp, 32
; CHECK32-IZFHMIN-NEXT:    ret
;
; CHECK64-IZFHMIN-LABEL: fcvt_q_h:
; CHECK64-IZFHMIN:       # %bb.0:
; CHECK64-IZFHMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZFHMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZFHMIN-NEXT:    fcvt.s.h fa0, fa0
; CHECK64-IZFHMIN-NEXT:    call __extendsftf2
; CHECK64-IZFHMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZFHMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZFHMIN-NEXT:    ret
;
; CHECK32-IZHINXMIN-LABEL: fcvt_q_h:
; CHECK32-IZHINXMIN:       # %bb.0:
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, -32
; CHECK32-IZHINXMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; CHECK32-IZHINXMIN-NEXT:    mv s0, a0
; CHECK32-IZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECK32-IZHINXMIN-NEXT:    addi a0, sp, 8
; CHECK32-IZHINXMIN-NEXT:    call __extendsftf2
; CHECK32-IZHINXMIN-NEXT:    lw a0, 8(sp)
; CHECK32-IZHINXMIN-NEXT:    lw a1, 12(sp)
; CHECK32-IZHINXMIN-NEXT:    lw a2, 16(sp)
; CHECK32-IZHINXMIN-NEXT:    lw a3, 20(sp)
; CHECK32-IZHINXMIN-NEXT:    sw a0, 0(s0)
; CHECK32-IZHINXMIN-NEXT:    sw a1, 4(s0)
; CHECK32-IZHINXMIN-NEXT:    sw a2, 8(s0)
; CHECK32-IZHINXMIN-NEXT:    sw a3, 12(s0)
; CHECK32-IZHINXMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; CHECK32-IZHINXMIN-NEXT:    addi sp, sp, 32
; CHECK32-IZHINXMIN-NEXT:    ret
;
; CHECK64-IZHINXMIN-LABEL: fcvt_q_h:
; CHECK64-IZHINXMIN:       # %bb.0:
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZHINXMIN-NEXT:    call __extendsftf2
; CHECK64-IZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZHINXMIN-NEXT:    ret
;
; CHECK32-IZDINXZHINXMIN-LABEL: fcvt_q_h:
; CHECK32-IZDINXZHINXMIN:       # %bb.0:
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, -32
; CHECK32-IZDINXZHINXMIN-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; CHECK32-IZDINXZHINXMIN-NEXT:    mv s0, a0
; CHECK32-IZDINXZHINXMIN-NEXT:    fcvt.s.h a1, a1
; CHECK32-IZDINXZHINXMIN-NEXT:    addi a0, sp, 8
; CHECK32-IZDINXZHINXMIN-NEXT:    call __extendsftf2
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a0, 8(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a1, 12(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a2, 16(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw a3, 20(sp)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a0, 0(s0)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a1, 4(s0)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a2, 8(s0)
; CHECK32-IZDINXZHINXMIN-NEXT:    sw a3, 12(s0)
; CHECK32-IZDINXZHINXMIN-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; CHECK32-IZDINXZHINXMIN-NEXT:    addi sp, sp, 32
; CHECK32-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK64-IZDINXZHINXMIN-LABEL: fcvt_q_h:
; CHECK64-IZDINXZHINXMIN:       # %bb.0:
; CHECK64-IZDINXZHINXMIN-NEXT:    addi sp, sp, -16
; CHECK64-IZDINXZHINXMIN-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK64-IZDINXZHINXMIN-NEXT:    fcvt.s.h a0, a0
; CHECK64-IZDINXZHINXMIN-NEXT:    call __extendsftf2
; CHECK64-IZDINXZHINXMIN-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK64-IZDINXZHINXMIN-NEXT:    addi sp, sp, 16
; CHECK64-IZDINXZHINXMIN-NEXT:    ret
;
; CHECK32-D-LABEL: fcvt_q_h:
; CHECK32-D:       # %bb.0:
; CHECK32-D-NEXT:    addi sp, sp, -32
; CHECK32-D-NEXT:    sw ra, 28(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    sw s0, 24(sp) # 4-byte Folded Spill
; CHECK32-D-NEXT:    mv s0, a0
; CHECK32-D-NEXT:    fmv.x.w a0, fa0
; CHECK32-D-NEXT:    slli a0, a0, 16
; CHECK32-D-NEXT:    srli a0, a0, 16
; CHECK32-D-NEXT:    fmv.w.x fa0, a0
; CHECK32-D-NEXT:    call __extendhfsf2
; CHECK32-D-NEXT:    addi a0, sp, 8
; CHECK32-D-NEXT:    call __extendsftf2
; CHECK32-D-NEXT:    lw a0, 8(sp)
; CHECK32-D-NEXT:    lw a1, 12(sp)
; CHECK32-D-NEXT:    lw a2, 16(sp)
; CHECK32-D-NEXT:    lw a3, 20(sp)
; CHECK32-D-NEXT:    sw a0, 0(s0)
; CHECK32-D-NEXT:    sw a1, 4(s0)
; CHECK32-D-NEXT:    sw a2, 8(s0)
; CHECK32-D-NEXT:    sw a3, 12(s0)
; CHECK32-D-NEXT:    lw ra, 28(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    lw s0, 24(sp) # 4-byte Folded Reload
; CHECK32-D-NEXT:    addi sp, sp, 32
; CHECK32-D-NEXT:    ret
  %1 = call fp128 @llvm.experimental.constrained.fpext.f128.f16(half %a, metadata !"fpexcept.strict")
  ret fp128 %1
}
declare fp128 @llvm.experimental.constrained.fpext.f128.f16(half, metadata)
