; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE4
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX1
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mcpu=x86-64-v4 | FileCheck %s --check-prefixes=AVX,AVX512

;
; 128-bit vectors
;

define <16 x i8> @test_fixed_v16i8(<16 x i8> %a0, <16 x i8> %a1) nounwind {
; SSE-LABEL: test_fixed_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX512-NEXT:    vpbroadcastb {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX512-NEXT:    vpternlogd $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm0
; AVX512-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %and = and <16 x i8> %a0, %a1
  %xor = xor <16 x i8> %a0, %a1
  %shift = ashr <16 x i8> %xor, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %res = add <16 x i8> %and, %shift
  ret <16 x i8> %res
}

define <16 x i8> @test_ext_v16i8(<16 x i8> %a0, <16 x i8> %a1) nounwind {
; SSE-LABEL: test_ext_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    pand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    paddb %xmm2, %xmm0
; SSE-NEXT:    psubb %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v16i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpsrlw $1, %xmm0, %xmm0
; AVX512-NEXT:    vpbroadcastb {{.*#+}} xmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX512-NEXT:    vpternlogd $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm1, %xmm0
; AVX512-NEXT:    vpaddb %xmm2, %xmm0, %xmm0
; AVX512-NEXT:    vpsubb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
  %x0 = sext <16 x i8> %a0 to <16 x i16>
  %x1 = sext <16 x i8> %a1 to <16 x i16>
  %sum = add <16 x i16> %x0, %x1
  %shift = ashr <16 x i16> %sum, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = trunc <16 x i16> %shift to <16 x i8>
  ret <16 x i8> %res
}

define <8 x i16> @test_fixed_v8i16(<8 x i16> %a0, <8 x i16> %a1) nounwind {
; SSE-LABEL: test_fixed_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_fixed_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; AVX-NEXT:    retq
  %and = and <8 x i16> %a0, %a1
  %xor = xor <8 x i16> %a1, %a0
  %shift = ashr <8 x i16> %xor, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = add <8 x i16> %and, %shift
  ret <8 x i16> %res
}

define <8 x i16> @test_ext_v8i16(<8 x i16> %a0, <8 x i16> %a1) nounwind {
; SSE-LABEL: test_ext_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    paddw %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_ext_v8i16:
; AVX:       # %bb.0:
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; AVX-NEXT:    retq
  %x0 = sext <8 x i16> %a0 to <8 x i32>
  %x1 = sext <8 x i16> %a1 to <8 x i32>
  %sum = add <8 x i32> %x0, %x1
  %shift = ashr <8 x i32> %sum, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %res = trunc <8 x i32> %shift to <8 x i16>
  ret <8 x i16> %res
}

define <4 x i32> @test_fixed_v4i32(<4 x i32> %a0, <4 x i32> %a1) nounwind {
; SSE-LABEL: test_fixed_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_fixed_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX-NEXT:    retq
  %and = and <4 x i32> %a0, %a1
  %xor = xor <4 x i32> %a1, %a0
  %shift = ashr <4 x i32> %xor, <i32 1, i32 1, i32 1, i32 1>
  %res = add <4 x i32> %and, %shift
  ret <4 x i32> %res
}

define <4 x i32> @test_ext_v4i32(<4 x i32> %a0, <4 x i32> %a1) nounwind {
; SSE-LABEL: test_ext_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pand %xmm1, %xmm2
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    paddd %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_ext_v4i32:
; AVX:       # %bb.0:
; AVX-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX-NEXT:    retq
  %x0 = sext <4 x i32> %a0 to <4 x i64>
  %x1 = sext <4 x i32> %a1 to <4 x i64>
  %sum = add <4 x i64> %x0, %x1
  %shift = ashr <4 x i64> %sum, <i64 1, i64 1, i64 1, i64 1>
  %res = trunc <4 x i64> %shift to <4 x i32>
  ret <4 x i32> %res
}

define <2 x i64> @test_fixed_v2i64(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE2-LABEL: test_fixed_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm3
; SSE2-NEXT:    psrlq $1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    paddq %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: test_fixed_v2i64:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pxor %xmm1, %xmm2
; SSE4-NEXT:    movdqa %xmm2, %xmm3
; SSE4-NEXT:    psrad $1, %xmm3
; SSE4-NEXT:    psrlq $1, %xmm2
; SSE4-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE4-NEXT:    pand %xmm1, %xmm0
; SSE4-NEXT:    paddq %xmm2, %xmm0
; SSE4-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpsrad $1, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2],xmm3[3]
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpsraq $1, %xmm0, %xmm0
; AVX512-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; AVX512-NEXT:    retq
  %and = and <2 x i64> %a0, %a1
  %xor = xor <2 x i64> %a1, %a0
  %shift = ashr <2 x i64> %xor, <i64 1, i64 1>
  %res = add <2 x i64> %and, %shift
  ret <2 x i64> %res
}

define <2 x i64> @test_ext_v2i64(<2 x i64> %a0, <2 x i64> %a1) nounwind {
; SSE2-LABEL: test_ext_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm3 = xmm2[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm3
; SSE2-NEXT:    psrlq $1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm3[0],xmm2[1],xmm3[1]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    paddq %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE4-LABEL: test_ext_v2i64:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm2
; SSE4-NEXT:    pxor %xmm1, %xmm2
; SSE4-NEXT:    movdqa %xmm2, %xmm3
; SSE4-NEXT:    psrad $1, %xmm3
; SSE4-NEXT:    psrlq $1, %xmm2
; SSE4-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; SSE4-NEXT:    pand %xmm1, %xmm0
; SSE4-NEXT:    paddq %xmm2, %xmm0
; SSE4-NEXT:    retq
;
; AVX1-LABEL: test_ext_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm0, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; AVX1-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpsrad $1, %xmm2, %xmm3
; AVX2-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm2 = xmm2[0],xmm3[1],xmm2[2],xmm3[3]
; AVX2-NEXT:    vpand %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpsraq $1, %xmm0, %xmm0
; AVX512-NEXT:    vpaddq %xmm0, %xmm2, %xmm0
; AVX512-NEXT:    retq
  %x0 = sext <2 x i64> %a0 to <2 x i128>
  %x1 = sext <2 x i64> %a1 to <2 x i128>
  %sum = add <2 x i128> %x0, %x1
  %shift = ashr <2 x i128> %sum, <i128 1, i128 1>
  %res = trunc <2 x i128> %shift to <2 x i64>
  ret <2 x i64> %res
}

;
; 256-bit vectors
;

define <32 x i8> @test_fixed_v32i8(<32 x i8> %a0, <32 x i8> %a1) nounwind {
; SSE-LABEL: test_fixed_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE-NEXT:    pxor %xmm5, %xmm0
; SSE-NEXT:    paddb %xmm4, %xmm0
; SSE-NEXT:    psubb %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    psrlw $1, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    paddb %xmm4, %xmm1
; SSE-NEXT:    psubb %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsubb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX512-NEXT:    vpternlogd $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm0
; AVX512-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %and = and <32 x i8> %a0, %a1
  %xor = xor <32 x i8> %a0, %a1
  %shift = ashr <32 x i8> %xor, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %res = add <32 x i8> %and, %shift
  ret <32 x i8> %res
}

define <32 x i8> @test_ext_v32i8(<32 x i8> %a0, <32 x i8> %a1) nounwind {
; SSE-LABEL: test_ext_v32i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    pand %xmm2, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE-NEXT:    pxor %xmm5, %xmm0
; SSE-NEXT:    paddb %xmm4, %xmm0
; SSE-NEXT:    psubb %xmm5, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm3, %xmm4
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    psrlw $1, %xmm1
; SSE-NEXT:    pand %xmm2, %xmm1
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    paddb %xmm4, %xmm1
; SSE-NEXT:    psubb %xmm5, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v32i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm4 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX1-NEXT:    vpxor %xmm5, %xmm3, %xmm3
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpaddb %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsubb %xmm5, %xmm1, %xmm1
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm4, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vpsubb %xmm5, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v32i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpand {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v32i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX512-NEXT:    vpbroadcastb {{.*#+}} ymm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX512-NEXT:    vpternlogd $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to8}, %ymm1, %ymm0
; AVX512-NEXT:    vpaddb %ymm2, %ymm0, %ymm0
; AVX512-NEXT:    vpsubb %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %x0 = sext <32 x i8> %a0 to <32 x i16>
  %x1 = sext <32 x i8> %a1 to <32 x i16>
  %sum = add <32 x i16> %x0, %x1
  %shift = ashr <32 x i16> %sum, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = trunc <32 x i16> %shift to <32 x i8>
  ret <32 x i8> %res
}

define <16 x i16> @test_fixed_v16i16(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: test_fixed_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    paddw %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    psraw $1, %xmm1
; SSE-NEXT:    paddw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsraw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsraw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsraw $1, %ymm0, %ymm0
; AVX512-NEXT:    vpaddw %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    retq
  %and = and <16 x i16> %a0, %a1
  %xor = xor <16 x i16> %a1, %a0
  %shift = ashr <16 x i16> %xor, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = add <16 x i16> %and, %shift
  ret <16 x i16> %res
}

define <16 x i16> @test_ext_v16i16(<16 x i16> %a0, <16 x i16> %a1) nounwind {
; SSE-LABEL: test_ext_v16i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    paddw %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    psraw $1, %xmm1
; SSE-NEXT:    paddw %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v16i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsraw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v16i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsraw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v16i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsraw $1, %ymm0, %ymm0
; AVX512-NEXT:    vpaddw %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    retq
  %x0 = sext <16 x i16> %a0 to <16 x i32>
  %x1 = sext <16 x i16> %a1 to <16 x i32>
  %sum = add <16 x i32> %x0, %x1
  %shift = ashr <16 x i32> %sum, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %res = trunc <16 x i32> %shift to <16 x i16>
  ret <16 x i16> %res
}

define <8 x i32> @test_fixed_v8i32(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: test_fixed_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    psrad $1, %xmm1
; SSE-NEXT:    paddd %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrad $1, %ymm0, %ymm0
; AVX512-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    retq
  %and = and <8 x i32> %a0, %a1
  %xor = xor <8 x i32> %a1, %a0
  %shift = ashr <8 x i32> %xor, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %res = add <8 x i32> %and, %shift
  ret <8 x i32> %res
}

define <8 x i32> @test_ext_v8i32(<8 x i32> %a0, <8 x i32> %a1) nounwind {
; SSE-LABEL: test_ext_v8i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm4
; SSE-NEXT:    pand %xmm2, %xmm4
; SSE-NEXT:    pxor %xmm2, %xmm0
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    paddd %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm2
; SSE-NEXT:    pand %xmm3, %xmm2
; SSE-NEXT:    pxor %xmm3, %xmm1
; SSE-NEXT:    psrad $1, %xmm1
; SSE-NEXT:    paddd %xmm2, %xmm1
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v8i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpsrad $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm3, %xmm1
; AVX1-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm0, %xmm2, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v8i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v8i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsrad $1, %ymm0, %ymm0
; AVX512-NEXT:    vpaddd %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    retq
  %x0 = sext <8 x i32> %a0 to <8 x i64>
  %x1 = sext <8 x i32> %a1 to <8 x i64>
  %sum = add <8 x i64> %x0, %x1
  %shift = ashr <8 x i64> %sum, <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>
  %res = trunc <8 x i64> %shift to <8 x i32>
  ret <8 x i32> %res
}

define <4 x i64> @test_fixed_v4i64(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE2-LABEL: test_fixed_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm5
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    paddq %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm4
; SSE2-NEXT:    psrlq $1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    paddq %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE4-LABEL: test_fixed_v4i64:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm4
; SSE4-NEXT:    pxor %xmm2, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm5
; SSE4-NEXT:    psrad $1, %xmm5
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE4-NEXT:    pand %xmm2, %xmm0
; SSE4-NEXT:    paddq %xmm4, %xmm0
; SSE4-NEXT:    movdqa %xmm1, %xmm2
; SSE4-NEXT:    pxor %xmm3, %xmm2
; SSE4-NEXT:    movdqa %xmm2, %xmm4
; SSE4-NEXT:    psrad $1, %xmm4
; SSE4-NEXT:    psrlq $1, %xmm2
; SSE4-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; SSE4-NEXT:    pand %xmm3, %xmm1
; SSE4-NEXT:    paddq %xmm2, %xmm1
; SSE4-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlq $1, %xmm3, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3],xmm3[4,5],xmm4[6,7]
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpsrad $1, %ymm2, %ymm3
; AVX2-NEXT:    vpsrlq $1, %ymm2, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[3],ymm2[4],ymm3[5],ymm2[6],ymm3[7]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsraq $1, %ymm0, %ymm0
; AVX512-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    retq
  %and = and <4 x i64> %a0, %a1
  %xor = xor <4 x i64> %a1, %a0
  %shift = ashr <4 x i64> %xor, <i64 1, i64 1, i64 1, i64 1>
  %res = add <4 x i64> %and, %shift
  ret <4 x i64> %res
}

define <4 x i64> @test_ext_v4i64(<4 x i64> %a0, <4 x i64> %a1) nounwind {
; SSE2-LABEL: test_ext_v4i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm4
; SSE2-NEXT:    pxor %xmm2, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm5
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    paddq %xmm4, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm2
; SSE2-NEXT:    pxor %xmm3, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm2[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm4
; SSE2-NEXT:    psrlq $1, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm2[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm2 = xmm2[0],xmm4[0],xmm2[1],xmm4[1]
; SSE2-NEXT:    pand %xmm3, %xmm1
; SSE2-NEXT:    paddq %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE4-LABEL: test_ext_v4i64:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm4
; SSE4-NEXT:    pxor %xmm2, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm5
; SSE4-NEXT:    psrad $1, %xmm5
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE4-NEXT:    pand %xmm2, %xmm0
; SSE4-NEXT:    paddq %xmm4, %xmm0
; SSE4-NEXT:    movdqa %xmm1, %xmm2
; SSE4-NEXT:    pxor %xmm3, %xmm2
; SSE4-NEXT:    movdqa %xmm2, %xmm4
; SSE4-NEXT:    psrad $1, %xmm4
; SSE4-NEXT:    psrlq $1, %xmm2
; SSE4-NEXT:    pblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; SSE4-NEXT:    pand %xmm3, %xmm1
; SSE4-NEXT:    paddq %xmm2, %xmm1
; SSE4-NEXT:    retq
;
; AVX1-LABEL: test_ext_v4i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm1, %ymm0, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm3, %xmm4
; AVX1-NEXT:    vpsrlq $1, %xmm3, %xmm3
; AVX1-NEXT:    vpblendw {{.*#+}} xmm3 = xmm3[0,1],xmm4[2,3],xmm3[4,5],xmm4[6,7]
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpaddq %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm3
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm3[2,3],xmm2[4,5],xmm3[6,7]
; AVX1-NEXT:    vpaddq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v4i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm1, %ymm0, %ymm2
; AVX2-NEXT:    vpsrad $1, %ymm2, %ymm3
; AVX2-NEXT:    vpsrlq $1, %ymm2, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm3[1],ymm2[2],ymm3[3],ymm2[4],ymm3[5],ymm2[6],ymm3[7]
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v4i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpand %ymm1, %ymm0, %ymm2
; AVX512-NEXT:    vpxor %ymm1, %ymm0, %ymm0
; AVX512-NEXT:    vpsraq $1, %ymm0, %ymm0
; AVX512-NEXT:    vpaddq %ymm0, %ymm2, %ymm0
; AVX512-NEXT:    retq
  %x0 = sext <4 x i64> %a0 to <4 x i128>
  %x1 = sext <4 x i64> %a1 to <4 x i128>
  %sum = add <4 x i128> %x0, %x1
  %shift = ashr <4 x i128> %sum, <i128 1, i128 1, i128 1, i128 1>
  %res = trunc <4 x i128> %shift to <4 x i64>
  ret <4 x i64> %res
}

;
; 512-bit vectors
;

define <64 x i8> @test_fixed_v64i8(<64 x i8> %a0, <64 x i8> %a1) nounwind {
; SSE-LABEL: test_fixed_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    pand %xmm4, %xmm9
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    paddb %xmm9, %xmm0
; SSE-NEXT:    psubb %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    psrlw $1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    paddb %xmm9, %xmm1
; SSE-NEXT:    psubb %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    psrlw $1, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    paddb %xmm5, %xmm2
; SSE-NEXT:    psubb %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    psrlw $1, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    paddb %xmm5, %xmm3
; SSE-NEXT:    psubb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpsrlw $1, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX1-NEXT:    vpxor %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsubb %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpaddb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpsrlw $1, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsubb %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX2-NEXT:    vpxor %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsubb %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm4
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpsubb %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsrlw $1, %zmm0, %zmm0
; AVX512-NEXT:    vpbroadcastb {{.*#+}} zmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX512-NEXT:    vpternlogd $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %zmm0
; AVX512-NEXT:    vpaddb %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpsubb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %and = and <64 x i8> %a0, %a1
  %xor = xor <64 x i8> %a0, %a1
  %shift = ashr <64 x i8> %xor, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %res = add <64 x i8> %and, %shift
  ret <64 x i8> %res
}

define <64 x i8> @test_ext_v64i8(<64 x i8> %a0, <64 x i8> %a1) nounwind {
; SSE-LABEL: test_ext_v64i8:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm9
; SSE-NEXT:    pand %xmm4, %xmm9
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    psrlw $1, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm8 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; SSE-NEXT:    pand %xmm8, %xmm0
; SSE-NEXT:    movdqa {{.*#+}} xmm4 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    paddb %xmm9, %xmm0
; SSE-NEXT:    psubb %xmm4, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm9
; SSE-NEXT:    pand %xmm5, %xmm9
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    psrlw $1, %xmm1
; SSE-NEXT:    pand %xmm8, %xmm1
; SSE-NEXT:    pxor %xmm4, %xmm1
; SSE-NEXT:    paddb %xmm9, %xmm1
; SSE-NEXT:    psubb %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm5
; SSE-NEXT:    pand %xmm6, %xmm5
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    psrlw $1, %xmm2
; SSE-NEXT:    pand %xmm8, %xmm2
; SSE-NEXT:    pxor %xmm4, %xmm2
; SSE-NEXT:    paddb %xmm5, %xmm2
; SSE-NEXT:    psubb %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm5
; SSE-NEXT:    pand %xmm7, %xmm5
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    psrlw $1, %xmm3
; SSE-NEXT:    pand %xmm8, %xmm3
; SSE-NEXT:    pxor %xmm4, %xmm3
; SSE-NEXT:    paddb %xmm5, %xmm3
; SSE-NEXT:    psubb %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v64i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpsrlw $1, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm6 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX1-NEXT:    vpand %xmm6, %xmm5, %xmm5
; AVX1-NEXT:    vbroadcastss {{.*#+}} xmm7 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX1-NEXT:    vpxor %xmm7, %xmm5, %xmm5
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpaddb %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsubb %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpsrlw $1, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vpaddb %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vpsubb %xmm7, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpsrlw $1, %xmm4, %xmm4
; AVX1-NEXT:    vpand %xmm6, %xmm4, %xmm4
; AVX1-NEXT:    vpxor %xmm7, %xmm4, %xmm4
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddb %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsubb %xmm7, %xmm3, %xmm3
; AVX1-NEXT:    vpsrlw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpand %xmm6, %xmm2, %xmm2
; AVX1-NEXT:    vpxor %xmm7, %xmm2, %xmm2
; AVX1-NEXT:    vpaddb %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vpsubb %xmm7, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v64i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrlw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm2 = [127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastb {{.*#+}} ymm5 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX2-NEXT:    vpxor %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpaddb %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpsubb %ymm5, %ymm0, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm4
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrlw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpand %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vpxor %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    vpaddb %ymm4, %ymm1, %ymm1
; AVX2-NEXT:    vpsubb %ymm5, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v64i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsrlw $1, %zmm0, %zmm0
; AVX512-NEXT:    vpbroadcastb {{.*#+}} zmm1 = [64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64]
; AVX512-NEXT:    vpternlogd $108, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm1, %zmm0
; AVX512-NEXT:    vpaddb %zmm2, %zmm0, %zmm0
; AVX512-NEXT:    vpsubb %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %x0 = sext <64 x i8> %a0 to <64 x i16>
  %x1 = sext <64 x i8> %a1 to <64 x i16>
  %sum = add <64 x i16> %x0, %x1
  %shift = ashr <64 x i16> %sum, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = trunc <64 x i16> %shift to <64 x i8>
  ret <64 x i8> %res
}

define <32 x i16> @test_fixed_v32i16(<32 x i16> %a0, <32 x i16> %a1) nounwind {
; SSE-LABEL: test_fixed_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    paddw %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    psraw $1, %xmm1
; SSE-NEXT:    paddw %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    psraw $1, %xmm2
; SSE-NEXT:    paddw %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    psraw $1, %xmm3
; SSE-NEXT:    paddw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsraw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpsraw $1, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsraw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsraw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsraw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsraw $1, %zmm0, %zmm0
; AVX512-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %and = and <32 x i16> %a0, %a1
  %xor = xor <32 x i16> %a1, %a0
  %shift = ashr <32 x i16> %xor, <i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1, i16 1>
  %res = add <32 x i16> %and, %shift
  ret <32 x i16> %res
}

define <32 x i16> @test_ext_v32i16(<32 x i16> %a0, <32 x i16> %a1) nounwind {
; SSE-LABEL: test_ext_v32i16:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    psraw $1, %xmm0
; SSE-NEXT:    paddw %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    psraw $1, %xmm1
; SSE-NEXT:    paddw %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    psraw $1, %xmm2
; SSE-NEXT:    paddw %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    psraw $1, %xmm3
; SSE-NEXT:    paddw %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v32i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsraw $1, %xmm2, %xmm2
; AVX1-NEXT:    vpaddw %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsraw $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddw %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpsraw $1, %xmm3, %xmm3
; AVX1-NEXT:    vpaddw %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsraw $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddw %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v32i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsraw $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddw %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsraw $1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddw %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v32i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsraw $1, %zmm0, %zmm0
; AVX512-NEXT:    vpaddw %zmm0, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %x0 = sext <32 x i16> %a0 to <32 x i32>
  %x1 = sext <32 x i16> %a1 to <32 x i32>
  %sum = add <32 x i32> %x0, %x1
  %shift = ashr <32 x i32> %sum, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %res = trunc <32 x i32> %shift to <32 x i16>
  ret <32 x i16> %res
}

define <16 x i32> @test_fixed_v16i32(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: test_fixed_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    paddd %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    psrad $1, %xmm1
; SSE-NEXT:    paddd %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    psrad $1, %xmm2
; SSE-NEXT:    paddd %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    psrad $1, %xmm3
; SSE-NEXT:    paddd %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrad $1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandd %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxord %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsrad $1, %zmm0, %zmm0
; AVX512-NEXT:    vpaddd %zmm0, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %and = and <16 x i32> %a0, %a1
  %xor = xor <16 x i32> %a1, %a0
  %shift = ashr <16 x i32> %xor, <i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1, i32 1>
  %res = add <16 x i32> %and, %shift
  ret <16 x i32> %res
}

define <16 x i32> @test_ext_v16i32(<16 x i32> %a0, <16 x i32> %a1) nounwind {
; SSE-LABEL: test_ext_v16i32:
; SSE:       # %bb.0:
; SSE-NEXT:    movdqa %xmm0, %xmm8
; SSE-NEXT:    pand %xmm4, %xmm8
; SSE-NEXT:    pxor %xmm4, %xmm0
; SSE-NEXT:    psrad $1, %xmm0
; SSE-NEXT:    paddd %xmm8, %xmm0
; SSE-NEXT:    movdqa %xmm1, %xmm4
; SSE-NEXT:    pand %xmm5, %xmm4
; SSE-NEXT:    pxor %xmm5, %xmm1
; SSE-NEXT:    psrad $1, %xmm1
; SSE-NEXT:    paddd %xmm4, %xmm1
; SSE-NEXT:    movdqa %xmm2, %xmm4
; SSE-NEXT:    pand %xmm6, %xmm4
; SSE-NEXT:    pxor %xmm6, %xmm2
; SSE-NEXT:    psrad $1, %xmm2
; SSE-NEXT:    paddd %xmm4, %xmm2
; SSE-NEXT:    movdqa %xmm3, %xmm4
; SSE-NEXT:    pand %xmm7, %xmm4
; SSE-NEXT:    pxor %xmm7, %xmm3
; SSE-NEXT:    psrad $1, %xmm3
; SSE-NEXT:    paddd %xmm4, %xmm3
; SSE-NEXT:    retq
;
; AVX1-LABEL: test_ext_v16i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm2
; AVX1-NEXT:    vpaddd %xmm2, %xmm5, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm0, %xmm0
; AVX1-NEXT:    vpaddd %xmm0, %xmm4, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm3, %xmm3
; AVX1-NEXT:    vpaddd %xmm3, %xmm4, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm1, %xmm1
; AVX1-NEXT:    vpaddd %xmm1, %xmm2, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v16i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $1, %ymm0, %ymm0
; AVX2-NEXT:    vpaddd %ymm0, %ymm4, %ymm0
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpsrad $1, %ymm1, %ymm1
; AVX2-NEXT:    vpaddd %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v16i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandd %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxord %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsrad $1, %zmm0, %zmm0
; AVX512-NEXT:    vpaddd %zmm0, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %x0 = sext <16 x i32> %a0 to <16 x i64>
  %x1 = sext <16 x i32> %a1 to <16 x i64>
  %sum = add <16 x i64> %x0, %x1
  %shift = ashr <16 x i64> %sum, <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>
  %res = trunc <16 x i64> %shift to <16 x i32>
  ret <16 x i32> %res
}

define <8 x i64> @test_fixed_v8i64(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE2-LABEL: test_fixed_v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm8
; SSE2-NEXT:    pxor %xmm4, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm9
; SSE2-NEXT:    psrlq $1, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    paddq %xmm8, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm8
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    paddq %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm5
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    paddq %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm7, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm5
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE2-NEXT:    pand %xmm7, %xmm3
; SSE2-NEXT:    paddq %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE4-LABEL: test_fixed_v8i64:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm8
; SSE4-NEXT:    pxor %xmm4, %xmm8
; SSE4-NEXT:    movdqa %xmm8, %xmm9
; SSE4-NEXT:    psrad $1, %xmm9
; SSE4-NEXT:    psrlq $1, %xmm8
; SSE4-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1],xmm9[2,3],xmm8[4,5],xmm9[6,7]
; SSE4-NEXT:    pand %xmm4, %xmm0
; SSE4-NEXT:    paddq %xmm8, %xmm0
; SSE4-NEXT:    movdqa %xmm1, %xmm4
; SSE4-NEXT:    pxor %xmm5, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm8
; SSE4-NEXT:    psrad $1, %xmm8
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm8[2,3],xmm4[4,5],xmm8[6,7]
; SSE4-NEXT:    pand %xmm5, %xmm1
; SSE4-NEXT:    paddq %xmm4, %xmm1
; SSE4-NEXT:    movdqa %xmm2, %xmm4
; SSE4-NEXT:    pxor %xmm6, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm5
; SSE4-NEXT:    psrad $1, %xmm5
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE4-NEXT:    pand %xmm6, %xmm2
; SSE4-NEXT:    paddq %xmm4, %xmm2
; SSE4-NEXT:    movdqa %xmm3, %xmm4
; SSE4-NEXT:    pxor %xmm7, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm5
; SSE4-NEXT:    psrad $1, %xmm5
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE4-NEXT:    pand %xmm7, %xmm3
; SSE4-NEXT:    paddq %xmm4, %xmm3
; SSE4-NEXT:    retq
;
; AVX1-LABEL: test_fixed_v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpsrad $1, %xmm5, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm5, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3],xmm5[4,5],xmm6[6,7]
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpaddq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlq $1, %xmm4, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpsrad $1, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlq $1, %xmm4, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm4
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; AVX1-NEXT:    vpaddq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_fixed_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpsrad $1, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlq $1, %ymm4, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2],ymm5[3],ymm4[4],ymm5[5],ymm4[6],ymm5[7]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpsrad $1, %ymm2, %ymm4
; AVX2-NEXT:    vpsrlq $1, %ymm2, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[3],ymm2[4],ymm4[5],ymm2[6],ymm4[7]
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_fixed_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsraq $1, %zmm0, %zmm0
; AVX512-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %and = and <8 x i64> %a0, %a1
  %xor = xor <8 x i64> %a1, %a0
  %shift = ashr <8 x i64> %xor, <i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1, i64 1>
  %res = add <8 x i64> %and, %shift
  ret <8 x i64> %res
}

define <8 x i64> @test_ext_v8i64(<8 x i64> %a0, <8 x i64> %a1) nounwind {
; SSE2-LABEL: test_ext_v8i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm8
; SSE2-NEXT:    pxor %xmm4, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm9 = xmm8[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm9
; SSE2-NEXT:    psrlq $1, %xmm8
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm8[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm8 = xmm8[0],xmm9[0],xmm8[1],xmm9[1]
; SSE2-NEXT:    pand %xmm4, %xmm0
; SSE2-NEXT:    paddq %xmm8, %xmm0
; SSE2-NEXT:    movdqa %xmm1, %xmm4
; SSE2-NEXT:    pxor %xmm5, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm8 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm8
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm8[0],xmm4[1],xmm8[1]
; SSE2-NEXT:    pand %xmm5, %xmm1
; SSE2-NEXT:    paddq %xmm4, %xmm1
; SSE2-NEXT:    movdqa %xmm2, %xmm4
; SSE2-NEXT:    pxor %xmm6, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm5
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE2-NEXT:    pand %xmm6, %xmm2
; SSE2-NEXT:    paddq %xmm4, %xmm2
; SSE2-NEXT:    movdqa %xmm3, %xmm4
; SSE2-NEXT:    pxor %xmm7, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm5 = xmm4[1,3,2,3]
; SSE2-NEXT:    psrad $1, %xmm5
; SSE2-NEXT:    psrlq $1, %xmm4
; SSE2-NEXT:    pshufd {{.*#+}} xmm4 = xmm4[0,2,2,3]
; SSE2-NEXT:    punpckldq {{.*#+}} xmm4 = xmm4[0],xmm5[0],xmm4[1],xmm5[1]
; SSE2-NEXT:    pand %xmm7, %xmm3
; SSE2-NEXT:    paddq %xmm4, %xmm3
; SSE2-NEXT:    retq
;
; SSE4-LABEL: test_ext_v8i64:
; SSE4:       # %bb.0:
; SSE4-NEXT:    movdqa %xmm0, %xmm8
; SSE4-NEXT:    pxor %xmm4, %xmm8
; SSE4-NEXT:    movdqa %xmm8, %xmm9
; SSE4-NEXT:    psrad $1, %xmm9
; SSE4-NEXT:    psrlq $1, %xmm8
; SSE4-NEXT:    pblendw {{.*#+}} xmm8 = xmm8[0,1],xmm9[2,3],xmm8[4,5],xmm9[6,7]
; SSE4-NEXT:    pand %xmm4, %xmm0
; SSE4-NEXT:    paddq %xmm8, %xmm0
; SSE4-NEXT:    movdqa %xmm1, %xmm4
; SSE4-NEXT:    pxor %xmm5, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm8
; SSE4-NEXT:    psrad $1, %xmm8
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm8[2,3],xmm4[4,5],xmm8[6,7]
; SSE4-NEXT:    pand %xmm5, %xmm1
; SSE4-NEXT:    paddq %xmm4, %xmm1
; SSE4-NEXT:    movdqa %xmm2, %xmm4
; SSE4-NEXT:    pxor %xmm6, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm5
; SSE4-NEXT:    psrad $1, %xmm5
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE4-NEXT:    pand %xmm6, %xmm2
; SSE4-NEXT:    paddq %xmm4, %xmm2
; SSE4-NEXT:    movdqa %xmm3, %xmm4
; SSE4-NEXT:    pxor %xmm7, %xmm4
; SSE4-NEXT:    movdqa %xmm4, %xmm5
; SSE4-NEXT:    psrad $1, %xmm5
; SSE4-NEXT:    psrlq $1, %xmm4
; SSE4-NEXT:    pblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; SSE4-NEXT:    pand %xmm7, %xmm3
; SSE4-NEXT:    paddq %xmm4, %xmm3
; SSE4-NEXT:    retq
;
; AVX1-LABEL: test_ext_v8i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %ymm2, %ymm0, %ymm4
; AVX1-NEXT:    vextractf128 $1, %ymm4, %xmm5
; AVX1-NEXT:    vpsrad $1, %xmm5, %xmm6
; AVX1-NEXT:    vpsrlq $1, %xmm5, %xmm5
; AVX1-NEXT:    vpblendw {{.*#+}} xmm5 = xmm5[0,1],xmm6[2,3],xmm5[4,5],xmm6[6,7]
; AVX1-NEXT:    vandps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpaddq %xmm5, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $1, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlq $1, %xmm4, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; AVX1-NEXT:    vpaddq %xmm4, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vxorps %ymm3, %ymm1, %ymm2
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm4
; AVX1-NEXT:    vpsrad $1, %xmm4, %xmm5
; AVX1-NEXT:    vpsrlq $1, %xmm4, %xmm4
; AVX1-NEXT:    vpblendw {{.*#+}} xmm4 = xmm4[0,1],xmm5[2,3],xmm4[4,5],xmm5[6,7]
; AVX1-NEXT:    vandps %ymm3, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpaddq %xmm4, %xmm3, %xmm3
; AVX1-NEXT:    vpsrad $1, %xmm2, %xmm4
; AVX1-NEXT:    vpsrlq $1, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm2 = xmm2[0,1],xmm4[2,3],xmm2[4,5],xmm4[6,7]
; AVX1-NEXT:    vpaddq %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm3, %ymm1, %ymm1
; AVX1-NEXT:    retq
;
; AVX2-LABEL: test_ext_v8i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %ymm2, %ymm0, %ymm4
; AVX2-NEXT:    vpsrad $1, %ymm4, %ymm5
; AVX2-NEXT:    vpsrlq $1, %ymm4, %ymm4
; AVX2-NEXT:    vpblendd {{.*#+}} ymm4 = ymm4[0],ymm5[1],ymm4[2],ymm5[3],ymm4[4],ymm5[5],ymm4[6],ymm5[7]
; AVX2-NEXT:    vpand %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpaddq %ymm4, %ymm0, %ymm0
; AVX2-NEXT:    vpxor %ymm3, %ymm1, %ymm2
; AVX2-NEXT:    vpsrad $1, %ymm2, %ymm4
; AVX2-NEXT:    vpsrlq $1, %ymm2, %ymm2
; AVX2-NEXT:    vpblendd {{.*#+}} ymm2 = ymm2[0],ymm4[1],ymm2[2],ymm4[3],ymm2[4],ymm4[5],ymm2[6],ymm4[7]
; AVX2-NEXT:    vpand %ymm3, %ymm1, %ymm1
; AVX2-NEXT:    vpaddq %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    retq
;
; AVX512-LABEL: test_ext_v8i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm2
; AVX512-NEXT:    vpxorq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpsraq $1, %zmm0, %zmm0
; AVX512-NEXT:    vpaddq %zmm0, %zmm2, %zmm0
; AVX512-NEXT:    retq
  %x0 = sext <8 x i64> %a0 to <8 x i128>
  %x1 = sext <8 x i64> %a1 to <8 x i128>
  %sum = add <8 x i128> %x0, %x1
  %shift = ashr <8 x i128> %sum, <i128 1, i128 1, i128 1, i128 1, i128 1, i128 1, i128 1, i128 1>
  %res = trunc <8 x i128> %shift to <8 x i64>
  ret <8 x i64> %res
}

