; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 | FileCheck %s --check-prefixes=CHECK,CHECK-BASE
; RUN: opt < %s -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output -mtriple=aarch64 -mattr=+fullfp16 | FileCheck %s --check-prefixes=CHECK,CHECK-FP16

define void @fcmp_oeq(i32 %arg) {
; CHECK-LABEL: 'fcmp_oeq'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp oeq float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp oeq <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp oeq <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp oeq <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp oeq double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp oeq <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp oeq <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp oeq fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp oeq <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp oeq float undef, undef
  %v2f32 = fcmp oeq <2 x float> undef, undef
  %v4f32 = fcmp oeq <4 x float> undef, undef
  %v8f32 = fcmp oeq <8 x float> undef, undef
  %f64 = fcmp oeq double undef, undef
  %v2f64 = fcmp oeq <2 x double> undef, undef
  %v4f64 = fcmp oeq <4 x double> undef, undef
  %f128 = fcmp oeq fp128 undef, undef
  %v2f128 = fcmp oeq <2 x fp128> undef, undef
  ret void
}

define void @fcmp_oeq_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_oeq_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp oeq half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp oeq <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp oeq <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp oeq <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp oeq <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_oeq_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp oeq half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp oeq <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp oeq <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp oeq <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp oeq <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp oeq half undef, undef
  %v2f16 = fcmp oeq <2 x half> undef, undef
  %v4f16 = fcmp oeq <4 x half> undef, undef
  %v8f16 = fcmp oeq <8 x half> undef, undef
  %v16f16 = fcmp oeq <16 x half> undef, undef
  ret void
}

define void @fcmp_oeq_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_oeq_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp oeq bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp oeq <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp oeq <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp oeq <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp oeq <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp oeq bfloat undef, undef
  %v2bf16 = fcmp oeq <2 x bfloat> undef, undef
  %v4bf16 = fcmp oeq <4 x bfloat> undef, undef
  %v8bf16 = fcmp oeq <8 x bfloat> undef, undef
  %v16bf16 = fcmp oeq <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ogt(i32 %arg) {
; CHECK-LABEL: 'fcmp_ogt'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ogt float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ogt <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ogt <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ogt <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ogt double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ogt <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ogt <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ogt fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ogt <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ogt float undef, undef
  %v2f32 = fcmp ogt <2 x float> undef, undef
  %v4f32 = fcmp ogt <4 x float> undef, undef
  %v8f32 = fcmp ogt <8 x float> undef, undef
  %f64 = fcmp ogt double undef, undef
  %v2f64 = fcmp ogt <2 x double> undef, undef
  %v4f64 = fcmp ogt <4 x double> undef, undef
  %f128 = fcmp ogt fp128 undef, undef
  %v2f128 = fcmp ogt <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ogt_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ogt_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ogt half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ogt <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ogt <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ogt <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ogt <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ogt_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ogt half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ogt <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ogt <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ogt <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ogt <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ogt half undef, undef
  %v2f16 = fcmp ogt <2 x half> undef, undef
  %v4f16 = fcmp ogt <4 x half> undef, undef
  %v8f16 = fcmp ogt <8 x half> undef, undef
  %v16f16 = fcmp ogt <16 x half> undef, undef
  ret void
}

define void @fcmp_ogt_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ogt_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ogt bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ogt <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ogt <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ogt <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ogt <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ogt bfloat undef, undef
  %v2bf16 = fcmp ogt <2 x bfloat> undef, undef
  %v4bf16 = fcmp ogt <4 x bfloat> undef, undef
  %v8bf16 = fcmp ogt <8 x bfloat> undef, undef
  %v16bf16 = fcmp ogt <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_oge(i32 %arg) {
; CHECK-LABEL: 'fcmp_oge'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp oge float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp oge <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp oge <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp oge <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp oge double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp oge <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp oge <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp oge fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp oge <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp oge float undef, undef
  %v2f32 = fcmp oge <2 x float> undef, undef
  %v4f32 = fcmp oge <4 x float> undef, undef
  %v8f32 = fcmp oge <8 x float> undef, undef
  %f64 = fcmp oge double undef, undef
  %v2f64 = fcmp oge <2 x double> undef, undef
  %v4f64 = fcmp oge <4 x double> undef, undef
  %f128 = fcmp oge fp128 undef, undef
  %v2f128 = fcmp oge <2 x fp128> undef, undef
  ret void
}

define void @fcmp_oge_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_oge_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp oge half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp oge <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp oge <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp oge <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp oge <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_oge_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp oge half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp oge <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp oge <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp oge <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp oge <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp oge half undef, undef
  %v2f16 = fcmp oge <2 x half> undef, undef
  %v4f16 = fcmp oge <4 x half> undef, undef
  %v8f16 = fcmp oge <8 x half> undef, undef
  %v16f16 = fcmp oge <16 x half> undef, undef
  ret void
}

define void @fcmp_oge_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_oge_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp oge bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp oge <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp oge <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp oge <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp oge <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp oge bfloat undef, undef
  %v2bf16 = fcmp oge <2 x bfloat> undef, undef
  %v4bf16 = fcmp oge <4 x bfloat> undef, undef
  %v8bf16 = fcmp oge <8 x bfloat> undef, undef
  %v16bf16 = fcmp oge <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_olt(i32 %arg) {
; CHECK-LABEL: 'fcmp_olt'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp olt float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp olt <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp olt <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp olt <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp olt double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp olt <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp olt <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp olt fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp olt <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp olt float undef, undef
  %v2f32 = fcmp olt <2 x float> undef, undef
  %v4f32 = fcmp olt <4 x float> undef, undef
  %v8f32 = fcmp olt <8 x float> undef, undef
  %f64 = fcmp olt double undef, undef
  %v2f64 = fcmp olt <2 x double> undef, undef
  %v4f64 = fcmp olt <4 x double> undef, undef
  %f128 = fcmp olt fp128 undef, undef
  %v2f128 = fcmp olt <2 x fp128> undef, undef
  ret void
}

define void @fcmp_olt_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_olt_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp olt half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp olt <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp olt <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp olt <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp olt <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_olt_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp olt half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp olt <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp olt <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp olt <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp olt <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp olt half undef, undef
  %v2f16 = fcmp olt <2 x half> undef, undef
  %v4f16 = fcmp olt <4 x half> undef, undef
  %v8f16 = fcmp olt <8 x half> undef, undef
  %v16f16 = fcmp olt <16 x half> undef, undef
  ret void
}

define void @fcmp_olt_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_olt_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp olt bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp olt <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp olt <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp olt <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp olt <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp olt bfloat undef, undef
  %v2bf16 = fcmp olt <2 x bfloat> undef, undef
  %v4bf16 = fcmp olt <4 x bfloat> undef, undef
  %v8bf16 = fcmp olt <8 x bfloat> undef, undef
  %v16bf16 = fcmp olt <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ole(i32 %arg) {
; CHECK-LABEL: 'fcmp_ole'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ole float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ole <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ole <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ole <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ole double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ole <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ole <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ole fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ole <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ole float undef, undef
  %v2f32 = fcmp ole <2 x float> undef, undef
  %v4f32 = fcmp ole <4 x float> undef, undef
  %v8f32 = fcmp ole <8 x float> undef, undef
  %f64 = fcmp ole double undef, undef
  %v2f64 = fcmp ole <2 x double> undef, undef
  %v4f64 = fcmp ole <4 x double> undef, undef
  %f128 = fcmp ole fp128 undef, undef
  %v2f128 = fcmp ole <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ole_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ole_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ole half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ole <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ole <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ole <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ole <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ole_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ole half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ole <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ole <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ole <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ole <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ole half undef, undef
  %v2f16 = fcmp ole <2 x half> undef, undef
  %v4f16 = fcmp ole <4 x half> undef, undef
  %v8f16 = fcmp ole <8 x half> undef, undef
  %v16f16 = fcmp ole <16 x half> undef, undef
  ret void
}

define void @fcmp_ole_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ole_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ole bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ole <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ole <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ole <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ole <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ole bfloat undef, undef
  %v2bf16 = fcmp ole <2 x bfloat> undef, undef
  %v4bf16 = fcmp ole <4 x bfloat> undef, undef
  %v8bf16 = fcmp ole <8 x bfloat> undef, undef
  %v16bf16 = fcmp ole <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_one(i32 %arg) {
; CHECK-LABEL: 'fcmp_one'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp one float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp one <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp one <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp one <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp one double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp one <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp one <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp one fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp one <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp one float undef, undef
  %v2f32 = fcmp one <2 x float> undef, undef
  %v4f32 = fcmp one <4 x float> undef, undef
  %v8f32 = fcmp one <8 x float> undef, undef
  %f64 = fcmp one double undef, undef
  %v2f64 = fcmp one <2 x double> undef, undef
  %v4f64 = fcmp one <4 x double> undef, undef
  %f128 = fcmp one fp128 undef, undef
  %v2f128 = fcmp one <2 x fp128> undef, undef
  ret void
}

define void @fcmp_one_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_one_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp one half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp one <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp one <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp one <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp one <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_one_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp one half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp one <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp one <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp one <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp one <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp one half undef, undef
  %v2f16 = fcmp one <2 x half> undef, undef
  %v4f16 = fcmp one <4 x half> undef, undef
  %v8f16 = fcmp one <8 x half> undef, undef
  %v16f16 = fcmp one <16 x half> undef, undef
  ret void
}

define void @fcmp_one_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_one_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp one bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp one <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp one <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp one <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp one <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp one bfloat undef, undef
  %v2bf16 = fcmp one <2 x bfloat> undef, undef
  %v4bf16 = fcmp one <4 x bfloat> undef, undef
  %v8bf16 = fcmp one <8 x bfloat> undef, undef
  %v16bf16 = fcmp one <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ord(i32 %arg) {
; CHECK-LABEL: 'fcmp_ord'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ord float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ord <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ord <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ord <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ord double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ord <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ord <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ord fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ord <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ord float undef, undef
  %v2f32 = fcmp ord <2 x float> undef, undef
  %v4f32 = fcmp ord <4 x float> undef, undef
  %v8f32 = fcmp ord <8 x float> undef, undef
  %f64 = fcmp ord double undef, undef
  %v2f64 = fcmp ord <2 x double> undef, undef
  %v4f64 = fcmp ord <4 x double> undef, undef
  %f128 = fcmp ord fp128 undef, undef
  %v2f128 = fcmp ord <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ord_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ord_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ord half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ord <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ord <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ord <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ord <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ord_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ord half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ord <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ord <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ord <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ord <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ord half undef, undef
  %v2f16 = fcmp ord <2 x half> undef, undef
  %v4f16 = fcmp ord <4 x half> undef, undef
  %v8f16 = fcmp ord <8 x half> undef, undef
  %v16f16 = fcmp ord <16 x half> undef, undef
  ret void
}

define void @fcmp_ord_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ord_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ord bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ord <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ord <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ord <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ord <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ord bfloat undef, undef
  %v2bf16 = fcmp ord <2 x bfloat> undef, undef
  %v4bf16 = fcmp ord <4 x bfloat> undef, undef
  %v8bf16 = fcmp ord <8 x bfloat> undef, undef
  %v16bf16 = fcmp ord <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ueq(i32 %arg) {
; CHECK-LABEL: 'fcmp_ueq'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ueq float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ueq <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ueq <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ueq <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ueq double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ueq <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ueq <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ueq fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ueq <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ueq float undef, undef
  %v2f32 = fcmp ueq <2 x float> undef, undef
  %v4f32 = fcmp ueq <4 x float> undef, undef
  %v8f32 = fcmp ueq <8 x float> undef, undef
  %f64 = fcmp ueq double undef, undef
  %v2f64 = fcmp ueq <2 x double> undef, undef
  %v4f64 = fcmp ueq <4 x double> undef, undef
  %f128 = fcmp ueq fp128 undef, undef
  %v2f128 = fcmp ueq <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ueq_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ueq_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ueq half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ueq <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ueq <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ueq <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ueq <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ueq_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ueq half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ueq <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ueq <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ueq <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ueq <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ueq half undef, undef
  %v2f16 = fcmp ueq <2 x half> undef, undef
  %v4f16 = fcmp ueq <4 x half> undef, undef
  %v8f16 = fcmp ueq <8 x half> undef, undef
  %v16f16 = fcmp ueq <16 x half> undef, undef
  ret void
}

define void @fcmp_ueq_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ueq_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ueq bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ueq <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ueq <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ueq <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ueq <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ueq bfloat undef, undef
  %v2bf16 = fcmp ueq <2 x bfloat> undef, undef
  %v4bf16 = fcmp ueq <4 x bfloat> undef, undef
  %v8bf16 = fcmp ueq <8 x bfloat> undef, undef
  %v16bf16 = fcmp ueq <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ugt(i32 %arg) {
; CHECK-LABEL: 'fcmp_ugt'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ugt float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ugt <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ugt <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ugt <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ugt double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ugt <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ugt <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ugt fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ugt <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ugt float undef, undef
  %v2f32 = fcmp ugt <2 x float> undef, undef
  %v4f32 = fcmp ugt <4 x float> undef, undef
  %v8f32 = fcmp ugt <8 x float> undef, undef
  %f64 = fcmp ugt double undef, undef
  %v2f64 = fcmp ugt <2 x double> undef, undef
  %v4f64 = fcmp ugt <4 x double> undef, undef
  %f128 = fcmp ugt fp128 undef, undef
  %v2f128 = fcmp ugt <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ugt_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ugt_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ugt half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ugt <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ugt <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ugt <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ugt <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ugt_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ugt half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ugt <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ugt <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ugt <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ugt <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ugt half undef, undef
  %v2f16 = fcmp ugt <2 x half> undef, undef
  %v4f16 = fcmp ugt <4 x half> undef, undef
  %v8f16 = fcmp ugt <8 x half> undef, undef
  %v16f16 = fcmp ugt <16 x half> undef, undef
  ret void
}

define void @fcmp_ugt_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ugt_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ugt bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ugt <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ugt <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ugt <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ugt <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ugt bfloat undef, undef
  %v2bf16 = fcmp ugt <2 x bfloat> undef, undef
  %v4bf16 = fcmp ugt <4 x bfloat> undef, undef
  %v8bf16 = fcmp ugt <8 x bfloat> undef, undef
  %v16bf16 = fcmp ugt <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_uge(i32 %arg) {
; CHECK-LABEL: 'fcmp_uge'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp uge float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp uge <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp uge <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp uge <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp uge double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp uge <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp uge <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp uge fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp uge <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp uge float undef, undef
  %v2f32 = fcmp uge <2 x float> undef, undef
  %v4f32 = fcmp uge <4 x float> undef, undef
  %v8f32 = fcmp uge <8 x float> undef, undef
  %f64 = fcmp uge double undef, undef
  %v2f64 = fcmp uge <2 x double> undef, undef
  %v4f64 = fcmp uge <4 x double> undef, undef
  %f128 = fcmp uge fp128 undef, undef
  %v2f128 = fcmp uge <2 x fp128> undef, undef
  ret void
}

define void @fcmp_uge_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_uge_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp uge half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp uge <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp uge <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp uge <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp uge <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_uge_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp uge half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp uge <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp uge <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp uge <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp uge <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp uge half undef, undef
  %v2f16 = fcmp uge <2 x half> undef, undef
  %v4f16 = fcmp uge <4 x half> undef, undef
  %v8f16 = fcmp uge <8 x half> undef, undef
  %v16f16 = fcmp uge <16 x half> undef, undef
  ret void
}

define void @fcmp_uge_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_uge_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp uge bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp uge <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp uge <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp uge <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp uge <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp uge bfloat undef, undef
  %v2bf16 = fcmp uge <2 x bfloat> undef, undef
  %v4bf16 = fcmp uge <4 x bfloat> undef, undef
  %v8bf16 = fcmp uge <8 x bfloat> undef, undef
  %v16bf16 = fcmp uge <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ult(i32 %arg) {
; CHECK-LABEL: 'fcmp_ult'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ult float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ult <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ult <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ult <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ult double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ult <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ult <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ult fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ult <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ult float undef, undef
  %v2f32 = fcmp ult <2 x float> undef, undef
  %v4f32 = fcmp ult <4 x float> undef, undef
  %v8f32 = fcmp ult <8 x float> undef, undef
  %f64 = fcmp ult double undef, undef
  %v2f64 = fcmp ult <2 x double> undef, undef
  %v4f64 = fcmp ult <4 x double> undef, undef
  %f128 = fcmp ult fp128 undef, undef
  %v2f128 = fcmp ult <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ult_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ult_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ult half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ult <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ult <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ult <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ult <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ult_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ult half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ult <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ult <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ult <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ult <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ult half undef, undef
  %v2f16 = fcmp ult <2 x half> undef, undef
  %v4f16 = fcmp ult <4 x half> undef, undef
  %v8f16 = fcmp ult <8 x half> undef, undef
  %v16f16 = fcmp ult <16 x half> undef, undef
  ret void
}

define void @fcmp_ult_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ult_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ult bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ult <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ult <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ult <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ult <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ult bfloat undef, undef
  %v2bf16 = fcmp ult <2 x bfloat> undef, undef
  %v4bf16 = fcmp ult <4 x bfloat> undef, undef
  %v8bf16 = fcmp ult <8 x bfloat> undef, undef
  %v16bf16 = fcmp ult <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_ule(i32 %arg) {
; CHECK-LABEL: 'fcmp_ule'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp ule float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp ule <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp ule <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp ule <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp ule double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp ule <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp ule <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp ule fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp ule <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp ule float undef, undef
  %v2f32 = fcmp ule <2 x float> undef, undef
  %v4f32 = fcmp ule <4 x float> undef, undef
  %v8f32 = fcmp ule <8 x float> undef, undef
  %f64 = fcmp ule double undef, undef
  %v2f64 = fcmp ule <2 x double> undef, undef
  %v4f64 = fcmp ule <4 x double> undef, undef
  %f128 = fcmp ule fp128 undef, undef
  %v2f128 = fcmp ule <2 x fp128> undef, undef
  ret void
}

define void @fcmp_ule_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_ule_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ule half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp ule <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp ule <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp ule <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp ule <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_ule_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp ule half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp ule <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp ule <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp ule <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp ule <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp ule half undef, undef
  %v2f16 = fcmp ule <2 x half> undef, undef
  %v4f16 = fcmp ule <4 x half> undef, undef
  %v8f16 = fcmp ule <8 x half> undef, undef
  %v16f16 = fcmp ule <16 x half> undef, undef
  ret void
}

define void @fcmp_ule_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_ule_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp ule bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp ule <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp ule <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp ule <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp ule <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp ule bfloat undef, undef
  %v2bf16 = fcmp ule <2 x bfloat> undef, undef
  %v4bf16 = fcmp ule <4 x bfloat> undef, undef
  %v8bf16 = fcmp ule <8 x bfloat> undef, undef
  %v16bf16 = fcmp ule <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_une(i32 %arg) {
; CHECK-LABEL: 'fcmp_une'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp une float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp une <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp une <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp une <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp une double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp une <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp une <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp une fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp une <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp une float undef, undef
  %v2f32 = fcmp une <2 x float> undef, undef
  %v4f32 = fcmp une <4 x float> undef, undef
  %v8f32 = fcmp une <8 x float> undef, undef
  %f64 = fcmp une double undef, undef
  %v2f64 = fcmp une <2 x double> undef, undef
  %v4f64 = fcmp une <4 x double> undef, undef
  %f128 = fcmp une fp128 undef, undef
  %v2f128 = fcmp une <2 x fp128> undef, undef
  ret void
}

define void @fcmp_une_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_une_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp une half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp une <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp une <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp une <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp une <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_une_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp une half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp une <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp une <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp une <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp une <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp une half undef, undef
  %v2f16 = fcmp une <2 x half> undef, undef
  %v4f16 = fcmp une <4 x half> undef, undef
  %v8f16 = fcmp une <8 x half> undef, undef
  %v16f16 = fcmp une <16 x half> undef, undef
  ret void
}

define void @fcmp_une_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_une_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp une bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp une <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp une <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp une <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp une <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp une bfloat undef, undef
  %v2bf16 = fcmp une <2 x bfloat> undef, undef
  %v4bf16 = fcmp une <4 x bfloat> undef, undef
  %v8bf16 = fcmp une <8 x bfloat> undef, undef
  %v16bf16 = fcmp une <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_uno(i32 %arg) {
; CHECK-LABEL: 'fcmp_uno'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp uno float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp uno <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp uno <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp uno <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp uno double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp uno <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp uno <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp uno fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp uno <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp uno float undef, undef
  %v2f32 = fcmp uno <2 x float> undef, undef
  %v4f32 = fcmp uno <4 x float> undef, undef
  %v8f32 = fcmp uno <8 x float> undef, undef
  %f64 = fcmp uno double undef, undef
  %v2f64 = fcmp uno <2 x double> undef, undef
  %v4f64 = fcmp uno <4 x double> undef, undef
  %f128 = fcmp uno fp128 undef, undef
  %v2f128 = fcmp uno <2 x fp128> undef, undef
  ret void
}

define void @fcmp_uno_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_uno_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp uno half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp uno <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp uno <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp uno <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp uno <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_uno_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp uno half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp uno <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp uno <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp uno <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp uno <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp uno half undef, undef
  %v2f16 = fcmp uno <2 x half> undef, undef
  %v4f16 = fcmp uno <4 x half> undef, undef
  %v8f16 = fcmp uno <8 x half> undef, undef
  %v16f16 = fcmp uno <16 x half> undef, undef
  ret void
}

define void @fcmp_uno_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_uno_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp uno bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp uno <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp uno <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp uno <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp uno <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp uno bfloat undef, undef
  %v2bf16 = fcmp uno <2 x bfloat> undef, undef
  %v4bf16 = fcmp uno <4 x bfloat> undef, undef
  %v8bf16 = fcmp uno <8 x bfloat> undef, undef
  %v16bf16 = fcmp uno <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_true(i32 %arg) {
; CHECK-LABEL: 'fcmp_true'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp true float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp true <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp true <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp true <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp true double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp true <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp true <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp true fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp true <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp true float undef, undef
  %v2f32 = fcmp true <2 x float> undef, undef
  %v4f32 = fcmp true <4 x float> undef, undef
  %v8f32 = fcmp true <8 x float> undef, undef
  %f64 = fcmp true double undef, undef
  %v2f64 = fcmp true <2 x double> undef, undef
  %v4f64 = fcmp true <4 x double> undef, undef
  %f128 = fcmp true fp128 undef, undef
  %v2f128 = fcmp true <2 x fp128> undef, undef
  ret void
}

define void @fcmp_true_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_true_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp true half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp true <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp true <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp true <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp true <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_true_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp true half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp true <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp true <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp true <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp true <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp true half undef, undef
  %v2f16 = fcmp true <2 x half> undef, undef
  %v4f16 = fcmp true <4 x half> undef, undef
  %v8f16 = fcmp true <8 x half> undef, undef
  %v16f16 = fcmp true <16 x half> undef, undef
  ret void
}

define void @fcmp_true_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_true_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp true bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp true <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp true <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp true <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp true <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp true bfloat undef, undef
  %v2bf16 = fcmp true <2 x bfloat> undef, undef
  %v4bf16 = fcmp true <4 x bfloat> undef, undef
  %v8bf16 = fcmp true <8 x bfloat> undef, undef
  %v16bf16 = fcmp true <16 x bfloat> undef, undef
  ret void
}

define void @fcmp_false(i32 %arg) {
; CHECK-LABEL: 'fcmp_false'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f32 = fcmp false float undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f32 = fcmp false <2 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v4f32 = fcmp false <4 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v8f32 = fcmp false <8 x float> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f64 = fcmp false double undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %v2f64 = fcmp false <2 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v4f64 = fcmp false <4 x double> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %f128 = fcmp false fp128 undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v2f128 = fcmp false <2 x fp128> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f32 = fcmp false float undef, undef
  %v2f32 = fcmp false <2 x float> undef, undef
  %v4f32 = fcmp false <4 x float> undef, undef
  %v8f32 = fcmp false <8 x float> undef, undef
  %f64 = fcmp false double undef, undef
  %v2f64 = fcmp false <2 x double> undef, undef
  %v4f64 = fcmp false <4 x double> undef, undef
  %f128 = fcmp false fp128 undef, undef
  %v2f128 = fcmp false <2 x fp128> undef, undef
  ret void
}

define void @fcmp_false_half(i32 %arg) {
; CHECK-BASE-LABEL: 'fcmp_false_half'
; CHECK-BASE-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp false half undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 3 for: %v2f16 = fcmp false <2 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of 4 for: %v4f16 = fcmp false <4 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8f16 = fcmp false <8 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16f16 = fcmp false <16 x half> undef, undef
; CHECK-BASE-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
; CHECK-FP16-LABEL: 'fcmp_false_half'
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %f16 = fcmp false half undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v2f16 = fcmp false <2 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v4f16 = fcmp false <4 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of 1 for: %v8f16 = fcmp false <8 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:2 CodeSize:1 Lat:1 SizeLat:1 for: %v16f16 = fcmp false <16 x half> undef, undef
; CHECK-FP16-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %f16 = fcmp false half undef, undef
  %v2f16 = fcmp false <2 x half> undef, undef
  %v4f16 = fcmp false <4 x half> undef, undef
  %v8f16 = fcmp false <8 x half> undef, undef
  %v16f16 = fcmp false <16 x half> undef, undef
  ret void
}

define void @fcmp_false_bfloat(i32 %arg) {
; CHECK-LABEL: 'fcmp_false_bfloat'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bf16 = fcmp false bfloat undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 3 for: %v2bf16 = fcmp false <2 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %v4bf16 = fcmp false <4 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:7 CodeSize:4 Lat:4 SizeLat:4 for: %v8bf16 = fcmp false <8 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:14 CodeSize:4 Lat:4 SizeLat:4 for: %v16bf16 = fcmp false <16 x bfloat> undef, undef
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret void
;
  %bf16 = fcmp false bfloat undef, undef
  %v2bf16 = fcmp false <2 x bfloat> undef, undef
  %v4bf16 = fcmp false <4 x bfloat> undef, undef
  %v8bf16 = fcmp false <8 x bfloat> undef, undef
  %v16bf16 = fcmp false <16 x bfloat> undef, undef
  ret void
}

