/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleRule.h"

#include "CSSStyleDeclaration.h"
#include "CSSStyleRule.h"
#include "JSCSSStyleDeclaration.h"
#include "KURL.h"
#include "StylePropertySet.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSStyleRuleTableValues[] =
{
    { "selectorText", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleRuleSelectorText), (intptr_t)setJSCSSStyleRuleSelectorText, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleRuleStyle), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSStyleRuleConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSStyleRuleTable = { 8, 7, JSCSSStyleRuleTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSStyleRuleConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSStyleRuleConstructorTable = { 1, 0, JSCSSStyleRuleConstructorTableValues, 0 };
const ClassInfo JSCSSStyleRuleConstructor::s_info = { "CSSStyleRuleConstructor", &Base::s_info, &JSCSSStyleRuleConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSStyleRuleConstructor) };

JSCSSStyleRuleConstructor::JSCSSStyleRuleConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSStyleRuleConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSCSSStyleRulePrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSCSSStyleRuleConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleRuleConstructor, JSDOMWrapper>(exec, &JSCSSStyleRuleConstructorTable, jsCast<JSCSSStyleRuleConstructor*>(cell), propertyName, slot);
}

bool JSCSSStyleRuleConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSStyleRuleConstructor, JSDOMWrapper>(exec, &JSCSSStyleRuleConstructorTable, jsCast<JSCSSStyleRuleConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleRulePrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSStyleRulePrototypeTable = { 1, 0, JSCSSStyleRulePrototypeTableValues, 0 };
const ClassInfo JSCSSStyleRulePrototype::s_info = { "CSSStyleRulePrototype", &Base::s_info, &JSCSSStyleRulePrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSStyleRulePrototype) };

JSObject* JSCSSStyleRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSStyleRule>(exec, globalObject);
}

const ClassInfo JSCSSStyleRule::s_info = { "CSSStyleRule", &Base::s_info, &JSCSSStyleRuleTable, 0 , CREATE_METHOD_TABLE(JSCSSStyleRule) };

JSCSSStyleRule::JSCSSStyleRule(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSStyleRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

void JSCSSStyleRule::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSStyleRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSStyleRulePrototype::create(exec->vm(), globalObject, JSCSSStyleRulePrototype::createStructure(exec->vm(), globalObject, JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSStyleRule::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSStyleRule* thisObject = jsCast<JSCSSStyleRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSCSSStyleRule, Base>(exec, &JSCSSStyleRuleTable, thisObject, propertyName, slot);
}

bool JSCSSStyleRule::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSStyleRule* thisObject = jsCast<JSCSSStyleRule*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSCSSStyleRule, Base>(exec, &JSCSSStyleRuleTable, thisObject, propertyName, descriptor);
}

JSValue jsCSSStyleRuleSelectorText(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleRule* castedThis = jsCast<JSCSSStyleRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleRule* impl = static_cast<CSSStyleRule*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, impl->selectorText());
    return result;
}


JSValue jsCSSStyleRuleStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleRule* castedThis = jsCast<JSCSSStyleRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSStyleRule* impl = static_cast<CSSStyleRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsCSSStyleRuleConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSStyleRule* domObject = jsCast<JSCSSStyleRule*>(asObject(slotBase));
    return JSCSSStyleRule::getConstructor(exec, domObject->globalObject());
}

void JSCSSStyleRule::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSCSSStyleRule* thisObject = jsCast<JSCSSStyleRule*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSCSSStyleRule, Base>(exec, propertyName, value, &JSCSSStyleRuleTable, thisObject, slot);
}

void setJSCSSStyleRuleSelectorText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSCSSStyleRule* castedThis = jsCast<JSCSSStyleRule*>(thisObject);
    CSSStyleRule* impl = static_cast<CSSStyleRule*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setSelectorText(nativeValue);
}


JSValue JSCSSStyleRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleRuleConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}
