/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSValueList.h"

#include "CSSValue.h"
#include "CSSValueList.h"
#include "ExceptionCode.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSCSSValueListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueListLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSValueListConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSValueListTable = { 5, 3, JSCSSValueListTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSCSSValueListConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSValueListConstructorTable = { 1, 0, JSCSSValueListConstructorTableValues, 0 };
const ClassInfo JSCSSValueListConstructor::s_info = { "CSSValueListConstructor", &Base::s_info, &JSCSSValueListConstructorTable, 0, CREATE_METHOD_TABLE(JSCSSValueListConstructor) };

JSCSSValueListConstructor::JSCSSValueListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSCSSValueListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSCSSValueListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSCSSValueListConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSValueListConstructor, JSDOMWrapper>(exec, &JSCSSValueListConstructorTable, jsCast<JSCSSValueListConstructor*>(cell), propertyName, slot);
}

bool JSCSSValueListConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSValueListConstructor, JSDOMWrapper>(exec, &JSCSSValueListConstructorTable, jsCast<JSCSSValueListConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSValueListPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsCSSValueListPrototypeFunctionItem), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSCSSValueListPrototypeTable = { 2, 1, JSCSSValueListPrototypeTableValues, 0 };
const ClassInfo JSCSSValueListPrototype::s_info = { "CSSValueListPrototype", &Base::s_info, &JSCSSValueListPrototypeTable, 0, CREATE_METHOD_TABLE(JSCSSValueListPrototype) };

JSObject* JSCSSValueListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSValueList>(exec, globalObject);
}

bool JSCSSValueListPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSValueListPrototype* thisObject = jsCast<JSCSSValueListPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSValueListPrototypeTable, thisObject, propertyName, slot);
}

bool JSCSSValueListPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSValueListPrototype* thisObject = jsCast<JSCSSValueListPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSCSSValueListPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSCSSValueList::s_info = { "CSSValueList", &Base::s_info, &JSCSSValueListTable, 0 , CREATE_METHOD_TABLE(JSCSSValueList) };

JSCSSValueList::JSCSSValueList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSValueList> impl)
    : JSCSSValue(structure, globalObject, impl)
{
}

void JSCSSValueList::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSCSSValueList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSCSSValueListPrototype::create(exec->vm(), globalObject, JSCSSValueListPrototype::createStructure(exec->vm(), globalObject, JSCSSValuePrototype::self(exec, globalObject)));
}

bool JSCSSValueList::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSCSSValueList* thisObject = jsCast<JSCSSValueList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSCSSValueList>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<CSSValueList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSValueList, Base>(exec, &JSCSSValueListTable, thisObject, propertyName, slot);
}

bool JSCSSValueList::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSCSSValueList* thisObject = jsCast<JSCSSValueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSCSSValueListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<CSSValueList*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSCSSValueList, Base>(exec, &JSCSSValueListTable, thisObject, propertyName, descriptor);
}

bool JSCSSValueList::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSCSSValueList* thisObject = jsCast<JSCSSValueList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<CSSValueList*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsCSSValueListLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSValueList* castedThis = jsCast<JSCSSValueList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSValueList* impl = static_cast<CSSValueList*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsCSSValueListConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSCSSValueList* domObject = jsCast<JSCSSValueList*>(asObject(slotBase));
    return JSCSSValueList::getConstructor(exec, domObject->globalObject());
}

void JSCSSValueList::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSCSSValueList* thisObject = jsCast<JSCSSValueList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<CSSValueList*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSCSSValueList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSValueListConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsCSSValueListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSCSSValueList::s_info))
        return throwVMTypeError(exec);
    JSCSSValueList* castedThis = jsCast<JSCSSValueList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSCSSValueList::s_info);
    CSSValueList* impl = static_cast<CSSValueList*>(castedThis->impl());
    unsigned index(toUInt32(exec, exec->argument(0), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}


JSValue JSCSSValueList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSCSSValueList* thisObj = jsCast<JSCSSValueList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<CSSValueList*>(thisObj->impl())->item(index));
}


}
