/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeoposition.h"

#include "Coordinates.h"
#include "Geoposition.h"
#include "JSCoordinates.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSGeopositionTableValues[] =
{
    { "coords", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeopositionCoords), (intptr_t)0, NoIntrinsic },
    { "timestamp", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeopositionTimestamp), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGeopositionTable = { 4, 3, JSGeopositionTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSGeopositionPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSGeopositionPrototypeTable = { 1, 0, JSGeopositionPrototypeTableValues, 0 };
const ClassInfo JSGeopositionPrototype::s_info = { "GeopositionPrototype", &Base::s_info, &JSGeopositionPrototypeTable, 0, CREATE_METHOD_TABLE(JSGeopositionPrototype) };

JSObject* JSGeopositionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSGeoposition>(exec, globalObject);
}

const ClassInfo JSGeoposition::s_info = { "Geoposition", &Base::s_info, &JSGeopositionTable, 0 , CREATE_METHOD_TABLE(JSGeoposition) };

JSGeoposition::JSGeoposition(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Geoposition> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSGeoposition::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSGeoposition::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSGeopositionPrototype::create(exec->vm(), globalObject, JSGeopositionPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSGeoposition::destroy(JSC::JSCell* cell)
{
    JSGeoposition* thisObject = static_cast<JSGeoposition*>(cell);
    thisObject->JSGeoposition::~JSGeoposition();
}

JSGeoposition::~JSGeoposition()
{
    releaseImplIfNotNull();
}

bool JSGeoposition::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSGeoposition* thisObject = jsCast<JSGeoposition*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSGeoposition, Base>(exec, &JSGeopositionTable, thisObject, propertyName, slot);
}

bool JSGeoposition::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSGeoposition* thisObject = jsCast<JSGeoposition*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSGeoposition, Base>(exec, &JSGeopositionTable, thisObject, propertyName, descriptor);
}

JSValue jsGeopositionCoords(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGeoposition* castedThis = jsCast<JSGeoposition*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Geoposition* impl = static_cast<Geoposition*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->coords()));
    return result;
}


JSValue jsGeopositionTimestamp(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSGeoposition* castedThis = jsCast<JSGeoposition*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Geoposition* impl = static_cast<Geoposition*>(castedThis->impl());
    JSValue result = jsNumber(impl->timestamp());
    return result;
}


static inline bool isObservable(JSGeoposition* jsGeoposition)
{
    if (jsGeoposition->hasCustomProperties())
        return true;
    return false;
}

bool JSGeopositionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSGeoposition* jsGeoposition = jsCast<JSGeoposition*>(handle.get().asCell());
    if (!isObservable(jsGeoposition))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSGeopositionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSGeoposition* jsGeoposition = jsCast<JSGeoposition*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGeoposition->impl(), jsGeoposition);
    jsGeoposition->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Geoposition* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSGeoposition>(exec, impl))
        return result;
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Geoposition.
    COMPILE_ASSERT(!__is_polymorphic(Geoposition), Geoposition_is_polymorphic_but_idl_claims_not_to_be);
#endif
    ReportMemoryCost<Geoposition>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSGeoposition>(exec, globalObject, impl);
}

Geoposition* toGeoposition(JSC::JSValue value)
{
    return value.inherits(&JSGeoposition::s_info) ? jsCast<JSGeoposition*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(GEOLOCATION)
