/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMarqueeElement.h"

#include "ExceptionCode.h"
#include "HTMLMarqueeElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLMarqueeElementTableValues[] =
{
    { "behavior", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementBehavior), (intptr_t)setJSHTMLMarqueeElementBehavior, NoIntrinsic },
    { "bgColor", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementBgColor), (intptr_t)setJSHTMLMarqueeElementBgColor, NoIntrinsic },
    { "direction", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementDirection), (intptr_t)setJSHTMLMarqueeElementDirection, NoIntrinsic },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementHeight), (intptr_t)setJSHTMLMarqueeElementHeight, NoIntrinsic },
    { "hspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementHspace), (intptr_t)setJSHTMLMarqueeElementHspace, NoIntrinsic },
    { "loop", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementLoop), (intptr_t)setJSHTMLMarqueeElementLoop, NoIntrinsic },
    { "scrollAmount", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementScrollAmount), (intptr_t)setJSHTMLMarqueeElementScrollAmount, NoIntrinsic },
    { "scrollDelay", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementScrollDelay), (intptr_t)setJSHTMLMarqueeElementScrollDelay, NoIntrinsic },
    { "trueSpeed", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementTrueSpeed), (intptr_t)setJSHTMLMarqueeElementTrueSpeed, NoIntrinsic },
    { "vspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementVspace), (intptr_t)setJSHTMLMarqueeElementVspace, NoIntrinsic },
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementWidth), (intptr_t)setJSHTMLMarqueeElementWidth, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMarqueeElementTable = { 36, 31, JSHTMLMarqueeElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLMarqueeElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMarqueeElementConstructorTable = { 1, 0, JSHTMLMarqueeElementConstructorTableValues, 0 };
const ClassInfo JSHTMLMarqueeElementConstructor::s_info = { "HTMLMarqueeElementConstructor", &Base::s_info, &JSHTMLMarqueeElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLMarqueeElementConstructor) };

JSHTMLMarqueeElementConstructor::JSHTMLMarqueeElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLMarqueeElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLMarqueeElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLMarqueeElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMarqueeElementConstructor, JSDOMWrapper>(exec, &JSHTMLMarqueeElementConstructorTable, jsCast<JSHTMLMarqueeElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLMarqueeElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMarqueeElementConstructor, JSDOMWrapper>(exec, &JSHTMLMarqueeElementConstructorTable, jsCast<JSHTMLMarqueeElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMarqueeElementPrototypeTableValues[] =
{
    { "start", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLMarqueeElementPrototypeFunctionStart), (intptr_t)0, NoIntrinsic },
    { "stop", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLMarqueeElementPrototypeFunctionStop), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMarqueeElementPrototypeTable = { 5, 3, JSHTMLMarqueeElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLMarqueeElementPrototype::s_info = { "HTMLMarqueeElementPrototype", &Base::s_info, &JSHTMLMarqueeElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLMarqueeElementPrototype) };

JSObject* JSHTMLMarqueeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMarqueeElement>(exec, globalObject);
}

bool JSHTMLMarqueeElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLMarqueeElementPrototype* thisObject = jsCast<JSHTMLMarqueeElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLMarqueeElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLMarqueeElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLMarqueeElementPrototype* thisObject = jsCast<JSHTMLMarqueeElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLMarqueeElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLMarqueeElement::s_info = { "HTMLMarqueeElement", &Base::s_info, &JSHTMLMarqueeElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLMarqueeElement) };

JSHTMLMarqueeElement::JSHTMLMarqueeElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLMarqueeElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLMarqueeElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLMarqueeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLMarqueeElementPrototype::create(exec->vm(), globalObject, JSHTMLMarqueeElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLMarqueeElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLMarqueeElement* thisObject = jsCast<JSHTMLMarqueeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLMarqueeElement, Base>(exec, &JSHTMLMarqueeElementTable, thisObject, propertyName, slot);
}

bool JSHTMLMarqueeElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLMarqueeElement* thisObject = jsCast<JSHTMLMarqueeElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLMarqueeElement, Base>(exec, &JSHTMLMarqueeElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLMarqueeElementBehavior(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::behaviorAttr));
    return result;
}


JSValue jsHTMLMarqueeElementBgColor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::bgcolorAttr));
    return result;
}


JSValue jsHTMLMarqueeElementDirection(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::directionAttr));
    return result;
}


JSValue jsHTMLMarqueeElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::heightAttr));
    return result;
}


JSValue jsHTMLMarqueeElementHspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsNumber(std::max(0, impl->getIntegralAttribute(WebCore::HTMLNames::hspaceAttr)));
    return result;
}


JSValue jsHTMLMarqueeElementLoop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->loop());
    return result;
}


JSValue jsHTMLMarqueeElementScrollAmount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->scrollAmount());
    return result;
}


JSValue jsHTMLMarqueeElementScrollDelay(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->scrollDelay());
    return result;
}


JSValue jsHTMLMarqueeElementTrueSpeed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::truespeedAttr));
    return result;
}


JSValue jsHTMLMarqueeElementVspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsNumber(std::max(0, impl->getIntegralAttribute(WebCore::HTMLNames::vspaceAttr)));
    return result;
}


JSValue jsHTMLMarqueeElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}


JSValue jsHTMLMarqueeElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMarqueeElement* domObject = jsCast<JSHTMLMarqueeElement*>(asObject(slotBase));
    return JSHTMLMarqueeElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLMarqueeElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLMarqueeElement* thisObject = jsCast<JSHTMLMarqueeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLMarqueeElement, Base>(exec, propertyName, value, &JSHTMLMarqueeElementTable, thisObject, slot);
}

void setJSHTMLMarqueeElementBehavior(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::behaviorAttr, nativeValue);
}


void setJSHTMLMarqueeElementBgColor(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::bgcolorAttr, nativeValue);
}


void setJSHTMLMarqueeElementDirection(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::directionAttr, nativeValue);
}


void setJSHTMLMarqueeElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::heightAttr, nativeValue);
}


void setJSHTMLMarqueeElementHspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    unsigned nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, nativeValue);
}


void setJSHTMLMarqueeElementLoop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setLoop(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSHTMLMarqueeElementScrollAmount(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setScrollAmount(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSHTMLMarqueeElementScrollDelay(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    int nativeValue(toInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setScrollDelay(nativeValue, ec);
    setDOMException(exec, ec);
}


void setJSHTMLMarqueeElementTrueSpeed(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::truespeedAttr, nativeValue);
}


void setJSHTMLMarqueeElementVspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    unsigned nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    impl->setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, nativeValue);
}


void setJSHTMLMarqueeElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(thisObject);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::widthAttr, nativeValue);
}


JSValue JSHTMLMarqueeElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMarqueeElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStart(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLMarqueeElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLMarqueeElement::s_info);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    impl->start();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStop(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLMarqueeElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLMarqueeElement* castedThis = jsCast<JSHTMLMarqueeElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLMarqueeElement::s_info);
    HTMLMarqueeElement* impl = static_cast<HTMLMarqueeElement*>(castedThis->impl());
    impl->stop();
    return JSValue::encode(jsUndefined());
}


}
