/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSHTMLTrackElement.h"

#include "HTMLNames.h"
#include "HTMLTrackElement.h"
#include "JSTextTrack.h"
#include "KURL.h"
#include "TextTrack.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLTrackElementTableValues[] =
{
    { "kind", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementKind), (intptr_t)setJSHTMLTrackElementKind, NoIntrinsic },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementSrc), (intptr_t)setJSHTMLTrackElementSrc, NoIntrinsic },
    { "srclang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementSrclang), (intptr_t)setJSHTMLTrackElementSrclang, NoIntrinsic },
    { "label", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementLabel), (intptr_t)setJSHTMLTrackElementLabel, NoIntrinsic },
    { "default", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementDefault), (intptr_t)setJSHTMLTrackElementDefault, NoIntrinsic },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementReadyState), (intptr_t)0, NoIntrinsic },
    { "track", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementTrack), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTrackElementTable = { 17, 15, JSHTMLTrackElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLTrackElementConstructorTableValues[] =
{
    { "NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementNONE), (intptr_t)0, NoIntrinsic },
    { "LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementLOADING), (intptr_t)0, NoIntrinsic },
    { "LOADED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementLOADED), (intptr_t)0, NoIntrinsic },
    { "ERROR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementERROR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTrackElementConstructorTable = { 9, 7, JSHTMLTrackElementConstructorTableValues, 0 };

COMPILE_ASSERT(0 == HTMLTrackElement::NONE, HTMLTrackElementEnumNONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == HTMLTrackElement::LOADING, HTMLTrackElementEnumLOADINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == HTMLTrackElement::LOADED, HTMLTrackElementEnumLOADEDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == HTMLTrackElement::TRACK_ERROR, HTMLTrackElementEnumTRACK_ERRORIsWrongUseDoNotCheckConstants);

const ClassInfo JSHTMLTrackElementConstructor::s_info = { "HTMLTrackElementConstructor", &Base::s_info, &JSHTMLTrackElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLTrackElementConstructor) };

JSHTMLTrackElementConstructor::JSHTMLTrackElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTrackElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSHTMLTrackElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSHTMLTrackElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTrackElementConstructor, JSDOMWrapper>(exec, &JSHTMLTrackElementConstructorTable, jsCast<JSHTMLTrackElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLTrackElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTrackElementConstructor, JSDOMWrapper>(exec, &JSHTMLTrackElementConstructorTable, jsCast<JSHTMLTrackElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLTrackElementPrototypeTableValues[] =
{
    { "NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementNONE), (intptr_t)0, NoIntrinsic },
    { "LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementLOADING), (intptr_t)0, NoIntrinsic },
    { "LOADED", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementLOADED), (intptr_t)0, NoIntrinsic },
    { "ERROR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementERROR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLTrackElementPrototypeTable = { 9, 7, JSHTMLTrackElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTrackElementPrototype::s_info = { "HTMLTrackElementPrototype", &Base::s_info, &JSHTMLTrackElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLTrackElementPrototype) };

JSObject* JSHTMLTrackElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTrackElement>(exec, globalObject);
}

bool JSHTMLTrackElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTrackElementPrototype* thisObject = jsCast<JSHTMLTrackElementPrototype*>(cell);
    return getStaticValueSlot<JSHTMLTrackElementPrototype, JSObject>(exec, &JSHTMLTrackElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLTrackElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTrackElementPrototype* thisObject = jsCast<JSHTMLTrackElementPrototype*>(object);
    return getStaticValueDescriptor<JSHTMLTrackElementPrototype, JSObject>(exec, &JSHTMLTrackElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLTrackElement::s_info = { "HTMLTrackElement", &Base::s_info, &JSHTMLTrackElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLTrackElement) };

JSHTMLTrackElement::JSHTMLTrackElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTrackElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTrackElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTrackElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTrackElementPrototype::create(exec->vm(), globalObject, JSHTMLTrackElementPrototype::createStructure(exec->vm(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTrackElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLTrackElement* thisObject = jsCast<JSHTMLTrackElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLTrackElement, Base>(exec, &JSHTMLTrackElementTable, thisObject, propertyName, slot);
}

bool JSHTMLTrackElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLTrackElement* thisObject = jsCast<JSHTMLTrackElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLTrackElement, Base>(exec, &JSHTMLTrackElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLTrackElementKind(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->kind());
    return result;
}


JSValue jsHTMLTrackElementSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLTrackElementSrclang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->srclang());
    return result;
}


JSValue jsHTMLTrackElementLabel(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->label());
    return result;
}


JSValue jsHTMLTrackElementDefault(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::defaultAttr));
    return result;
}


JSValue jsHTMLTrackElementReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->readyState());
    return result;
}


JSValue jsHTMLTrackElementTrack(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->track()));
    return result;
}


JSValue jsHTMLTrackElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLTrackElement* domObject = jsCast<JSHTMLTrackElement*>(asObject(slotBase));
    return JSHTMLTrackElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTrackElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLTrackElement* thisObject = jsCast<JSHTMLTrackElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLTrackElement, Base>(exec, propertyName, value, &JSHTMLTrackElementTable, thisObject, slot);
}

void setJSHTMLTrackElementKind(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setKind(nativeValue);
}


void setJSHTMLTrackElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    const String& nativeValue(valueToStringWithNullCheck(exec, value));
    if (exec->hadException())
        return;
    impl->setAttribute(WebCore::HTMLNames::srcAttr, nativeValue);
}


void setJSHTMLTrackElementSrclang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setSrclang(nativeValue);
}


void setJSHTMLTrackElementLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    const String& nativeValue(value.isEmpty() ? String() : value.toString(exec)->value(exec));
    if (exec->hadException())
        return;
    impl->setLabel(nativeValue);
}


void setJSHTMLTrackElementDefault(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLTrackElement* castedThis = jsCast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* impl = static_cast<HTMLTrackElement*>(castedThis->impl());
    bool nativeValue(value.toBoolean(exec));
    if (exec->hadException())
        return;
    impl->setBooleanAttribute(WebCore::HTMLNames::defaultAttr, nativeValue);
}


JSValue JSHTMLTrackElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTrackElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsHTMLTrackElementNONE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsHTMLTrackElementLOADING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsHTMLTrackElementLOADED(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsHTMLTrackElementERROR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}


}

#endif // ENABLE(VIDEO_TRACK)
