/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyboardEvent.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSDOMWindow.h"
#include "JSDictionary.h"
#include "KURL.h"
#include "KeyboardEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSKeyboardEventTableValues[] =
{
    { "keyIdentifier", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyIdentifier), (intptr_t)0, NoIntrinsic },
    { "location", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventLocation), (intptr_t)0, NoIntrinsic },
    { "keyLocation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyLocation), (intptr_t)0, NoIntrinsic },
    { "ctrlKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventCtrlKey), (intptr_t)0, NoIntrinsic },
    { "shiftKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventShiftKey), (intptr_t)0, NoIntrinsic },
    { "altKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltKey), (intptr_t)0, NoIntrinsic },
    { "metaKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventMetaKey), (intptr_t)0, NoIntrinsic },
    { "altGraphKey", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltGraphKey), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSKeyboardEventTable = { 33, 31, JSKeyboardEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSKeyboardEventConstructorTableValues[] =
{
    { "DOM_KEY_LOCATION_STANDARD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_STANDARD), (intptr_t)0, NoIntrinsic },
    { "DOM_KEY_LOCATION_LEFT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_LEFT), (intptr_t)0, NoIntrinsic },
    { "DOM_KEY_LOCATION_RIGHT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_RIGHT), (intptr_t)0, NoIntrinsic },
    { "DOM_KEY_LOCATION_NUMPAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_NUMPAD), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSKeyboardEventConstructorTable = { 8, 7, JSKeyboardEventConstructorTableValues, 0 };

COMPILE_ASSERT(0x00 == KeyboardEvent::DOM_KEY_LOCATION_STANDARD, KeyboardEventEnumDOM_KEY_LOCATION_STANDARDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x01 == KeyboardEvent::DOM_KEY_LOCATION_LEFT, KeyboardEventEnumDOM_KEY_LOCATION_LEFTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x02 == KeyboardEvent::DOM_KEY_LOCATION_RIGHT, KeyboardEventEnumDOM_KEY_LOCATION_RIGHTIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0x03 == KeyboardEvent::DOM_KEY_LOCATION_NUMPAD, KeyboardEventEnumDOM_KEY_LOCATION_NUMPADIsWrongUseDoNotCheckConstants);

EncodedJSValue JSC_HOST_CALL JSKeyboardEventConstructor::constructJSKeyboardEvent(ExecState* exec)
{
    JSKeyboardEventConstructor* jsConstructor = jsCast<JSKeyboardEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    KeyboardEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillKeyboardEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<KeyboardEvent> event = KeyboardEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillKeyboardEventInit(KeyboardEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillUIEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("keyIdentifier", eventInit.keyIdentifier))
        return false;
    if (!dictionary.tryGetProperty("location", eventInit.location))
        return false;
    if (!dictionary.tryGetProperty("keyLocation", eventInit.location))
        return false;
    if (!dictionary.tryGetProperty("ctrlKey", eventInit.ctrlKey))
        return false;
    if (!dictionary.tryGetProperty("shiftKey", eventInit.shiftKey))
        return false;
    if (!dictionary.tryGetProperty("altKey", eventInit.altKey))
        return false;
    if (!dictionary.tryGetProperty("metaKey", eventInit.metaKey))
        return false;
    return true;
}

const ClassInfo JSKeyboardEventConstructor::s_info = { "KeyboardEventConstructor", &Base::s_info, &JSKeyboardEventConstructorTable, 0, CREATE_METHOD_TABLE(JSKeyboardEventConstructor) };

JSKeyboardEventConstructor::JSKeyboardEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSKeyboardEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSKeyboardEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSKeyboardEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSKeyboardEventConstructor, JSDOMWrapper>(exec, &JSKeyboardEventConstructorTable, jsCast<JSKeyboardEventConstructor*>(cell), propertyName, slot);
}

bool JSKeyboardEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSKeyboardEventConstructor, JSDOMWrapper>(exec, &JSKeyboardEventConstructorTable, jsCast<JSKeyboardEventConstructor*>(object), propertyName, descriptor);
}

#if ENABLE(DOM4_EVENTS_CONSTRUCTOR)
ConstructType JSKeyboardEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSKeyboardEvent;
    return ConstructTypeHost;
}
#endif // ENABLE(DOM4_EVENTS_CONSTRUCTOR)

/* Hash table for prototype */

static const HashTableValue JSKeyboardEventPrototypeTableValues[] =
{
    { "DOM_KEY_LOCATION_STANDARD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_STANDARD), (intptr_t)0, NoIntrinsic },
    { "DOM_KEY_LOCATION_LEFT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_LEFT), (intptr_t)0, NoIntrinsic },
    { "DOM_KEY_LOCATION_RIGHT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_RIGHT), (intptr_t)0, NoIntrinsic },
    { "DOM_KEY_LOCATION_NUMPAD", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventDOM_KEY_LOCATION_NUMPAD), (intptr_t)0, NoIntrinsic },
    { "initKeyboardEvent", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsKeyboardEventPrototypeFunctionInitKeyboardEvent), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSKeyboardEventPrototypeTable = { 16, 15, JSKeyboardEventPrototypeTableValues, 0 };
const ClassInfo JSKeyboardEventPrototype::s_info = { "KeyboardEventPrototype", &Base::s_info, &JSKeyboardEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSKeyboardEventPrototype) };

JSObject* JSKeyboardEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSKeyboardEvent>(exec, globalObject);
}

bool JSKeyboardEventPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSKeyboardEventPrototype* thisObject = jsCast<JSKeyboardEventPrototype*>(cell);
    return getStaticPropertySlot<JSKeyboardEventPrototype, JSObject>(exec, &JSKeyboardEventPrototypeTable, thisObject, propertyName, slot);
}

bool JSKeyboardEventPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSKeyboardEventPrototype* thisObject = jsCast<JSKeyboardEventPrototype*>(object);
    return getStaticPropertyDescriptor<JSKeyboardEventPrototype, JSObject>(exec, &JSKeyboardEventPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSKeyboardEvent::s_info = { "KeyboardEvent", &Base::s_info, &JSKeyboardEventTable, 0 , CREATE_METHOD_TABLE(JSKeyboardEvent) };

JSKeyboardEvent::JSKeyboardEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<KeyboardEvent> impl)
    : JSUIEvent(structure, globalObject, impl)
{
}

void JSKeyboardEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSKeyboardEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSKeyboardEventPrototype::create(exec->vm(), globalObject, JSKeyboardEventPrototype::createStructure(exec->vm(), globalObject, JSUIEventPrototype::self(exec, globalObject)));
}

bool JSKeyboardEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSKeyboardEvent* thisObject = jsCast<JSKeyboardEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSKeyboardEvent, Base>(exec, &JSKeyboardEventTable, thisObject, propertyName, slot);
}

bool JSKeyboardEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSKeyboardEvent* thisObject = jsCast<JSKeyboardEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSKeyboardEvent, Base>(exec, &JSKeyboardEventTable, thisObject, propertyName, descriptor);
}

JSValue jsKeyboardEventKeyIdentifier(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->keyIdentifier());
    return result;
}


JSValue jsKeyboardEventLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->location());
    return result;
}


JSValue jsKeyboardEventKeyLocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsNumber(impl->location());
    return result;
}


JSValue jsKeyboardEventCtrlKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ctrlKey());
    return result;
}


JSValue jsKeyboardEventShiftKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->shiftKey());
    return result;
}


JSValue jsKeyboardEventAltKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altKey());
    return result;
}


JSValue jsKeyboardEventMetaKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->metaKey());
    return result;
}


JSValue jsKeyboardEventAltGraphKey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    JSValue result = jsBoolean(impl->altGraphKey());
    return result;
}


JSValue jsKeyboardEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSKeyboardEvent* domObject = jsCast<JSKeyboardEvent*>(asObject(slotBase));
    return JSKeyboardEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSKeyboardEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyboardEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSKeyboardEvent::s_info))
        return throwVMTypeError(exec);
    JSKeyboardEvent* castedThis = jsCast<JSKeyboardEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSKeyboardEvent::s_info);
    KeyboardEvent* impl = static_cast<KeyboardEvent*>(castedThis->impl());
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    DOMWindow* view(toDOMWindow(exec->argument(3)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& keyIdentifier(exec->argument(4).isEmpty() ? String() : exec->argument(4).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    unsigned location(toUInt32(exec, exec->argument(5), NormalConversion));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool ctrlKey(exec->argument(6).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altKey(exec->argument(7).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool shiftKey(exec->argument(8).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool metaKey(exec->argument(9).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool altGraphKey(exec->argument(10).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->initKeyboardEvent(type, canBubble, cancelable, view, keyIdentifier, location, ctrlKey, altKey, shiftKey, metaKey, altGraphKey);
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsKeyboardEventDOM_KEY_LOCATION_STANDARD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x00));
}

JSValue jsKeyboardEventDOM_KEY_LOCATION_LEFT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x01));
}

JSValue jsKeyboardEventDOM_KEY_LOCATION_RIGHT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x02));
}

JSValue jsKeyboardEventDOM_KEY_LOCATION_NUMPAD(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0x03));
}


}
