/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_TIMING)

#include "JSPerformanceTiming.h"

#include "PerformanceTiming.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSPerformanceTimingTableValues[] =
{
    { "navigationStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingNavigationStart), (intptr_t)0, NoIntrinsic },
    { "unloadEventStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingUnloadEventStart), (intptr_t)0, NoIntrinsic },
    { "unloadEventEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingUnloadEventEnd), (intptr_t)0, NoIntrinsic },
    { "redirectStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRedirectStart), (intptr_t)0, NoIntrinsic },
    { "redirectEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRedirectEnd), (intptr_t)0, NoIntrinsic },
    { "fetchStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingFetchStart), (intptr_t)0, NoIntrinsic },
    { "domainLookupStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomainLookupStart), (intptr_t)0, NoIntrinsic },
    { "domainLookupEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomainLookupEnd), (intptr_t)0, NoIntrinsic },
    { "connectStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConnectStart), (intptr_t)0, NoIntrinsic },
    { "connectEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConnectEnd), (intptr_t)0, NoIntrinsic },
    { "secureConnectionStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingSecureConnectionStart), (intptr_t)0, NoIntrinsic },
    { "requestStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingRequestStart), (intptr_t)0, NoIntrinsic },
    { "responseStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingResponseStart), (intptr_t)0, NoIntrinsic },
    { "responseEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingResponseEnd), (intptr_t)0, NoIntrinsic },
    { "domLoading", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomLoading), (intptr_t)0, NoIntrinsic },
    { "domInteractive", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomInteractive), (intptr_t)0, NoIntrinsic },
    { "domContentLoadedEventStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomContentLoadedEventStart), (intptr_t)0, NoIntrinsic },
    { "domContentLoadedEventEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomContentLoadedEventEnd), (intptr_t)0, NoIntrinsic },
    { "domComplete", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingDomComplete), (intptr_t)0, NoIntrinsic },
    { "loadEventStart", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingLoadEventStart), (intptr_t)0, NoIntrinsic },
    { "loadEventEnd", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingLoadEventEnd), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsPerformanceTimingConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceTimingTable = { 67, 63, JSPerformanceTimingTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSPerformanceTimingConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceTimingConstructorTable = { 1, 0, JSPerformanceTimingConstructorTableValues, 0 };
const ClassInfo JSPerformanceTimingConstructor::s_info = { "PerformanceTimingConstructor", &Base::s_info, &JSPerformanceTimingConstructorTable, 0, CREATE_METHOD_TABLE(JSPerformanceTimingConstructor) };

JSPerformanceTimingConstructor::JSPerformanceTimingConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSPerformanceTimingConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSPerformanceTimingPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSPerformanceTimingConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSPerformanceTimingConstructor, JSDOMWrapper>(exec, &JSPerformanceTimingConstructorTable, jsCast<JSPerformanceTimingConstructor*>(cell), propertyName, slot);
}

bool JSPerformanceTimingConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSPerformanceTimingConstructor, JSDOMWrapper>(exec, &JSPerformanceTimingConstructorTable, jsCast<JSPerformanceTimingConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSPerformanceTimingPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSPerformanceTimingPrototypeTable = { 1, 0, JSPerformanceTimingPrototypeTableValues, 0 };
const ClassInfo JSPerformanceTimingPrototype::s_info = { "PerformanceTimingPrototype", &Base::s_info, &JSPerformanceTimingPrototypeTable, 0, CREATE_METHOD_TABLE(JSPerformanceTimingPrototype) };

JSObject* JSPerformanceTimingPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSPerformanceTiming>(exec, globalObject);
}

const ClassInfo JSPerformanceTiming::s_info = { "PerformanceTiming", &Base::s_info, &JSPerformanceTimingTable, 0 , CREATE_METHOD_TABLE(JSPerformanceTiming) };

JSPerformanceTiming::JSPerformanceTiming(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<PerformanceTiming> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSPerformanceTiming::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSPerformanceTiming::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSPerformanceTimingPrototype::create(exec->vm(), globalObject, JSPerformanceTimingPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSPerformanceTiming::destroy(JSC::JSCell* cell)
{
    JSPerformanceTiming* thisObject = static_cast<JSPerformanceTiming*>(cell);
    thisObject->JSPerformanceTiming::~JSPerformanceTiming();
}

JSPerformanceTiming::~JSPerformanceTiming()
{
    releaseImplIfNotNull();
}

bool JSPerformanceTiming::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSPerformanceTiming* thisObject = jsCast<JSPerformanceTiming*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSPerformanceTiming, Base>(exec, &JSPerformanceTimingTable, thisObject, propertyName, slot);
}

bool JSPerformanceTiming::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSPerformanceTiming* thisObject = jsCast<JSPerformanceTiming*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSPerformanceTiming, Base>(exec, &JSPerformanceTimingTable, thisObject, propertyName, descriptor);
}

JSValue jsPerformanceTimingNavigationStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->navigationStart());
    return result;
}


JSValue jsPerformanceTimingUnloadEventStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->unloadEventStart());
    return result;
}


JSValue jsPerformanceTimingUnloadEventEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->unloadEventEnd());
    return result;
}


JSValue jsPerformanceTimingRedirectStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->redirectStart());
    return result;
}


JSValue jsPerformanceTimingRedirectEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->redirectEnd());
    return result;
}


JSValue jsPerformanceTimingFetchStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->fetchStart());
    return result;
}


JSValue jsPerformanceTimingDomainLookupStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domainLookupStart());
    return result;
}


JSValue jsPerformanceTimingDomainLookupEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domainLookupEnd());
    return result;
}


JSValue jsPerformanceTimingConnectStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->connectStart());
    return result;
}


JSValue jsPerformanceTimingConnectEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->connectEnd());
    return result;
}


JSValue jsPerformanceTimingSecureConnectionStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->secureConnectionStart());
    return result;
}


JSValue jsPerformanceTimingRequestStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->requestStart());
    return result;
}


JSValue jsPerformanceTimingResponseStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->responseStart());
    return result;
}


JSValue jsPerformanceTimingResponseEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->responseEnd());
    return result;
}


JSValue jsPerformanceTimingDomLoading(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domLoading());
    return result;
}


JSValue jsPerformanceTimingDomInteractive(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domInteractive());
    return result;
}


JSValue jsPerformanceTimingDomContentLoadedEventStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domContentLoadedEventStart());
    return result;
}


JSValue jsPerformanceTimingDomContentLoadedEventEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domContentLoadedEventEnd());
    return result;
}


JSValue jsPerformanceTimingDomComplete(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->domComplete());
    return result;
}


JSValue jsPerformanceTimingLoadEventStart(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->loadEventStart());
    return result;
}


JSValue jsPerformanceTimingLoadEventEnd(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* castedThis = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    PerformanceTiming* impl = static_cast<PerformanceTiming*>(castedThis->impl());
    JSValue result = jsNumber(impl->loadEventEnd());
    return result;
}


JSValue jsPerformanceTimingConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSPerformanceTiming* domObject = jsCast<JSPerformanceTiming*>(asObject(slotBase));
    return JSPerformanceTiming::getConstructor(exec, domObject->globalObject());
}

JSValue JSPerformanceTiming::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSPerformanceTimingConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

static inline bool isObservable(JSPerformanceTiming* jsPerformanceTiming)
{
    if (jsPerformanceTiming->hasCustomProperties())
        return true;
    return false;
}

bool JSPerformanceTimingOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSPerformanceTiming* jsPerformanceTiming = jsCast<JSPerformanceTiming*>(handle.get().asCell());
    if (!isObservable(jsPerformanceTiming))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSPerformanceTimingOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSPerformanceTiming* jsPerformanceTiming = jsCast<JSPerformanceTiming*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsPerformanceTiming->impl(), jsPerformanceTiming);
    jsPerformanceTiming->releaseImpl();
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7PerformanceTiming@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore17PerformanceTimingE[]; }
#endif
#endif
JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, PerformanceTiming* impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSPerformanceTiming>(exec, impl))
        return result;

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7PerformanceTiming@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore17PerformanceTimingE[2];
#if COMPILER(CLANG) && COMPILER_SUPPORTS(CXX_STATIC_ASSERT)
    // If this fails PerformanceTiming does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    COMPILE_ASSERT(__is_polymorphic(PerformanceTiming), PerformanceTiming_is_not_polymorphic);
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // PerformanceTiming has subclasses. If PerformanceTiming has subclasses that get passed
    // to toJS() we currently require PerformanceTiming you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    ReportMemoryCost<PerformanceTiming>::reportMemoryCost(exec, impl);
    return createNewWrapper<JSPerformanceTiming>(exec, globalObject, impl);
}

PerformanceTiming* toPerformanceTiming(JSC::JSValue value)
{
    return value.inherits(&JSPerformanceTiming::s_info) ? jsCast<JSPerformanceTiming*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEB_TIMING)
