/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGCircleElement.h"

#include "JSSVGAnimatedLength.h"
#include "SVGCircleElement.h"
#include <wtf/GetPtr.h>

#if ENABLE(SVG)
#include "JSSVGAnimatedBoolean.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGCircleElementTableValues[] =
{
    { "cx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementCx), (intptr_t)0, NoIntrinsic },
    { "cy", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementCy), (intptr_t)0, NoIntrinsic },
    { "r", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementR), (intptr_t)0, NoIntrinsic },
#if ENABLE(SVG)
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGCircleElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGCircleElementTable = { 17, 15, JSSVGCircleElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGCircleElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGCircleElementConstructorTable = { 1, 0, JSSVGCircleElementConstructorTableValues, 0 };
const ClassInfo JSSVGCircleElementConstructor::s_info = { "SVGCircleElementConstructor", &Base::s_info, &JSSVGCircleElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGCircleElementConstructor) };

JSSVGCircleElementConstructor::JSSVGCircleElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGCircleElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGCircleElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGCircleElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGCircleElementConstructor, JSDOMWrapper>(exec, &JSSVGCircleElementConstructorTable, jsCast<JSSVGCircleElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGCircleElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGCircleElementConstructor, JSDOMWrapper>(exec, &JSSVGCircleElementConstructorTable, jsCast<JSSVGCircleElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGCircleElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGCircleElementPrototypeTable = { 1, 0, JSSVGCircleElementPrototypeTableValues, 0 };
const ClassInfo JSSVGCircleElementPrototype::s_info = { "SVGCircleElementPrototype", &Base::s_info, &JSSVGCircleElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGCircleElementPrototype) };

JSObject* JSSVGCircleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGCircleElement>(exec, globalObject);
}

const ClassInfo JSSVGCircleElement::s_info = { "SVGCircleElement", &Base::s_info, &JSSVGCircleElementTable, 0 , CREATE_METHOD_TABLE(JSSVGCircleElement) };

JSSVGCircleElement::JSSVGCircleElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGCircleElement> impl)
    : JSSVGGraphicsElement(structure, globalObject, impl)
{
}

void JSSVGCircleElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGCircleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGCircleElementPrototype::create(exec->vm(), globalObject, JSSVGCircleElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGraphicsElementPrototype::self(exec, globalObject)));
}

bool JSSVGCircleElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGCircleElement* thisObject = jsCast<JSSVGCircleElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGCircleElement, Base>(exec, &JSSVGCircleElementTable, thisObject, propertyName, slot);
}

bool JSSVGCircleElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGCircleElement* thisObject = jsCast<JSSVGCircleElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGCircleElement, Base>(exec, &JSSVGCircleElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGCircleElementCx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->cxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementCy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->cyAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGCircleElementR(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->rAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


#if ENABLE(SVG)
JSValue jsSVGCircleElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* castedThis = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGCircleElement* impl = static_cast<SVGCircleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}

#endif

JSValue jsSVGCircleElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGCircleElement* domObject = jsCast<JSSVGCircleElement*>(asObject(slotBase));
    return JSSVGCircleElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGCircleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGCircleElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
