/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGLinearGradientElement.h"

#include "JSSVGAnimatedLength.h"
#include "SVGLinearGradientElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGLinearGradientElementTableValues[] =
{
    { "x1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLinearGradientElementX1), (intptr_t)0, NoIntrinsic },
    { "y1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLinearGradientElementY1), (intptr_t)0, NoIntrinsic },
    { "x2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLinearGradientElementX2), (intptr_t)0, NoIntrinsic },
    { "y2", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLinearGradientElementY2), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGLinearGradientElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLinearGradientElementTable = { 16, 15, JSSVGLinearGradientElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGLinearGradientElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLinearGradientElementConstructorTable = { 1, 0, JSSVGLinearGradientElementConstructorTableValues, 0 };
const ClassInfo JSSVGLinearGradientElementConstructor::s_info = { "SVGLinearGradientElementConstructor", &Base::s_info, &JSSVGLinearGradientElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGLinearGradientElementConstructor) };

JSSVGLinearGradientElementConstructor::JSSVGLinearGradientElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGLinearGradientElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGLinearGradientElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGLinearGradientElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGLinearGradientElementConstructor, JSDOMWrapper>(exec, &JSSVGLinearGradientElementConstructorTable, jsCast<JSSVGLinearGradientElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGLinearGradientElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGLinearGradientElementConstructor, JSDOMWrapper>(exec, &JSSVGLinearGradientElementConstructorTable, jsCast<JSSVGLinearGradientElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGLinearGradientElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGLinearGradientElementPrototypeTable = { 1, 0, JSSVGLinearGradientElementPrototypeTableValues, 0 };
const ClassInfo JSSVGLinearGradientElementPrototype::s_info = { "SVGLinearGradientElementPrototype", &Base::s_info, &JSSVGLinearGradientElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGLinearGradientElementPrototype) };

JSObject* JSSVGLinearGradientElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGLinearGradientElement>(exec, globalObject);
}

const ClassInfo JSSVGLinearGradientElement::s_info = { "SVGLinearGradientElement", &Base::s_info, &JSSVGLinearGradientElementTable, 0 , CREATE_METHOD_TABLE(JSSVGLinearGradientElement) };

JSSVGLinearGradientElement::JSSVGLinearGradientElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGLinearGradientElement> impl)
    : JSSVGGradientElement(structure, globalObject, impl)
{
}

void JSSVGLinearGradientElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGLinearGradientElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGLinearGradientElementPrototype::create(exec->vm(), globalObject, JSSVGLinearGradientElementPrototype::createStructure(exec->vm(), globalObject, JSSVGGradientElementPrototype::self(exec, globalObject)));
}

bool JSSVGLinearGradientElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGLinearGradientElement* thisObject = jsCast<JSSVGLinearGradientElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGLinearGradientElement, Base>(exec, &JSSVGLinearGradientElementTable, thisObject, propertyName, slot);
}

bool JSSVGLinearGradientElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGLinearGradientElement* thisObject = jsCast<JSSVGLinearGradientElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGLinearGradientElement, Base>(exec, &JSSVGLinearGradientElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGLinearGradientElementX1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLinearGradientElement* castedThis = jsCast<JSSVGLinearGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* impl = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->x1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLinearGradientElementY1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLinearGradientElement* castedThis = jsCast<JSSVGLinearGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* impl = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->y1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLinearGradientElementX2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLinearGradientElement* castedThis = jsCast<JSSVGLinearGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* impl = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->x2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLinearGradientElementY2(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLinearGradientElement* castedThis = jsCast<JSSVGLinearGradientElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGLinearGradientElement* impl = static_cast<SVGLinearGradientElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->y2Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGLinearGradientElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGLinearGradientElement* domObject = jsCast<JSSVGLinearGradientElement*>(asObject(slotBase));
    return JSSVGLinearGradientElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGLinearGradientElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGLinearGradientElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(SVG)
