/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGPreserveAspectRatio.h"

#include "ExceptionCode.h"
#include "SVGPreserveAspectRatio.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGPreserveAspectRatioTableValues[] =
{
    { "align", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioAlign), (intptr_t)setJSSVGPreserveAspectRatioAlign, NoIntrinsic },
    { "meetOrSlice", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioMeetOrSlice), (intptr_t)setJSSVGPreserveAspectRatioMeetOrSlice, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPreserveAspectRatioTable = { 8, 7, JSSVGPreserveAspectRatioTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGPreserveAspectRatioConstructorTableValues[] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX), (intptr_t)0, NoIntrinsic },
    { "SVG_MEETORSLICE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_MEETORSLICE_MEET", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET), (intptr_t)0, NoIntrinsic },
    { "SVG_MEETORSLICE_SLICE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPreserveAspectRatioConstructorTable = { 35, 31, JSSVGPreserveAspectRatioConstructorTableValues, 0 };

COMPILE_ASSERT(0 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_UNKNOWN, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_NONE, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_NONEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMINYMIN, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMINYMINIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMIDYMIN, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMIDYMINIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMAXYMIN, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMAXYMINIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(5 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMINYMID, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMINYMIDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(6 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMIDYMID, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMIDYMIDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(7 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMAXYMID, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMAXYMIDIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(8 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMINYMAX, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMINYMAXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(9 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMIDYMAX, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMIDYMAXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(10 == SVGPreserveAspectRatio::SVG_PRESERVEASPECTRATIO_XMAXYMAX, SVGPreserveAspectRatioEnumSVG_PRESERVEASPECTRATIO_XMAXYMAXIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == SVGPreserveAspectRatio::SVG_MEETORSLICE_UNKNOWN, SVGPreserveAspectRatioEnumSVG_MEETORSLICE_UNKNOWNIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == SVGPreserveAspectRatio::SVG_MEETORSLICE_MEET, SVGPreserveAspectRatioEnumSVG_MEETORSLICE_MEETIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == SVGPreserveAspectRatio::SVG_MEETORSLICE_SLICE, SVGPreserveAspectRatioEnumSVG_MEETORSLICE_SLICEIsWrongUseDoNotCheckConstants);

const ClassInfo JSSVGPreserveAspectRatioConstructor::s_info = { "SVGPreserveAspectRatioConstructor", &Base::s_info, &JSSVGPreserveAspectRatioConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatioConstructor) };

JSSVGPreserveAspectRatioConstructor::JSSVGPreserveAspectRatioConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGPreserveAspectRatioConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->vm());
    ASSERT(inherits(&s_info));
    putDirect(exec->vm(), exec->propertyNames().prototype, JSSVGPreserveAspectRatioPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->vm(), exec->propertyNames().length, jsNumber(0), ReadOnly | DontDelete | DontEnum);
}

bool JSSVGPreserveAspectRatioConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGPreserveAspectRatioConstructor, JSDOMWrapper>(exec, &JSSVGPreserveAspectRatioConstructorTable, jsCast<JSSVGPreserveAspectRatioConstructor*>(cell), propertyName, slot);
}

bool JSSVGPreserveAspectRatioConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGPreserveAspectRatioConstructor, JSDOMWrapper>(exec, &JSSVGPreserveAspectRatioConstructorTable, jsCast<JSSVGPreserveAspectRatioConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPreserveAspectRatioPrototypeTableValues[] =
{
    { "SVG_PRESERVEASPECTRATIO_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMINYMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMIN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMINYMID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMID", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMINYMAX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMIDYMAX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX), (intptr_t)0, NoIntrinsic },
    { "SVG_PRESERVEASPECTRATIO_XMAXYMAX", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX), (intptr_t)0, NoIntrinsic },
    { "SVG_MEETORSLICE_UNKNOWN", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN), (intptr_t)0, NoIntrinsic },
    { "SVG_MEETORSLICE_MEET", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET), (intptr_t)0, NoIntrinsic },
    { "SVG_MEETORSLICE_SLICE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGPreserveAspectRatioPrototypeTable = { 35, 31, JSSVGPreserveAspectRatioPrototypeTableValues, 0 };
const ClassInfo JSSVGPreserveAspectRatioPrototype::s_info = { "SVGPreserveAspectRatioPrototype", &Base::s_info, &JSSVGPreserveAspectRatioPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGPreserveAspectRatioPrototype) };

JSObject* JSSVGPreserveAspectRatioPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGPreserveAspectRatio>(exec, globalObject);
}

bool JSSVGPreserveAspectRatioPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPreserveAspectRatioPrototype* thisObject = jsCast<JSSVGPreserveAspectRatioPrototype*>(cell);
    return getStaticValueSlot<JSSVGPreserveAspectRatioPrototype, JSObject>(exec, &JSSVGPreserveAspectRatioPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGPreserveAspectRatioPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPreserveAspectRatioPrototype* thisObject = jsCast<JSSVGPreserveAspectRatioPrototype*>(object);
    return getStaticValueDescriptor<JSSVGPreserveAspectRatioPrototype, JSObject>(exec, &JSSVGPreserveAspectRatioPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGPreserveAspectRatio::s_info = { "SVGPreserveAspectRatio", &Base::s_info, &JSSVGPreserveAspectRatioTable, 0 , CREATE_METHOD_TABLE(JSSVGPreserveAspectRatio) };

JSSVGPreserveAspectRatio::JSSVGPreserveAspectRatio(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGPropertyTearOff<SVGPreserveAspectRatio> > impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSSVGPreserveAspectRatio::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGPreserveAspectRatio::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGPreserveAspectRatioPrototype::create(exec->vm(), globalObject, JSSVGPreserveAspectRatioPrototype::createStructure(globalObject->vm(), globalObject, globalObject->objectPrototype()));
}

void JSSVGPreserveAspectRatio::destroy(JSC::JSCell* cell)
{
    JSSVGPreserveAspectRatio* thisObject = static_cast<JSSVGPreserveAspectRatio*>(cell);
    thisObject->JSSVGPreserveAspectRatio::~JSSVGPreserveAspectRatio();
}

JSSVGPreserveAspectRatio::~JSSVGPreserveAspectRatio()
{
    releaseImplIfNotNull();
}

bool JSSVGPreserveAspectRatio::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGPreserveAspectRatio* thisObject = jsCast<JSSVGPreserveAspectRatio*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGPreserveAspectRatio, Base>(exec, &JSSVGPreserveAspectRatioTable, thisObject, propertyName, slot);
}

bool JSSVGPreserveAspectRatio::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGPreserveAspectRatio* thisObject = jsCast<JSSVGPreserveAspectRatio*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGPreserveAspectRatio, Base>(exec, &JSSVGPreserveAspectRatioTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGPreserveAspectRatioAlign(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPreserveAspectRatio* castedThis = jsCast<JSSVGPreserveAspectRatio*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPreserveAspectRatio& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.align());
    return result;
}


JSValue jsSVGPreserveAspectRatioMeetOrSlice(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPreserveAspectRatio* castedThis = jsCast<JSSVGPreserveAspectRatio*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGPreserveAspectRatio& impl = castedThis->impl()->propertyReference();
    JSValue result =  jsNumber(impl.meetOrSlice());
    return result;
}


JSValue jsSVGPreserveAspectRatioConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGPreserveAspectRatio* domObject = jsCast<JSSVGPreserveAspectRatio*>(asObject(slotBase));
    return JSSVGPreserveAspectRatio::getConstructor(exec, domObject->globalObject());
}

void JSSVGPreserveAspectRatio::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGPreserveAspectRatio* thisObject = jsCast<JSSVGPreserveAspectRatio*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGPreserveAspectRatio, Base>(exec, propertyName, value, &JSSVGPreserveAspectRatioTable, thisObject, slot);
}

void setJSSVGPreserveAspectRatioAlign(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPreserveAspectRatio* castedThis = jsCast<JSSVGPreserveAspectRatio*>(thisObject);
    SVGPropertyTearOff<SVGPreserveAspectRatio> * impl = static_cast<SVGPropertyTearOff<SVGPreserveAspectRatio> *>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned short nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGPreserveAspectRatio& podImpl = impl->propertyReference();
    podImpl.setAlign(nativeValue, ec);
    setDOMException(exec, ec);
    if (!ec)
        impl->commitChange();
}


void setJSSVGPreserveAspectRatioMeetOrSlice(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGPreserveAspectRatio* castedThis = jsCast<JSSVGPreserveAspectRatio*>(thisObject);
    SVGPropertyTearOff<SVGPreserveAspectRatio> * impl = static_cast<SVGPropertyTearOff<SVGPreserveAspectRatio> *>(castedThis->impl());
    ExceptionCode ec = 0;
    unsigned short nativeValue(toUInt32(exec, value, NormalConversion));
    if (exec->hadException())
        return;
    if (impl->isReadOnly()) {
        setDOMException(exec, NO_MODIFICATION_ALLOWED_ERR);
        return;
    }
    SVGPreserveAspectRatio& podImpl = impl->propertyReference();
    podImpl.setMeetOrSlice(nativeValue, ec);
    setDOMException(exec, ec);
    if (!ec)
        impl->commitChange();
}


JSValue JSSVGPreserveAspectRatio::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPreserveAspectRatioConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

// Constant getters

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_NONE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMIN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMIN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMIN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMID(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMID(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMID(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMINYMAX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMIDYMAX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(9));
}

JSValue jsSVGPreserveAspectRatioSVG_PRESERVEASPECTRATIO_XMAXYMAX(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(10));
}

JSValue jsSVGPreserveAspectRatioSVG_MEETORSLICE_UNKNOWN(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsSVGPreserveAspectRatioSVG_MEETORSLICE_MEET(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsSVGPreserveAspectRatioSVG_MEETORSLICE_SLICE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

static inline bool isObservable(JSSVGPreserveAspectRatio* jsSVGPreserveAspectRatio)
{
    if (jsSVGPreserveAspectRatio->hasCustomProperties())
        return true;
    return false;
}

bool JSSVGPreserveAspectRatioOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSSVGPreserveAspectRatio* jsSVGPreserveAspectRatio = jsCast<JSSVGPreserveAspectRatio*>(handle.get().asCell());
    if (!isObservable(jsSVGPreserveAspectRatio))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSSVGPreserveAspectRatioOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSSVGPreserveAspectRatio* jsSVGPreserveAspectRatio = jsCast<JSSVGPreserveAspectRatio*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPreserveAspectRatio->impl(), jsSVGPreserveAspectRatio);
    jsSVGPreserveAspectRatio->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, SVGPropertyTearOff<SVGPreserveAspectRatio> * impl)
{
    if (!impl)
        return jsNull();
    if (JSValue result = getExistingWrapper<JSSVGPreserveAspectRatio, SVGPropertyTearOff<SVGPreserveAspectRatio> >(exec, impl))
        return result;
    ReportMemoryCost<SVGPropertyTearOff<SVGPreserveAspectRatio> >::reportMemoryCost(exec, impl);
    return createNewWrapper<JSSVGPreserveAspectRatio, SVGPropertyTearOff<SVGPreserveAspectRatio> >(exec, globalObject, impl);
}

SVGPropertyTearOff<SVGPreserveAspectRatio> * toSVGPreserveAspectRatio(JSC::JSValue value)
{
    return value.inherits(&JSSVGPreserveAspectRatio::s_info) ? jsCast<JSSVGPreserveAspectRatio*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
