/*      Copyright (c) 1992 Raymond Hettinger.  All rights reserved.   */
/*      Modified to fit the POSIX standard, 2005, Markus R. Kessler   */

/* Basic letter format specification.
        Letter formats are stored as an array of 7 char-sized bitmaps.
        The lower case letters always have the first bitmap == zero.
        All bitmaps have zero in the rightmost bit to faciliate spacing
        between letters.
*/

/* Prototypes */
void bputs( char *string );

/* Includes */
#include <conio.h>

/* Defines */
#define NUL     0
#define ROWS    7

const char alphabet[ '~' - ' ' + 1][ROWS] = {
        { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },   /* ' ' */
        { 0x38, 0x38, 0x38, 0x10, 0x00, 0x38, 0x38 },   /* '!' */
        { 0x24, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00 },   /* '"' UNV */
        { 0x28, 0x28, 0xFE, 0x28, 0xFE, 0x28, 0x28 },   /* '#' */
        { 0x7C, 0x92, 0x90, 0x7C, 0x12, 0x92, 0x7C },   /* '$' */
        { 0xE2, 0xA4, 0xE8, 0x10, 0x2E, 0x4A, 0x8E },   /* '%' */
        { 0x30, 0x48, 0x30, 0x70, 0x8A, 0x84, 0x72 },   /* '&' */
        { 0x38, 0x38, 0x10, 0x20, 0x00, 0x00, 0x00 },   /* ''' */
        { 0x18, 0x20, 0x40, 0x40, 0x40, 0x20, 0x18 },   /* '(' */
        { 0x30, 0x08, 0x04, 0x04, 0x04, 0x08, 0x30 },   /* ')' */
        { 0x00, 0x44, 0x28, 0xFE, 0x28, 0x44, 0x00 },   /* '*' */
        { 0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00 },   /* '+' */
        { 0x00, 0x00, 0x00, 0x38, 0x38, 0x10, 0x20 },   /* ',' */
        { 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00 },   /* '-' */
        { 0x00, 0x00, 0x00, 0x00, 0x38, 0x38, 0x38 },   /* '.' */
        { 0x02, 0x04, 0x08, 0x10, 0x20, 0x40, 0x80 },   /* '/' */
        { 0x38, 0x44, 0x82, 0x82, 0x82, 0x44, 0x38 },   /* '0' */
        { 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x7C },   /* '1' */
        { 0x7C, 0x82, 0x02, 0x7C, 0x80, 0x80, 0xFE },   /* '2' */
        { 0x7C, 0x82, 0x02, 0x7C, 0x02, 0x82, 0x7C },   /* '3' */
        { 0x80, 0x84, 0x84, 0x84, 0xFE, 0x04, 0x04 },   /* '4' */
        { 0xFE, 0x80, 0x80, 0xFC, 0x02, 0x82, 0x7C },   /* '5' */
        { 0x7C, 0x82, 0x80, 0xFC, 0x82, 0x82, 0x7C },   /* '6' */
        { 0xFC, 0x84, 0x08, 0x10, 0x20, 0x20, 0x20 },   /* '7' */
        { 0x7C, 0x82, 0x82, 0x7C, 0x82, 0x82, 0x7C },   /* '8' */
        { 0x7C, 0x82, 0x82, 0x7E, 0x02, 0x82, 0x7C },   /* '9' */
        { 0x10, 0x38, 0x10, 0x00, 0x10, 0x38, 0x10 },   /* ':' */
        { 0x38, 0x38, 0x00, 0x38, 0x38, 0x10, 0x20 },   /* ';' */
        { 0x08, 0x10, 0x20, 0x40, 0x20, 0x10, 0x08 },   /* '<' */
        { 0x00, 0x00, 0xFE, 0x00, 0xFE, 0x00, 0x00 },   /* '=' UNV. */
        { 0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20 },   /* '>' */
        { 0x7C, 0x82, 0x02, 0x1C, 0x10, 0x00, 0x10 },   /* '?' */
        { 0x7C, 0x82, 0xBA, 0xBA, 0xBC, 0x80, 0x7C },   /* '@' */
        { 0x10, 0x28, 0x44, 0x82, 0xFE, 0x82, 0x82 },   /* 'A' */
        { 0xFC, 0x82, 0x82, 0xFC, 0x82, 0x82, 0xFC },   /* 'B' */
        { 0x7C, 0x82, 0x80, 0x80, 0x80, 0x82, 0x7C },   /* 'C' */
        { 0xFC, 0x82, 0x82, 0x82, 0x82, 0x82, 0xFC },   /* 'D' */
        { 0xFE, 0x80, 0x80, 0xF8, 0x80, 0x80, 0xFE },   /* 'E' */
        { 0xFE, 0x80, 0x80, 0xF8, 0x80, 0x80, 0x80 },   /* 'F' */
        { 0x7C, 0x82, 0x80, 0x9E, 0x82, 0x82, 0x7C },   /* 'G' */
        { 0x82, 0x82, 0x82, 0xFE, 0x82, 0x82, 0x82 },   /* 'H' */
        { 0x38, 0x10, 0x10, 0x10, 0x10, 0x10, 0x38 },   /* 'I' */
        { 0x02, 0x02, 0x02, 0x02, 0x82, 0x82, 0x7C },   /* 'J' */
        { 0x84, 0x88, 0x90, 0xE0, 0x90, 0x88, 0x84 },   /* 'K' */
        { 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFE },   /* 'L' */
        { 0x82, 0xC6, 0xAA, 0x92, 0x82, 0x82, 0x82 },   /* 'M' */
        { 0x82, 0xC2, 0xA2, 0x92, 0x8A, 0x86, 0x82 },   /* 'N' */
        { 0xFE, 0x82, 0x82, 0x82, 0x82, 0x82, 0xFE },   /* 'O' */
        { 0xFC, 0x82, 0x82, 0xFC, 0x80, 0x80, 0x80 },   /* 'P' */
        { 0x7C, 0x82, 0x82, 0x82, 0x8A, 0x84, 0x7A },   /* 'Q' */
        { 0xFC, 0x82, 0x82, 0xFC, 0x88, 0x84, 0x82 },   /* 'R' */
        { 0x7C, 0x82, 0x80, 0x7C, 0x02, 0x82, 0x7C },   /* 'S' */
        { 0xFE, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10 },   /* 'T' */
        { 0x82, 0x82, 0x82, 0x82, 0x82, 0x82, 0x7C },   /* 'U' */
        { 0x82, 0x82, 0x82, 0x82, 0x44, 0x28, 0x10 },   /* 'V' */
        { 0x82, 0x92, 0x92, 0x92, 0x92, 0x92, 0x6C },   /* 'W' */
        { 0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82 },   /* 'X' */
        { 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10 },   /* 'Y' */
        { 0xFE, 0x04, 0x08, 0x10, 0x20, 0x40, 0xFE },   /* 'Z' */
        { 0x7C, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7C },   /* '[' */
        { 0x80, 0x40, 0x20, 0x10, 0x08, 0x04, 0x02 },   /* '\' */
        { 0x7C, 0x04, 0x04, 0x04, 0x04, 0x04, 0x7C },   /* ']' */
        { 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x00 },   /* '^' */
        { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE },   /* '_' */
        { 0x00, 0x38, 0x38, 0x10, 0x08, 0x00, 0x00 },   /* '`' */
        { 0x00, 0x18, 0x24, 0x42, 0x7E, 0x42, 0x42 },   /* 'a' */
        { 0x00, 0x7C, 0x42, 0x7C, 0x42, 0x42, 0x7C },   /* 'b' */
        { 0x00, 0x3C, 0x42, 0x40, 0x40, 0x42, 0x3C },   /* 'c' */
        { 0x00, 0x7C, 0x42, 0x42, 0x42, 0x42, 0x7C },   /* 'd' */
        { 0x00, 0x7E, 0x40, 0x7C, 0x40, 0x40, 0x7E },   /* 'e' */
        { 0x00, 0x7E, 0x40, 0x7C, 0x40, 0x40, 0x40 },   /* 'f' */
        { 0x00, 0x3C, 0x42, 0x40, 0x4E, 0x42, 0x3C },   /* 'g' */
        { 0x00, 0x42, 0x42, 0x7E, 0x42, 0x42, 0x42 },   /* 'h' */
        { 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08 },   /* 'i' */
        { 0x00, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3C },   /* 'j' */
        { 0x00, 0x42, 0x44, 0x78, 0x48, 0x44, 0x42 },   /* 'k' */
        { 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7E },   /* 'l' */
        { 0x00, 0x42, 0x66, 0x5A, 0x42, 0x42, 0x42 },   /* 'm' */
        { 0x00, 0x42, 0x62, 0x52, 0x4A, 0x46, 0x42 },   /* 'n' */
        { 0x00, 0x3C, 0x42, 0x42, 0x42, 0x42, 0x3C },   /* 'o' */
        { 0x00, 0x7C, 0x42, 0x42, 0x7C, 0x40, 0x40 },   /* 'p' */
        { 0x00, 0x3C, 0x42, 0x42, 0x4A, 0x44, 0x3A },   /* 'q' */
        { 0x00, 0x7C, 0x42, 0x42, 0x7C, 0x44, 0x42 },   /* 'r' */
        { 0x00, 0x3C, 0x40, 0x3C, 0x02, 0x42, 0x3C },   /* 's' */
        { 0x00, 0x3E, 0x08, 0x08, 0x08, 0x08, 0x08 },   /* 't' */
        { 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3C },   /* 'u' */
        { 0x00, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18 },   /* 'v' */
        { 0x00, 0x42, 0x42, 0x42, 0x5A, 0x66, 0x42 },   /* 'w' */
        { 0x00, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42 },   /* 'x' */
        { 0x00, 0x22, 0x14, 0x08, 0x08, 0x08, 0x08 },   /* 'y' */
        { 0x00, 0x7E, 0x04, 0x08, 0x10, 0x20, 0x7E },   /* 'z' */
        { 0x38, 0x40, 0x40, 0xC0, 0x40, 0x40, 0x38 },   /* '{' */
        { 0x10, 0x10, 0x10, 0x00, 0x10, 0x10, 0x10 },   /* '|' */
        { 0x38, 0x04, 0x04, 0x06, 0x04, 0x04, 0x38 },   /* '}' */
        { 0x60, 0x92, 0x0C, 0x00, 0x00, 0x00, 0x00 },   /* '~' */
};

const char bit[8] = { 128, 64, 32, 16, 8, 4, 2, 1 };
const char copyright[] = {
        "\nUNIX banner for GNU/DJGPP v.1.0\n\n"
        "Usage: banner chars\n"
        "   or: banner \'word1 word2\' \'word3 word4 word5\'\n"
        "Copyright (c) 1992 Raymond Hettinger.  All rights reserved.\n\n"
};

int
main( int argc, char *argv[] )
{
        int i;

        if( argc==1 )
                printf( copyright );
        else
                for( i=1 ; i<argc ; i++ )
                        bputs( argv[i] );

        return 0;
}

char outbuf[ 4096 ];

void
bputs( char * const string )
{
        char *s, bitmap, r, c, *curout;

        for( r=0 ; r<ROWS ; r++ ){
                for( s=string, curout=outbuf ; *s != NUL ; s++ ){
                        bitmap = 0;
                        if( ' ' <= *s  &&  *s <= '~' )
                                bitmap = alphabet[ *s - 32 ][ r ];
                        for( c=0 ; c<8 ; c++ )
                                *(curout++) = ( bitmap & bit[c] ) ? '#'  :  ' ';
                }
                *(curout-1) = '\n';
                *(curout) = NUL;            /* Mark end of string */
                printf( outbuf );
        }
        printf( "\n" );
}
