This is Info file kpathsea.info, produced by Makeinfo version 1.67 from
the input file kpathsea.texinfo.

INFO-DIR-SECTION TeX
START-INFO-DIR-ENTRY
* Kpathsea: (kpathsea).              File lookup along search paths.
* kpsewhich: (kpathsea)Invoking kpsewhich.      TeX file searching.
* MakeTeXMF: (kpathsea)MakeTeX scripts.         MF source generation.
* MakeTeXPK: (kpathsea)MakeTeX scripts.         PK bitmap generation.
* MakeTeXTeX: (kpathsea)MakeTeX scripts.        TeX source generation.
* MakeTeXTFM: (kpathsea)MakeTeX scripts.        TeX font metric generation.
* MakeTeXls-R: (kpathsea)Filename database.     Update ls-R.
END-INFO-DIR-ENTRY

  This file documents the Kpathsea library for path searching.

  Copyright (C) 1993, 94, 95, 96, 97 K. Berry.

  Permission is granted to make and distribute verbatim copies of this
manual provided the copyright notice and this permission notice are
preserved on all copies.

  Permission is granted to copy and distribute modified versions of this
manual under the conditions for verbatim copying, provided that the
entire resulting derived work is distributed under the terms of a
permission notice identical to this one.

  Permission is granted to copy and distribute translations of this
manual into another language, under the above conditions for modified
versions, except that this permission notice may be stated in a
translation approved by the Free Software Foundation.


File: kpathsea.info,  Node: Filename aliases,  Next: Database format,  Prev: ls-R,  Up: Filename database

Filename aliases
----------------

  In some circumstances, you may wish to find a file under several
names.  For example, suppose a TeX document was created using a DOS
system and tries to read `longtabl.sty'.  But now it's being run on a
Unix system, and the file has its original name, `longtable.sty'.  The
file won't be found.  You need to give the actual file `longtable.sty'
an alias `longtabl.sty'.

  You can handle this by creating a file `aliases' as a companion to
the `ls-R' for the hierarchy containing the file in question.  (You
must have an `ls-R' for the alias feature to work.)

  The format of `aliases' is simple: two whitespace-separated words per
line; the first is the real name `longtable.sty', and second is the
alias (`longtabl.sty').  These must be base filenames, with no
directory components.  `longtable.sty' must be in the sibling `ls-R'.

  Also, blank lines and lines starting with `%' or `#' are ignored in
`aliases', to allow for comments.

  If a real file `longtabl.sty' exists, it is used regardless of any
aliases.


File: kpathsea.info,  Node: Database format,  Prev: Filename aliases,  Up: Filename database

Database format
---------------

  The "database" read by Kpathsea is a line-oriented file of plain
text. The format is that generated by GNU (and most other) `ls'
programs given the `-R' option, as follows.

   * Blank lines are ignored.

   * If a line begins with `/' or `./' or `../' and ends with a colon,
     it's the name of a directory.  (`../' lines aren't useful,
     however, and should not be generated.)

   * All other lines define entries in the most recently seen directory.
     /'s in such lines will produce possibly-strange results.

   * Files with no preceding directory line are ignored.

  For example, here's the first few lines of `ls-R' (which totals about
30K bytes) on my system:

     bibtex
     dvips
     fonts
     ls-R
     metafont
     metapost
     tex
     web2c
     
     ./bibtex:
     bib
     bst
     doc
     
     ./bibtex/bib:
     asi.bib
     btxdoc.bib
     ...


File: kpathsea.info,  Node: Invoking kpsewhich,  Prev: Filename database,  Up: Path searching

`kpsewhich': Standalone path searching
======================================

  The Kpsewhich program exercises the path searching functionality
independent of any particular application.  This can also be useful as a
sort of `find' program to locate files in your TeX hierarchies, perhaps
in administrative scripts.  It is used heavily in the distributed
`MakeTeX...' scripts.

  Synopsis:
     kpsewhich OPTION... FILENAME...

  The options and filename(s) to look up can be intermixed.  Options
can start with either `-' or `--', and any unambiguous abbreviation is
accepted.

* Menu:

* Path searching options::      Changing the mode, resolution, etc.
* Auxiliary tasks::             Path and variable expansion.
* Standard options::            -help and -version.


File: kpathsea.info,  Node: Path searching options,  Next: Auxiliary tasks,  Up: Invoking kpsewhich

Path searching options
----------------------

  Kpsewhich looks up each non-option argument on the command line as a
filename, and returns the first file found.  There is no option to
return all the files with a particular name (you can run the Unix
`find' utility for that, *note Invoking find: (findutils)Invoking
find.).

  Various options alter the path searching behavior:

`--dpi=NUM'
     Set the resolution to NUM; this only affects `gf' and `pk'
     lookups.  `-D' is a synonym, for compatibility with Dvips.
     Default is 600.

`--format=NAME'
     Set the format for lookup to NAME.  By default, the format is
     guessed from the filename.  In fact, the recognized filename
     extensions and the allowable NAMEs (including any leading `.') are
     the same.

     You can also specify an integer for NAME; this is the only way to
     specify formats that don't have an associated suffix, such as
     MetaPost support files and Dvips configuration files.  It's also
     somewhat faster, since no unused formats need to be initialized.
     The integers appear in the output of `--help', and are of course
     subject to change.

     Here's the current list of recognized names and numbers.  *Note
     Supported file formats::, for more information on each of these.
          gf(0)
          pk(1)
          bitmap font (2)
          .afm(3)
          .base(4)
          .bib(5)
          .bst(6)
          .cnf(7)
          ls-R(8)
          .fmt(9)
          .map(10)
          .mem(11)
          .mf(12)
          .pool(13)
          .mft(14)
          .mp(15)
          .pool(16)
          MetaPost support (17)
          .ocp(18)
          .ofm(19)
          .opl(20)
          .otp(21)
          .ovf(22)
          .ovp(23)
          graphic/figure (24) .eps .epsi
          .tex(25) .ltx .dtx .texi .texinfo .txi .eps .epsi
          TeX documentation (26)
          .pool(27)
          TeX sources (28)
          PostScript header/font (29) .pro
          Troff fonts (30)
          .tfm(31)
          .pfa(32) .pfb
          .vf(33)
          dvips config (34)
          .ist(35)

     This option and `--path' are mutually exclusive.

`--interactive'
     After processing the command line, read additional filenames to
     look up from standard input.

`-maketex=FILETYPE'
`-no-maketex=FILETYPE'
     Turn on or off the `MakeTeX' script associated with FILETYPE.  The
     only values that make sense for FILETYPE are `pk', `mf', `tex',
     and `tfm'. By default, all are off in Kpsewhich.  *Note MakeTeX
     scripts::.

`--mode=STRING'
     Set the mode name to STRING; this also only affects `gf' and `pk'
     lookups.  No default: any mode will be found.  *Note MakeTeX
     script arguments::.

`--must-exist'
     Do everything possible to find the files, notably including
     searching the disk.  By default, only the `ls-R' database is
     checked, in the interest of efficiency.

`--path=STRING'
     Search along the path STRING (colon-separated as usual), instead
     of guessing the search path from the filename.  `//' and all the
     usual expansions are supported (*note Path expansion::.).  This
     option and `--format' are mutually exclusive.  To output the
     complete directory expansion of a path, instead of doing a
     one-shot lookup, see `--path-expand' in the following section.

`--progname=NAME'
     Set the program name to NAME; default is `kpsewhich'.  This can
     affect the search paths via the `.PROGNAM' feature in
     configuration files (*note Config files::.).


File: kpathsea.info,  Node: Auxiliary tasks,  Next: Standard options,  Prev: Path searching options,  Up: Invoking kpsewhich

Auxiliary tasks
---------------

  Kpsewhich provides some additional features not strictly related to
path lookup:

   * `--debug=NUM' sets the debugging options to NUM.  *Note
     Debugging::.

   * `--expand-var=STRING' outputs the variable expansion of STRING.
     For example, the `MakeTeX...' scripts run `kpsewhich
     --expand-var='$TEXMF'' to find the root of the TeX system
     hierarchy.  *Note Path expansion::.

   * `--expand-path=STRING' outputs the complete expansion of STRING as
     a colon-separated path.  This is useful to construct a search path
     for a program that doesn't accept recursive subdirectory
     specifications.  The option `--separator=STRING' changes the
     separator in the output from `:' to STRING.

     For one-shot uses of an arbitrary (not built in to Kpathsea) path,
     see `--path' in the previous section.

   * `--show-path=NAME' shows the path that would be used for file
     lookups of file type NAME.  Either a filename extension (`pk',
     `.vf', etc.) or an integer can be used, just as with `--format',
     described in the previous section.


File: kpathsea.info,  Node: Standard options,  Prev: Auxiliary tasks,  Up: Invoking kpsewhich

Standard options
----------------

  Kpsewhich accepts the standard GNU options:

   * `--help' prints a help message on standard output and exits.

   * `--version' prints the Kpathsea version number and exits.


File: kpathsea.info,  Node: TeX support,  Next: Programming,  Prev: Path searching,  Up: Top

TeX support
***********

  Although the basic features in Kpathsea can be used for any type of
path searching, it came about (like all libraries) with a specific
application in mind: I wrote Kpathsea specifically for TeX system
programs.  I had been struggling with the programs I was using (Dvips,
Xdvi, and TeX itself) having slightly different notions of how to
specify paths; and debugging was painful, since no code was shared.

  Therefore, Kpathsea provides some TeX-specific formats and features.
Indeed, many of the supposedly generic path searching features were
provided because they seemed useful in that conTeXt (font lookup,
particularly).

  Kpathsea provides a standard way to search for files of any of the
supported file types; glyph fonts are a bit different than all the rest.
Searches are based solely on filenames, not file contents--if a GF file
is named `cmr10.600pk', it will be found as a PK file.

* Menu:

* Supported file formats::      File types Kpathsea knows about.
* File lookup::                 Searching for most kinds of files.
* Glyph lookup::                Searching for bitmap fonts.
* Suppressing warnings::        Avoiding warnings via TEX_HUSH.


File: kpathsea.info,  Node: Supported file formats,  Next: File lookup,  Up: TeX support

Supported file formats
======================

  Kpathsea has support for a number of file types.  Each file type has a
list of environment and config file variables that are checked to define
the search path, and most have a default suffix that plays a role in
finding files (see the next section).  Some also define additional
suffixes, and/or a program to be run to create missing files on the fly.

  Since environment variables containing periods, such as
`TEXINPUTS.latex', are not allowed on some systems, Kpathsea looks for
environment variables with an underscore, e.g., `TEXINPUTS_latex'
(*note Config files::.).

  The following table lists the above information.

`.afm'
     (Adobe font metrics, *note Metric files: (dvips)Metric files.)
     `AFMFONTS'.

`.base'
     (Metafont memory dump, *note Memory dumps: (web2c)Memory dumps.)
     `MFBASES', `TEXMFINI'.

`.bib'
     (BibTeX bibliography source, *note bibtex invocation:
     (web2c)bibtex invocation.) `BIBINPUTS', `TEXBIB'.

`.bst'
     (BibTeX style file, *note Basic BibTeX style files: (web2c)Basic
     BibTeX style files.) `BSTINPUTS'.

`.cnf'
     (Runtime configuration files, *note Config files::.) `TEXMFCNF'.

`ls-R'
     (Filename databases, *note Filename database::.) `TEXMFDBS'.

`.fmt'
     (TeX memory dump, *note Memory dumps: (web2c)Memory dumps.)
     `TEXFORMATS', `TEXMFINI'.

`gf'
     (generic font bitmap, *note Glyph files: (dvips)Glyph files.)
     `PROGRAMFONTS', `GFFONTS', `GLYPHFONTS', `TEXFONTS'.

`.map'
     (Fontmaps, *note Fontmap::.) `TEXFONTMAPS'.

`.ist'
     (makeindex style files) `TEXINDEXSTYLE', `INDEXSTYLE'.

`.mem'
     (MetaPost memory dump, *note Memory dumps: (web2c)Memory dumps.)
     `MPMEMS', `TEXMFINI'.

`.mf'
     (Metafont source, *note mf invocation: (web2c)mf invocation.)
     `MFINPUTS'; dynamic creation program: `MakeTeXMF'.

`.mft'
     (`MFT' style file, *note mft invocation: (web2c)mft invocation.)
     `MFTINPUTS'.

`mf.pool'
     (Metafont program strings, *note pooltype invocation:
     (web2c)pooltype invocation.) `MFPOOL', `TEXMFINI'.

`.mp'
     (MetaPost source, *note mpost invocation: (web2c)mpost invocation.)
     `MPINPUTS'.

`mp.pool'
     (MetaPost program strings, *note pooltype invocation:
     (web2c)pooltype invocation.) `MPPOOL', `TEXMFINI'.

`(none)'
     (MetaPost support files, used by DMP; *note dmp invocation:
     (web2c)dmp invocation.) `MPSUPPORT'.

`.ocp'
     (Omega compiled process files) `OCPINPUTS';
     dynamic creation program: `MakeOmegaOCP'.

`.ofm'
     (Omega font metrics) `OFMFONTS', `TEXFONTS';
     dynamic creation program: `MakeOmegaOFM'.

`.opl'
     (Omega property lists) `OPLFONTS', `TEXFONTS'.

`.otp'
     (Omega translation process files) `OTPINPUTS'.

`.ovf'
     (Omega virtual fonts) `OVFFONTS', `TEXFONTS'.

`.ovp'
     (Omega virtual property lists) `OVPFONTS', `TEXFONTS'.

`.eps'
     (Encapsulated PostScript figures, *note PostScript figures:
     (dvips)PostScript figures.) `TEXPICTS', `TEXINPUTS'; additional
     suffixes: `.epsi'.

`pk'
     (packed bitmap fonts, *note Glyph files: (dvips)Glyph files.)
     `PROGRAMFONTS' (PROGRAM being `XDVI', etc.), `PKFONTS', `TEXPKS',
     `GLYPHFONTS', `TEXFONTS'; dynamic creation program: `MakeTeXPK'.

`.pro'
     (downloadable PostScript, *note Header files: (dvips)Header files.)
     `TEXPSHEADERS', `PSHEADERS'.

`.tex'
     (TeX source, *note tex invocation: (web2c)tex invocation.)
     `TEXINPUTS'; additional suffixes: `.ltx' `.dtx' `.texi' `.texinfo'
     `.txi' `.eps' `.epsi'; dynamic creation program: `MakeTeXTeX'.

`(none)'
     (Documentation files for the TeX system) `TEXDOCS'.

`tex.pool'
     (TeX program strings, *note pooltype invocation: (web2c)pooltype
     invocation.) `TEXPOOL', `TEXMFINI'.

`(none)'
     (Source files for the TeX system) `TEXSOURCES'.

`.tfm'
     (TeX font metrics, *note Metric files: (dvips)Metric files.)
     `TFMFONTS', `TEXFONTS'; dynamic creation program: `MakeTeXTFM'.

`(none)'
     (Troff fonts, used by DMP; *note DMP invocation: (web2c)DMP
     invocation.) `TRFONTS'.

`.pfa'
     (Type 1 PostScript outline fonts, *note Glyph files: (dvips)Glyph
     files.) `T1FONTS', `T1INPUTS', `TEXPSHEADERS', `DVIPSHEADERS';
     additional suffix: `.pfb'.

`.vf'
     (virtual fonts, *note Virtual fonts: (dvips)Virtual fonts.)
     `VFFONTS', `TEXFONTS'.

`(none)'
     (Dvips `config.*' files, such as `config.ps', *note Config files:
     (dvips)Config files.) `TEXCONFIG'.

  If an environment variable by these names are set, the corresponding
`texmf.cnf' definition won't be looked at (unless, as usual, the
environment variable value has an extra `:').  *Note Default
expansion::.

  For the font variables, the intent is that:
   * `TEXFONTS' is the default for everything.

   * `GLYPHFONTS' is the default for bitmap (or, more precisely,
     non-metric) files.

   * Each font format has a variable of its own.

   * Each program has its own font override path as well; e.g.,
     `DVIPSFONTS' for Dvipsk.  Again, this is for bitmaps, not metrics.


File: kpathsea.info,  Node: File lookup,  Next: Glyph lookup,  Prev: Supported file formats,  Up: TeX support

File lookup
===========

  This section describes how Kpathsea searches for most files (bitmap
font searches are the exception, as described in the next section).

  Here is the search strategy for a file NAME:
  1. If NAME has a suffix, search for exactly NAME along the
     appropriate path.  Example: given `foo.sty', look for `foo.sty'
     before `foo.sty.tex', even though it's a TeX input file.

  2. If the file format defines a default suffix, and the suffix of
     NAME is not already that default, try appending the default.
     Example: given `foo.bar', search for `foo.bar.tex'.  But if given
     `foo.tex', don't bother to search for `foo.tex.tex'.

  3. If we're searching for a TFM, PK, or GF file, look for aliases of
     NAME in `texfonts.map' files (*note Fontmap::.).  Example: given
     `Times-Roman', find `ptmr'.

  4. If the file format defines a program to invoke to create missing
     files, run it (*note MakeTeX scripts::.).

  5. Search for NAME itself, if we haven't done so already.  Example:
     given `foo', search for `foo'.

  This is implemented in the routine `kpse_find_file' in
`kpathsea/tex-file.c'.  You can watch it in action with the debugging
options (*note Debugging::.).


File: kpathsea.info,  Node: Glyph lookup,  Next: Suppressing warnings,  Prev: File lookup,  Up: TeX support

Glyph lookup
============

  This section describes how Kpathsea searches for a bitmap font in GF
or PK format (or either) given a font name (e.g., `cmr10') and a
resolution (e.g., 600).

  Here is an outline of the search strategy (details in the sections
below) for a file NAME at resolution DPI.  The search stops at the
first successful lookup.

  1. Look for an existing file NAME.DPIFORMAT in the specified
     format(s).

  2. If NAME is an alias for a file F in the fontmap file
     `texfonts.map', look for F.DPI.

  3. Run an external program (typically named `MakeTeXPK') to generate
     the font (*note MakeTeX scripts::.)

  4. Look for FALLBACK.DPI, where FALLBACK is some last-resort font
     (typically `cmr10').

  This is implemented in `kpse_find_glyph_format' in
`kpathsea/tex-glyph.c'.

* Menu:

* Basic glyph lookup::          Features common to all glyph lookups.
* Fontmap::                     Aliases for fonts.
* Fallback font::               Resolutions and fonts of last resort.


File: kpathsea.info,  Node: Basic glyph lookup,  Next: Fontmap,  Up: Glyph lookup

Basic glyph lookup
------------------

  When Kpathsea looks for a bitmap font NAME at resolution DPI in a
format FORMAT, it first checks each directory in the search path for a
file `NAME.DPIFORMAT'; for example, `cmr10.600pk'.  Kpathsea looks for
a PK file first, then a GF file.

  If that fails, Kpathsea looks for `dpiDPI/NAME.FORMAT'; for example,
`dpi600/cmr10.pk'. This is how fonts are typically stored on
filesystems (such as DOS) that permit only three-character extensions.

  If that fails, Kpathsea looks for a font with a close-enough DPI.
"Close enough" is defined by the macro `KPSE_BITMAP_TOLERANCE' in
`kpathsea/tex-glyph.h' to be `DPI / 500 + 1'.  This is slightly more
than the 0.2% minimum allowed by the DVI standard
(`CTAN:/dviware/driv-standard/level-0').


File: kpathsea.info,  Node: Fontmap,  Next: Fallback font,  Prev: Basic glyph lookup,  Up: Glyph lookup

Fontmap
-------

  If a bitmap font or metric file is not found with the original name
(see the previous section), Kpathsea looks through any "fontmap" files
for an "alias" for the original font name.  These files are named
`texfonts.map' and searched for along the `TEXFONTMAPS'
environment/config file variable.  All `texfonts.map' files that are
found are read; earlier definitions override later ones.

  This feature is intended to help in two respects:

  1. An alias name is limited in length only by available memory, not
     by your filesystem.  Therefore, if you want to ask for
     `Times-Roman' instead of `ptmr', you can (you get `ptmr8r').

  2. A few fonts have historically had multiple names: specifically,
     LaTeX's "circle font" has variously been known as `circle10',
     `lcircle10', and `lcirc10'.  Aliases can make all the names
     equivalent, so that it no longer matters what the name of the
     installed file is; TeX documents will find their favorite name.


  The format of fontmap files is straightforward:

   * Comments start with `%' and continue to the end of the line.

   * Blank lines are ignored.

   * Each nonblank line is broken up into a series of "words":   a
     sequence of non-whitespace characters.

   * If the first word is `include', the second word is used as   a
     filename, and it is searched for and read.

   * Otherwise, the first word on each line is the true filename;

   * the second word is the alias;

   * subsequent words are ignored.

  If an alias has an extension, it matches only those files with that
extension; otherwise, it matches anything with the same root, regardless
of extension.  For example, an alias `foo.tfm' matches only when
`foo.tfm' is being searched for; but an alias `foo' matches `foo.vf',
`foo.600pk', etc.

  As an example, here is an excerpt from the `texfonts.map' in the
Web2c distribution.  It makes the circle fonts equivalent and includes
automatically generated maps for most PostScript fonts available from
various font suppliers.

     circle10        lcircle10
     circle10        lcirc10
     lcircle10       circle10
     lcircle10       lcirc10
     lcirc10         circle10
     lcirc10         lcircle10
     ...
     include adobe.map
     include apple.map
     include bitstrea.map
     ...

  Fontmaps are implemented in the file `kpathsea/fontmap.c'.  The
Fontname distribution has much more information on font naming (*note
Introduction: (fontname)Introduction.).


File: kpathsea.info,  Node: Fallback font,  Prev: Fontmap,  Up: Glyph lookup

Fallback font
-------------

  If a bitmap font cannot be found or created at the requested size,
Kpathsea looks for the font at a set of "fallback resolutions".  You
specify these resolutions as a colon-separated list (like search paths).
Kpathsea looks first for a program-specific environment variable (e.g.,
`DVIPSSIZES' for Dvipsk), then the environment variable `TEXSIZES',
then a default specified at compilation time (the Make variable
`default_texsizes').  You can set this list to be empty if you prefer
to find fonts at their stated size or not at all.

  Finally, if the font cannot be found even at the fallback resolutions,
Kpathsea looks for a fallback font, typically `cmr10'.  Programs must
enable this feature by assigning to the global variable
`kpse_fallback_font' or calling `kpse_init_prog' (*note Calling
sequence::.); the default is no fallback font.


File: kpathsea.info,  Node: Suppressing warnings,  Prev: Glyph lookup,  Up: TeX support

Suppressing warnings
====================

  Kpathsea provides a way to suppress selected usually-harmless
warnings; this is useful at large sites where most users are not
administrators, and thus the warnings are merely a source of confusion,
not a help.  To do this, you set the environment variable or
configuration file value `TEX_HUSH' to a colon-separated list of
values.  Here are the possibilities:

`all'
     Suppress everything possible.

`checksum'
     Suppress mismatched font checksum warnings.

`lostchar'
     Suppress warnings when a character is missing from a font that a
     DVI or VF file tries to typeset.

`readable'
     Suppress warnings about attempts to access a file whose permissions
     render it unreadable.

`special'
     Suppresses warnings about an unimplemented or unparsable
     `\special' command.

`tex-hush.c' defines the function that checks the variable value.  Each
driver implements its own checks where appropriate.


File: kpathsea.info,  Node: Programming,  Next: Index,  Prev: TeX support,  Up: Top

Programming
***********

  This chapter is for programmers who wish to use Kpathsea.  *Note
Introduction::, for the conditions under which you may do so.

* Menu:

* Overview: Programming overview.         Introduction.
* Calling sequence::                      Specifics of what to call.
* Config: Programming with config files.  Getting info from texmf.cnf.


File: kpathsea.info,  Node: Programming overview,  Next: Calling sequence,  Up: Programming

Programming overview
====================

  Aside from this manual, your best source of information is the source
to the programs I've modified to use Kpathsea (*note Introduction::.).
Of those, Dviljk is probably the simplest, and hence a good place to
start.  Xdvik adds VF support and the complication of X resources.
Dvipsk adds the complication of its own config files.  Web2c is source
code I also maintain, so it uses Kpathsea rather straightforwardly, but
is of course complicated by the Web to C translation.  Finally,
Kpsewhich is a small utility program whose sole purpose is to exercise
the main path-searching functionality.

  Beyond these examples, the `.h' files in the Kpathsea source describe
the interfaces and functionality (and of course the `.c' files define
the actual routines, which are the ultimate documentation).
`pathsearch.h' declares the basic searching routine.  `tex-file.h' and
`tex-glyph.h' define the interfaces for looking up particular kinds of
files.  You may wish to use `#include <kpathsea/kpathsea.h>', which
includes every Kpathsea header.

  The library provides no way for an external program to register new
file types: `tex-file.[ch]' must be modified to do this. For example,
Kpathsea has support for looking up Dvips config files, even though no
program other than Dvips will likely ever want to do so.  I felt this
was acceptable, since along with new file types should also come new
defaults in `texmf.cnf' (and its descendant `paths.h'), since it's
simplest for users if they can modify one configuration file for all
kinds of paths.

  Kpathsea does not parse any formats itself; it barely opens any files.
Its primary purpose is to return filenames.  The GNU font utilities does
contain libraries to read TFM, GF, and PK files, as do the programs
above, of course.


File: kpathsea.info,  Node: Calling sequence,  Next: Programming with config files,  Prev: Programming overview,  Up: Programming

Calling sequence
================

  The typical way to use Kpathsea in your program goes something like
this:

  1. Call `kpse_set_progname' with `argv[0]'; This is the only
     initialization that is mandatory to take full advantage of
     Kpathsea--specifically, for the `.PROGRAM' feature of config files
     (*note Config files::.).

     If necessary, `kpse_set_progname' sets the global variables
     `program_invocation_name' and `program_invocation_short_name'.
     These variables are used in the error message macros defined in
     `kpathsea/lib.h'.  It also initializes debugging options based on
     the environment variable `KPATHSEA_DEBUG' (if that is set).
     Finally, it sets the variables `SELFAUTOLOC', `SELFAUTODIR' and
     `SELFAUTOPARENT' to the location, parent and grandparent directory
     of the executable, removing `.' and `..' path elements and
     resolving symbolic links.  These are used in the default
     configuration file to allow people to invoke TeX from anywhere,
     specifically from a mounted CD-ROM.  (You can use
     `--expand-var=\$SELFAUTOLOC', etc., to see the values finds.)

  2. Set debugging options. *Note Debugging::.  If your program doesn't
     have a debugging option already, you can define one and set
     `kpathsea_debug' to the number that the user supplies (as in Dviljk
     and Web2c), or you can just omit this altogether (people can
     always set `KPATHSEA_DEBUG').  If you do have runtime debugging
     already, you need to merge Kpathsea's options with yours (as in
     Dvipsk and Xdvik).

  3. If your program has its own configuration files that can define
     search paths, you should assign those paths to the `client_path'
     member in the appropriate element of the `kpse_format_info' array.
     (This array is indexed by file type; see `tex-file.h'.)  See
     `resident.c' in Dvipsk for an example.

  4. Call `kpse_init_prog' (see `proginit.c'). It's useful for the DVI
     drivers, at least, but for other programs it may be simpler to
     extract the parts of it that actually apply.  This does not
     initialize any paths, it just looks for (and sets) certain
     environment variables and other random information.  (A search
     path is always initialized at the first call to find a file of
     that type; this eliminates much useless work, e.g., initializing
     the BibTeX search paths in a DVI driver.)

  5. The routine to actually find a file of type FORMAT is
     `kpse_find_FORMAT', defined in `tex-file.h'. These are macros that
     expand to a call to `kpse_find_file'.  You can call, say,
     `kpse_find_tfm' after doing only the first of the initialization
     steps above--Kpathsea automatically reads the `texmf.cnf' generic
     config files, looks for environment variables, and does expansions
     at the first lookup.

  6. To find PK and/or GF bitmap fonts, the routines are `kpse_find_pk',
     `kpse_find_gf' and `kpse_find_glyph', defined in `tex-glyph.h'.
     These return a structure in addition to the resultant filename,
     because fonts can be found in so many ways. See the documentation
     in the source.

  7. To actually open a file, not just return a filename, call
     `kpse_open_file'.  This function takes the name to look up and a
     Kpathsea file format as arguments, and returns the usual `FILE *'.
     It always assumes the file must exist, and thus will search the
     disk if necessary (unless the search path specified `!!', etc.).
     In other words, if you are looking up a VF or some other file that
     need not exist, don't use this.


  Kpathsea also provides many utility routines. Some are generic: hash
tables, memory allocation, string concatenation and copying, string
lists, reading input lines of arbitrary length, etc. Others are
filename-related: default path, tilde, and variable expansion, `stat'
calls, etc. (Perhaps someday I'll move the former to a separate
library.)

  The `c-*.h' header files can also help your program adapt to many
different systems.  You will almost certainly want to use Autoconf for
configuring your software if you use Kpathsea; I strongly recommend
using Autoconf regardless.  It is available from
`ftp://prep.ai.mit.edu/pub/gnu/'.


File: kpathsea.info,  Node: Programming with config files,  Prev: Calling sequence,  Up: Programming

Programming with config files
=============================

  You can (and probably should) use the same `texmf.cnf' configuration
file that Kpathsea uses for your program.  This helps installers by
keeping all configuration in one place.

  To retrieve a value VAR from config files, the best way is to call
`kpse_var_value' on the string `VAR'.  This will look first for an
environment variable VAR, then a config file value.  The result will be
the value found or `NULL'.  This function is declared in
`kpathsea/variable.h'.  For an example, see the `shell_escape' code in
`web2c/lib/texmfmp.c'.

  The routine to do variable expansion in the context of a search path
(as opposed to simply retrieving a value) is `kpse_var_expand', also
declared in `kpathsea/variable.h'.  It's generally only necessary to
set the search path structure components as explained in the previous
section, rather than using this yourself.

  If for some reason you want to retrieve a value *only* from a config
file, not automatically looking for a corresponding environment
variable, call `kpse_cnf_get' (declared in `kpathsea/cnf.h') with the
string VAR.

  No initialization calls are needed.

