@echo off
echo Configuring GNU Bash 4.2.53 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set HTML=enabled
if not "%HTML%" == "enabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set DBG=enabled
if not "%DBG%" == "enabled" goto SmallEnv
set MALLOC=enabled
if not "%MALLOC%" == "enabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto HTMLOption
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
:HTMLOption
if "%1" == "withhtml" goto NextArgument
if "%1" == "withHTML" goto NextArgument
if "%1" == "WITHHTML" goto NextArgument
if "%1" == "withouthtml" goto _WithoutHTML
if "%1" == "withoutHTML" goto _WithoutHTML
if "%1" == "WITHOUTHTML" goto _WithoutHTML
goto SilentOption
:_WithoutHTML
if "%1" == "withouthtml" set HTML=disabled
if "%1" == "withoutHTML" set HTML=disabled
if "%1" == "WITHOUTHTML" set HTML=disabled
if not "%HTML%" == "disabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto DbgOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:DbgOption
if "%1" == "dbg" goto NextArgument
if "%1" == "DBG" goto NextArgument
if "%1" == "no-dbg" goto NoDBG
if "%1" == "no-DBG" goto NoDBG
if "%1" == "NO-DBG" goto NoDBG
goto MallocOption
:NoDBG
if "%1" == "no-dbg" set DBG=disabled
if "%1" == "no-DBG" set DBG=disabled
if "%1" == "NO-DBG" set DBG=disabled
if not "%DBG%" == "disabled" goto SmallEnv
goto NextArgument
:MallocOption
if "%1" == "malloc" goto NextArgument
if "%1" == "MALLOC" goto NextArgument
if "%1" == "no-malloc" goto NoMALLOC
if "%1" == "no-MALLOC" goto NoMALLOC
if "%1" == "NO-MALLOC" goto NoMALLOC
goto SrcDirOption
:NoMALLOC
if "%1" == "no-malloc" set MALLOC=disabled
if "%1" == "no-MALLOC" set MALLOC=disabled
if "%1" == "NO-MALLOC" set MALLOC=disabled
if not "%MALLOC%" == "disabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"              echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"              echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"  echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled" echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"      echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"     echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"       echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"      echo --without-libintl-prefix >> args
if "%HTML%" == "enabled"                 echo --enable-html >> args
if "%HTML%" == "disabled"                echo --disable-html >> args
if "%SILENT%" == "enabled"               echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"              echo --disable-silent-rules >> args
if "%DBG%" == "enabled"                  echo --enable-debugger >> args
if "%DBG%" == "disabled"                 echo --disable-debugger >> args
if "%MALLOC%" == "enabled"               echo --with-bash-malloc >> args
if "%MALLOC%" == "disabled"              echo --without-bash-malloc >> args
if not "%ARGS%" == ""                    echo %ARGS% >> args

echo --prefix=/dev/env/DJDIR >> args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set HTML=
set SILENT=
set DBG=
set MALLOC=


if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./configure
dtou ./configure
touch -r configure.org ./configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config.h %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/configh.in %XSRC%/config.h-in
test -f %XSRC%/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/config_h.in %XSRC%/config.h-in
test -f %XSRC%/lib/config.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/config.h.in %XSRC%/lib/config.h-in
test -f %XSRC%/lib/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/config.h %XSRC%/lib/config.h-in
test -f %XSRC%/lib/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/configh.in %XSRC%/lib/config.h-in
test -f %XSRC%/lib/config.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/config_h.in %XSRC%/lib/config.h-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.am-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.in-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/build-aux/snippet/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/build-aux/snippet/c++defs.h %XSRC%/build-aux/snippet/cxxdefs.h
test -f %XSRC%/lib/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/c++defs.h %XSRC%/lib/cxxdefs.h
test -f %XSRC%/tests/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/tests/c++defs.h %XSRC%/tests/cxxdefs.h
test -f %XSRC%/gnulib-tests/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/gnulib-tests/c++defs.h %XSRC%/gnulib-tests/cxxdefs.h
test -f %XSRC%/pathnames.h.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/pathnames.h.in %XSRC%/pathnames.h-in
test -f %XSRC%/pathnames.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pathnames.h %XSRC%/pathnames.h-in
test -f %XSRC%/pathnames.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pathnamesh.in %XSRC%/pathnames.h-in
test -f %XSRC%/pathnames.h-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/pathnames_h.in %XSRC%/pathnames.h-in
:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/bash.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/bash..in %XSRC%/man/bash.-in
:test -f %XSRC%/man/bash.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/bash. %XSRC%/man/bash.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

::Rem Update libtool files
::echo Updating libtool scripts...
::test -f %XSRC%/build-aux/ltmain.org
::if errorlevel 1 update %XSRC%/build-aux/ltmain.sh %XSRC%/build-aux/ltmain.org
::sed -f %XSRC%/djgpp/ltmain.sed %XSRC%/build-aux/ltmain.org > ltmain.tmp
::if errorlevel 1 goto Sed6Error
::dtou ltmain.tmp
::mv -f ltmain.tmp %XSRC%/build-aux/ltmain.sh

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/bash.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls --without-included-gettext >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles
echo Editing config.h...
test -f ./config.h
if errorlevel 1 goto InLibDir
:test -f ./config_h.org
:if errorlevel 1 update ./config.h ./config_h.org
update ./config.h ./config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./config_h.org > config.h
if errorlevel 1 goto Sed2Error
echo Done.
goto NextEdit
:InLibDir
:test -f ./lib/config_h.org
:if errorlevel 1 update ./lib/config.h ./lib/config_h.org
update ./lib/config.h ./lib/config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./lib/config_h.org > config.h
if errorlevel 1 goto Sed2Error
mv config.h ./lib/config.h
echo Done.

:NextEdit
echo Editing Makefile...
:test -f ./Makefile.org
:if errorlevel 1 update ./Makefile ./Makefile.org
update ./Makefile ./Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./Makefile.org > Makefile.tmp
if errorlevel 1 goto Sed3Error
mv Makefile.tmp ./Makefile
echo Done.

echo Editing doc/Makefile...
update ./doc/Makefile ./doc/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./doc/Makefile.org > Makefile.doc
if errorlevel 1 goto Sed4Error
mv Makefile.doc ./doc/Makefile
echo Done.

echo Editing lib/glob/Makefile...
:test -f ./lib/glob/Makefile.org
:if errorlevel 1 update ./lib/glob/Makefile ./lib/glob/Makefile.org
update ./lib/glob/Makefile ./lib/glob/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/glob/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed5Error
mv Makefile.lib ./lib/glob/Makefile
echo Done.

echo Editing lib/intl/Makefile...
:test -f ./lib/intl/Makefile.org
:if errorlevel 1 update ./lib/intl/Makefile ./lib/intl/Makefile.org
update ./lib/intl/Makefile ./lib/intl/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/intl/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed6Error
mv Makefile.lib ./lib/intl/Makefile
echo Done.

echo Editing lib/malloc/Makefile...
:test -f ./lib/malloc/Makefile.org
:if errorlevel 1 update ./lib/malloc/Makefile ./lib/malloc/Makefile.org
update ./lib/malloc/Makefile ./lib/malloc/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/malloc/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed7Error
mv Makefile.lib ./lib/malloc/Makefile
echo Done.

echo Editing lib/readline/Makefile...
:test -f ./lib/readline/Makefile.org
:if errorlevel 1 update ./lib/readline/Makefile ./lib/readline/Makefile.org
update ./lib/readline/Makefile ./lib/readline/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/readline/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed8Error
mv Makefile.lib ./lib/readline/Makefile
echo Done.

echo Editing lib/sh/Makefile...
:test -f ./lib/sh/Makefile.org
:if errorlevel 1 update ./lib/sh/Makefile ./lib/sh/Makefile.org
update ./lib/sh/Makefile ./lib/sh/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/sh/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed9Error
mv Makefile.lib ./lib/sh/Makefile
echo Done.

echo Editing lib/termcap/Makefile...
:test -f ./lib/termcap/Makefile.org
:if errorlevel 1 update ./lib/termcap/Makefile ./lib/termcap/Makefile.org
update ./lib/termcap/Makefile ./lib/termcap/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/termcap/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed10Error
mv Makefile.lib ./lib/termcap/Makefile
echo Done.

echo Editing lib/tilde/Makefile...
:test -f ./lib/tilde/Makefile.org
:if errorlevel 1 update ./lib/tilde/Makefile ./lib/tilde/Makefile.org
update ./lib/tilde/Makefile ./lib/tilde/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./lib/tilde/Makefile.org > Makefile.lib
if errorlevel 1 goto Sed11Error
mv Makefile.lib ./lib/tilde/Makefile
echo Done.

echo Editing builtins/Makefile...
:test -f ./builtins/Makefile.org
:if errorlevel 1 update ./builtins/Makefile ./builtins/Makefile.org
update ./builtins/Makefile ./builtins/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./builtins/Makefile.org > Makefile.tmp
if errorlevel 1 goto Sed12Error
mv Makefile.tmp ./builtins/Makefile
echo Done.

echo Editing support/Makefile...
:test -f ./support/Makefile.org
:if errorlevel 1 update ./support/Makefile ./support/Makefile.org
update ./support/Makefile ./support/Makefile.org
sed -f %XSRC%/djgpp/Makefile.sed ./support/Makefile.org > Makefile.tmp
if errorlevel 1 goto Sed13Error
mv Makefile.tmp ./support/Makefile
echo Done.

::echo Editing tests/Makefile...
::update ./tests/Makefile ./tests/Makefile.org
::sed "/^PATH_SEPARATOR[ 	]*=/ s/:$/;/" ./tests/Makefile.org > Makefile.tst
::if errorlevel 1 goto Sed5Error
::mv Makefile.tst ./tests/Makefile
::echo Done.

echo Fixing test scripts...
find %XSRC%/tests -name "run-*" > files.tmp
find %XSRC%/tests -name "array.tests" >> files.tmp
find %XSRC%/tests -name "assoc.tests" >> files.tmp
find %XSRC%/tests -name "builtins.tests" >> files.tmp
find %XSRC%/tests -name "builtins1.sub" >> files.tmp
find %XSRC%/tests -name "dstack.tests" >> files.tmp
find %XSRC%/tests -name "dstack2.sub" >> files.tmp
find %XSRC%/tests -name "read.tests" >> files.tmp
find %XSRC%/tests -name "test.tests" >> files.tmp
find %XSRC%/tests -name "type.tests" >> files.tmp
:sed "/misc/d;s|^.*/run|sed \x22s/FILENAME/run|;s|^.*/read|sed \x22s/FILENAME/read|;s|$|/g\x22 testsfix.t2 \x3E\x3E testsfix.t3|" files.tmp > creatfix.bat
echo "/misc/d" > script.txt
echo "s|^.*/run|sed \x22s/FILENAME/run|" >> script.txt
echo "s|^.*/assoc|sed \x22s/FILENAME/assoc|" >> script.txt
echo "s|^.*/array|sed \x22s/FILENAME/array|" >> script.txt
:echo "s|^.*/builtins1|sed \x22s/FILENAME/builtins1|" >> script.txt
echo "s|^.*/builtins|sed \x22s/FILENAME/builtins|" >> script.txt
echo "s|^.*/dstack|sed \x22s/FILENAME/dstack|" >> script.txt
echo "s|^.*/read|sed \x22s/FILENAME/read|" >> script.txt
echo "s|^.*/test|sed \x22s/FILENAME/test|" >> script.txt
echo "s|^.*/type|sed \x22s/FILENAME/type|" >> script.txt
echo "s|$|/g\x22 testsfix.t2 \x3E\x3E testsfix.t3|" >> script.txt
echo "" >> script.txt
sed "s/\x22//g;s/[\x09\x20]*$//" script.txt > script.sed
sed -f script.sed files.tmp > creatfix.bat

echo "test -f %XSRC%/tests/_FILENAME.org" > testsfix.t1
echo "if errorlevel 1 update %XSRC%/tests/FILENAME %XSRC%/tests/_FILENAME.org" >> testsfix.t1
echo "sed -f %XSRC%/djgpp/testsfix.sed %XSRC%/tests/_FILENAME.org > FILENAME.tmp" >> testsfix.t1
echo "if errorlevel 1 goto SedError" >> testsfix.t1
echo "dtou FILENAME.tmp" >> testsfix.t1
echo "mv -f FILENAME.tmp %XSRC%/tests/FILENAME" >> testsfix.t1
sed "s/\x22//g;s/[\x09\x20]*$//" testsfix.t1 > testsfix.t2

rm -f testsfix.bat
call creatfix.bat
sed "$a\goto End\n\n\n:SedError\necho tests script editing failed!\n\n:End" testsfix.t3 > testsfix.bat
::call testsfix.bat
rm -f testsfix.* creatfix.bat files.tmp script.*

Rem Create po/LINGUAS file or the build fails.
update %XSRC%/po/LINGUAS ./po/LINGUAS
goto End

:Sed1Error
echo ./configure script editing failed!
goto End

:Sed2Error
echo config.h fixing failed!
goto End

:Sed3Error
echo Makefile fixing failed!
goto End

:Sed4Error
echo doc/Makefile fixing failed!
goto End

:Sed5Error
echo lib/glob/Makefile fixing failed!
goto End

:Sed6Error
echo lib/intl/Makefile fixing failed!
goto End

:Sed7Error
echo lib/malloc/Makefile fixing failed!
goto End

:Sed8Error
echo lib/readline/Makefile fixing failed!
goto End

:Sed9Error
echo lib/sh/Makefile fixing failed!
goto End

:Sed10Error
echo lib/termcap/Makefile fixing failed!
goto End

:Sed11Error
echo lib/tilde/Makefile fixing failed!
goto End

:Sed12Error
echo builtins/Makefile fixing failed!
goto End

:Sed13Error
echo support/Makefile fixing failed!
goto End


:Sed55Error
echo tests/Makefile fixing failed!
goto End

:::Sed6Error
::echo ./ltmain.sh editing failed!
::goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set SILENT=
set DBG=
set MALLOC=
set XSRC=
