# sed script for additional DJGPP specific editing of ltmain.sh.

# For some reason the function does not work with bash 2.05b.
/^func_lalib_p/,/^}$/ {
  /test/ i\
    case \$1 in\
    *.la | *.lo)
  /SED/ {
    s/$/;;/
    a\
    *) false;;\
    esac
  }
}

# Use func_lalib_p instead of func_lalib_unsafe_p.
/func_lalib_unsafe_p[ 	][^(]/ s/_unsafe//

# Adjust temp directory.
/{TMPDIR-\/tmp}/ s|{TMPDIR-/tmp}|{TMPDIR-${TMP-${TEMP-.}}}|

# Remove -lc reference from the "dependency_libs=" line in .la files.
# This is unnecessary when linking with static labraries and causes
# multiple symbol definitions that cannot be resolved when using DXE3 modules.
/^# Libraries that this one depends upon.$/,/^# Directory that this library needs to be installed in:$/ {
  /^# Directory that this library needs to be installed in:$/ {
    n
    a\
	  sed "/^dependency_libs=/ s|[ 	]\\{1,\\}-lc| |"  $output > fixed.sed && cp -vf fixed.sed $output
  }
}

# Replace (command) > /dev/null with `command > /dev/null`, since
# parenthesized commands always return zero status in the ported Bash,
# even if the named command doesn't exist
/^func_extract_an_archive/,/^}$/ {
  /.*if[ 	](/ {
    s/(/`/
    s/)/`/
  }
}
