#! /bin/sh
#
# This scripts
# 1) unpacks MPFR source archive (tar.gz or tar.bz2)
# 2) generates DJGPP source archive with configured sources
# 3) builds MPFR and run tests
# 4) generates DJGPP binary package of MPFR.
#
# It is not intended for building MPFR from mpfr221s.zip
# even when it is included there.
#
set -x
name=mpfr
version=4.1.0
email="Andris Pavenis <andris.pavenis@iki.fi>"

top=`pwd`

gcc -v -O2 -x c - -o gmpver__.exe -lgmp -lm <<'EOF'
#include <stdio.h>
#include <gmp.h>
int main(void) { printf("%s\n", gmp_version); return 0; }
EOF

test -f gmpver__.exe || exit 1
gmp_ver=$(./gmpver__.exe)
gcc_ver=$(gcc --version | head -1 | awk '{print $3}')
rm -f gmpver__.exe

mkdir -p gnu || exit 1

rm -rf gnu/mpfr-*

if [ -f $name-$version.tar.bz2 ] ; then
  bzip2 -cd $name-$version.tar.bz2 | ( cd gnu && tar x ) || exit 1
else
  if [ -f $name-$version.tar.xz ] ; then
     xz -cd $name-$version.tar.xz | ( cd gnu && tar x ) || exit 1
  else
     echo MPFR source archive is not found
     exit 1
  fi
fi

djver1=`echo $version | sed -e 's:\.::2g'`
djver2=`echo $version | sed -e 's:\.::g'`
srcdir=$top/gnu/$name-$djver1

if test x"$djver1" != x"$version"; then
  mv -v gnu/$name-$version $srcdir
fi

#( cd $srcdir && aclocal && autoconf || exit 1 )

# Workaround bug in autoconf-2.63
sed -e 's:\\\\r:\\r:g' $srcdir/configure >$srcdir/configure.new
diff -u $srcdir/configure $srcdir/configure.new
mv -fv $srcdir/configure.new $srcdir/configure

( cd $srcdir && ./configure i386-pc-msdosdjgpp --disable-thread-safe --disable-dependency-tracking )

#
# Write README file for DJGPP to the source directory
#
cat >gnu/$name-$djver1/readme.djgpp <<EOF
This is DJGPP port of MPFR-$version.

The MPFR library is a C library for multiple-precision floating-point
computations with correct rounding. MPFR requires GMP for use. It is also
required to install MPFR after GMP, as it may replaces part of GMP files

See README and http://www.mpfr.org for more information.

Building from sources
=====================

LFN support is required for building MPFR for DJGPP. I built MPFR
using GCC-$gcc_ver under Windows Vista Business SP2. DJGPP port of GMP-$gmp_ver
were used when building MPFR-$version. One may need to to rebuild MPFR
if different enough GMP version is being used. 

Sources in mpfr${djver2}s.zip are preconfigured for target i386-pc-msdosdjgpp.
Simply running configure script with needed parameters should be enough
to reconfigure if needed.

To build MPFR run 'make'.

To run tests of the MPFR, run 'make check'

To install MPFR run 'make install prefix=where_to_install' (replace
'where_to_install' with real value).

$email
EOF

#
# Write script for building binary packets for DJGPP to the source directory
#
sed -e "s:@NAME@:$name:" -e "s:@VERSION@:$version:g" >$srcdir/makepkg.sh <<'EOF'
#! /bin/sh

name=@NAME@
version=@VERSION@

djver1=`echo $version | sed -e 's:\.::2g'`
djver2=`echo $version | sed -e 's:\.::g'`
dname=$name-$djver1

rm -rf inst.djg
make all check
make check >check.log 2>&1
make install prefix=`pwd`/inst.djg

mkdir -p inst.djg/info
mkdir -p inst.djg/manifest
mkdir -p inst.djg/gnu/$dname

touch inst.djg/manifest/mpfr${djver2}b.mft

cat >inst.djg/manifest/mpfr${djver2}b.ver <<E2
mpfr${djver2}b.zip: MPFR - C library for multiple-precision floating-point computations (binaries)
E2

mv -v inst.djg/share/info/*.info inst.djg/info/
cp -v authors bugs COPYING* inst.djg/gnu/$dname/
cp -v news readme* todo inst.djg/gnu/$dname/
cp -vf check.log inst.djg/gnu/$dname/
rm -rf inst.djg/share

( cd inst.djg && find . -type f | sed -e 's:^\./::' | sort >manifest/mpfr${djver2}b.mft )
( cd inst.djg && cat manifest/mpfr${djver2}b.mft | zip -9@ ../mpfr${djver2}b.zip )
EOF

# Write also this script to the source dircetory
cat $0 >$srcdir/`basename $0`

mkdir -p manifest

cat >manifest/mpfr${djver2}s.ver <<EOF
mpfr${djver2}s.zip: MPFR - C library for multiple-precision floating-point computations (sources)
EOF

touch manifest/mpfr${djver2}s.ver

(
  cd $top
  find gnu -type f
  find manifest -name mpfr${djver2}s'.*'
) | sort >manifest/mpfr${djver2}s.mft

rm -vf mpfr${djver2}s.zip
cat manifest/mpfr${djver2}s.mft | zip -9q@ mpfr${djver2}s.zip

cd $srcdir && make all check || exit 1

cd $srcdir && ./makepkg.sh || exit 1

mv -v $srcdir/$name${djver2}b.zip $top/
