@echo off
echo Configuring GNU Sed 4.8 for DJGPP v2.5...

Rem WARNING WARNING WARNING: This file needs to have DOS CRLF end-of-line
Rem format, or else stock DOS/Windows shells will refuse to run it.

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out if NLS is wanted or not,
Rem if dependency-tracking is wanted or not,
Rem if caching is wanted or not
Rem and where the sources are.
Rem We always default to NLS support,
Rem no dependency tracking
Rem and to in place configuration.
set ARGS=
set NLS=enabled
if not "%NLS%" == "enabled" goto SmallEnv
set CACHING=enabled
if not "%CACHING%" == "enabled" goto SmallEnv
set DEPENDENCY_TRACKING=disabled
if not "%DEPENDENCY_TRACKING%" == "disabled" goto SmallEnv
set LIBICONV_PREFIX=disabled
if not "%LIBICONV_PREFIX%" == "disabled" goto SmallEnv
set LIBINTL_PREFIX=disabled
if not "%LIBINTL_PREFIX%" == "disabled" goto SmallEnv
set GNU_REGEX=enabled
if not "%GNU_REGEX%" == "enabled" goto SmallEnv
set SILENT=enabled
if not "%SILENT%" == "enabled" goto SmallEnv
set I18N=disabled
if not "%I18N%" == "disabled" goto SmallEnv
set MT=disabled
if not "%MT%" == "disabled" goto SmallEnv
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv

Rem Loop over all arguments.
Rem Special arguments are: NLS, XSRC, CACHE, STATIC_LIBS, LIBICONV_PREFIX, LIBINTL_PREFIX, GNU_REGEX and DEPS.
Rem All other arguments are stored into ARGS.
:ArgLoop
if "%1" == "nls" goto NextArgument
if "%1" == "NLS" goto NextArgument
if "%1" == "no-nls" goto NoNLS
if "%1" == "no-NLS" goto NoNLS
if "%1" == "NO-NLS" goto NoNLS
goto CachingOption
:NoNLS
if "%1" == "no-nls" set NLS=disabled
if "%1" == "no-NLS" set NLS=disabled
if "%1" == "NO-NLS" set NLS=disabled
if not "%NLS%" == "disabled" goto SmallEnv
goto NextArgument
:CachingOption
if "%1" == "cache" goto NextArgument
if "%1" == "CACHE" goto NextArgument
if "%1" == "no-cache" goto NoCaching
if "%1" == "no-CACHE" goto NoCaching
if "%1" == "NO-CACHE" goto NoCaching
goto DependencyOption
:NoCaching
if "%1" == "no-cache" set CACHING=disabled
if "%1" == "no-CACHE" set CACHING=disabled
if "%1" == "NO-CACHE" set CACHING=disabled
if not "%CACHING%" == "disabled" goto SmallEnv
goto NextArgument
:DependencyOption
if "%1" == "no-dep" goto NextArgument
if "%1" == "no-DEP" goto NextArgument
if "%1" == "NO-DEP" goto NextArgument
if "%1" == "dep" goto _DependencyTraking
if "%1" == "DEP" goto _DependencyTraking
goto LibiconvPrefixOption
:_DependencyTraking
if "%1" == "dep" set DEPENDENCY_TRACKING=enabled
if "%1" == "DEP" set DEPENDENCY_TRACKING=enabled
if not "%DEPENDENCY_TRACKING%" == "enabled" goto SmallEnv
goto NextArgument
:LibiconvPrefixOption
if "%1" == "no-libiconvprefix" goto NextArgument
if "%1" == "no-LIBICONVPREFIX" goto NextArgument
if "%1" == "NO-LIBICONVPREFIX" goto NextArgument
if "%1" == "libiconvprefix" goto WithLibiconvPrefix
if "%1" == "LIBICONVPREFIX" goto WithLibiconvPrefix
goto LibintlPrefixOption
:WithLibiconvPrefix
if "%1" == "libiconvprefix" set LIBICONV_PREFIX=enabled
if "%1" == "LIBICONVPREFIX" set LIBICONV_PREFIX=enabled
if not "%LIBICONV_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:LibintlPrefixOption
if "%1" == "no-libintlprefix" goto NextArgument
if "%1" == "no-LIBINTLPREFIX" goto NextArgument
if "%1" == "NO-LIBINTLPREFIX" goto NextArgument
if "%1" == "libintlprefix" goto _WithLibintlPrefix
if "%1" == "LIBINTLPREFIX" goto _WithLibintlPrefix
goto IncludedGnuRegexOption
:_WithLibintlPrefix
if "%1" == "libintlprefix" set LIBINTL_PREFIX=enabled
if "%1" == "LIBINTLPREFIX" set LIBINTL_PREFIX=enabled
if not "%LIBINTL_PREFIX%" == "enabled" goto SmallEnv
goto NextArgument
:IncludedGnuRegexOption
if "%1" == "gnureg" goto NextArgument
if "%1" == "GNUREG" goto NextArgument
if "%1" == "no-gnureg" goto 1WithoutIncludedGnuRegex
if "%1" == "no-GNUREG" goto 1WithoutIncludedGnuRegex
if "%1" == "NO-GNUREG" goto 1WithoutIncludedGnuRegex
goto SilentOption
:1WithoutIncludedGnuRegex
if "%1" == "no-gnureg" set GNU_REGEX=disabled
if "%1" == "no-GNUREG" set GNU_REGEX=disabled
if "%1" == "NO-GNUREG" set GNU_REGEX=disabled
if not "%GNU_REGEX%" == "disabled" goto SmallEnv
goto NextArgument
:SilentOption
if "%1" == "silent" goto NextArgument
if "%1" == "SILENT" goto NextArgument
if "%1" == "no-silent" goto NoSILENT
if "%1" == "no-SILENT" goto NoSILENT
if "%1" == "NO-SILENT" goto NoSILENT
goto I18nOption
:NoSILENT
if "%1" == "no-silent" set SILENT=disabled
if "%1" == "no-SILENT" set SILENT=disabled
if "%1" == "NO-SILENT" set SILENT=disabled
if not "%SILENT%" == "disabled" goto SmallEnv
goto NextArgument
:I18nOption
if "%1" == "i18n" goto NextArgument
if "%1" == "I18N" goto NextArgument
if "%1" == "no-i18n" goto NoI18N
if "%1" == "no-I18N" goto NoI18N
if "%1" == "NO-I18N" goto NoI18N
goto MtOption
:NoI18N
if "%1" == "no-i18n" set I18N=disabled
if "%1" == "no-I18N" set I18N=disabled
if "%1" == "NO-I18N" set I18N=disabled
if not "%I18N%" == "disabled" goto SmallEnv
goto NextArgument
:MtOption
if "%1" == "no-mt" goto NextArgument
if "%1" == "no-MT" goto NextArgument
if "%1" == "NO-MT" goto NextArgument
if "%1" == "mt" goto _MT
if "%1" == "Mt" goto _MT
if "%1" == "MT" goto _MT
goto SrcDirOption
:_MT
if "%1" == "mt" set MT=enabled
if "%1" == "Mt" set MT=enabled
if "%1" == "MT" set MT=enabled
if not "%MT%" == "enabled" goto SmallEnv
goto NextArgument
:SrcDirOption
echo %1 | grep -q "/"
if errorlevel 1 goto CollectArgument
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
goto NextArgument
:CollectArgument
set _ARGS=#%ARGS%#%1#
if not "%_ARGS%" == "#%ARGS%#%1#" goto SmallEnv
echo %_ARGS% | grep -q "###"
if errorlevel 1 set ARGS=%ARGS% %1
set _ARGS=
:NextArgument
shift
if not "%1" == "" goto ArgLoop

Rem Create an arguments file for the configure script.
echo --srcdir=%XSRC% > args
:if "%CACHING%" == "enabled"              echo --cache-file=%XSRC%/djgpp/config.cache >> args
if "%CACHING%" == "enabled"              echo --cache-file=./config.cache >> args
if "%DEPENDENCY_TRACKING%" == "enabled"  echo --enable-dependency-tracking >> args
if "%DEPENDENCY_TRACKING%" == "disabled" echo --disable-dependency-tracking >> args
if "%LIBICONV_PREFIX%" == "enabled"      echo --with-libiconv-prefix >> args
if "%LIBICONV_PREFIX%" == "disabled"     echo --without-libiconv-prefix >> args
if "%LIBINTL_PREFIX%" == "enabled"       echo --with-libintl-prefix >> args
if "%LIBINTL_PREFIX%" == "disabled"      echo --without-libintl-prefix >> args
if "%GNU_REGEX%" == "enabled"            echo --with-included-regex >> args
if "%GNU_REGEX%" == "disabled"           echo --without-included-regex >> args
if "%SILENT%" == "enabled"               echo --enable-silent-rules >> args
if "%SILENT%" == "disabled"              echo --disable-silent-rules >> args
if "%I18N%" == "enabled"                 echo --enable-i18n >> args
if "%I18N%" == "disabled"                echo --disable-i18n >> args
if "%MT%" == "enabled"                   echo --enable-threads >> args
if "%MT%" == "disabled"                  echo --disable-threads >> args
if not "%ARGS%" == ""                    echo %ARGS% >> args
echo --prefix=/dev/env/DJDIR >> args

set ARGS=
set CACHING=
set DEPENDENCY_TRACKING=
set LIBICONV_PREFIX=
set LIBINTL_PREFIX=
set GNU_REGEX=
set SILENT=
set I18N=
set MT=


if "%XSRC%" == "." goto InPlace

:NotInPlace
redir -e /dev/null update %XSRC%/configure.org ./configure
test -f ./configure
if errorlevel 1 update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
test -f ./configure.org
if errorlevel 1 update configure configure.org
sed -f %XSRC%/djgpp/config.sed configure.org > filename.ext
if errorlevel 1 goto Sed1Error
sed "/symlink /s/\x60//g" ./filename.ext > filename.out
mv -f ./filename.out ./configure
dtou ./configure
touch -r configure.org ./configure
rm -f ./filename.ext

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem Make sure crucial file names are not munged by unpacking
test -f %XSRC%/bootstrap.sh.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/bootstrap.sh.in %XSRC%/bootstrap.sh-in
test -f %XSRC%/bootstrap.sh-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/bootstrap.sh %XSRC%/bootstrap.sh-in
test -f %XSRC%/po/Makefile.am.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am.in %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.am-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.am %XSRC%/po/Makefile.am-in
test -f %XSRC%/po/Makefile.in.in
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/po/Makefile.in-in
if errorlevel 1 redir -e /dev/null mv -f %XSRC%/po/Makefile.in %XSRC%/po/Makefile.in-in
test -f %XSRC%/build-aux/snippet/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/build-aux/snippet/c++defs.h %XSRC%/build-aux/snippet/cxxdefs.h
test -f %XSRC%/lib/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/lib/c++defs.h %XSRC%/lib/cxxdefs.h
test -f %XSRC%/tests/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/tests/c++defs.h %XSRC%/tests/cxxdefs.h
test -f %XSRC%/gnulib-tests/c++defs.h
if not errorlevel 1 redir -e /dev/null mv -f %XSRC%/gnulib-tests/c++defs.h %XSRC%/gnulib-tests/cxxdefs.h
:# Beginn  Zusaetzliche zu veraendernde Dateinamen.
:test -f %XSRC%/man/sed.in
:if not errorlevel redir -e /dev/null 1 mv -f %XSRC%/man/sed..in %XSRC%/man/sed.-in
:test -f %XSRC%/man/sed.-in
:if errorlevel 1 redir -e /dev/null mv -f %XSRC%/man/sed. %XSRC%/man/sed.-in
:# Ende  Zusaetzliche zu veraendernde Dateinamen.

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set SHELL to a sane default or some configure tests stop working
Rem if the package is configured across partitions.
if not "%SHELL%" == "" goto HomeName
set SHELL=/bin/sh
if not "%SHELL%" == "/bin/sh" goto SmallEnv
echo No SHELL found in the environment, using default value

:HomeName
Rem Set HOME to a sane default so configure stops complaining.
if not "%HOME%" == "" goto HostName
set HOME=%XSRC%/djgpp
if not "%HOME%" == "%XSRC%/djgpp" goto SmallEnv
echo No HOME found in the environment, using default value

:HostName
Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
goto userdone
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set _HOSTNAME=%HOSTNAME%, %OS%
if not "%_HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
set HOSTNAME=%_HOSTNAME%
:hostdone
set _HOSTNAME=
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
test -f %XSRC%/install-sh
if not errorlevel 1 goto NoRen0
test -f %XSRC%/install-sh.sh
if not errorlevel 1 mv -f %XSRC%/install-sh.sh %XSRC%/install-sh
:NoRen0

if "%NLS%" == "disabled" goto WithoutNLS

:WithNLS
test -d %XSRC%/po
if errorlevel 1 goto WithoutNLS

Rem Check for the needed libraries and binaries.
test -x /dev/env/DJDIR/bin/msgfmt.exe
if errorlevel 1 goto MissingNLSTools
test -x /dev/env/DJDIR/bin/xgettext.exe
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libcharset.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libcharset.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/iconv.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libiconv.a
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/include/libintl.h
if errorlevel 1 goto MissingNLSTools
test -f /dev/env/DJDIR/lib/libintl.a
if errorlevel 1 goto MissingNLSTools

Rem Recreate the files in the %XSRC%/po subdir with our ported tools.
redir -e /dev/null rm %XSRC%/po/*.gmo
redir -e /dev/null rm %XSRC%/po/sed.pot
redir -e /dev/null rm %XSRC%/po/cat-id-tbl.c
redir -e /dev/null rm %XSRC%/po/stamp-cat-id

Rem Update the arguments file for the configure script.
Rem We prefer without-included-gettext because libintl.a from gettext package
Rem is the only one that is garanteed to have been ported to DJGPP.
echo --enable-nls >> args
goto ConfigurePackage

:MissingNLSTools
echo Needed DJGPP ports of the required libs/tools for NLS support not found.
echo Configuring without NLS.
:WithoutNLS
Rem Update the arguments file for the configure script.
echo --disable-nls >> args

:ConfigurePackage
echo Running the ./configure script...
sh ./configure @args
if errorlevel 1 goto RunConfigStatus
rm args
echo Done.
goto EditFiles
:RunConfigStatus
test -f ./config.status
if errorlevel 1 goto CfgError
echo Running the ./config.status script (manually)...
redir -e /dev/null sh ./config.status
if errorlevel 1 goto CfgError
rm args
echo Done.

:EditFiles
echo Editing config.h...
update ./config.h ./config_h.org
sed -f %XSRC%/djgpp/config_h.sed ./config_h.org > config.h
if errorlevel 1 goto Sed2Error
echo Done.

:echo Editing doc/Makefile...
:update ./doc/Makefile ./doc/Makefile.org
:sed "/^PATH_SEPARATOR[ 	]*=/ s/:$/;/" ./doc/Makefile.org > Makefile.doc
:if errorlevel 1 goto Sed3Error
:mv Makefile.doc ./doc/Makefile
:echo Done.

:echo Editing po/Makefile...
:update ./po/Makefile ./po/Makefile.org
:sed -e "/^PATH_SEPARATOR[ 	]*=/ s/:$/;/" -f %XSRC%/djgpp/Makefile.sed ./po/Makefile.org > Makefile.po
:if errorlevel 1 goto Sed4Error
:mv Makefile.po ./po/Makefile
:echo Done.

:echo Editing testsuite/Makefile.tests...
:update %XSRC%/testsuite/Makefile.tests %XSRC%/testsuite/Makefile.org
:sed -e "/^PATH_SEPARATOR[ 	]*=/ s/:$/;/" -f %XSRC%/djgpp/Makefile.sed %XSRC%/testsuite/Makefile.org > Makefile.tst
:if errorlevel 1 goto Sed5Error
:dtou Makefile.tst
:touch -r %XSRC%/testsuite/Makefile.tests Makefile.tst
:mv Makefile.tst %XSRC%/testsuite/Makefile.tst
:echo Done.

echo Editing Makefile...
update ./Makefile ./Makefile.org
sed -e "/^PATH_SEPARATOR[ 	]*=/ s/:$/;/" -f %XSRC%/djgpp/Makefile.sed ./Makefile.org > Makefile.tmp
if errorlevel 1 goto Sed6Error
:dtou Makefile.org
:touch -r %XSRC%/Makefile.org Makefile.tmp
mv Makefile.tmp ./Makefile
echo Done.

echo Fixing testsuite files...
echo "/^print_ver_ sed$/ a\" > script.tmp
echo "\" >> script.tmp
echo "# DJGPP specific adjustment of relative paths.\" >> script.tmp
echo "# initial_cwd_ and test_dir_ are defined by/in init.sh\" >> script.tmp
echo "if [ x$test_dir_ != x$initial_cwd_ ]; then\" >> script.tmp
echo "  rest=$(echo $test_dir_ | sed s|$initial_cwd_||)\" >> script.tmp
echo "  abs_top_srcdir=${abs_top_srcdir}$(echo $rest | sed s|/.*[^/]|/..|g)\" >> script.tmp
echo "fi" >> script.tmp
sed "s/^\x22//;s/\x22[\x20\x09]*$//;s/\xB4/\x22/g" script.tmp > script.sed

test -f %XSRC%/testsuite/8bit.org
if errorlevel 1 update %XSRC%/testsuite/8bit.sh %XSRC%/testsuite/8bit.org
sed -f script.sed %XSRC%/testsuite/8bit.org > 8bit.tmp
if errorlevel 1 goto Sed7Error
mv -f ./8bit.tmp %XSRC%/testsuite/8bit.sh

test -f %XSRC%/testsuite/binary.org
if errorlevel 1 update %XSRC%/testsuite/binary.sh %XSRC%/testsuite/binary.org
sed -f script.sed %XSRC%/testsuite/binary.org > binary.tmp
if errorlevel 1 goto Sed7Error
mv -f ./binary.tmp %XSRC%/testsuite/binary.sh

test -f %XSRC%/testsuite/bsd-wrapper.org
if errorlevel 1 update %XSRC%/testsuite/bsd-wrapper.sh %XSRC%/testsuite/bsd-wrapper.org
sed -f script.sed %XSRC%/testsuite/bsd-wrapper.org > bsd-wrapper.tmp
if errorlevel 1 goto Sed7Error
mv -f ./bsd-wrapper.tmp %XSRC%/testsuite/bsd-wrapper.sh

test -f %XSRC%/testsuite/dc.org
if errorlevel 1 update %XSRC%/testsuite/dc.sh %XSRC%/testsuite/dc.org
sed -f script.sed %XSRC%/testsuite/dc.org > dc.tmp
if errorlevel 1 goto Sed7Error
mv -f ./dc.tmp %XSRC%/testsuite/dc.sh

test -f %XSRC%/testsuite/distrib.org
if errorlevel 1 update %XSRC%/testsuite/distrib.sh %XSRC%/testsuite/distrib.org
sed -f script.sed %XSRC%/testsuite/distrib.org > distrib.tmp
if errorlevel 1 goto Sed7Error
mv -f ./distrib.tmp %XSRC%/testsuite/distrib.sh

test -f %XSRC%/testsuite/mac-mf.org
if errorlevel 1 update %XSRC%/testsuite/mac-mf.sh %XSRC%/testsuite/mac-mf.org
sed -f script.sed %XSRC%/testsuite/mac-mf.org > mac-mf.tmp
if errorlevel 1 goto Sed7Error
mv -f ./mac-mf.tmp %XSRC%/testsuite/mac-mf.sh

test -f %XSRC%/testsuite/madding.org
if errorlevel 1 update %XSRC%/testsuite/madding.sh %XSRC%/testsuite/madding.org
sed -f script.sed %XSRC%/testsuite/madding.org > madding.tmp
if errorlevel 1 goto Sed7Error
mv -f ./madding.tmp %XSRC%/testsuite/madding.sh

test -f %XSRC%/testsuite/uniq.org
if errorlevel 1 update %XSRC%/testsuite/uniq.sh %XSRC%/testsuite/uniq.org
sed -f script.sed %XSRC%/testsuite/uniq.org > uniq.tmp
if errorlevel 1 goto Sed7Error
mv -f ./uniq.tmp %XSRC%/testsuite/uniq.sh

test -f %XSRC%/testsuite/xemacs.org
if errorlevel 1 update %XSRC%/testsuite/xemacs.sh %XSRC%/testsuite/xemacs.org
sed -f script.sed %XSRC%/testsuite/xemacs.org > xemacs.tmp
if errorlevel 1 goto Sed7Error
mv -f ./xemacs.tmp %XSRC%/testsuite/xemacs.sh
rm -f script.sed script.tmp
echo Done.

echo Fixing testsuite/init.sh
test -f %XSRC%/testsuite/init_sh.org
if errorlevel 1 update %XSRC%/testsuite/init.sh %XSRC%/testsuite/init_sh.org
sed -f %XSRC%/djgpp/init_sh.sed %XSRC%/testsuite/init_sh.org > init.tmp
if errorlevel 1 goto initError
mv -f ./init.tmp %XSRC%/testsuite/init.sh
echo Done.
goto End


:Sed1Error
echo ./configure script editing failed!
goto End

:Sed2Error
echo config.h fixing failed!
goto End

:Sed3Error
echo ./doc/Makefile fixing failed!
goto End

:Sed4Error
echo ./po/Makefile fixing failed!
goto End

:Sed5Error
echo ./testsuite/Makefile.tests fixing failed!
goto End

:Sed6Error
echo Makefile fixing failed!
goto End

:Sed7Error
echo Testsuite files fixing failed!
goto End

:initError
echo %XSRC%/testsuite/init.sh editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!

:End
test -f %XSRC%/install-sh.sh
if not errorlevel 1 goto NoRen1
test -f %XSRC%/install-sh
if not errorlevel 1 mv -f %XSRC%/install-sh %XSRC%/install-sh.sh
:NoRen1
if "%SHELL%" == "/bin/sh" set SHELL=
if "%HOME%" == "%XSRC%/djgpp" set HOME=
set ARGS=
set CONFIG_SITE=
set HOSTNAME=
set NLS=
set CACHING=
set DEPENDENCY_TRACKING=
set SILENT=
set I18N=
set MT=
set XSRC=
