/* debug.c -- debug routines
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

#ifdef DBG
char _DebugString[LARGE_BUF_SIZE]; 
char _DebugPos[LARGE_BUF_SIZE]; 
char _LastFunction[LARGE_BUF_SIZE];
BYTE _DebugStackLevel = 0;

void PrintDateAndTime(IN PFILETIME p)
{
	SYSTEMTIME s;
	WORD result;
	char ds[250];
	*ds ='\0';
	if (!FileTimeToSystemTime(p, &s)) {
		DBGMSG("error FileTimeToSystemTime");
		result = (WORD)GetLastError();	
		DBGVALUE(result,"%d");
		return;
	} 

	wsprintf(ds,"%02d/%02d/%d %02d:%02d",
                s.wMonth, s.wDay, s.wYear, s.wHour, s.wMinute);
	DBGMSG(ds);
	return;
}

#endif
