/* getfileinfo.c -- get file information
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

//
//handle = VDDRetrieveNtHandle(		// NT file HANDLE
//	ULONG pPDB,                 	// MK_FP(psp_seg, 0);
//	SHORT hFile,             	// DOS file handle;
//	PVOID* ppSFT,                	// DOS SFT table, pointer to
//	PVOID* ppJFT);              	// program JFT, pointer to
//

WORD	process_get_file_information(
		IN  SHORT hFile,				
		IN  ULONG pPDB,					
		IN  PVOID * ppSFT,                     		
		IN  PVOID * ppJFT,				
		OUT PBY_HANDLE_FILE_INFORMATION pfileinfo)	
{
	HANDLE handle;
	WORD	result;
	BY_HANDLE_FILE_INFORMATION fileinfo;
	PBY_HANDLE_FILE_INFORMATION pf;
	PROLOG(process_get_file_information);
	ISNULL(ppSFT);
	ISNULL(ppJFT);
	DBGVALUE(hFile,"%d");

	handle = VDDRetrieveNtHandle (pPDB, hFile, ppSFT, ppJFT);
	if (handle == INVALID_HANDLE_VALUE) {
		DBGMSG("invalid handle retrieved");
		EPILOG(process_get_file_information, FALSE);
		return ERROR_INVALID_HANDLE;
	} 
	IS_NULL(pfileinfo, ERROR_SUCCESS);

	if (!pfileinfo)
		pf = &fileinfo;
	else
		pf = pfileinfo;

	if(!GetFileInformationByHandle(handle, pf)) 
		result =  (WORD)GetLastError();	
	else
		result = ERROR_SUCCESS;

	EPILOG(process_get_file_information,TRUE);
	return result;
}
