/* setcurdir.c -- set current directory
   Copyright (C) 1999-2000 Wojciech Galazka

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "lfnsrv.h"

WORD	process_set_current_directory(
		IN OUT LPSTR lpPathName)
{
	WORD result;
	char lpOrgPath[MAX_PATHNAME_SIZE];
	PROLOG(process_set_current_directory);
	IS_NULL(lpPathName, ERROR_PATH_NOT_FOUND);	
	IS_MAX_PATH_SIZE(lpPathName);
	DBGVALUE(lpPathName,"%s");

	if (lstrlen(lpPathName) == 1 && lpPathName[0] == '.') {
		EPILOG(process_set_current_directory, TRUE);
		return ERROR_SUCCESS;		
	}

	lstrcpy(lpOrgPath, lpPathName);

       	if (!GetShortPathName(lpPathName, lpPathName, MAX_PATHNAME_SIZE)) {
		result = (WORD)GetLastError();
		DBGMSG("SetCurrentDirectory, cannot generate short filename");
		if (result == ERROR_NOT_SUPPORTED) //  The network request is not supported.
			if ((result = GetShortPathName_(lpPathName, lpPathName))) {
				DBGMSG("Cannot generate short filename 2");             		
				EPILOG(process_set_current_directory, FALSE);
				return result;
			}
	}	

	if (!SetCurrentDirectory(lpOrgPath)) {
		result = (WORD)GetLastError();
		DBGMSG("SetCurrentDirectory call failed");
		DBGVALUE(lpPathName,"%s");	
		EPILOG(process_set_current_directory, FALSE);
		return result;
	} 

	DBGVALUE(lpPathName,"%s");
	EPILOG(process_set_current_directory, TRUE);
	return ERROR_SUCCESS;		
}
