/*
        SMARTEDIT - A general purpose editor for text files.

        Copyright (C) 1999 Prashant TR
                          B-42, Kudremukh Colony,
                          II Block, Koramangala,
                          Bangalore - 560034.

This program is freeware. You are free to modify and/or redistribute them
under the terms of the GNU General Public License version 2.0 or later.
Read the file COPYING for the license.

The file COPYING.TR contains details about the distribution of this software.

*/

/* ID for this file. */
#define _INIT_C_

#include "editor.h"

extern PREFERENCES pref;
extern WINDOW *win;
extern WINDOW winlist[];

unsigned video_base;

void init_editor()
{
	FILE *fp;
	int f;

	__dpmi_regs regs;

        _go32_want_ctrl_break(1);
        __djgpp_set_ctrl_c(0);
	printf("\nSMARTEDIT v1.10, Copyright (C) 1999 Prashant TR\n"
	                    "ABSOLUTELY NO WARRANTY!\n");

	if ((fp = fopen("editor.cfg", "rb")) == NULL) {
		printf("\nError: Cannot find Configuration File."
			" Defaults loaded.\n");

		/* Setup preferences. */
		pref.mainmenucolor 	= BLACK;
		pref.mainmenubkcolor 	= LIGHTGRAY;
		pref.statusbarcolor 	= WHITE;
		pref.statusbarbkcolor 	= BROWN;
		pref.pullmenucolor 	= WHITE;
		pref.pullmenubkcolor 	= BLUE;
		pref.menubarcolor 	= WHITE;
		pref.menubarbkcolor 	= BLACK;
		pref.textmode		= C80;
		pref.intensecolors	= YES;
		pref.wincolor		= WHITE;
		pref.winbkcolor		= BLACK;
		pref.color 		= WHITE;
		pref.bkcolor		= BLUE;
		pref.scrltype		= 0;

		/* Other preferences. */
		pref.tabsize		= 8;
		pref.backupfiles	= NO;
		pref.insertmode		= YES;
		pref.initinsertmode	= ON;
		pref.unixstyle      	= NO;
		pref.tabs		= YES;
		strcpy(pref.deffilename, "");
	}
	else {
		fread(&pref, sizeof(PREFERENCES), 1, fp);
		fclose(fp);
	}

	/* Store the old window. */
	/* See if monochrome. */
	regs.h.ah = 0xf;
	__dpmi_int(0x10, &regs);

	if (regs.h.al == 7) {
		video_base = 0xb0000;
		pref.textmode = MONO;
	}
	else video_base = 0xb8000;

	/* Initialize mouse. */
	mouseinit();
	mousestat();

	/* Initialize video. */
	if (pref.textmode != 7) intensevideo();

	/* Change background color of the whole screen. */
	textcolor(pref.color);
	textbackground(pref.bkcolor);
	clrscr();
	_setcursortype(0);

	/* Initialize window details. */
	for(f = 0; f < MAXWINDOWS; f++) winlist[f].in_use = 0;

	/* Create new window. */
	Window_NewWindow();

	/* Draw menubar. */
	mainmenubar();

	drawwindow();

	_setcursortype(1);
	setcursor;
}