indexing
    description    : "Allegro con Eiffel: keyboard objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : keyboard
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class KEYBOARD


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end  -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make is
    -- Create a new keyboard
    require
        ace_initialised        : info.ace_initialised
        keyboard_not_installed : not info.keyboard_initialised
    local
        b : BOOLEAN
    do
        c_inline_c("_b=(install_keyboard()==0?-1:0);")

        info.set_keyboard_flag(b)
    ensure
        keyboard_initialised : info.keyboard_initialised
    end  -- feature make


------------------------------------------------------ Keyboard features
feature { ANY }

    pressed(scancode : SCANCODE) : BOOLEAN is
    -- Is the specified key currently depressed?
    require
        ace_initialised      : info.ace_initialised
        keyboard_initialised : info.keyboard_initialised
        scancode_is_valid    : scancode /= Void
    local
        code : INTEGER
    do
        code := scancode.code
        c_inline_c("R=key[_code];")
    end  -- feature pressed


    input_waiting : BOOLEAN is
    -- Has any key been pressed since the last call to read
    require
        ace_initialised      : info.ace_initialised
        keyboard_initialised : info.keyboard_initialised
    external
        "IC"
    alias
        "keypressed"
    end  -- feature input_waiting


    read : KEYPRESS is
    -- Read the next character from the keyboard buffer
    require
        ace_initialised      : info.ace_initialised
        keyboard_initialised : info.keyboard_initialised
    local
        i : INTEGER
    do
        c_inline_c("_i=readkey();")
        !!Result.make_from_readkey_code(i)
    end  -- feature read


    write(keypress : KEYPRESS) is
    -- Write the given keycode into the keyboard buffer (same format as
    -- read returns)
    require
        ace_initialised      : info.ace_initialised
        keyboard_initialised : info.keyboard_initialised
        keypress_is_valid    : keypress /= Void
    local
        scancode  : INTEGER
        character : CHARACTER
    do
        scancode  := keypress.scancode
        character := keypress.character
        c_inline_c("simulate_keypress((_scancode<<8)+_character);")
    end  -- feature write


    clear is
    -- Clear the keyboard buffer
    require
        ace_initialised      : info.ace_initialised
        keyboard_initialised : info.keyboard_initialised
    external
        "IC"
    alias
        "clear_keybuf"
    end  -- feature clear


    emergency_exit_installed : BOOLEAN is
    -- Is the emergency keyboard exit code installed?
    require
        ace_initialised      : info.ace_initialised
        keyboard_initialised : info.keyboard_initialised
    do
        c_inline_c("R=three_finger_flag;")
    end  -- feature emergency_exit_installed


    set_emergency_exit_on is
    -- Turn the emergency exit keyboard sequence (Ctrl+Alt+Del or
    -- Ctrl+Alt+End) on
    require
        ace_initialised              : info.ace_initialised
        keyboard_initialised         : info.keyboard_initialised
        emergency_exit_not_installed : not emergency_exit_installed
    do
        c_inline_c("three_finger_flag=-1;")
    ensure
        emergency_exit_installed : emergency_exit_installed
    end  -- feature set_emergency_exit_on


    set_emergency_exit_off is
    -- Turn the emergency exit keyboard sequence off
    require
        ace_initialised          : info.ace_initialised
        keyboard_initialised     : info.keyboard_initialised
        emergency_exit_installed : emergency_exit_installed
    do
        c_inline_c("three_finger_flag=0;")
    ensure
        emergency_exit_not_installed : not emergency_exit_installed
    end  -- feature set_emergency_exit_off


    led_toggling_installed : BOOLEAN is
    -- Is keyboard LED toggling currently on?
    require
        ace_initialised          : info.ace_initialised
        keyboard_initialised     : info.keyboard_initialised
    do
        c_inline_c("R=key_led_flag;")
    end  -- feature led_toggling_installed


    set_led_toggling_on is
    -- Set keyboard LED toggling on
    require
        ace_initialised            : info.ace_initialised
        keyboard_initialised       : info.keyboard_initialised
        led_toggling_not_installed : not led_toggling_installed
    do
        c_inline_c("key_led_flag=-1;")
    ensure
        led_toggling_installed : led_toggling_installed
    end  -- feature set_led_toggling_on


    set_led_toggling_off is
    -- Set keyboard LED toggling off
    require
        ace_initialised        : info.ace_initialised
        keyboard_initialised   : info.keyboard_initialised
        led_toggling_installed : led_toggling_installed
    do
        c_inline_c("key_led_flag=0;")
    ensure
        led_toggling_not_installed : not led_toggling_installed
    end  -- feature set_led_toggling_off


end  -- class KEYBOARD
