indexing
    description    : "Allegro con Eiffel: mouse objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : mouse
    date_started   : "30th January, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class MOUSE


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end  -- inherit ACE_INFORMATION_SINGLETON


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    make is
    -- Create a new mouse
    require
        ace_initialised     : info.ace_initialised
        mouse_not_installed : not info.mouse_installed
    do
        c_inline_c("C->_buttons=install_mouse();")

        is_installed := buttons /= -1
        info.set_mouse_flag(is_installed)
        is_visible := FALSE
    ensure
        mouse_not_visible : not is_visible
    end  -- feature make


------------------------------------------------------ Mouse features
feature { ANY }

    -- Is a mouse installed?
    is_installed : BOOLEAN


    -- Stores the number of buttons of the mouse
    buttons : INTEGER


    -- Is the mouse currently visible?
    is_visible : BOOLEAN


    is_frozen : BOOLEAN is
    -- Is the mouse currently frozen?
    do
        c_inline_c("R=freeze_mouse_flag;")
    end  -- feature is_frozen


    x : INTEGER is
    -- Return the current x position of the mouse
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
    do
        c_inline_c("R=mouse_x;")
    end  -- feature x


    y : INTEGER is
    -- Return the current y position of the mouse
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
    do
        c_inline_c("R=mouse_y;")
    end  -- feature y


    left_button_pressed : BOOLEAN is
    -- Return TRUE if the left button is currently depressed
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
        sufficient_buttons : buttons >= 1
    do
        c_inline_c("R=mouse_b&1;")
    end  -- feature left_button_pressed


    right_button_pressed : BOOLEAN is
    -- Return TRUE if the right button is currently depressed
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
        sufficient_buttons : buttons >= 2
    do
        c_inline_c("R=mouse_b&2;")
    end  -- feature right_button_pressed


    middle_button_pressed : BOOLEAN is
    -- Return TRUE if the middle button is currently depressed
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
        sufficient_buttons : buttons >= 3
    do
        c_inline_c("R=mouse_b&3;")
    end  -- feature middle_button_pressed


    show is
    -- Show the mouse cursor on the screen
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
        mouse_not_is_visible : not is_visible
    do
        c_inline_c("show_mouse(screen);")
        is_visible := TRUE
    ensure
        mouse_is_visible : is_visible
    end  -- feature show


    hide is
    -- Hide the mouse cursor (required before drawing to the screen)
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
        mouse_is_visible     : is_visible
    do
        c_inline_c("show_mouse(NULL);")
        is_visible := FALSE
    ensure
        mouse_is_not_visible : not is_visible
    end  -- feature show


    freeze is
    -- Freeze the mouse cursor
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
        mouse_is_not_frozen  : not is_frozen
    do
        c_inline_c("freeze_mouse_flag=-1;")
    ensure
        mouse_is_frozen : is_frozen
    end  -- feature freeze


    unfreeze is
    -- Unfreeze the mouse cursor
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
        mouse_is_frozen      : is_frozen
    do
        c_inline_c("freeze_mouse_flag=0;")
    ensure
        mouse_is_not_frozen : not is_frozen
    end  -- feature unfreeze


    set_position(new_x, new_y : INTEGER) is
    -- Move the mouse to the specified location
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
        new_x_is_valid     : new_x >= 0
        new_y_is_valid     : new_y >= 0
    do
        c_inline_c("position_mouse(a1,a2);")
    ensure
        x_is_valid : x = new_x
        y_is_valid : y = new_y
    end  -- feature set_position


    set_range(left, top, right, bottom : INTEGER) is
    -- Set the limits of the mouse
    require
        ace_initialised    : info.ace_initialised
        mouse_is_installed : is_installed
        left_is_valid      : left   >= 0 and left <= right
        top_is_valid       : top    >= 0 and top  <= bottom
        right_is_valid     : right  >= left
        bottom_is_valid    : bottom >= top
    do
        c_inline_c("set_mouse_range(a1,a2,a3,a4);")
    end  -- feature set_range


    set_speed(x_speed, y_speed : INTEGER) is
    -- Set the speed of the mouse
    require
        ace_initialised     : info.ace_initialised
        mouse_is_installed  : is_installed
        x_speed_is_valid    : x_speed >= 0
        y_speed_is_valid    : y_speed >= 0
    do
        c_inline_c("set_mouse_speed(a1,a2);")
    end  -- feature set_speed


    set_cursor(cursor : BITMAP) is
    -- Set the cursor to the specified bitmap
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
        cursor_is_valid      : cursor /= Void
    do
        c_inline_c("set_mouse_sprite(a1);")
    end  -- feature set_cursor


    reset_cursor is
    -- Set the cursor back to the default pointer
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
    do
        c_inline_c("set_mouse_sprite(NULL);")
        set_cursor_hotspot(1,1)
    end  -- feature reset_cursor


    set_cursor_hotspot(x_spot, y_spot : INTEGER) is
    -- Set the hotspot of the cursor
    require
        ace_initialised      : info.ace_initialised
        graphics_initialised : info.graphics_initialised
        timer_initialised    : info.timer_initialised
        mouse_is_installed   : is_installed
        x_spot_is_valid      : x_spot >= 0
        y_spot_is_valid      : y_spot >= 0
    do
        c_inline_c("set_mouse_sprite_focus(a1,a2);")
    end  -- feature set_cursor_hotspot


end  -- class MOUSE
