indexing
    description    : "Allegro con Eiffel: timer_test program"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : timer_test
    date_started   : "1st December, 1996"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


class TIMER_TEST


inherit
    ACE  -- implementation inheritance
    end  -- inherit ACE


creation { ANY }
    make


------------------------------------------------------ Creation features
feature { ANY }

    -- Tester creation feature
    make is
    local
        i             : INTEGER
        start1, stop1 : INTEGER
        start2, stop2 : INTEGER
        start3, stop3 : INTEGER
        d             : DOUBLE
    do

--------------------------------------------------- ACE initialisation

        -- Initialise ACE
        if not init.success then
            crash_with_message("ACE initialisation error: ")
        end  -- if


--------------------------------------------------- Timer routines

        -- Initialise timer1
        if not timer1.init_success then
            crash_with_message("Timer 1 initialisation failed.")
        end  -- if

        -- Initialise timer2
        if not timer2.init_success then
            crash_with_message("Timer 2 initialisation failed.")
        end  -- if

        -- Initialise timer3
        if not timer3.init_success then
            crash_with_message("Timer 3 initialisation failed.")
        end  -- if

        io.put_string("%NTiming loop, please wait...%N")

        timer1.start(1000)     -- 1 tick per second
        timer2.start(100)      -- 10 ticks per second
        timer3.start(10)       -- 100 ticks per second

        -- Get the starting tick count
        start1 := timer1.count
        start2 := timer2.count
        start3 := timer3.count

        -- Loop for a while, printing out timer counts
        from
            i := 0
        invariant
            0 <= i and i <= num_iterations
        variant
            num_iterations - i
        until
            i = num_iterations
        loop
            i := i + 1
        end  -- from

        -- Get the final tick count
        stop1 := timer1.count
        stop2 := timer2.count
        stop3 := timer3.count

        -- Stop the timers
        timer1.stop
        timer2.stop
        timer3.stop

        -- Print time in seconds
        io.put_integer(stop1-start1)
        io.put_string(" seconds to loop ")
        io.put_integer(num_iterations)
        io.put_string(" times.%N")

        -- Print time in 10s of seconds
        d := (stop2 - start2) / 10
        io.put_string(d.to_string_format(1))
        io.put_string(" seconds to loop ")
        io.put_integer(num_iterations)
        io.put_string(" times.%N")


        -- Print time in 100s of seconds
        d := (stop3 - start3) / 100
        io.put_string(d.to_string_format(2))
        io.put_string(" seconds to loop ")
        io.put_integer(num_iterations)
        io.put_string(" times.%N")
    end  -- feature make


------------------------------------------------------ Internal features
feature { NONE }

    -- The number of iterations of each test to perform
    num_iterations : INTEGER is 1000000


    wait_for_key(message : STRING) is
    -- Display the message then wait for a key
    require
        message_is_valid : message /= Void
    do
        io.put_string(message)
        io.put_string("%NPress ENTER...")
        io.read_character
    end  -- feature wait_for_key


    crash_with_message(message : STRING) is
    -- Display the message then the ace error message then crash
    require
        message_is_valid : message /= Void
    do
       io.put_character('%N')
       io.put_string(message)
       io.put_string(info.error_description)
       io.put_character('%N')
       crash
    end  -- feature crash_with_message


end  -- class TIMER_TEST
