indexing
    description    : "Allegro con Eiffel: file iterator objects"
    status         : "Initial development"
    author         : "Peter Monks (pmonks@iname.com)"
    allegro_author : "Shawn Hargreaves (shawn@talula.demon.co.uk)"
    names          : file_iterator
    date_started   : "8th February, 1997"
    version        : "0.1 beta"
    platforms      : "MS-DOS"
    dependencies   : "Allegro v2.2, DJGPP v2.01"


deferred class FILE_ITERATOR


inherit
    ACE_INFORMATION_SINGLETON  -- implementation inheritance
    end                        -- inherit ACE_INFORMATION_SINGLETON


------------------------------------------------------ Possible creation feature
feature { ANY }

    make(spec : STRING) is
    -- Set up the file specification to use in the iteration
    require
        spec_is_valid : spec /= Void
    do
        specification := clone(spec)
    ensure
        specification.is_equal(spec)
    end  -- feature make


    make_and_go(spec : STRING) is
    -- Set up the file specification to use in the iteration
    require
        spec_is_valid : spec /= Void
    local
        files_processed : INTEGER
    do
        make(spec)
        files_processed := go
    end  -- feature make_and_go


------------------------------------------------------ Internal features
feature { NONE }

    specification : STRING


------------------------------------------------------ FILE_ITERATOR features
feature { ANY }

    go : INTEGER is
    -- Perform operation on each file in the given wildcard specification.
    require
        ace_initialised        : info.ace_initialised
        specification_is_valid : specification /= Void
    local
        p : POINTER
    do
        p := specification.to_external
        c_inline_c("R=eiffel_for_each_file((char *)_p,(void *)C);")
    end  -- feature for_each_file


    operation(filename : POINTER; attributes : INTEGER) : BOOLEAN is
    -- The operation to perform on the given file
    require
        ace_initialised   : info.ace_initialised
        filename_is_valid : filename.is_not_void
    deferred
    end  -- feature operation


end  -- class FILE_ITERATOR
