//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

/*

TEXTBOX EXAMPLE

*/

#include <stdlib.h>
#include <stdio.h>

#include "allegro.h"

// Include the dialog objects
#include "degui.h"

// The pointer for the textbox;
char *text =
"

DEGUI

Version 1.1 beta
designed for Allegro 2.2 beta

C++ objects for Allegro's GUI

By Doug Eleveld, April 1997
D.J.Eleveld@anest.azg.nl

#include <std.disclaimer.h>

'I do not accept responsibility for any effects, adverse or otherwise, that this code may have on you, your computer, your sanity, your dog, and anything else that you can think of.  Use it at your own risk.'

What is DEGUI

DEGUI is a set of programs and C++ objects that allow users of Allegro's GUI to make dialogs using more familiar normal C++ methods.  Extending the basic dialog_object with class derivation is simpler and cleaner than the mixing of procedures that was necessary using standard Allegro d_xxx_proc procedures.  Also the user can easily and simply interface with object callback functions to find out when a button is clicked, a checkbox is selected, etc.  A GUI builder program is provided that can be used to graphically build dialogs and export the dialogs to program code.  DEGUI objects can also be easily interfaced with DIALOG structures for mixed C/C++ style dialogs.

DEGUI is not very useful without Allegro since it relies on many of Allegro's procedures.  The latest version of Allegro can always be found on x2ftp.oulu.fi, in /pub/msdos/programmer/djgpp2/, and on the Allegro homepage, http://www.taula.demon.co.uk/allegro/.

DEGUI is currently available at: http://huizen.dds.nl/~deleveld/index.htm


Copyright

I think that the way Allegro is copyrighted is fantastic and so I'm going to copyright DEGUI in the same way.  This is from Allegros' readme.txt with the name Allegro exchanged with DEGUI.

DEGUI is swap-ware. You may use, modify, redistribute, and generally hack it about in any way you like, but if you do you must send me something in exchange. This could be a complimentary copy of a game, an addition or improvement to DEGUI, a bug report, some money (this is particularly encouraged if you use DEGUI in a commercial product), or just a copy of your autoexec.bat if you don't have anything better. If you redistribute parts of DEGUI or make a game using it, it would be nice if you mentioned me somewhere in the credits, but if you just want to pinch a few routines that is OK too. I'll trust you not to rip me off.

Of course you must also read Allegro's copyright and for DJGPP too, I guess.
";

//----------------------------------------------------------------------------
int main(void)
   {
   /* initialise everything */
   allegro_init();
   install_keyboard(); 
   install_mouse();
   install_timer();

   // Set up the graphics mode
   set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
   set_pallete(desktop_pallete);

   set_default_object_colors(0,235,236,237,238,239,240,241);

   // Declare the dialog and some objects
   dialog the_dialog;
   clear_screen_object  clear_obj;
   textbox_object		   textbox(text,true,true);
   button_object			ok_button("OK",0,true);

   // Add the objects to the dialog
   // The color arguments have defaults so we don't have to fill then in
                              // (x)   (y)   (w)   (h)   (fg)  (bg)
   the_dialog.add(clear_obj);
   the_dialog.add(textbox,        50,   50,   300,  400);
   the_dialog.add(ok_button,      400,  50,   160,  48 );

   // Do the dialog
   the_dialog.execute();

   show_mouse(NULL);
   set_gfx_mode(GFX_TEXT,80,25,0,0);
   allegro_exit();
   return 0;
   }
//----------------------------------------------------------------------------
