//----------------------------------------------------------------------------
//
// C++ Objects for Allegro's gui
//
// Douglas Eleveld (D.J.Eleveld@anest.azg.nl)
//
//----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Some C Objects for Allegro's gui
//----------------------------------------------------------------------------
#include "degui.h"
#include "internal.h"

//----------------------------------------------------------------------------
// Global helper functions for the editable text line
//----------------------------------------------------------------------------
// Helper to draw the editable text
// Returned value is last character number drawn
static int _draw_text (const char *text,
                       const int cursorpos,
                       const int offsetpos,
                       const int x, const int y, const int w, const int h,
                       const int disabled, const int has_focus,
                       const int fore,
                       const int deselect,
                       const int disable,
                       int* there_is_more)
   {
   int  x1    = x+4;
   int  y1 = y + (h/2) - text_height(font)/2 + 1;
   int  xx    = x+w-10;
   char s[2]  = ".";
   int  i     = offsetpos;
   int  len;
   int cursorx = -1;
   int fg = fore;
   int ii;

   if(disabled) fg = disable;
   if(!has_focus) i = 0;

   // Assume that we will go to the end
   *there_is_more = 0;

   text_mode(deselect);

   // Possibly remember where the cursor should go
   if(i==cursorpos) cursorx = x1;

   while(text[i]!=0)
      {
      // Find the length of the character
      s[0] = text[i];
      len = text_length(font,(unsigned char*)s);

      // Draw the character, possible with cursor
      if(fore>=0) textout(screen,font,(unsigned char*)s,x1,y1,fore);

      x1 += len;

      // Stop drawing if we are out of bounds
      if(x1>xx)
         {
         // Remember that there is more to draw
         *there_is_more = 1;
         break;
         }
      i++;

      // Possibly remember where the cursor should go
      if(i==cursorpos) cursorx = x1;
      }
   // If we ran off the end before finding the cursor, then its at the end
   if((*there_is_more)&&(cursorx<0)) cursorx = x1;

   // Draw the cursor if we have the focus
   if((cursorx>=0)&&has_focus&&(fore>=0))
      {
      for(ii=0;ii<text_height(font); ii++)
         {
         putpixel(screen,cursorx,y1+ii,fore);
         putpixel(screen,cursorx+1,y1+ii,fore);
         }
      }
   return i;
   }
//----------------------------------------------------------------------------
// Draw the editable text
// If the object doesn't has the focus, we may adjust the start position
int _draw_edittext_object (const char *text,
                           const int cursorpos,
                           const int offsetpos,
                           const int x, const int y, const int w, const int h,
                           const int disabled, const int has_focus,
                           const int fore,
                           const int deselect,
                           const int disable,
                           const int light_shad, const int dark_shad)
   {
   int y1 = y + (h/2) - text_height(font)/2 - 2;
   int y2 = y1 + text_height(font) + 5;

   int lastchar = offsetpos;
   int newoffset = offsetpos;
   int there_is_more = 0;

   // Only draw the frme if it's a serious color
   if(has_focus)
      {
      // Try it with the current offset, but don't draw
      while(1)
         {
         lastchar = _draw_text(text,
                               cursorpos,
                               newoffset,
                               x,y,w,h,
                               disabled,has_focus,
                               -1,
                               deselect,
                               disable,
                               &there_is_more);

         // Do we need to decrease the offset
         if(!there_is_more)
            {
            newoffset--;
            if(newoffset<0) newoffset = 0;
            break;
            }
         // Do we need to decrease the offset
         else if(lastchar>cursorpos)
            {
            newoffset--;
            if(newoffset<0)
               {
               newoffset = 0;
               break;
               }
            }
         // Do we need to increase the offset
         else if(lastchar<cursorpos)
            {
            newoffset++;
            if(newoffset>cursorpos) newoffset = cursorpos;
            if(newoffset<0) newoffset = 0;
            }
         // Now that we know the correct offset we can draw it for real
         else break;
         }
      }

   // Now draw the text on the screen
   draw_3d_frame(screen,x,y1,x+w,y2,deselect,dark_shad,light_shad);
   _draw_text(text,
              cursorpos,
              newoffset,
              x,y,w,h,
              disabled,has_focus,
              fore,
              deselect,
              disable,
              &there_is_more);

   return newoffset;
   }
//----------------------------------------------------------------------------

