/* 8bpp palette code */
#include "m3d.h"

/* texture cache */
static BITMAP *txt_cache[TOTAL_TEXTURES], *ntxt_cache[TOTAL_TEXTURES];
static int txt_cache_i, hotpink;
static RGB_MAP rgbmap;
static COLOR_MAP colmap;
PALETTE m3dpal;
static unsigned long *ColCnt;

void m3d_MakePal(void)
{
    unsigned long i, best, besti, x, y, r, g, b;

    /* find 256 highest used colors */
    m3dpal[0].r = m3dpal[0].b = 63; m3dpal[0].g = 0;
    for (x = hotpink; x < 256; x++) {
        for (best = besti = y = 0; y < (1<<15); y++)
            if (ColCnt[y] > best) {
                best = ColCnt[y];
                besti = y; }
        m3dpal[x].r = ((besti>>10)<<1);
        m3dpal[x].g = ((besti>>5) & 31)<<1;
        m3dpal[x].b = (besti&31)<<1;
        ColCnt[besti] = 0; }

    /* make rgbmap */
    create_rgb_table(&rgbmap, m3dpal, NULL);
    rgb_map = &rgbmap;

    /* make color map */
    create_light_table(&colmap, m3dpal, 0,0,0, NULL);
    color_map = &colmap;

    /* set palette */
    set_palette(m3dpal);

    /* remap textures */
    for (i = 0; i < txt_cache_i; i++) {
        m3d_remap_bitmap(txt_cache[i], ntxt_cache[i]);
        destroy_bitmap(txt_cache[i]); }

    /* free mem */
    free(ColCnt);
}   

void m3d_MakePalInit(void) {
    hotpink = txt_cache_i = 0;
    ColCnt = calloc(1<<15, sizeof(long));
}

void m3d_MakePalAddColor(unsigned long color, unsigned long shades)
{
    unsigned long i, r, g, b, rr, gg, bb, best, besti;

    /* check for bad parameters */
    if (shades > 32)
        shades = 32;
    else if (shades < 1)
        shades = 1;

    if (color == 0) { ++ColCnt[0]; return; }

    /* get rgb values */
    r = (color >> 16) & 255;
    g = (color >> 8) & 255;
    b = (color) & 255;

    for (i = 1; i <= shades; i++) {
        rr = ((r * i) / shades) >> 3;
        gg = ((g * i) / shades) >> 3;
        bb = ((b * i) / shades) >> 3;
        ++ColCnt[(rr<<10)|(gg<<5)|bb];
    }
}

void m3d_MakePalObj(obj *o, unsigned long shades)
{
    int x, i, xx, yy, r, g, b, t;

    for (x = 0; x < o->nfaces; x++) {
        switch (o->faces[x].shadetype & (~POLYTYPE_ZBUF)) {
            case POLYTYPE_WIRE:
                m3d_MakePalAddColor(255, shades);
                break;
            case POLYTYPE_GRGB:
            case POLYTYPE_FLAT:
            case POLYTYPE_GCOL:
                for (i = 0; i < 3; i++)
                    m3d_MakePalAddColor(o->faces[x].v[i].c, shades);
                break;
            case POLYTYPE_ATEX:
            case POLYTYPE_PTEX:
            case POLYTYPE_ATEX_LIT:
            case POLYTYPE_PTEX_LIT:
            case POLYTYPE_ATEX_MASK:
            case POLYTYPE_PTEX_MASK:
            case POLYTYPE_ATEX_MASK_LIT:
            case POLYTYPE_PTEX_MASK_LIT:
                /* is it in the cache? */
                for (xx = 0; xx < txt_cache_i; xx++)
                    if (txt_cache[xx] == o->faces[x].texture) {
                        o->faces[x].texture = ntxt_cache[xx];
                        xx = 1234567; break; }

                if ((xx != 1234567) && (txt_cache_i < TOTAL_TEXTURES)) {
                    txt_cache[txt_cache_i] = o->faces[x].texture;
                    ntxt_cache[txt_cache_i] = create_bitmap_ex(8, o->faces[x].texture->w, o->faces[x].texture->h);
                    o->faces[x].texture = ntxt_cache[txt_cache_i];
                    m3d_map_bitmap(txt_cache[txt_cache_i], shades);
                    ++txt_cache_i;
               }
                break;
        }
    }
    for (x = 0; x < o->nchild; x++)
        m3d_MakePalObj(&o->child[x], shades);
}

BITMAP *load_truecolor(char *name)
{
    BITMAP *o, *o2;
    PALETTE pal;
    int x, y, z;

    o = load_bitmap(name, (RGB *)&pal);

    if (bitmap_color_depth(o) >= 15)
        return o;

    o2 = create_bitmap_ex(24, o->w, o->h);
    for (x = 0; x < o->w; x++)
        for (y = 0; y < o->h; y++) {
            z = getpixel(o, x, y);
            putpixel(o2, x, y, makecol24(pal[z].r<<2, pal[z].g<<2, pal[z].b<<2));
        }
    destroy_bitmap(o);
    return o2;
}

void m3d_remap_bitmap(BITMAP *src, BITMAP *dest)
{
    int x, y, depth, c;

    depth = bitmap_color_depth(src);
    for (x = 0; x < src->w; x++)
        for (y = 0; y < src->h; y++) {
            c = getpixel(src, x, y);
            if ((getr_depth(depth, c) == 255) && (getb_depth(depth, c) == 255) && (getg_depth(depth, c) == 0))
                putpixel(dest, x, y, 0);
            else                    
                putpixel(dest, x, y, rgbmap.data[getr_depth(depth,c)>>3][getg_depth(depth,c)>>3][getb_depth(depth,c)>>3]);
        }
}

BITMAP *m3d_remap_bitmap_ex(BITMAP *src)
{
    BITMAP *dest;

    dest = create_bitmap_ex(8, src->w, src->h);
    m3d_remap_bitmap(src, dest);
    return dest;
}

void m3d_map_bitmap(BITMAP *src, unsigned long shades)
{
    int i, xx, yy, t, r, g, b;

    i = bitmap_color_depth(src);
    for (xx = 0; xx < src->w; xx++)
    for (yy = 0; yy < src->h; yy++) {
        t = getpixel(src, xx, yy);
        r = getr_depth(i, t);
        g = getg_depth(i, t);
        b = getb_depth(i, t);

        /* is there a hot pink */
        if ((r == 255) && (b == 255) && (g == 0))
            hotpink = 1;
        else
            m3d_MakePalAddColor((r<<16)|(g<<8)|b, shades);
    }
}
