#include <math.h>
#include <iostream.h>
#include <fstream.h>
#include <allegro.h>
#include <_string.h>
#include <string.h>
#include "globals.h"
#include "dialog.h"
#include "dbitmap.h"
#include "mdk_desk.h"
#include "ids.h"
#include "pall.h"
#include "objhelp.h"
#define BLIT show_mouse(NULL);blit(Gui_area,screen,0,0,X_GUI,Y_GUI,_W,_H);show_mouse(screen)



gui_d_bitmap_proc::gui_d_bitmap_proc(char* text):gui_d_text_proc(text)
{
   centre=FALSE;
   name="d_bitmap_proc";
   dp="bitmap_no";
   dehn=1;
   num=-1;
   strcpy(file,"Bitmap.dat");
   b_map=(BITMAP*) create_bitmap(w=10,h=10);
}
void gui_d_bitmap_proc::AdaptFilename(char* file)
{
   String File;
   File=file;
   File.gsub("\\","/");
   strcpy(file,File);
}


int gui_d_bitmap_proc::save_items(int line_nr,String DialogName)
{
   if (dp=="NULL") return -1;
   fout<<"\nBITMAP* "<<dp<<";\n";
   fout<<"\nvoid init_"<<dp<<"(void){";
   fout<<"\n\tDATAFILE* TEMP;";
   fout<<"\n\t"<<dp<<"=(BITMAP*) create_bitmap("<<w<<","<<h<<");";
   fout<<"\n\tTEMP =load_datafile(\""<<file<< "\");";
   fout<<"\n\tblit((BITMAP*) TEMP["<<num<<"].dat,"<<dp<<",0,0,0,0,"<<w<<","<<h<<");";
   fout<<"\n\t"<<DialogName<<"["<<line_nr<<"].dp="<<dp<<";";
   fout<<"\n\t}";
}
void gui_d_bitmap_proc::SaveInit()
{
  if (dp!="NULL") fout<<"\n\t init_"<<dp<<"();";
}

void gui_d_bitmap_proc::export()
{
   AdaptFilename(file);
   strcpy(s,dp);
   dp="DUMMY";
   dialog::export();
   fout<<"\n"<<s; /* The s-argument can include spaces */
   dp=s;
   fout<<"\n"<<file;
   fout<<"\n"<<num;
}
void gui_d_bitmap_proc::load_file(char* file,BITMAP* b,int number)
{
  if (number==-1) return;
  if (exists(file))
     {
	if (number<0)
	  {
	     char z[256]="";
	     strcat(z,"In file \"");
	     strcat(z,file);
	     strcat(z,"\" cann't be a Bitmap at Position ");
	     strcat(z,itoa(number,num_,10));
	     alert(z,"Creating a invisable bitmapobject though", "Hmmmm....", UserText[OK_], NULL, 'y', 27);
           clear_to_color(b,palette_color[0]);
	  }
	if (number>-1)
	  {
	     clear_to_color(b,palette_color[0]);
	     BitmapContainer=load_datafile(file);
	     blit((BITMAP*) BitmapContainer[number].dat,b,0,0,0,0,w,h);
	     unload_datafile(BitmapContainer);
	  }
     }
   else
     {
	char z[256]="";
	strcat(z,"The saved bitmapfile is not found (searched for:\"");
	strcat(z,file);
	strcat(z,"\")");
	alert(z,"Creating a invisable bitmapobject though", "Hmmmm....", UserText[OK_], NULL, 'y', 27);
	clear_to_color(b,palette_color[255]);

     }

}
void gui_d_bitmap_proc::warning(char* file)
{
	char z[256]="";
	strcat(z,"The DAT-file is not found (searched for:\"");
	strcat(z,file);
	strcat(z,"\")");
	alert(z,NULL, "Hmmmm....", UserText[OK_], NULL, 'y', 27);
}
void gui_d_bitmap_proc::import()
{
   dialog::import();
   fin.getline(s,255); /* There is a newlinechar*/
   fin.getline(s,255);
   fin.getline(file,255);
   fin>>num;
   dp=s;
   destroy_bitmap(b_map);
   b_map=create_bitmap(w,h);
   load_file(file,b_map,num);
}

void gui_d_bitmap_proc::save(int line_nr)
{
   fout<<"\n";
   GuiNumber=line_nr;
   if (WRITE_COLORS_STATIC!=D_SELECTED)
    {
      if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
      fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\t"<<fg;
      fout<<",\t"<<bg<<",\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
      fout<<" ,\tNULL },";
    }
    else
    {
      if (number_Dialogs) fout<<"/* "<<line_nr<<" */";
      fout<<"\t{ "<<name<<" ,\t"<<x<<" ,\t"<<y<<" ,\t"<<w<<" ,\t"<<h<<" ,\tpalette_color["<<fg;
      fout<<"],\tpalette_color["<<bg<<"],\t"<<key<<" ,\t"<<flags<<" ,\t"<<d1<<" ,\t"<<d2;
      fout<<" ,\tNULL},";
    }

}
void gui_d_bitmap_proc::copy(gui_d_bitmap_proc& from,int& xc, int& yc,int NoDeltaMove=0)
{
   dialog::copy(from,xc,yc,NoDeltaMove);
   strcpy(s,from.s);
   strcpy(file,from.file);
   num=from.num;

   if (num==-1)
   {
      if (b_map) destroy_bitmap(b_map);
      b_map=NULL;
      dp="NULL";
   }
   else
   {
     char dummy[10];
     dp="BitmapCopyNo"+ String(itoa(LCounter,dummy,10));
     if (b_map) destroy_bitmap(b_map);
     b_map=create_bitmap(w,h);
     clear_to_color(b_map,palette_color[0]);
     blit(from.b_map,b_map,0,0,0,0,w,h);
   }
}
int gui_d_bitmap_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1)
   {
    fgd=fg;
    bgd=bg;
    Screen=screen;
    screen=b;
    DIALOG this_dia[]=
     {
	d_bitmap_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],  key_convert(),flags_convert(),       d1,  d2,    b_map
     };
     d_bitmap_proc(MSG_DRAW,this_dia,0);
     screen=Screen;
     }
   else
   {
    Screen=screen;
    screen=b;
    DIALOG this_dia[]=
     {
	d_bitmap_proc,    x,   y,   w,  h,   palette_color[fgd],    palette_color[bgd],  key_convert(),flags_convert(),       d1,  d2,    b_map
     };
     d_bitmap_proc(MSG_DRAW,this_dia,0);
     for (int tx=0;tx<=w;tx=tx+2)
	  {
	     putpixel(b,x+tx, y,palette_color[255]);
	     putpixel(b,x+tx+1, y,palette_color[0]);
	     putpixel(b,x+tx,y+h,palette_color[255]);
   	     putpixel(b,x+tx+1,y+h,palette_color[0]);
	  };
	for (int ty=0;ty<=h;ty=ty+2)
	  {
	     putpixel(b,x,y+ty,palette_color[255]);
  	     putpixel(b,x,y+ty+1,palette_color[0]);
	     putpixel(b,x+w,y+ty,palette_color[255]);
   	     putpixel(b,x+w,y+ty+1,palette_color[0]);
	  };
     screen=Screen;
   }
}

char* gui_d_bitmap_proc::input()
{
   // Allegro - C- code done with MichisDialogkiste
   char ret[256];
   char wd[256];
   char hi[256];
   char x_[5];
   char y_[5];
   
   strcpy(ret,file);
   itoa(w,wd,10);
   itoa(h,hi,10);
   itoa(x,x_,10);
   itoa(y,y_,10);
   itoa(num,num_,10);
   DIALOG id_dialog[]= {
      /* 0 */	{ d_box_proc ,	235 ,	207 ,	132 ,	42 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 1 */	{ d_shadow_box_proc ,	190 ,	141 ,	285 ,	180 ,	palette_color[5],palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 2 */	{ d_box_proc ,	214 ,	171 ,	246 ,	95 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 3 */	{d_text_proc ,	217 ,	174 ,	48 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "File Name" },
      /* 4 */	{d_edit_proc ,	217 ,	186 ,	200 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,   0,	256 ,	1 ,	 file },
      /* 5 */	{d_text_proc ,	217 ,	198 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "Bitmap number in file:" },
      /* 6 */	{d_text_proc ,	274 ,	150 ,	156 ,	24 ,	palette_color[136] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 name },
      /* 7 */	{d_edit_proc ,	397 ,	198 ,	48,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	10 ,	1 ,	 num_},
      /* 8 */	{d_text_proc ,	241 ,	210 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "width:" },
      /* 9 */	{d_text_proc ,	313 ,	210 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 wd },
      /* 10 */	{d_text_proc ,	241 ,	222 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "height:" },
      /* 11 */	{d_text_proc ,	313 ,	222 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	hi },
      /* 12 */	{d_button_proc ,	214 ,	273 ,	100 ,	12 ,	palette_color[33] ,	palette_color[7] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Position" },
      /* 13 */	{d_button_proc ,	214 ,	297 ,	60 ,	12 ,	palette_color[33] ,	palette_color[7] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
      /* 14 */	{d_button_proc ,	344 ,	273 ,	80 ,	12 ,	palette_color[33] ,	palette_color[7] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Size" },
      /* 15 */	{d_button_proc ,	388 ,	297 ,	48 ,	12 ,	palette_color[33] ,	palette_color[7] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
      /* 16 */	{d_button_proc ,	298 ,	297 ,	60 ,	12 ,	palette_color[33] ,	palette_color[7] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
      /* 17 */	{d_button_proc ,	236 ,	237 ,	200 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Grabb Bitmap in file" },
      /* 20 */	{d_text_proc ,	340 ,	210 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "Pos X:" },
      /* 21 */	{d_text_proc ,	400 ,	210 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 x_ },
      /* 22 */	{d_text_proc ,	340 ,	222 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "Pos Y:" },
      /* 23 */	{d_text_proc ,	400 ,	222 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 y_ },
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   do {
      centre_dialog(id_dialog);
      popup_dialog(id_dialog,-1);
      strcpy(s,file);
      num=atoi(num_);
      if (id_dialog[4].flags==MSG_DCLICK)	show_prop(fg,bg);
      if (id_dialog[16].flags==MSG_DCLICK) help();
      if (id_dialog[14].flags==MSG_DCLICK) {
         dialog tmp("Rect");
         rect_preparer p;
         p.run();
	   p.coordinate_transform(tmp);
         x=tmp.x;y=tmp.y;w=tmp.w;h=tmp.h;
         itoa(x,x_,10);
	   itoa(y,y_,10);
         itoa(w,wd,10);
         itoa(h,hi,10);
         strcpy(ret,"sized");
         BLIT;
         }
      if (id_dialog[12].flags==MSG_DCLICK)
	{
	   set_mouse_sprite(My_centre_pointer);
	   set_mouse_sprite_focus(X_GUI+8, Y_GUI+8);
	   if (num>=0)
	     {
		
		while (!(mouse_b&1))
		  {
		     x=grid(mouse_x)-X_GUI;
		     y=grid(mouse_y)-Y_GUI;
		     blit(Gui_area,temp_area,0,0,0,0,_W,_H);
		     show_mouse(temp_area);
		     activate_func(temp_area);
		     blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
		  };
	     }
	   else
	     {
		while (!(mouse_b&1));
	     }
	   show_mouse(NULL);
	   x=grid(mouse_x)-X_GUI;
	   y=grid(mouse_y)-Y_GUI;
	   itoa(x,x_,10);
	   itoa(y,y_,10);
	   strcpy(ret,"item positioned");
	   set_mouse_sprite(My_mouse_pointer);
	   set_mouse_sprite_focus(0,0);
	   BLIT;
	   show_mouse(screen);
	   
	}
      
	   
      if (id_dialog[17].flags==MSG_DCLICK)
	{
	   strcpy(str_all[0],file);
	   strcpy(file,grabber_call(num_all, str_all));
	   set_mouse_sprite(My_busy_pointer);
	   num=*num_all-1;
	   itoa(num,num_,10);
	   strcpy(wd,str_all[1]);
	   strcpy(hi,str_all[2]);
	   if (num>-1)
	     {
           	w=atoi(wd);
            h=atoi(hi);
            destroy_bitmap(b_map);
            b_map=create_bitmap(w,h);
	      clear_to_color(b_map,palette_color[255]);
            if (BitmapContainer!=NULL) {
            BitmapContainer=load_datafile(file);
		blit((BITMAP*) BitmapContainer[num].dat,b_map,0,0,0,0,w,h);
		unload_datafile(BitmapContainer);
            }
             else warning(file);
	     }
	   set_mouse_sprite(My_mouse_pointer);
	};
      if (id_dialog[15].flags==MSG_DCLICK){
	 strcpy(ret,"Cancel");
             return ret;}
      
   } while ((id_dialog[13].flags!=MSG_DCLICK)&(id_dialog[15].flags!=MSG_DCLICK));
    if (num>-1)
     {
	w=atoi(wd);
	h=atoi(hi);
	destroy_bitmap(b_map);
	b_map=create_bitmap(w,h);
	clear_to_color(b_map,palette_color[255]);

	BitmapContainer=load_datafile(file);
      if (BitmapContainer!=NULL) {
      blit((BITMAP*) BitmapContainer[num].dat,b_map,0,0,0,0,w,h);
	unload_datafile(BitmapContainer);
      }  else warning(file);
     } else
        {
         strcpy(ret,"Cancel");
        }
   return ret;
};
void gui_d_bitmap_proc::help();






gui_d_icon_proc::gui_d_icon_proc(char* text):gui_d_bitmap_proc(text)
{
   centre=FALSE;
   name="d_icon_proc";
   dp="icon_no";
   dp2="icon_Selected_no";
   dp3="icon_disabled_no";
   d1=2;
   d2=2;
   dehn=1;
   num=-1;
   numSelected=-1;
   numDisabled=-1;
   ws=0;
   hs=0;
   wd=0;
   hd=0;
   strcpy(file,"Bitmap.dat");
   strcpy(fileSelected,"Selected.dat");
   strcpy(fileDisabled,"Disabled.dat");
   b_map=(BITMAP*) create_bitmap(1,1);
   bSelected=(BITMAP*) create_bitmap(1,1);
   bDisabled=(BITMAP*) create_bitmap(1,1);
   ActiveBitmap=0;
}
void gui_d_icon_proc::write_defines(String DialogName,int DialogID)
{
   String dp_save;
   dp_save=dp;
   dp_save.gsub(" ","_");
   dp_save.gsub("&","_");
   dp_save.gsub("+","_");
   dp_save.gsub("-","_");
   dp_save.gsub("*","_");
   dp_save.gsub("/","_");
   dp_save.gsub("?","_");
   dp_save.gsub("(","_");
   dp_save.gsub("\"","_");
   dp_save.gsub(")","_");
   dp_save.gsub("{","_");
   dp_save.gsub("}","_");
   fout<<"\n#define _"<< upcase(DialogName)<<"_"<<upcase(dp_save)<<" "<<DialogID;
}


int gui_d_icon_proc::save_items(int line_nr,String DialogName)
{
   fout<<"\nBITMAP* "<<dp<<";\n";
   if (numSelected>-1) fout<<"\nBITMAP* "<<dp2<<";\n";
   if (numDisabled>-1) fout<<"\nBITMAP* "<<dp3<<";\n";
   fout<<"\nvoid init_"<<dp<<"(void){";
   fout<<"\n\tDATAFILE* TEMP;";
   fout<<"\n\t"<<dp<<"=(BITMAP*) create_bitmap("<<w<<","<<h<<");";
   if (numSelected>-1)  fout<<"\n\t"<<dp2<<"=(BITMAP*) create_bitmap("<<w<<","<<h<<");";
   if (numDisabled>-1)  fout<<"\n\t"<<dp3<<"=(BITMAP*) create_bitmap("<<w<<","<<h<<");";
   fout<<"\n\tTEMP =load_datafile(\""<<file<< "\");";
   fout<<"\n\tblit((BITMAP*) TEMP["<<num<<"].dat,"<<dp<<",0,0,0,0,"<<w<<","<<h<<");";
   fout<<"\n\t"<<DialogName<<"["<<line_nr<<"].dp="<<dp<<";";
   if (numSelected>-1)
      {
      fout<<"\n\tTEMP =load_datafile(\""<<fileSelected<< "\");";
      fout<<"\n\tblit((BITMAP*) TEMP["<<numSelected<<"].dat,"<<dp2<<",0,0,0,0,"<<w<<","<<h<<");";
      fout<<"\n\t"<<DialogName<<"["<<line_nr<<"].dp2="<<dp2<<";";
      }
   if (numDisabled>-1)
      {
      fout<<"\n\tTEMP =load_datafile(\""<<fileDisabled<< "\");";
      fout<<"\n\tblit((BITMAP*) TEMP["<<numDisabled<<"].dat,"<<dp3<<",0,0,0,0,"<<w<<","<<h<<");";
      fout<<"\n\t"<<DialogName<<"["<<line_nr<<"].dp3="<<dp3<<";";
      }
      fout<<"\n";
   
   fout<<"}\n";

}

int gui_d_icon_proc::THIS(int mx,int my)
{
   int ret;
   if (ret=dialog::THIS(mx,my))
     {
	// Allegro - C- code done with MichisDialogkiste
	//                   MDK 3.0
#define _ICON_THIS_SHOW_ACTIVE_BITMAP 2
#define _ICON_THIS_SHOW_SELECTED_BITMAP 3
#define _ICON_THIS_SHOW_DISABLED_BITMAP 4
#define _ICON_THIS_SELECT_ICON_PROC 5
#define _ICON_THIS_OK 7
#define _ICON_THIS_HELP 8
	DIALOG icon_this[]= {
	   /* 0 */	{ d_shadow_box_proc ,	166 ,	132 ,	228 ,	144 ,	palette_color[13] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
	   /* 1 */	{ d_box_proc ,	178 ,	156 ,	204 ,	66 ,	palette_color[10] ,	palette_color[8] ,	0 ,	0 ,	0 ,	0 ,	NULL},
	   /* 2 */	{d_radio_proc ,	190 ,	162 ,	168 ,	12 ,	palette_color[10] ,	palette_color[8] ,	0 ,	D_SELECTED ,	1 ,	0 ,	 "Show Active Bitmap" },
	   /* 3 */	{d_radio_proc ,	190 ,	180 ,	168 ,	12 ,	palette_color[10] ,	palette_color[8] ,	0 ,	0 ,	1 ,	0 ,	 "Show Selected Bitmap" },
	   /* 4 */	{d_radio_proc ,	190 ,	198 ,	168 ,	12 ,	palette_color[10] ,	palette_color[8] ,	0 ,	0 ,	1 ,	0 ,	 "Show Disabled Bitmap" },
	   /* 5 */	{d_check_proc ,	190 ,	228 ,	180 ,	12 ,	palette_color[13] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "De-/Select Icon Proc" },
	   /* 6 */	{d_text_proc ,	178 ,	138 ,	192 ,	12 ,	palette_color[249] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Icon context menu" },
	   /* 7 */	{d_button_proc ,	190 ,	252 ,	54 ,	12 ,	palette_color[13] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Ok" },
	   /* 8 */	{d_button_proc ,	310 ,	252 ,	54 ,	12 ,	palette_color[13] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
	     { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
	};
	centre_dialog(icon_this);
	do{
	   popup_dialog(icon_this,-1);
	   if (icon_this[_ICON_THIS_HELP].flags==MSG_DCLICK) help();
	   if (icon_this[_ICON_THIS_SELECT_ICON_PROC].flags!=D_SELECTED) ret=0;
	   if (icon_this[_ICON_THIS_SHOW_ACTIVE_BITMAP].flags==D_SELECTED) ActiveBitmap=0;
	   if (icon_this[_ICON_THIS_SHOW_SELECTED_BITMAP].flags==D_SELECTED) ActiveBitmap=1;
	   if (icon_this[_ICON_THIS_SHOW_DISABLED_BITMAP].flags==D_SELECTED) ActiveBitmap=2;
	}
	while (icon_this[_ICON_THIS_OK].flags!=MSG_DCLICK);
     if (!ret)
        {
         activate_func(Gui_area);
         blit(Gui_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
        }

     }

   return ret;
     
}




void gui_d_icon_proc::export()
{
   AdaptFilename(file);
   AdaptFilename(fileSelected);
   AdaptFilename(fileDisabled);
   strcpy(s,dp);
   dp="DUMMY";
   dialog::export();
   fout<<"\n"<<s; /* The s-argument can include spaces */
   dp=s;
   fout<<"\n"<<file;
   fout<<"\n"<<num;
   fout<<"\n"<<dp2;
   fout<<"\n"<<fileSelected;
   fout<<"\n"<<numSelected;
   fout<<"\n"<<dp3;
   fout<<"\n"<<fileDisabled;
   fout<<"\n"<<numDisabled;

}
void gui_d_icon_proc::rename(char* number)
{
 dp=dp+number;
 dp2=dp2+number;
 dp3=dp3+number;
 }
void gui_d_icon_proc::import()

{
   dialog::import();
   fin.getline(s,255); /* There is a newlinechar*/
   fin.getline(s,255);
   dp=s;
   fin.getline(file,255);
   fin>>num;
   dp=s;
   fin>>dp2;
   fin.getline(fileSelected,255);
   fin>>numSelected;
   fin>>dp3;
   fin.getline(fileDisabled,255);
   fin>>numDisabled;
   destroy_bitmap(b_map);
   destroy_bitmap(bSelected);
   destroy_bitmap(bDisabled);
   bSelected=create_bitmap(w,h);
   bDisabled=create_bitmap(w,h);
   b_map=create_bitmap(w,h);
   load_file(file,b_map,num);
   load_file(fileSelected,bSelected,numSelected);
   load_file(fileDisabled,bDisabled,numDisabled);
}

char* gui_d_icon_proc::input()
{
  // Allegro - C- code done with MichisDialogkiste
   char ret[256];
   char wd_[256];
   char hi[256];
   char wds[256];
   char his[256];
   char wdd[256];
   char hid[256];
   char nums[256];
   char numd[256];
   char x_[5];
   char y_[5];
   char d1_[5];
   char d2_[5];
   
   strcpy(ret,file);
   itoa(w,wd_,10);
   itoa(h,hi,10);
   itoa(ws,wds,10);
   itoa(hs,his,10);
   itoa(wd,wdd,10);
   itoa(hd,hid,10);

   itoa(x,x_,10);
   itoa(y,y_,10);
   itoa(d1,d1_,10);
   itoa(d2,d2_,10);
   itoa(num,num_,10);
   itoa(numSelected,nums,10);
   itoa(numDisabled,numd,10);


   // Allegro - C- code done with MichisDialogkiste
   //                   MDK 3.0
#define _ICON_ID_GRABB_OTHER2 36
#define _ICON_ID_GRABB_OTHER3 37
#define _ICON_ID_OK 38
#define _ICON_ID_CANCEL 39
#define _ICON_ID_HELP 40
#define _ICON_ID_GRABB_OTHER 41
#define _ICON_ID_POSITION 42
#define _ICON_ID_SIZE 48
   DIALOG Icon_ID[]= {
      /* 0 */	{ d_shadow_box_proc ,	10 ,	12 ,	312 ,	450 ,	palette_color[5] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 1 */	{ d_box_proc ,	34 ,	90 ,	258 ,	102 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 2 */	{ d_box_proc ,	34 ,	210 ,	258 ,	102 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 3 */	{ d_box_proc ,	34 ,	330 ,	258 ,	102 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	NULL},
      /* 4 */	{d_text_proc ,	43 ,	114 ,	48 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "File Name" },
      /* 5 */	{d_edit_proc ,	43 ,	126 ,	240,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	 file},
      /* 6 */	{d_text_proc ,	43 ,	138 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "Bitmap number in file:" },
      /* 7 */	{d_text_proc ,	40 ,	24 ,	156 ,	24 ,	palette_color[136] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Icon Object" },
      /* 8 */	{d_edit_proc ,	223 ,	138 ,	48 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	 num_ },
      /* 9 */	{d_text_proc ,	223 ,	138 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "1" },
      /* 10 */	{d_text_proc ,	49 ,	150 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "width:" },
      /* 11 */	{d_text_proc ,	115 ,	150 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 wd_ },
      /* 12 */	{d_text_proc ,	49 ,	162 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "height:" },
      /* 13 */	{d_text_proc ,	115 ,	162 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 hi },
      /* 14 */	{d_text_proc ,	46 ,	96 ,	204 ,	12 ,	palette_color[96] ,	palette_color[223] ,	0 ,	0 ,	0 ,	0 ,	 "* Icon Bitmap (active) *" },
      /* 15 */	{d_text_proc ,	49 ,	234 ,	48 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "File Name" },
      /* 16 */	{d_edit_proc ,	49 ,	246 ,	240,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	 fileSelected},
      /* 17 */	{d_text_proc ,	49 ,	258 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "Bitmap number in file:" },
      /* 18 */	{d_edit_proc ,	229 ,	258 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	 nums },
      /* 19 */	{d_text_proc ,	55 ,	270 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "width:" },
      /* 20 */	{d_text_proc ,	115 ,	270 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 wds },
      /* 21 */	{d_text_proc ,	55 ,	282 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "height:" },
      /* 22 */	{d_text_proc ,	115 ,	282 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 his },
      /* 23 */	{d_text_proc ,	46 ,	216 ,	204 ,	12 ,	palette_color[96] ,	palette_color[223] ,	0 ,	0 ,	0 ,	0 ,	 "* Icon Bitmap (selected) *" },
      /* 24 */	{d_text_proc ,	49 ,	354 ,	48 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "File Name" },
      /* 25 */	{d_edit_proc ,	49 ,	366 ,	240,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	 fileDisabled },
      /* 26 */	{d_text_proc ,	49 ,	378 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "Bitmap number in file:" },
      /* 27 */	{d_text_proc ,	55 ,	390 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "width:" },
      /* 28 */	{d_text_proc ,	115 ,	390 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 wdd },
      /* 29 */	{d_text_proc ,	55 ,	402 ,	132 ,	12 ,	palette_color[137] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 "height:" },
      /* 30 */	{d_text_proc ,	115 ,	402 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	0 ,	0 ,	 hid },
      /* 31 */	{d_text_proc ,	46 ,	342 ,	204 ,	12 ,	palette_color[96] ,	palette_color[223] ,	0 ,	0 ,	0 ,	0 ,	 "* Icon Bitmap (disabled) *" },
      /* 32 */	{d_text_proc ,	58 ,	36 ,	156 ,	24 ,	palette_color[96] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Push depth <d1>:" },
      /* 33 */	{d_text_proc ,	58 ,	48 ,	156 ,	24 ,	palette_color[96] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "focus <d2>:" },
      /* 34 */	{d_edit_proc ,	193 ,	36 ,	48 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 d1_ },
      /* 35 */	{d_edit_proc ,	193 ,	48 ,	48 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 d2_ },
      /* 36 */	{d_button_proc ,	158 ,	279 ,	120 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Grabb other" },
      /* 37 */	{d_button_proc ,	164 ,	399 ,	120 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Grabb other" },
      /* 38 */	{d_button_proc ,	34 ,	444 ,	54 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "OK" },
      /* 39 */	{d_button_proc ,	124 ,	444 ,	54 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
      /* 40 */	{d_button_proc ,	244 ,	444 ,	54 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Help" },
      /* 41 */	{d_button_proc ,	158 ,	159 ,	120 ,	12 ,	palette_color[33] ,	palette_color[140] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Grabb other" },
      /* 42 */	{d_button_proc ,	178 ,	75 ,	66 ,	12 ,	palette_color[1] ,	palette_color[9] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Position" },
      /* 43 */	{d_text_proc ,	58 ,	60 ,	56 ,	24 ,	palette_color[96] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "PosX:" },
      /* 44 */	{d_text_proc ,	115 ,	60 ,	48 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 x_ },
      /* 45 */	{d_text_proc ,	58 ,	72 ,	56 ,	24 ,	palette_color[96] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "PosY:" },
      /* 46 */	{d_text_proc ,	115 ,	72 ,	48 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 y_ },
      /* 47 */	{d_edit_proc ,	229 ,	378 ,	48 ,	12 ,	palette_color[1] ,	palette_color[140] ,	0 ,	0 ,	256 ,	1 ,	 numd },
      /* 48 */	{d_button_proc ,	178 ,	60 ,	66 ,	12 ,	palette_color[1] ,	palette_color[9] ,	0 ,	D_EXIT ,	0 ,	0 ,"Size" },
	{ NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
   };
   centre_dialog(Icon_ID);
   do
     {
      popup_dialog(Icon_ID,-1);
      if (Icon_ID[_ICON_ID_GRABB_OTHER].flags==MSG_DCLICK)
	{
	   strcpy(str_all[0],file);
	   strcpy(file,grabber_call(num_all, str_all));
	   set_mouse_sprite(My_busy_pointer);
	   num=*num_all-1;
	   itoa(num,num_,10);
	   strcpy(wd_,str_all[1]);
	   strcpy(hi,str_all[2]);
	   w=atoi(wd_);
	   h=atoi(hi);
	   destroy_bitmap(b_map);
	   b_map=create_bitmap(w,h);
	   clear_to_color(b_map,palette_color[255]);
	   if (num>-1)
	     {
            if (BitmapContainer!=NULL) {
		BitmapContainer=load_datafile(file);
		blit((BITMAP*) BitmapContainer[num].dat,b_map,0,0,0,0,w,h);
		unload_datafile(BitmapContainer);
            }
            else warning(file);
	     }
	   set_mouse_sprite(My_mouse_pointer);
	}
     if (Icon_ID[_ICON_ID_SIZE].flags==MSG_DCLICK)
      {
         dialog tmp("Rect");
         rect_preparer p;
         p.run();
	   p.coordinate_transform(tmp);
         x=tmp.x;y=tmp.y;w=tmp.w;h=tmp.h;
         itoa(x,x_,10);
	   itoa(y,y_,10);
         itoa(w,wd_,10);
         itoa(h,hi,10);
         strcpy(ret,"sized");
         BLIT;
      }

     if (Icon_ID[_ICON_ID_POSITION].flags==MSG_DCLICK)
	{
	   set_mouse_sprite(My_centre_pointer);
	   set_mouse_sprite_focus(X_GUI+8, Y_GUI+8);
	   if (num>=0)
	     {
		
		while (!(mouse_b&1))
		  {
		     x=grid(mouse_x)-X_GUI;
		     y=grid(mouse_y)-Y_GUI;
		     blit(Gui_area,temp_area,0,0,0,0,_W,_H);
		     show_mouse(temp_area);
		     activate_func(temp_area);
		     blit(temp_area,screen,0,0,X_GUI,Y_GUI,_W,_H);
		  };
	     }
	   else
	     {
		while (!(mouse_b&1));
	     }
	   show_mouse(NULL);
	   x=grid(mouse_x)-X_GUI;
	   y=grid(mouse_y)-Y_GUI;
	   itoa(x,x_,10);
	   itoa(y,y_,10);
	   strcpy(ret,"item positioned");
	   set_mouse_sprite(My_mouse_pointer);
	   set_mouse_sprite_focus(0,0);
	   BLIT;
	   show_mouse(screen);
	   
	}
      if (Icon_ID[_ICON_ID_GRABB_OTHER2].flags==MSG_DCLICK)
	{
	   strcpy(str_all[0],fileSelected);
         if (numSelected>-1) *num_all=numSelected;
	   strcpy(fileSelected,grabber_call(num_all, str_all));
	   set_mouse_sprite(My_busy_pointer);
	   numSelected=*num_all-1;
	   itoa(numSelected,nums,10);
	   strcpy(wds,str_all[1]);
	   strcpy(his,str_all[2]);
	   ws=atoi(wds);
	   hs=atoi(his);
         destroy_bitmap(bSelected);
	   bSelected=create_bitmap(ws,hs);
	   clear_to_color(bSelected,palette_color[255]);
    	   ws=atoi(wds);
	   hs=atoi(his);

	   if (numSelected>-1)
	     {
            if (BitmapContainer!=NULL) {
		BitmapContainer=load_datafile(fileSelected);
		blit((BITMAP*) BitmapContainer[numSelected].dat,bSelected,0,0,0,0,ws,hs);
		unload_datafile(BitmapContainer);
            }
            else warning(fileSelected);
	     }

	   set_mouse_sprite(My_mouse_pointer);
	};
      if (Icon_ID[_ICON_ID_GRABB_OTHER3].flags==MSG_DCLICK)
	{
	   strcpy(str_all[0],fileDisabled);
         if (numDisabled>-1) *num_all=numDisabled;
	   strcpy(fileDisabled,grabber_call(num_all, str_all));
	   set_mouse_sprite(My_busy_pointer);
	   numDisabled=*num_all-1;
	   itoa(numDisabled,numd,10);
	   strcpy(wdd,str_all[1]);
	   strcpy(hid,str_all[2]);
	   wd=atoi(wdd);
	   hd=atoi(hid);
	   destroy_bitmap(bDisabled);
	   bDisabled=create_bitmap(wd,hd);
	   clear_to_color(bDisabled,palette_color[255]);
	   if (numDisabled>-1)
	     {
            if (BitmapContainer!=NULL) {

		BitmapContainer=load_datafile(file);
		blit((BITMAP*) BitmapContainer[numDisabled].dat,bDisabled,0,0,0,0,wd,hd);
		unload_datafile(BitmapContainer);
            }
           else warning(fileDisabled);
	     }
	   set_mouse_sprite(My_mouse_pointer);
	};
      if (Icon_ID[_ICON_ID_HELP].flags==MSG_DCLICK) help();
	if (Icon_ID[_ICON_ID_CANCEL].flags==MSG_DCLICK)

        {
        strcpy(ret,"Cancel");
        return ret;
        }
     } while ((Icon_ID[_ICON_ID_OK].flags!=MSG_DCLICK)&(Icon_ID[_ICON_ID_CANCEL].flags!=MSG_DCLICK));

   if (num>-1)
     {
	w=atoi(wd_);
	h=atoi(hi);
	destroy_bitmap(b_map);
	b_map=create_bitmap(w,h);
	clear_to_color(b_map,palette_color[255]);
	BitmapContainer=load_datafile(file);
      if (BitmapContainer!=NULL) {
	blit((BITMAP*) BitmapContainer[num].dat,b_map,0,0,0,0,w,h);
	unload_datafile(BitmapContainer);
      }
      else warning(file);
     } else strcpy(ret,"Cancel");
   if (numSelected>-1)
     {
	ws=atoi(wds);
	hs=atoi(his);
	destroy_bitmap(bSelected);
	bSelected=create_bitmap(ws,hs);
	clear_to_color(bSelected,palette_color[255]);
	ws=atoi(wds);
	hs=atoi(his);
	BitmapContainer=load_datafile(fileSelected);
      if (BitmapContainer!=NULL){
	blit((BITMAP*) BitmapContainer[numSelected].dat,bSelected,0,0,0,0,ws,hs);
	unload_datafile(BitmapContainer);
      }
     else warning(fileSelected);
     }
   
   if (numDisabled>-1)
     {
	wd=atoi(wdd);
	hd=atoi(hid);
	destroy_bitmap(bDisabled);
	bDisabled=create_bitmap(wd,hd);
	clear_to_color(bDisabled,palette_color[255]);
	BitmapContainer=load_datafile(file);
      if (BitmapContainer!=NULL)
      {
      	blit((BITMAP*) BitmapContainer[numDisabled].dat,bDisabled,0,0,0,0,wd,hd);
	      unload_datafile(BitmapContainer);
         }
      else warning(fileDisabled);
     }

   return ret;
}

int gui_d_icon_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{  BITMAP* Temp;
   Temp=b_map;
   switch (ActiveBitmap)
     {
      case 1:b_map=bSelected;
             key="D_SELECTED";
             break;
      case 2:b_map=bDisabled;
             key="D_DISABLED";
             break;
      default:key="";
	
     }
   gui_d_bitmap_proc::activate_func(b,fgd,bgd);
   b_map=Temp;
}






gui_d_slider_proc::gui_d_slider_proc(char* text):gui_d_bitmap_proc(text)
     {
	name="d_slider_proc";
      wb=0;
      hb=0;
      dp="slider_no";
      b_map=NULL;
      dp2="NULL";
      dp3="NULL";
      strcpy(s,"filename");
     }

void gui_d_slider_proc::export()
{
   AdaptFilename(file);
   if (b_map==NULL) dp="NULL";
   strcpy(s,dp);
   dp="DUMMY";
   dialog::export();
   fout<<"\n"<<s; /* The s-argument can include spaces */
   dp=s;
   fout<<"\n"<<file;
   fout<<"\n"<<num;
   fout<<"\n"<<dp2;
   fout<<"\n"<<dp3;
   fout<<"\n"<<wb;
   fout<<"\n"<<hb;
 }
void gui_d_slider_proc::import()
{
   dialog::import();
   fin.getline(s,255); /* There is a newlinechar*/
   fin.getline(s,255);
   fin.getline(file,255);
   fin>>num;
   dp=s;
   fin>>dp2>>dp3>>wb>>hb;
   destroy_bitmap(b_map);
   b_map=create_bitmap(wb,hb);
   load_file(file,b_map,num);
 }




char* gui_d_slider_proc::input()
{


// Allegro - C- code done with MichisDialogkiste
//                   MDK 3.0
#define _SLIDER_DLG_GRABB_OTHER 12
#define _SLIDER_DLG_NO_BITMAP_CONNECTION 13
#define _SLIDER_DLG_OK 20
#define _SLIDER_DLG_CANCEL 21
#define _SLIDER_DLG_HELP 22
#define _SLIDER_DLG_SIZE_BITMAP 23
char wd[5] ;
char hi[5] ;
char d1_[256];
char dp2_[256];
char dp3_[256];
char ret[256];
itoa(wb,wd,10);
itoa(hb,hi,10);
itoa(d1,d1_,10);
itoa(num,num_,10);
strcpy(dp2_,dp2);
strcpy(dp3_,dp3);

 DIALOG slider_dlg[]= {
/* 0 */	{ d_shadow_box_proc ,	130 ,	90 ,	336 ,	234 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 1 */	{d_text_proc ,	142 ,	102 ,	162 ,	12 ,	palette_color[249] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 name },
/* 2 */	{ d_box_proc ,	154 ,	126 ,	270 ,	84 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	NULL},
/* 3 */	{d_text_proc ,	160 ,	132 ,	252 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	 "Slider Bitmap Handling (dp)" },
/* 4 */	{d_text_proc ,	160 ,	150 ,	78 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	 "DAT-file:" },
/* 5 */	{d_text_proc ,	160 ,	162 ,	78 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	 "number in file:" },
/* 6 */	{ d_edit_proc ,	286 ,	162 ,	100 ,	12 ,	palette_color[192] ,	palette_color[31] ,	0 ,	0 , 256 ,	1 ,	num_},
/* 7 */	{ d_edit_proc ,	286 ,	150 ,	100 ,	12 ,	palette_color[160] ,	palette_color[31] ,	0 ,	0 , 256 ,	1 ,	file},
/* 8 */	{d_text_proc ,	184 ,	174 ,	42 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	 "Width:" },
/* 9 */	{d_text_proc ,	184 ,	186 ,	42 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	 "Height:" },
/* 10 */	{d_text_proc ,	256 ,	174 ,	36 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	wd },
/* 11 */	{d_text_proc ,	256 ,	186 ,	36 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	0 ,	0 ,	0 ,	hi },
/* 12 */	{d_button_proc ,	310 ,	176 ,	102 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Grabb other" },
/* 13 */	{d_check_proc ,	142 ,	222 ,	172 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	D_SELECTED ,	0 ,	0 ,	 "No Bitmap connection" },
/* 14 */	{d_text_proc ,	142 ,	240 ,	210 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Range from 0 to (d1):" },
/* 15 */	{d_edit_proc ,	316 ,	240 ,	36 ,	12 ,	palette_color[192] ,	palette_color[28] ,	0 ,	0 ,  25 ,	1 ,	 d1_ },
/* 16 */	{d_text_proc ,	142 ,	258 ,	210 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Callback function (dp2):" },
/* 17 */	{ d_edit_proc ,	340 ,	258 ,	100 ,	12 ,	palette_color[192] ,	palette_color[28] ,	0 ,	0 , 256 ,	1 ,	dp2_},
/* 18 */	{d_text_proc ,	142 ,	276 ,	210 ,	12 ,	palette_color[97] ,	palette_color[28] ,	0 ,	0 ,	0 ,	0 ,	 "Argument of callback (dp3):" },
/* 19 */	{ d_edit_proc ,	364 ,	276 ,	100 ,	12 ,	palette_color[192] ,	palette_color[28] ,	0 ,	0 ,  256,	1 ,	dp3_},
/* 20 */	{d_button_proc ,	142 ,	300 ,	78 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "OK" },
/* 21 */	{d_button_proc ,	262 ,	300 ,	78 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Cancel" },
/* 22 */	{d_button_proc ,	370 ,	300 ,	78 ,	12 ,	palette_color[5] ,	palette_color[28] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "help" },
/* 23 */	{d_button_proc ,	310 ,	190 ,	102 ,	12 ,	palette_color[18] ,	palette_color[31] ,	0 ,	D_EXIT ,	0 ,	0 ,	 "Size Bitmap" },
 { NULL,              0,    0,    0,    0,    0,    0,    0,    0,       0,    0,    NULL }
 };
 centre_dialog(slider_dlg);
 do
 {
  popup_dialog(slider_dlg,-1);
  num=atoi(num_);
  d1=atoi(d1_);
  strcpy(s,file);
  if (slider_dlg[_SLIDER_DLG_HELP].flags==MSG_DCLICK) help();
  if (slider_dlg[_SLIDER_DLG_CANCEL].flags==MSG_DCLICK) strcpy(s,"Cancel"); else strcpy(s,"");
  if (slider_dlg[_SLIDER_DLG_NO_BITMAP_CONNECTION].flags==MSG_DCLICK)
   {
     b_map=NULL;
    }
  if (slider_dlg[_SLIDER_DLG_SIZE_BITMAP].flags==MSG_DCLICK)
      {
         dialog tmp("Rect");
         rect_preparer p;
         p.run();
	   p.coordinate_transform(tmp);
         x=tmp.x;y=tmp.y;wb=tmp.w;hb=tmp.h;
         itoa(wb,wd,10);
         itoa(hb,hi,10);
	   destroy_bitmap(b_map);
	   b_map=create_bitmap(wb,hb);
	   clear_to_color(b_map,palette_color[255]);
	   if (num>-1)
	     {
		BitmapContainer=load_datafile(file);
            if (BitmapContainer!=NULL)
              {
               blit((BITMAP*) BitmapContainer[num].dat,b_map,0,0,0,0,wb,hb);
		   unload_datafile(BitmapContainer);
               }
                  else warning(file);
                  }

      }

  if (slider_dlg[_SLIDER_DLG_GRABB_OTHER].flags==MSG_DCLICK)
	{
	   strcpy(str_all[0],file);
	   strcpy(file,grabber_call(num_all, str_all));
	   set_mouse_sprite(My_busy_pointer);
	   num=*num_all-1;
	   itoa(num,num_,10);
	   strcpy(wd,str_all[1]);
	   strcpy(hi,str_all[2]);
	   wb=atoi(wd);
	   hb=atoi(hi);
	   destroy_bitmap(b_map);
	   b_map=create_bitmap(wb,hb);
	   clear_to_color(b_map,palette_color[255]);
	   if (num>-1)
	     {
		BitmapContainer=load_datafile(file);
            if (BitmapContainer!=NULL){
		blit((BITMAP*) BitmapContainer[num].dat,b_map,0,0,0,0,wb,hb);
		unload_datafile(BitmapContainer);
            }
            else warning(file);
	     }
	   set_mouse_sprite(My_mouse_pointer);
	}


  }while ((slider_dlg[_SLIDER_DLG_OK].flags!=MSG_DCLICK)&(slider_dlg[_SLIDER_DLG_CANCEL].flags!=MSG_DCLICK));
  return s;
}

int gui_d_slider_proc::activate_func(BITMAP* b = Gui_area,int fgd=-1, int bgd=0)
{
   if (fgd==-1) {fgd=fg;bgd=bg;};
   Screen=screen;
   screen=b;
   DIALOG this_dia[]=
     {
	d_slider_proc,    x,   y,   w,  h,   palette_color[fgd],  palette_color[bgd],    key_convert(),  flags_convert(),       255,  0,    b_map,    NULL, NULL
     };
   d_slider_proc(MSG_DRAW,this_dia,0);
   screen=Screen;
}
void gui_d_slider_proc::copy(gui_d_slider_proc& from,int& xc, int& yc,int NoDeltaMove=0)
{
  wb=from.wb;
  hb=from.hb;
  gui_d_bitmap_proc::copy(from,xc,yc,NoDeltaMove);
 }




void gui_d_bitmap_proc::help()
 {
  set_object_help_bitmap();
  do_help();
 }
void gui_d_slider_proc::help()
 {
   set_object_help_slider();
   do_help();
 }

void gui_d_icon_proc::help()
 {
   set_object_help_icon();
   do_help();
 }
