//////////////////////////////////////////////////////////////////////////////
// Model implementation
#include <stdio.h>
#include <stdlib.h>
#include "mdlib.h"

// function declaration
extern q1mdl_t Q1LoadFile(char *filename);
extern void Q1Debug(q1mdl_t *model);
extern void Q1DrawPoints(BITMAP *dbuf, mdl_t *model);
extern void Q1DrawWireframe(BITMAP *dbuf, mdl_t *model);
extern void Q1DrawFlatShade(BITMAP *dbuf, mdl_t *model);
extern void Q1DrawTexture(BITMAP *dbuf, mdl_t *model);
extern void Q1UpdateView(camera_t cam, mdl_t *model);
extern void Q1Unload(mdl_t *model);
extern ascmdl_t ASCLoadFile(char *filename);
extern void ASCDebug(ascmdl_t *model);
extern void ASCDrawPoints(BITMAP *dbuf, mdl_t *model);
extern void ASCDrawWireframe(BITMAP *dbuf, mdl_t *model);
extern void ASCDrawFlatShade(BITMAP *dbuf, mdl_t *model);
extern void ASCUpdateView(camera_t cam, mdl_t *model);
extern q2mdl_t Q2LoadFile(char *filename);
extern void Q2DrawPoints(BITMAP *dbuf, mdl_t *model);
extern void Q2DrawWireframe(BITMAP *dbuf, mdl_t *model);
extern void Q2DrawTexture(BITMAP *dbuf, mdl_t *model);
extern void Q2UpdateView(camera_t cam, mdl_t *model);
extern void Q2Unload(mdl_t *model);

// returns the type of model file
int MDLCheckType(char *filename)
{
    PACKFILE *fp;
    long id, version;

    if( !exists(filename) ) return TYPE_UNKNOWN;

    fp = pack_fopen( filename, F_READ );

    id = pack_igetl( fp );
    version = pack_igetl( fp );

    pack_fclose(fp);

    if( id==IDQ1 ) return TYPE_MDLQ1;
    if( id==IDQ2 ) return TYPE_MDLQ2;
    if( id==IDQ3 ) return TYPE_MDLQ3;
    if( id==IDHL ) return TYPE_MDLHL;
    if( id==IDASC ) return TYPE_ASC;
    if( id & ID3DS ) return TYPE_3DS;
    // TODO: put other type of models here

    return TYPE_UNKNOWN;
}


// load a generic model file
mdl_t MDLLoad( char *filename )
{
    int type = MDLCheckType( filename );
    mdl_t model;

    model.q1mdl = NULL;
    model.q2mdl = NULL;
    model.q3mdl = NULL;
    model.hlmdl = NULL;
    model.s3dmdl = NULL;
    model.ascmdl = NULL;
    model.frameidx = 0;
    model.numframes = 0;


    switch (type)  // find out what type of model is it and call the apropriate LoadFile()
    {
        case TYPE_UNKNOWN:
            printf("MDLLoad(): Unknown model file\n");
            model.type = TYPE_UNKNOWN;
            break;
        case TYPE_MDLQ1:
            model.q1mdl = (q1mdl_t *)malloc( sizeof(q1mdl_t) );
            *model.q1mdl = Q1LoadFile( filename );
            model.type = TYPE_MDLQ1;
            model.numframes = model.q1mdl->header.numframes;
            break;
        case TYPE_MDLQ2:
            model.q2mdl = (q2mdl_t *)malloc( sizeof(q2mdl_t) );
            *model.q2mdl = Q2LoadFile( filename );
            model.type = TYPE_MDLQ2;
            model.numframes = model.q2mdl->header.num_frames;
            break;
//        case TYPE_MDLQ3:
//            model.q3mdl = (q3mdl_t *)malloc( sizeof(q3mdl_t) );
//            *model.q3mdl = Q3LoadFile( filename );
//            model.type = TYPE_MDLQ3;
//            break;
//        case TYPE_MDLHL:
//            model.hlmdl = (hlmdl_t *)malloc( sizeof(hlmdl_t) );
//            *model.hlmdl = HLLoadFile( filename );
//            model.type = TYPE_MDLHL;
//            break;
//        case TYPE_3DS:
//            model.s3dmdl = (s3dmdl_t *)malloc( sizeof(s3dmdl_t) );
//            *model.s3dmdl = S3DLoadFile( filename );
//            model.type = TYPE_3DS;
//            break;
        case TYPE_ASC:
            model.ascmdl = (ascmdl_t *)malloc( sizeof(ascmdl_t) );
            *model.ascmdl = ASCLoadFile( filename );
            model.type = TYPE_ASC;
            break;
        default:
            printf("MDLLoad(): Unknown error!\n");
            model.type = TYPE_UNKNOWN;
            break;
    }


    return model;
}


// draw points on the screen
void MDLDrawPoints(BITMAP *dbuf, mdl_t *model)
{
    switch (model->type)  // find out what type of model is it and call the apropriate DrawPoints()
    {
        case TYPE_UNKNOWN:
            printf("MDLDrawPoints(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1DrawPoints( dbuf, model );
            break;
        case TYPE_MDLQ2:
            Q2DrawPoints( dbuf, model );
            break;
//        case TYPE_MDLQ3:
//            Q3DrawPoints( dbuf, model );
//            break;
//        case TYPE_MDLHL:
//            HLDrawPoints( dbuf, model );
//            break;
//        case TYPE_3DS:
//            S3DDrawPoints( dbuf, model );
//            break;
        case TYPE_ASC:
            ASCDrawPoints( dbuf, model );
            break;
        default:
            printf("MDLDrawPoints(): Unknown error!\n");
            break;
    }
}

// draw wireframe triangles
void MDLDrawWireframe( BITMAP *dbuf, mdl_t *model )
{
    switch (model->type)  // find out what type of model is it and call the apropriate DrawWireframe()
    {
        case TYPE_UNKNOWN:
            printf("MDLDrawWireframe(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1DrawWireframe( dbuf, model );
            break;
        case TYPE_MDLQ2:
            Q2DrawWireframe( dbuf, model );
            break;
//        case TYPE_MDLQ3:
//            Q3DrawWireframe( dbuf, model );
//            break;
//        case TYPE_MDLHL:
//            HLDrawWireframe( dbuf, model );
//            break;
//        case TYPE_3DS:
//            S3DDrawWireframe( dbuf, model );
//            break;
        case TYPE_ASC:
            ASCDrawWireframe( dbuf, model );
            break;
        default:
            printf("MDLDrawWireframe(): Unknown error!\n");
            break;
    }
}

// Draw flat shaded triangles
void MDLDrawFlatShade( BITMAP *dbuf, mdl_t *model )
{
    switch (model->type)  // find out what type of model is it and call the apropriate DrawFlatShade()
    {
        case TYPE_UNKNOWN:
            printf("MDLDrawFlatShade(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1DrawFlatShade( dbuf, model );
            break;
//        case TYPE_MDLQ2:
//            Q2DrawFlatShade( dbuf, model );
//            break;
//        case TYPE_MDLQ3:
//            Q3DrawFlatShade( dbuf, model );
//            break;
//        case TYPE_MDLHL:
//            HLDrawFlatShade( dbuf, model );
//            break;
//        case TYPE_3DS:
//            S3DDrawFlatShade( dbuf, model );
//            break;
        case TYPE_ASC:
            ASCDrawFlatShade( dbuf, model );
            break;
        default:
            printf("MDLDrawFlatShade(): Unknown error!\n");
            break;
    }
}



// draws textured triangles
void MDLDrawTexture( BITMAP *dbuf, mdl_t *model )
{
    switch (model->type)  // find out what type of model is it and call the apropriate DrawTexture()
    {
        case TYPE_UNKNOWN:
            printf("MDLDrawTexture(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1DrawTexture( dbuf, model );
            break;
        case TYPE_MDLQ2:
            Q2DrawTexture( dbuf, model );
            break;
//        case TYPE_MDLQ3:
//            Q3DrawTexture( dbuf, model );
//            break;
//        case TYPE_MDLHL:
//            HLDrawTexture( dbuf, model );
//            break;
//        case TYPE_3DS:
//            S3DDrawTexture( dbuf, model );
//            break;
        case TYPE_ASC:
            printf("MDLDrawTexture(): .ASC models don't have textures!");
            break;
        default:
            printf("MDLDrawTexture(): Unknown error!\n");
            break;
    }
}


void MDLDrawGouradTexture( BITMAP *dbuf, mdl_t *model )
{

}

// rotate the points of the model according to a camera
void MDLUpdateView( camera_t cam, mdl_t *model )
{
    switch (model->type)  // find out what type of model is it and call the apropriate UpdateView()
    {
        case TYPE_UNKNOWN:
            printf("MDLUpdateView(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1UpdateView( cam, model );
            break;
        case TYPE_MDLQ2:
            Q2UpdateView( cam, model );
            break;
//        case TYPE_MDLQ3:
//            Q3UpdateView( cam, model );
//            break;
//        case TYPE_MDLHL:
//            HLUpdateView( cam, model );
//            break;
//        case TYPE_3DS:
//            S3DUpdateView( cam, model );
//            break;
        case TYPE_ASC:
            ASCUpdateView( cam, model );
            break;
        default:
            printf("MDLUpdateView(): Unknown error!\n");
            break;
    }
}

// Make the camera move, rotate, chase, based on what type of camera is it
// You must update all the cameras you create even if you aren't using them all the time
void MDLUpdateCamera( camera_t *cam )
{

}

// show some info about the model
void MDLDebug( mdl_t *model )
{

    switch (model->type)  // find out what type of model is it and call the apropriate Debug()
    {
        case TYPE_UNKNOWN:
            printf("MDLDebug(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1Debug( model->q1mdl );
            break;
        case TYPE_MDLQ2:
            Q2Debug( model->q2mdl );
            break;
//        case TYPE_MDLQ3:
//            Q3Debug( model->q3mdl );
//            break;
//        case TYPE_MDLHL:
//            HLDebug( model->hlmdl );
//            break;
//        case TYPE_3DS:
//            S3DDebug( model->s3dmdl );
//            break;
        case TYPE_ASC:
            ASCDebug( model->ascmdl );
            break;
        default:
            printf("MDLDebug(): Unknown error!\n");
            break;
    }
}

// free memory if we are no longer using this model
void MDLUnload(mdl_t *model)
{
    switch (model->type)  // find out what type of model is it and call the apropriate Unload()
    {
        case TYPE_UNKNOWN:
            printf("MDLUnload(): Unknown model file\n");
            break;
        case TYPE_MDLQ1:
            Q1Unload( model );
            free( model->q1mdl );
            break;
        case TYPE_MDLQ2:
            Q2Unload( model );
            free( model->q2mdl );
            break;
//        case TYPE_MDLQ3:
//            Q3DrawPoints( dbuf, model->q3mdl );
//            break;
//        case TYPE_MDLHL:
//            HLDrawPoints( dbuf, model->hlmdl );
//            break;
//        case TYPE_3DS:
//            S3DDrawPoints( dbuf, model->s3dmdl );
//            break;
//        case TYPE_ASC:
//            ASCUnload( model );
//            free( model->ascmdl );
//            break;
        default:
            printf("MDLUnload(): Unknown error!\n");
            break;
    }
}


// Sort a list e put the order in the v vector
// left must be zero and right must be the size of the vector-1
void Mysort(float *list, long v[], long left, long right)
{
	long i, last;

	if(left >= right) return;/* do nothing if array contains fewer than two elements */
	Swapsort(v, left, (left+right)/2); /* move partition element to v[0] */
	last = left;

	for(i=left+1; i<=right; i++) if(list[v[i]] < list[v[left]]) Swapsort(v, ++last, i);

	Swapsort(v, left, last); /* restore partition element */
	Mysort(list, v, left, last-1);
	Mysort(list, v, last+1, right);
}


// Do a swap. I use it to sort the distance values
void Swapsort(long v[], long i, long j)
{
	long temp;

	temp = v[i];
	v[i] = v[j];
	v[j] = temp;
}

