/**[txh]********************************************************************

  Description:
  That's the third example for Palantir.
  The objetive is to send and receive information of the modem.
  This example assumes a modem in COM3, please read and modify it to your
hardware setup. (line 192 to change used com number, line 203 to change
used IRQ number )

  Copyright (c) 1997 by Salvador Eduardo Tropea (SET)
  e-mail: salvador@inti.gov.ar or set-soft@usa.net

  Parts of this code:
  Copyright 1997 Dim Zegebart, Moscow Russia.
  e-mail zager@post.comstar.ru

  You can do anything with this code but:

1) You can't remove the copyright.
2) You can't blame me for any reason.

Changed by Dim Zegebart to works properly with Palantir 0.4
***************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <palantir.h>
#include <io.h>

#define LWPEnDisableUsed int tmp
// A simple routine to show the erros from DZComm
inline void dz_print_comm_err()
{
 printf("%s",szDZCommErr);
 fflush(stdout);
}

// That's to handle the COM port. That's a little different to the keyboard
// and the mouse where the devices are defined by Palantir, here we must
// call to DZComm to create a device suitable for our COM.
device *modem;

/**[txh]********************************************************************

  Description:
  I used it to debug DZComm.

***************************************************************************/

#ifdef DEBUG_HANDSHAKE
void ShowCTS_RTS(void)
{
 LWPEnDisableUsed;
 comm_port* port=(comm_port*)(modem->device_user_data);

 lwp_disable;
 printf("CTS: %d  RTS: %d  Can transmit: %d\n",
        port->cts,port->rts,
        port->cts==CTS_ON && port->rts==RTS_ON);
 lwp_enable;
}
#else
#define ShowCTS_RTS()
#endif

/**[txh]********************************************************************

  Description:
  That's our Modem Application. It will get all the messages from the modem.

***************************************************************************/

int modem_handler(a_message code,int p1,int p2)
{
 LWPEnDisableUsed;

 switch (code)
   {
    case APP_START:
         // That's an example of use for the APP_START, here we ask the
         // status to the modem.
         ShowCTS_RTS();
         comm_port_command_send(modem,"AT");
         ShowCTS_RTS();
         break;
    case H_COMM_IN:
         // It just shows in the screen each byte received from the modem
         if (p1==0) p1=' ';
         ShowCTS_RTS();
         lwp_disable;
         putch((char)p1);
         lwp_enable;
         break;
    case APP_STOP:
         return 0;
         break;
    default : break;
   }

 return 1;
}


/**[txh]********************************************************************

  Description:
  That's our Keyboard Handler application.
  It will receive messages from the keyboard.
  In this example we use it for:

1) Quit with Ctrl+Q
2) Implement a couple of shortcuts (Ctrl+A,Ctrl+H)
3) Send all the keystrokes to the modem

***************************************************************************/

int keyboard_handler(a_message code,int p1,int p2)
{
 int c=p1;
 byte ch;

 if (code==H_KEYBOARD)
   {
    if (ctrl_(c,'Q'))
      {
       palantir_deinit();
       return 1;
      }
    if (ctrl_(c,'A'))
      { // I call to myself, I ever get busy ;-)))
       comm_port_command_send(modem,"ATDP7590013");
       return 1;
      }
    if (ctrl_(c,'H'))
      { // Hang up
       comm_port_command_send(modem,"+++ATH0");
       return 1;
      }
    ch=ascii_(c);

    #if 0
    // The modem produces the echo, we don't need it
    {  LWPEnDisableUsed;
    lwp_disable;
    putch(ch);
    lwp_enable;
    }
    #endif

    // Send the key to the modem
    ShowCTS_RTS();
    comm_port_out(modem,ch);
    ShowCTS_RTS();
   }
 return 1;
}


int main(void)
{
 LWPEnDisableUsed;
 // That's the pointer to our keyboard application
 dz_app *keyb_app;
 // That's the pointer to our modem application
 dz_app *modem_app;
 // we use it to configure the COM settings
// comm_port *port;

 clrscr();
 // Init Palantir using keyboard and COMs
 if (palantir_init(DEV_KEYBOARD | DEV_COMMS)==FALSE)
   {
    printf("Error: Palantir initialization failed\n");
    return 1;
   }

 // Now create the new application with:
 // Name="KBD APP", Stack=4K, Priority=1 (1 time slice per turn) and this
 // application will process the messages through keyboard_handler
 // Just used to stop the program with Ctrl+Q
 keyb_app=dz_app_new("KBD APP",4096,1,keyboard_handler);
 // Now "connect" our keyboard application with the keyboard device
 device_client_task_add(keyboard_device,keyb_app,READ);

 /*
   That's a little bit complex in comparisson with the rest, here we setup
   the modem application
 */
 // That creates the modem structure and fills it with default values for
 // the COM 3
 if ((modem=comm_port_init(_com2))==NULL)
   {
    dz_print_comm_err();
    return 2;
   }
 comm_port_load_settings(com2,"ports.ini");
 // That's a shortcut to the COM data
// port=(comm_port*)(modem->device_user_data);
 // Just a name for the modem structure
// strcpy(modem->szName,"Modem (type command)");
 // My COM3 uses IRQ 11 because I like to have a separated IRQ for each of
 // my COMs.
 // port->nIRQ=0xB;
 // The modems talks at low speed, 9600 is OK
// port->nBaud=_9600;
 // Use hardware flow control
// port->control_type=RTS_CTS;
 // Now install the ISR for our COM
 if (!comm_port_install_handler(modem))
   {
    dz_print_comm_err();
    return 3;
   }
 // That was all the needed stuff to setup the COM, now we can create the
 // application to handle it and connect it to our device.
 modem_app=dz_app_new("PORT3 APP",16384,1,modem_handler);
 device_client_task_add(modem,modem_app,READ);

 lwp_disable;
 printf("%X %X %X\n",cdport_(com2)->nIRQVector,
                     cdport_(com2)->nIRQ,cdport_(com2)->nPort);
 printf("Control the modem ...\nCtrl-Q to exit\n");
 lwp_enable;

 lwp_wait_true(&exit_program);
 return 0;
}
