//This example shows how to create threads using LWP API and Palantir one.

#include <stdio.h>
#include <conio.h>
#include <dos.h>
#include <palantir.h>
#include <io.h>

int keyboard_handler(a_message code,int p1,int p2)
{
 int tmp;
 int c=p1;
 byte ch;

 // Uncomment this line to see what messages receive the application.
 // You'll see it gets APP_START(37), H_KEYBOARD(26) & APP_STOP(38).
 // Note: The values are for Palantir 0.3.
 //printf("Code : %d\n",code);

 // See if the message is from the keyboard
 if (code==H_KEYBOARD)
   {
    // If yes test if the key is CTRL+Q
    if (ctrl_(c,'Q'))
      { // In this case just stop all
       palantir_deinit();
       return 1;
      }

    ch=ascii_(c);
    // We must avoid problems with other tasks, so we can't write to the
    // screen at the same time that other task. For this reason we disable
    // the task switcher during it. This must be done for ALL the
    // no-reentrant things.
    lwp_disable;
    putch(ch);
    lwp_enable;
   }
 return 1;
}


void proc1(void *argv)
{
  while(!exit_program)
   { printf("%s\n",(char*)argv);
//     lwp_sleep(1,0);
   }
}

void proc2(void *argv)
{
  while(!exit_program)
   { printf("%s\n",(char*)argv);
//     lwp_sleep(1,0);
   }
}

int main(void)
{ int tmp;

 // That's the pointer to our keyboard application
 dz_app *keyb_app;

 clrscr();
 // Init Palantir using only the keyboard
 if (palantir_init(DEV_KEYBOARD)==FALSE)
   {
    printf("Error: Palantir initialization failed\n");
    return 1;
   }

 // Now create the new application with:
 // Name="KBD APP", Stack=4K, Priority=1 (1 time slice per turn) and this
 // application will process the messages through keyboard_handler
 keyb_app=dz_app_new("KBD APP",4096,1,keyboard_handler);
 // Now "connect" our keyboard application with the keyboard device
 device_client_task_add(keyboard_device,keyb_app,READ);

 lwp_disable;
 printf("Touch keyboard ...\nCtrl-Q to exit\n");
 lwp_enable;

 lwp_spawn(proc1,4096,1,"Hello ! I'm proc1.",NULL); //DZ
 lwp_spawn(proc2,4096,2,"Hello ! I'm proc2.",NULL); //DZ

 lwp_wait_true(&exit_program);
 return 0;
}
