@ECHO OFF

REM **************************************
REM ****                              ****
REM ****  Salad installation program  ****
REM ****                              ****
REM ****  (c) by Sven Sandberg 1998   ****
REM ****                              ****
REM ****  Thanks to Ralf Brown and    ****
REM ****  Matthias Paul; their cool   ****
REM ****  bat-file for the interrupt  ****
REM ****  list helped me a lot when   ****
REM ****  making this bat-file.       ****
REM ****                              ****
REM **************************************

IF NOT EXIST install.bat GOTO noinstal
IF NOT EXIST src\salad.c GOTO nosalad
IF NOT EXIST %DJDIR%\bin\gcc.exe GOTO noenvdj
IF NOT EXIST %ALLEGRO%\src\allegro.c GOTO noenval
IF NOT EXIST %DJDIR%\bin\gcc.exe GOTO wrongdj
IF NOT EXIST %DJDIR%\lib\*.* GOTO wrongdj
IF NOT EXIST %DJDIR%\include\*.* GOTO wrongdj
IF NOT EXIST %DJDIR%\lib\liballeg.a GOTO warnal

:awarnal
ECHO.
ECHO =========================================================
ECHO ============ Installing Salad. Please wait. =============
ECHO =========================================================
ECHO.
IF "nolib"=="%1" GOTO acomplib
IF "nolib"=="%2" GOTO acomplib
IF "nolib"=="%3" GOTO acomplib
IF "-nolib"=="%1" GOTO acomplib
IF "-nolib"=="%2" GOTO acomplib
IF "-nolib"=="%3" GOTO acomplib
IF "/nolib"=="%1" GOTO acomplib
IF "/nolib"=="%2" GOTO acomplib
IF "/nolib"=="%3" GOTO acomplib
GOTO complib
:acomplib
IF "noexamples"=="%1" GOTO acompex
IF "noexamples"=="%2" GOTO acompex
IF "noexamples"=="%3" GOTO acompex
IF "-noexamples"=="%1" GOTO acompex
IF "-noexamples"=="%2" GOTO acompex
IF "-noexamples"=="%3" GOTO acompex
IF "/noexamples"=="%1" GOTO acompex
IF "/noexamples"=="%2" GOTO acompex
IF "/noexamples"=="%3" GOTO acompex
GOTO compex
:acompex
IF "nohelp"=="%1" GOTO amhelp
IF "nohelp"=="%2" GOTO amhelp
IF "nohelp"=="%3" GOTO amhelp
IF NOT EXIST %ALLEGRO%\obj\djgpp\makedoc.exe GOTO nomdoc
IF NOT EXIST %DJDIR%\bin\makeinfo.exe GOTO nominfo
GOTO mhelp
:amhelp
GOTO endok

:complib
	ECHO Copying headers...
		ECHO copy src\salad.h %DJDIR%\include\salad.h
		COPY src\salad.h %DJDIR%\include\salad.h >nul
	IF EXIST %DJDIR%\include\salad\*.* GOTO amincsal
		ECHO md %DJDIR%\include\salad
		md %DJDIR%\include\salad >nul
	:amincsal
	ECHO copy src\*.h %DJDIR%\include\salad\*.h
		COPY src\*.h %DJDIR%\include\salad\*.h >nul
		ECHO.
	ECHO Compiling library...
	ECHO gcc -I%DJDIR%\include -I%DJDIR%\include\salad -I%ALLEGRO% -I%ALLEGRO%\src\djgpp -O3 -Wall -c src\salad.c -o obj\salad.o
		gcc -I%DJDIR%\include -I%DJDIR%\include\salad -I%ALLEGRO% -I%ALLEGRO%\src\djgpp -c src\salad.c -o obj\salad.o -O3 -Wall
		IF NOT ERRORLEVEL 0 GOTO comperr
REM Making the lib is commented, since Salad doesn't seem to work as a lib.

REM   ECHO  ar ras %DJDIR%\lib\liballeg.a obj\salad.o
REM      ar ras obj\salad.o %DJDIR%\lib\liballeg.a
REM      IF NOT ERRORLEVEL 0 GOTO comperr
REM      ECHO.
REM   ECHO Copying library...
REM   ECHO copy lib\salad.a %DJDIR%\lib\libsalad.a
REM      COPY lib\salad.a %DJDIR%\lib\libsalad.a >nul
GOTO acomplib

:compex
	ECHO.
	ECHO Compiling examples...
	ECHO gcc -I%DJDIR%\include -O3 -Wall -c examples\sphere.c -o obj\sphere.o
		gcc -I%DJDIR%\include -O3 -Wall -c examples\sphere.c -o obj\sphere.o
		IF NOT ERRORLEVEL 0 GOTO comperr
	ECHO gcc -I%DJDIR%\include -O3 -Wall -c examples\fade.c -o obj\fade.o
		gcc -I%DJDIR%\include -O3 -Wall -c examples\fade.c -o obj\fade.o
		IF NOT ERRORLEVEL 0 GOTO comperr
	ECHO gcc -I%DJDIR%\include -O3 -Wall -c examples\char.c -o obj\char.o
		gcc -I%DJDIR%\include -O3 -Wall -c examples\char.c -o obj\char.o
		IF NOT ERRORLEVEL 0 GOTO comperr
	ECHO gcc -I%DJDIR%\include -O3 -Wall -c examples\timer.c -o obj\timer.o
		gcc -I%DJDIR%\include -O3 -Wall -c examples\timer.c -o obj\timer.o
		IF NOT ERRORLEVEL 0 GOTO comperr
	@ECHO Linking examples...
	ECHO gcc -o examples\sphere.exe obj\sphere.o obj\salad.o -lalleg -lm
		gcc -o examples\sphere.exe obj\sphere.o obj\salad.o -lalleg -lm
		IF NOT ERRORLEVEL 0 GOTO comperr
	ECHO gcc -o examples\fade.exe obj\fade.o obj\salad.o -lalleg -lm
		gcc -o examples\fade.exe obj\fade.o obj\salad.o -lalleg -lm
		IF NOT ERRORLEVEL 0 GOTO comperr
	ECHO gcc -o examples\char.exe obj\char.o obj\salad.o -lalleg -lm
		gcc -o examples\char.exe obj\char.o obj\salad.o -lalleg -lm
		IF NOT ERRORLEVEL 0 GOTO comperr
	ECHO gcc -o examples\timer.exe obj\timer.o obj\salad.o -lalleg -lm
		gcc -o examples\timer.exe obj\timer.o obj\salad.o -lalleg -lm
		IF NOT ERRORLEVEL 0 GOTO comperr
	IF NOT EXIST %DJDIR%\bin\djp.exe GOTO apackexe
		ECHO Packing examples...
		djp examples\*.exe
	:apackexe
GOTO acompex

:mhelp
	ECHO.
	ECHO Compiling help...
	IF EXIST	%DJDIR%\info\*.* GOTO amdjinfo
		ECHO md %DJDIR%\info
		md %DJDIR%\info >nul
	:amdjinfo
	ECHO %ALLEGRO%\obj\djgpp\makedoc -ascii salad.txt -htm docs\salad.htm -texinfo docs\salad.txi docs\salad._tx
		%ALLEGRO%\obj\djgpp\makedoc -ascii salad.txt -htm docs\salad.htm -texinfo docs\salad.txi docs\salad._tx >nul
		IF NOT ERRORLEVEL 0 GOTO hcomperr
	ECHO %ALLEGRO%\obj\djgpp\makedoc -ascii readme.txt -htm docs\readme.htm docs\readme._tx
		%ALLEGRO%\obj\djgpp\makedoc -ascii readme.txt -htm docs\readme.htm docs\readme._tx >nul
		IF NOT ERRORLEVEL 0 GOTO hcomperr
	ECHO %ALLEGRO%\obj\djgpp\makedoc -ascii docs\thanks.txt -htm docs\thanks.htm docs\thanks._tx
		%ALLEGRO%\obj\djgpp\makedoc -ascii docs\thanks.txt -htm docs\thanks.htm docs\thanks._tx >nul
		IF NOT ERRORLEVEL 0 GOTO hcomperr
	ECHO %ALLEGRO%\obj\djgpp\makedoc -ascii docs\miscinfo.txt -htm docs\miscinfo.htm docs\miscinfo._tx
		%ALLEGRO%\obj\djgpp\makedoc -ascii docs\miscinfo.txt -htm docs\miscinfo.htm docs\miscinfo._tx >nul
		IF NOT ERRORLEVEL 0 GOTO hcomperr
	ECHO %DJDIR%\bin\makeinfo --no-split --paragraph-indent asis docs\salad.txi -o docs\salad.inf
		%DJDIR%\bin\makeinfo --no-split --paragraph-indent asis docs\salad.txi -o docs\salad.inf >nul
		IF NOT ERRORLEVEL 0 GOTO hcomperr
		ECHO.
	ECHO Copying help...
	ECHO copy docs\salad.inf %DJDIR%\info\salad.inf
		COPY docs\salad.inf %DJDIR%\info\salad.inf >nul
GOTO amhelp

:nomdoc
	ECHO Couldn't find allegro\obj\djgpp\makedoc.exe. This means that the help can't
	ECHO be compiled.
	ECHO * If you never have used Allegro, you may have forgotten to compile it. Go to
	ECHO   the Allegro directory and type "make".
GOTO quiterr

:nominfo
	ECHO Couldn't find djgpp\bin\makeinfo.exe. This means that the help can't be
	ECHO compiled.
	ECHO * You may have forgotten to download makeinfo.exe. Look for it at
	ECHO   http://www.delorie.com/djgpp/.
GOTO quiterr

:nosalad
	ECHO Couldn't find salad.c.
	ECHO * You may be in the wrong directory. You must run this install program from the
	ECHO   directory where it is.
	ECHO * You may also have a broken Salad directory structure. This could be because
	ECHO   you have forgotten to use the -d switch so that the directory tree is
	ECHO   preserved.
GOTO quiterr

:noenvdj
	ECHO The environment variable "DJDIR" isn't set properly!
	ECHO * To set the environment variable, type
	ECHO      set DJDIR=x
	ECHO   where x is the directory where you have DJGPP, for example "c:\djgpp".
	ECHO * There is also a small probablility that DJGPP isn't installed correctly.
	ECHO   There must be at least one file in the DJDIR directory.
GOTO quiterr

:noenval
	ECHO The environment variable "ALLEGRO" isn't set properly!
	ECHO * To set the environment variable, type
	ECHO      set ALLEGRO=x
	ECHO   where x is the directory where you have Allegro, for example
	ECHO   "c:\djgpp\allegro".
	ECHO * There is also a small probablility that Allegro isn't installed correctly.
	ECHO   There must be at least one file in the ALLEGRO directory.
GOTO quiterr

:noinstal
	ECHO You must be in the same directory as "install.bat" when you run it! Install.bat
	ECHO also has to be in the same directory as Salad (i.e. it doesn't work if you move
	ECHO it).
GOTO quiterr

:wrongdj
	ECHO The DJGPP directory tree seems to be broken.
	ECHO * Have you unzipped all the DJGPP files with the `-d' switch, preserving the
	ECHO   directory tree? If you never have used DJGPP before, that could be the cause
rem ` The character in the beginning of this line is needed to get better syntax highliting in RHIDE.
	ECHO   of the error.
	ECHO * Have you got the whole DJGPP package? If you don't, look for it in
	ECHO   http://www.delorie.com/djgpp/.
GOTO quiterr

:warnal
	ECHO Warning! Couldn't find %DJDIR%\lib\liballeg.a.
	ECHO * Do you have Allegro? You can install Salad without Allegro, but you can not
	ECHO   use it without it.
	ECHO Do you want to continue anyway?
	choice
	if ERRORLEVEL 1 GOTO quit
GOTO awarnal

:comperr
	ECHO Couldn't compile Salad! It's hard to say exactly what has gone wrong, but try
	ECHO the following:
	ECHO * Make sure you have all files in Salad on the right places.
	ECHO * Get a new Salad.zip. It may be broken.
GOTO quiterr

:hcomperr
	ECHO Couldn't compile the help!  This ought not to happen.
	ECHO * The zip file may be broken. Get a new one from the place where you got this
	ECHO   from.
GOTO quiterr

:endok
	ECHO.
	ECHO ===================================
	ECHO ============ Finished! ============
	ECHO ===================================
	ECHO.
REM   ECHO * If you're using RHIDE, add Salad to the list of libraries and make sure the
REM   ECHO   check box next to it is checked.
	ECHO * Add salad.c or salad.o to all your projects that use Salad.
	ECHO * Include salad.h in all files that use Salad.
	ECHO * If you want online help for Salad in RHIDE, add the line:
	ECHO      *Salad: (salad.inf).
	ECHO   to %DJDIR%\info\dir.txi.
	ECHO   Then go to the menu "Help/Syntax help/Files to search" in RHIDE and add
	ECHO   Salad to the list of help files.
	ECHO.
	ECHO See also readme.txt for general info and salad.txt for help on the library.
	ECHO Don't forget the swapware rule described in readme.txt!
	ECHO.
GOTO quit

:quiterr
	ECHO.
	ECHO * If nothing else works, e-mail me at csg@mdh.se.
	ECHO   NOTE: This address will probably change soon. If you're reading this after
	ECHO   28 February 1998, go to the place where you got Salad from and see if it
	ECHO   says anything about my new address.
	ECHO.
GOTO quit

:quit
