/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for changing case and some more for characters.

*/
#ifndef s_char_c
#define s_char_c

#include "s_char.h"

#include "s_defs.h"

//This file contains some functions for converting case fro characters.


/* Upper/lowercase table. All characters that are symbols (not letters) are
	0. All other have an index to the inverted case character, except for 0xDF
	and 0xFF, that can't be uppercased or lowercased (0xDF is beta and 0xFF is
	y with two dots). Those have their own indexes instead. All characters
	whose item in the casetable array is greater than their own index are
	uppercase characters (i.e. the lowercase letter is always after the
	uppercase letter in the table).
*/
uchar casetable[256]={
//0  1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //0
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //1
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //2
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //3
0,   0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,//4
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0,   0,   0,   0,   0,   //5
0,   0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,//6
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0,   0,   0,   0,   0,   //7
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //8
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //9
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //A
0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   //B
0xE0,0xE1,0xE2,0xE3,0xE4,0xE5,0xE6,0xE7,0xE8,0xE9,0xEA,0xEB,0xEC,0xED,0xEE,0xEF,//C
0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0,   0xF8,0xF9,0xFA,0xFB,0xFC,0xFD,0xFE,0xDF,//D
0xC0,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,0xC8,0xC9,0xCA,0xCB,0xCC,0xCD,0xCE,0xCF,//E
0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0,   0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xFF //F
};



//Alphabetic.
inline int charisalpha(uchar ascii) {return _charisalpha(ascii);}
//Uppercase.
inline int charisupper(uchar ascii) {return _charisupper(ascii);}
//Lowercase.
inline int charislower(uchar ascii) {return _charislower(ascii);}
//Digit.
inline int charisdigit(uchar ascii) {return _charisdigit(ascii);}
//Alphabetic or digit.
inline int charisalnum(uchar ascii) {return _charisalnum(ascii);}
//Uppercase or digit.
int charisuppernum(uchar ascii)
{
return _charisuppernum(ascii);
}  
//Lowercase or digit.
int charislowernum(uchar ascii)
{
return _charislowernum(ascii);
}
//a..z.
inline int charislower_az(uchar ascii) {return _charislower_az(ascii);}
//A..Z.
inline int charisupper_az(uchar ascii) {return _charisupper_az(ascii);}
//Alphabetic.
int charisalpha_az(uchar ascii)
{
return _charisalpha_az(ascii);
}
//Aa..Zz or digit.
int charisalnum_az(uchar ascii)
{
return _charisalnum_az(ascii);
}
//A..Z or digit.
int charisuppernum_az(uchar ascii)
{
return _charisuppernum_az(ascii);
}
//a..z or digit.
int charislowernum_az(uchar ascii)
{
return _charislowernum_az(ascii);
}
//Space, enter, tab etc.
int charisempty(uchar ascii)
{
return _charisempty(ascii);
}
//Neither alpha, digit nor space.
int charissymbol(uchar ascii)
{
return _charissymbol(ascii);
}
//Neither Aa..Zz nor digit.
int charissymbol_az(uchar ascii)
{
return _charissymbol_az(ascii);
}
/* Nonzero if the ascii is a valid digit using the number system with base
	`base'. For example, with base 2 (binary), only '1' and '0' are valid.
	With base 16 (hex), however, all digits '0'..'9' and 'A'..'Z' and 'a'..'z'
	are valid.
*/
int charisdigit_base(uchar ascii,int base)
{
return _charisdigit_base(ascii,base);
}


//Convert to uppercase.
inline uchar chartoupper(uchar ascii) {return _chartoupper(ascii);}
//Convert to lowercase.
inline uchar chartolower(uchar ascii) {return _chartolower(ascii);}
//Change case.
inline uchar charchangecase(uchar ascii){return _charchangecase(ascii);}
//Convert Aa..Zz to upper.
inline uchar chartoupper_az(uchar ascii){return _chartoupper_az(ascii);}
//Convert Aa..Zz to lower.
inline uchar chartolower_az(uchar ascii){return _chartolower_az(ascii);}
//Change case for Aa..Zz.
inline uchar charchangecase_az(uchar ascii){return _charchangecase_az(ascii);}



/* This function is copied from "d:djgpp\src\libc\compat\string\strlwr.c" and
	changed so that it changes case for national characters too.
*/
char *strlwr_nat(char *_s)
{
char *rv = _s;
while (*_s){
	*_s = _chartolower(*_s);
	_s++;
}
return rv;
}
/* This function is copied from "d:djgpp\src\libc\compat\string\strlwr.c" and
	changed so that it changes case to uppercase for national characters too.
*/
char *strupr_nat(char *_s)
{
char *rv = _s;
while (*_s){
	*_s = _chartoupper(*_s);
	_s++;
}
return rv;
}

//Returns `TRUE' if the characters are equal, ignoring case.
int charicmp(uchar c1,uchar c2)
{
return _charicmp(c1,c2);
}
int charicmp_az(uchar c1,uchar c2)
{
return _charicmp_az(c1,c2);
}

/* This function is copied from "d:djgpp\src\libc\compat\string\stricmp.c" and
	changed so that it ignores case for national characters too. NOTE THAT IT
	CAN'T DETECT ALPHABETIC ORDER!

	NOTE: The return value is `TRUE' if the strings are the same, and `FALSE'
	if there is a difference.
*/
int stricmp_nat(const char *s1, const char *s2)
{
while (_chartolower(*s1)==_chartolower(*s2)){
	if (*s1 == 0)
		return TRUE;//0;
	s1++;
	s2++;
}
return FALSE;//_chartolower(*s1)-_chartolower(*s2);
}


/* This function is copied from "d:djgpp\src\libc\compat\string\strnicmp.c"
	and changed so that it changes case for national characters too. NOTE THAT
	IT CAN'T DETECT ALPHABETIC ORDER!

	NOTE: The return value is `TRUE' if the strings are the same, and `FALSE'
	if there is a difference.
*/
int strnicmp_nat(const char *s1, const char *s2, ulong n)
{
if (n == 0)
	return TRUE;//0;
do{
	if (_chartolower(*s1) != _chartolower(*s2++))
		return FALSE;//(int)_chartolower_nat(*s1) - (int)_chartolower_nat(*--s2);
	if (*s1++ == 0)
		break;
}while (--n != 0);
return TRUE;//0;
}



//For characters that can't be converted (swde means swedish_win2dos_table
//empty).
//#define swde ('')
#define sdwe (0x79)
uchar swedish_win2dos_table[256]={
//0  1    2    3    4    5    6    7    8    9    A    B    C    D    E    F
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,//0
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,//1
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,//2
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,//3
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,//4
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,//5
0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,//6
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,//7
0x80,0x81,'', '', sdwe,sdwe,'+', sdwe,'^', sdwe,sdwe,'<', sdwe,0x8D,0x8E,0x8F,//8
0x90,'\'','\'','"', '"', '', '-', '', '~', sdwe,sdwe,'>', sdwe,0x9D,0x9E,'', //9
sdwe,'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', //A
'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', //B
'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', //C
'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', //D
'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', //E
'', '', '', '', '', '', '', '', '', '', '', '', '', '', '', ''};//F
#undef sdwe

//This table is automatically generated from the `win2dos' table. If you want
//to add a table for your language, I could send you the utility that does
//that.
uchar swedish_dos2win_table[256]={
0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,0x0D,0x0E,0x0F,
0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,0x1D,0x1E,0x1F,
0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,
0x80,0x81,0xE9,0xE2,0xE4,0xE0,0xE5,0xE7,0xEA,0xEB,0xE8,0xEF,0xEE,0x8D,0x8E,0x8F,
0x90,0xE6,0xC6,0xF4,0xF6,0xF2,0xFB,0xF9,0x9F,0xD6,0xDC,0xF8,0xA3,0x9D,0x9E,0x83,
0xE1,0xED,0xF3,0xFA,0xF1,0xD1,0xAA,0xBA,0xBF,0xAE,0xAC,0xBD,0xBC,0xA1,0xAB,0xBB,
0x80,0x80,0x80,0x80,0x80,0xC1,0xC2,0xC0,0xA9,0x80,0x80,0x80,0x80,0xA2,0xA5,0x80,
0x80,0x80,0x80,0x80,0x97,0x80,0xE3,0xC3,0x80,0x80,0x80,0x80,0x80,0x80,0x80,0xA4,
0xF0,0xD0,0xCA,0xCB,0xC8,0x80,0xCD,0xCE,0xCF,0x80,0x80,0x80,0x80,0xA6,0xCC,0x80,
0xD3,0xDF,0xD4,0xD2,0xF5,0xD5,0xB5,0xDE,0xFE,0xDA,0xDB,0xD9,0xFD,0xDD,0xAF,0xB4,
0xAD,0xB1,0x80,0xBE,0xB6,0xA7,0xF7,0x82,0xB0,0xA8,0x95,0xB9,0xB3,0xB2,0x80,0x80};


//Converts from windows string to swedish dos string.
uchar *str_swedish_win2dos_change(uchar *text)
{
uchar *ret=text;
while (*text){
	*text = swedish_win2dos(*text);
	text++;
}
return ret;
}

//Converts from swedish dos string to windows string.
uchar *str_swedish_dos2win_change(uchar *text)
{
uchar *ret=text;
while (*text){
	*text = swedish_dos2win(*text);
	text++;
}
return ret;
}

//Converts from windows string to swedish dos string, but as most length
//characters.
uchar *strn_swedish_win2dos_change(uchar *text,int length)
{
for(length--;length>=0;length--)
	text[length]=swedish_win2dos(text[length]);
return text;
}

//Converts from swedish dos string to windows string, but as most length
//characters.
uchar *strn_swedish_dos2win_change(uchar *text,int length)
{
for(length--;length>=0;length--)
	text[length]=swedish_dos2win(text[length]);
return text;
}




#endif
