/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains miscellaneous functions that don't belong anywhere else.

*/
#ifndef s_common_h
#define s_common_h

#include "s_defs.h"

//Debugging function that does nothing. Used to get a line to place a
//breakpoint on.
extern int nofun(void);

//Macro that tells that a variable/parameter/function etc is unused, so that
//you don't get a warning for it. This was defined in Allegro 2.2, but not in
//Allegro 3.
#ifndef __UNUSED__
#define __UNUSED__ __attribute__ ((unused))
#endif

//I hate when people remove only the wovels in words. It's impossible to
//pronounce them. The only exception I accept is str for string.
//`copy'.
#define memcopy(de,so,len)          memcpy(de,so,len)
#define memccopy(to,from,ch,len)    memccpy(to,from,ch,len)
#define strcopy(s1,s2)              strcpy(s1,s2)
#define strncopy(s1,s2,len)         strncpy(s1,s2,len)
#define stpcopy(s1,s2)              stpcpy(s1,s2)
//`upper'/`lower'.
#define strupper(text)              strupr(text)
#define strlower(text)              strlwr(text)
#define strupper_nat(text)          strupr_nat(text)
#define strlower_nat(text)          strlwr_nat(text)
//`comp'.
#define _charicomp(c1,c2)           _charicmp(c1,c2)
#define charicomp(c1,c2)            charicmp(c1,c2)
#define _charicomp_az(c1,c2)        _charicmp_az(c1,c2)
#define charicomp_az(c1,c2)         charicmp_az(c1,c2)
#define strcomp(s1,s2)              strcmp(s1,s2)
#define stricomp(s1,s2)             stricmp(s1,s2)
#define strcasecomp(s1,s2)          strcasecmp(s1,s2)
#define strncomp(s1,s2,len)         strncmp(s1,s2,len)
#define strnicomp(s1,s2,len)        strnicmp(s1,s2,len)
#define strncasecomp(s1,s2,len)     strncasecmp(s1,s2,len)
#define stricomp_nat(s1,s2)         stricmp_nat(s1,s2)
#define strnicomp_nat(s1,s2,len)    strnicmp_nat(s1,s2,len)
#define bcomp(ptr1,ptr2,len)        bcmp(ptr1,ptr2,len)
#define memcomp(s1,s2,len)          memcmp(s1,s2,len)


//Sets a whole struct to zero. First parameter is the first byte to start at,
//second is the name of the struct, for example TRECT.
#define _zerostruct(buf,structname) (memset((buf),0,sizeof(structname)))
//Ors length bytes of buf2 with buf1 and stores the result in buf1, which it
//also returns.
extern void *memor(void *buf1,void *buf2,ulong length);


//Waits till a key is pressed.
extern int keywait(void);
//Waits till a key or mouse button is pressed.
extern int keymousewait(void);


//NOT FOR USE WITH ALLEGRO! Waits till y or n is pressed, and returns which.
extern uchar dos_getyn(void);


#endif
