/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains string handling functions.

*/
#ifndef s_string_c
#define s_string_c

#include "s_string.h"

#include "s_common.h"

#include <string.h>
#include <stdlib.h>

//This file contains common string-handling functions that I have made.







/***********
****    ****
**** sc ****
****    ****
************
This function returns its parameter.
It is very usable if you want to assign a string constant to a char* , since
c won't let you write the code:

	char *mystring;
	mystring = "hallo world";

Instead, you can now write the code:

	char *mystring;
	mystring = sc("hallo world");

sc means string constant. */
uchar *sc(uchar *text)
{
return text;
}




/***********************************
****                            ****
**** Functions for string lists ****
****                            ****
***********************************/
//Adds an item to a string list, even if it is `NULL'.
int add_strlist_item(TSTRLIST *sl, uchar *item)
{
if(!sl)
	return -1;
if(sl->num_malloced_strings <= sl->num_strs)
	sl->list=xxrealloc(sl->list,
	 sizeof(uchar *) * (sl->num_malloced_strings=sl->num_strs+16));
sl->list[sl->num_strs++] = item;
return sl->num_strs-1;
}
//Removes an item from a string list.
void remove_strlist_item(TSTRLIST *sl, int index)
{
if(!sl)
	return;
if(index>sl->num_strs)
	return;
memmove(&sl->list[index], &sl->list[index+1], sl->num_strs-index);
sl->num_strs--;
}
//Removes and frees an item from a string list. NOTE: The string MUST be
//malloced dynamically.
void free_strlist_item(TSTRLIST *sl, int index)
{
if(!sl)
	return;
if(index>sl->num_strs)
	return;
free(sl->list[index]);
memmove(&sl->list[index], &sl->list[index+1], sl->num_strs-index);
sl->num_strs--;
}
//Adds a string to a TSTRLIST.
TSTRLIST *create_strlist(void)
{
TSTRLIST *ret=xxmalloc(sizeof(TSTRLIST));
ret->list = xxmalloc(sizeof(uchar*) * (ret->num_malloced_strings=8));
ret->num_strs = 0;
return ret;
}
//Destroys a string list, but not its items.
void destroy_strlist(TSTRLIST *sl)
{
free(sl->list);
free(sl);
}
//Destroys a string list and its items. NOTE: All items MUST be dynamically
//malloced!
void destroy_strlist_items(TSTRLIST *sl)
{
int i;
for(i=sl->num_strs-1; i>=0; i--)
	free(sl->list[i]);
free(sl->list);
free(sl);
}





/****************
****         ****
**** fillstr ****
****         ****
*****************
Fills a string with a number of chars.*/
uchar *fillstr_d(uchar *de,uchar ascii,long length)
{
_ifstrxmalloc(de,length);
return memset(de,ascii,length);
}




/******************
****           ****
**** mergestrs ****
****           ****
*******************
Concatenates many strings. Pass any number of uchar*-s.
NOTE: THE LAST PARAMETER MUST BE NULL, OR YOUR PROGRAM WILL DIE!
*/
uchar *mergestrs_change(uchar *text,...)
{
uchar **texts=&text;
ulong thislength,sofarlength=strlen(text);
int i;
//Add strings.
for(i=1;texts[i];i++){
	thislength=strlen(texts[i]);
	memcpy(text+sofarlength,texts[i],thislength);
	sofarlength+=thislength;
}
text[sofarlength]=0;
//Return.
return text;
}
/************
** realloc **
************/
uchar *mergestrs_realloc(uchar *text,...)
{
uchar **texts=&text;
ulong totallength=0,thislength,sofarlength=strlen(text);
int i;
//Count length so that we can realloc.
for(i=0;texts[i];i++)
	totallength+=strlen(texts[i]);
_strxrealloc(text,totallength);
//Add strings.
for(i=1;texts[i];i++){
	thislength=strlen(texts[i]);
	memcpy(text+sofarlength,texts[i],thislength);
	sofarlength+=thislength;
}
//Return.
return text;
}
/****************
** destination **
****************/
uchar *mergestrs_de(uchar *de, uchar *text,...)
{
uchar **texts=&text;
ulong thislength,sofarlength=0;
int i;
//Add strings.
for(i=0;texts[i];i++){
	thislength=strlen(texts[i]);
	memcpy(de+sofarlength,texts[i],thislength);
	sofarlength+=thislength;
}
de[sofarlength]=0;
//Return.
return de;
}
/********
** new **
********/
uchar *mergestrs_new(uchar *text,...)
{
uchar **texts=&text;
uchar *ret;
ulong totallength=0,thislength,sofarlength=0;
int i;
//Count length so that we can malloc.
for(i=0;texts[i];i++)
	totallength+=strlen(texts[i]);
_strxmalloc(ret,totallength);
//Add strings.
for(i=0;texts[i];i++){
	thislength=strlen(texts[i]);
	memcpy(ret+sofarlength,texts[i],thislength);
	sofarlength+=thislength;
}
//Return.
return ret;
}




/******************
****           ****
**** getsubstr ****
****           ****
*******************
Returns a string containing a part of the first string. _new version stores
the result in a new string, the other uses the existing string.*/
uchar *getsubstr_s(uchar *text,int allocmode,ulong start,ulong length)
{
ulong textlength=strlen(text);
//Clipping.
if(start+length>textlength){
	if(start>textlength){
		_ifstrxrealloc(text,allocmode,0);
		return text;
	}else
		length=textlength-start;
}
memmove(text,text+start,length);
_ifstrxrealloc(text,allocmode,length);
return text;
}
uchar *getsubstr_d(uchar *so,uchar *de,ulong start,ulong length)
{
ulong textlength=strlen(so);
//Clipping.
if(start+length>textlength){
	if(start>textlength){
		_ifstrxmalloc(de,0);
		return de;
	}else
		length=textlength-start;
}
_ifstrxmalloc(de,length);
return memcpy(de,so+start,length);
}
/**********************
****               ****
**** replacesubstr ****
****               ****
***********************
Replaces part of a string with another.*/
uchar *replacesubstr_s(uchar *text,int allocmode,ulong start,ulong length,uchar *substr)
{
ulong substrlength=strlen(substr);
ulong textlength=strlen(text);
//Clipping.
if(start+length>textlength){
	if(start>textlength){
		start=textlength;
		length=0;
	}else
		length=textlength-start;
}
//Textlength from now on used as the number of chars not changed.
if(substrlength>length){
	_ifstrxrealloc(text,allocmode,(textlength-=length)+substrlength);
	memmove(text+start+substrlength,
	 text+length,
	 textlength-start);
	memcpy(text+start,
	 substr,
	 substrlength);
}else{
	memmove(text+start+substrlength,
	 text+start+length,
	 (textlength-=length)-start);
	_ifstrxrealloc(text,allocmode,textlength+substrlength);
	memcpy(text+start,
	 substr,
	 substrlength);
}
return text;
}
uchar *replacesubstr_d(uchar *so,uchar *de,ulong start,ulong length,uchar *substr)
{
ulong substrlength=strlen(substr);
ulong textlength=strlen(so);
//Clipping.
if(start+length>textlength){
	if(start>textlength){
		start=textlength;
		length=0;
	}else
		length=textlength-start;
}
//Textlength from now on used as the number of chars not changed.
textlength-=length;
//Copying last zero too makes it unnecessary to _ifstrxmalloc.
_ifxmalloc(de,textlength+substrlength+1);
memcpy(de,
 so,
 start);
memcpy(de+start,
 substr,
 substrlength);
memcpy(de+start+substrlength,
 so+start+length,
 textlength-start+1);
return de;
}
/*********************
****              ****
**** deletesubstr ****
****              ****
**********************
Deletes part of a string.*/
uchar *deletesubstr_s(uchar *text,int allocmode,ulong start,ulong length)
{
ulong textlength=strlen(text);
//Clipping.
if(start+length>textlength){
	if(start>textlength)
		return text;
	else
		length=textlength-start;
}
memmove(text+start,
 text+start+length,
 (textlength-=length)-start);
_ifstrxrealloc(text,allocmode,textlength);
return text;
}
uchar *deletesubstr_d(uchar *so,uchar *de,ulong start,ulong length)
{
ulong textlength=strlen(so);
//Clipping.
if(start+length>textlength){
	if(start>textlength)
		start=textlength;
	_ifstrxmalloc(de,start);
	return memcpy(de,so,start);
}
textlength-=length;
_ifstrxmalloc(de,textlength);
memcpy(de,so,start);
memcpy(de+start,
 so+start+length,
 textlength-start);
return de;
}
/*********************
****              ****
**** insertsubstr ****
****              ****
**********************
Inserts a string at a position in another.*/
uchar *insertsubstr_s(uchar *text,int allocmode,ulong position,uchar *substr)
{
ulong substrlength=strlen(substr);
ulong textlength=strlen(text);
//Clipping.
if(position>textlength)
	position=textlength;
_ifstrxrealloc(text,allocmode,textlength+substrlength);
memmove(text+position+substrlength,
 text+position,
 textlength-position);
memcpy(text+position,
 substr,
 substrlength);
return text;
}
uchar *insertsubstr_d(uchar *so,uchar *de,ulong position,uchar *substr)
{
ulong substrlength=strlen(substr);
ulong textlength=strlen(so);
//Clipping.
if(position>textlength)
	position=textlength;
_ifstrxmalloc(de,textlength+substrlength);
memcpy(de,so,position);
memcpy(de+position,
 substr,
 substrlength);
memcpy(de+position+substrlength,
 so+position,
 textlength-position);
return de;
}




/****************
****         ****
**** strmove ****
****         ****
*****************
strcpy exists, as well as memmove and memcpy, so it seems logical that
strmove also should exist.*/
uchar *strmove(uchar *dest,uchar *source)
{
return memmove(dest,source,strlen(source));
}

#endif
