/*
     _______                     ___                          ________
    /       \         /\        |   |\             /\        |        \
   /         >       /  \       |   ||            /  \       |         \
  /   ______/ >     /    \      |   ||           /    \      |    __    \
 <   <_______/     /      \     |   ||          /      \     |   |\_\    \
  \        \      /   /\   \    |   ||         /   /\   \    |   ||  \    \
   \        \    |   /_L\   |   |   ||        |   /_L\   |   |   ||   >   |\
    \_____   \   |          |\  |   ||        |          |\  |   ||  /    /|
   __L____>   >  |          ||  |   |L____    |          ||  |   |L_/    / /
  /          / > |   ____   ||  |         |\  |   ____   ||  |          / /
 <          / /  |   |\_|   ||  |         ||  |   |\_|   ||  |         / /
  \________/ /   |___|| |___||  |_________||  |___|| |___||  |________/ /
   \________/     \___\  \___\   \_________\   \___\  \___\   \_______\/


                an Addon Package for Allegro by Sven Sandberg


This file contains functions for drawing text.

*/
#ifndef s_text_h
#define s_text_h


//For FONT.
#include <allegro.h>
//For uchar.
#include "s_defs.h"
//For TRECT.
#include "s_rect.h"


//Alignment constants.
#define al_left                     (-10)
//This is also used to tell that the position is at the center of the box.
#define al_center                   (min_slong)
#define al_right                    (-11)
#define al_wordjustify              (-12)
#define al_wordjustifyleft          (-13)
#define al_wordjustifycenter        (-14)
#define al_wordjustifyright         (-15)
#define al_characterjustify         (-16)
#define al_characterjustifyleft     (-17)
#define al_characterjustifycenter   (-18)
#define al_characterjustifyright    (-19)
#define al_top                      (al_left)
#define al_justify                  (al_wordjustify)
#define al_bottom                   (al_right)
//If you prefer `char' to `character'.
#define al_charjustify              (al_characterjustify)
#define al_charjustifyleft          (al_characterjustifyleft)
#define al_charjustifycenter        (al_characterjustifycenter)
#define al_charjustifyright         (al_characterjustifyright)
//If you prefer spelling `center' as `centre'.
#define al_centre                   (al_center)
#define al_wordjustifycentre        (al_wordjustifycenter)
#define al_characterjustifycentre   (al_characterjustifycenter)
#define al_charjustifycentre        (al_charjustifycenter)

//Data for one line in a textbox.
typedef struct{
	long start,end;//end-start=length => text[end] is first character not on
						//the line.
	long nextlinestart;  //First character on next line.
	long pixelwidth;     //Width of text in pixels.
	int endofparagraph, endofstring; //Booleans. `endofparagraph' is _not_
												//automatically set if endofstring is set.
}TLINEWIDTH;
//Data for a textbox, containing an array for the lines and some more.
typedef struct{
	char *text;    //The text of course.
	FONT *f;       //The font.
	TRECT box;     //The area covered by the textbox.
	int xalignment,yalignment;//This should be one of the alignment constants
						//above.
	int numlines;  //The number of lines in the textbox.
	TLINEWIDTH **lines;//An array of TLINEWIDTH*
	long widestline;//The widest line, in pixels.
}TTEXTBOX;

//Functions for drawing text in which ampersands mean an underlined character.
extern void textout_au_align(BITMAP *bmp,FONT *f,uchar *text,int x,int y,int color,int alignment);
#define textout_au(bmp,f,text,x,y,color)        textout_au_align(bmp,f,text,x,y,color,al_left)
#define textout_au_centre(bmp,f,text,x,y,color) textout_au_align(bmp,f,text,x,y,color,al_center)
#define textout_au_center(bmp,f,text,x,y,color) textout_au_align(bmp,f,text,x,y,color,al_center)
#define textout_au_right(bmp,f,text,x,y,color)  textout_au_align(bmp,f,text,x,y,color,al_right)

//Two functions missed by Allegro.
extern int textout_right(BITMAP *bmp,FONT *f,uchar *text,int x,int y,int color);
extern int textprintf_right(BITMAP *bmp,FONT *f,int x,int y,int color,uchar *format,...);
//Useful char functions.
extern int char_width(FONT *f,int ascii);
extern void charout(BITMAP *bmp, FONT *f, uchar ascii, int x, int y,
 int color);
//Drawing only part of a string
extern void draw_substr(BITMAP *bmp, FONT *f, uchar *text, TPOINT pos, int color,
 int start, int length);

//Returns current textmode (colored or transparent background when drawing
//text). This is the corresponding get-function to Allegro's text_mode()-
//function.
extern int _textmode;
#define get_text_mode() (_textmode)


/* A cool function.
	Draws text in a box on a bitmap. Handles word-wrapping and extended
	alignment both horizontally and vertically.
*/
extern void textbox(BITMAP *bmp,FONT *f,uchar *text,TRECT box,
 int xalignment,int yalignment,int color);
#define textbox_left(bmp,f,text,box,color)      (textbox(bmp,f,text,box,al_left,al_top,color))
#define textbox_right(bmp,f,text,box,color)     (textbox(bmp,f,text,box,al_right,al_top,color))
#define textbox_centre(bmp,f,text,box,color)    (textbox(bmp,f,text,box,al_centre,al_top,color))
#define textbox_center(bmp,f,text,box,color)    (textbox(bmp,f,text,box,al_centre,al_top,color))
#define textbox_justify(bmp,f,text,box,color)   (textbox(bmp,f,text,box,al_justify,al_top,color))

//Some helper functions.
extern TLINEWIDTH *charwrap_line(uchar *text, long textstart, FONT *f,
 long pixelwidth);
extern TLINEWIDTH *wordwrap_line(uchar *text, long textstart, FONT *f,
 long pixelwidth);

//Functions that draw one `TLINEWIDTH', i.e. one line in a `TTEXTBOX' with
//different alignment.
extern void textline_left(BITMAP *bmp, FONT *f,uchar *text,
 TPOINT pos,TLINEWIDTH *line, int color);
extern void textline_center(BITMAP *bmp, FONT *f,uchar *text,
 TPOINT pos,TLINEWIDTH *line, long spacetoadd, int color);
#define textline_centre(bmp,f,text,pos,line,spacetoadd,color)  textline_center(bmp,f,text,pos,line,spacetoadd,color)
extern void textline_right(BITMAP *bmp, FONT *f,uchar *text,
 TPOINT pos,TLINEWIDTH *line, long spacetoadd, int color);
extern void textline_charjustify(BITMAP *bmp, FONT *f,uchar *text,
 TPOINT pos,TLINEWIDTH *line, long spacetoadd, int color);
extern void textline_wordjustify(BITMAP *bmp, FONT *f,uchar *text,
 TPOINT pos,TLINEWIDTH *line, long spacetoadd, int color);

//Calculates the data for a textbox. The pointer returned can later be passed
//to draw_textbox or freed by free_textbox.
extern TTEXTBOX *calc_textbox(FONT *f,uchar *text,TRECT box,int xalignment,
 int yalignment);
//Draws a TEXTBOX.
extern void draw_textbox(BITMAP *bmp,FONT *f,TTEXTBOX *textbox,long startline,
 int color);

//Frees a TTEXTBOX.
extern void free_textbox(TTEXTBOX *textbox);

//Returns width of a character or a string.
extern int char_width(FONT *f,int ascii);
extern int text_width(FONT *f,uchar *text);

#endif
