#include "line.h"

screen_line::
screen_line( int x, int length )
: line( x, length )
{
   _buffer_length = 0;
   _image = 0;
   set_fill_char( DEFAULT_CHARACTER,
                  DEFAULT_COLOUR );
   resize( length );
}

screen_line::
screen_line( screen_char fill_char, int x, int length )
: line( x, length )
{
   _buffer_length = 0;
   _image = 0;
   set_fill_char( fill_char.character,
                  fill_char.colour );
   resize( length );
}

screen_line::
screen_line( const char * text, int x, char colour )
{
   _buffer_length = 0;
   _image = 0;
   set_fill_char( DEFAULT_CHARACTER,
                  colour );
   resize( 0 );
   operator=( text );
   move_to( x );
}

screen_line::
screen_line( screen_line & other )
{
   _buffer_length = 0;
   _image = 0;
   resize( 0 );
   operator=( other );
}

screen_line::
screen_line( const char * text )
{
   _buffer_length = 0;
   _image = 0;
   set_fill_char( DEFAULT_CHARACTER,
                  DEFAULT_COLOUR );
   resize( 0 );
   operator=( text );
}

screen_line::
~screen_line()
{
   delete [] _image;
}


screen_line & screen_line::
operator=( screen_line & other )
{
   _fill_char = other._fill_char;
   resize( other.length() );
   int i = 0;
   while( i < length() ) {
      _image[i] = other._image[i];
      i++;
      }

   move_to( other.left() );
   return *this;
}

screen_line & screen_line::
operator=( const char * text )
{
   resize( strlen(text) );
   int i = 0;
   while( i < length() ) {
      _image[i].character = text[i];
      i++;
      }

   return *this;
}

void screen_line::
resize( int new_length )
{
   if( new_length > _buffer_length ) {
      if( _image )
         delete [] _image;
      _buffer_length = new_length + GROWTH_MARGIN;
      _image = new screen_char [_buffer_length];
      }
   fill();
   line::resize( new_length );
}

void screen_line::
resize_and_keep( int new_length )
{
   if( new_length > _buffer_length )
   {
      if( _image )
      {
         screen_char * _old_image = _image;
         _buffer_length = new_length + GROWTH_MARGIN;
         _image = new screen_char [_buffer_length];
         int line_length = smaller_of( length(), new_length );

         int i = 0;
         while( i < line_length ) {
            _image[i] = _old_image[i];
            i++;
            }

         delete [] _old_image;

         while( i < _buffer_length ) {
            _image[i] = _fill_char;
            i++;
            }
         line::resize( new_length );
      }
      else
         resize( new_length );
   }
   else
      line::resize( new_length );
}

void screen_line::
draw_to( screen_line & other )
{
   int offset = this -> left() - other.left();
   if( offset >= 0 )
   {
      int length = smaller_of( other.length() - offset,
                                this -> length() );
      int i = 0;
      while( i < length ) {
         other._image[i+offset] = _image[i];
         i++;
         }
   }
   else
   {
      int length = smaller_of( other.length(),
                                this -> length() + offset );
      int i = 0;
      while( i < length ) {
         other._image[i] = _image[i-offset];
         i++;
         }
   }
}

void screen_line::
copy_to( screen_line & other, int x, int length )
{
   length = smaller_of( length, other.length() - x );
   int i = 0;
   while( i < length ) {
      other._image[i+x] = _image[i];
      i++;
      }
}

void screen_line::
set_fill_char( char character, char colour )
{
   _fill_char.character = character;
   _fill_char.colour = colour;
}

void screen_line::
fill()
{
   int i = 0;
   while( i < _buffer_length ) {
      _image[i] = _fill_char;
      i++;
      }
}

void screen_line::
fill( screen_char fill_char, int x, int desired_length )
{
   int start = bigger_of( x, 0 );
   int end = smaller_of( x + desired_length - 1, right() );
   int i = start;
   while( i <= end ) {
      _image[i] = fill_char;
      i++;
      }
}

void screen_line::
get_text( char * buffer, int x, int desired_length )
{
   if( x < 0 || x >= length() || desired_length <= 0 )
      return;

   desired_length = smaller_of( desired_length, length() - x );

   int i = 0;
   while( i < desired_length ) {
      buffer[i] = _image[x+i].character;
      i++;
      }
}

void screen_line::
put_text( const char * text, int x, int desired_length )
{
   if( x < 0 || x >= length() || desired_length <= 0 )
      return;

   desired_length = smaller_of( desired_length, length() - x );

   int i = 0;
   while( i < desired_length ) {
      _image[x+i].character = text[i];
      i++;
      }
}


void screen_line::
set_text( char character, int x, int desired_length )
{
   if( x < 0 || x >= length() || desired_length <= 0 )
      return;

   desired_length = smaller_of( desired_length, length() - x );

   int i = 0;
   while( i < desired_length ) {
      _image[x+i].character = character;
      i++;
      }
}

void screen_line::
set_colour( char colour, int x, int desired_length )
{
   if( x < 0 || x >= length() || desired_length <= 0 )
      return;

   desired_length = smaller_of( desired_length, length() - x );

   int i = 0;
   while( i < desired_length ) {
      _image[x+i].colour = colour;
      i++;
      }
}

void screen_line::
set_colour( char colour, int x )
{
   if( x >= 0 && x < length() )
      _image[x].colour = colour;
}


void screen_line::
insert_at( char character, int x )
{
   if( x >= length() )
      resize_and_keep( x + 1 );
   else
      resize_and_keep( length() + 1 );

   screen_line after( left() + x, ( right() - x ) + 1 );
   draw_to( after );
   after.move_to( after.left() + 1 );
   after.draw_to( *this );

   _image[x].character = character;
   _image[x].colour    = _fill_char.colour;
}

void screen_line::
delete_at( int x )
{
   if( x < 0 || x >= length() )
      return;

   screen_line after( left() + (x+1), length() - (x+1) );
   draw_to( after );
   after.move_to( after.left() - 1 );
   after.draw_to( *this );

   resize_and_keep( length() - 1 );
}

