/*-----------------------------------------------------------------------*
 | mouse_class: a text-oriented mouse interface                Version 1 |
 |                                                                       |
 | Written by Stephen Bint for djgpp                                     |
 *-----------------------------------------------------------------------*/

#ifndef mouse_header
#define mouse_header

#include "overlap.h"
#include <time.h>

#define DOUBLE_CLICK_PERIOD 0.25  // seconds (default)

enum
{
   no_event                 =  0,
   mouse_left_click         =  1,
   mouse_right_click        =  2,
   mouse_left_double_click  =  8,
   mouse_right_double_click = 16,
   mouse_movement           = 32
};

class mouse_class
{
public:
 mouse_class();
~mouse_class();

/*---------------*
 | preliminaries |
 *---------------*/

// call this first, to check a driver is loaded
bool will_work();


// call this after changing video modes,
// or the numbers will come out wrong
void new_video_mode();


/*----------------*
 | info functions |
 *----------------*/

// call this to update info, before calling info functions
void poll();

int event();     // can be ANDed with enum values above

// click info
int clicked();  // = event() & ( mouse_left_click | mouse_right_click )

bool left_click();
bool left_double_click();
bool right_click();
bool right_double_click();

// position info
bool has_moved();

// measuring in text co-ordinates
int x();
int y();

bool is_over( rectangle& area );

// measuring in graphics pixel co-ordinates
int x_pixel();
int y_pixel();
bool is_over_pixel( rectangle& area );


/*------------------*
 | cursor functions |
 *------------------*/
void show_cursor( int number_of_times = 1 );
void hide_cursor( int number_of_times = 1 );
void place_cursor( float x, float y );

int  visibility();
void save_visibility();
void set_visibility( int new_setting );
void restore_visibility();


/*-------------------------*
 | behavioural adjustments |
 *-------------------------*/
void set_double_click_period( double seconds );
void set_sensitivity( unsigned x_sense, unsigned y_sense );
void set_x_limits( float leftmost_x, float rightmost_x );
void set_y_limits( float top_y, float bottom_y );



private:
/*------------------------------------------------------------*
 | do not concern yourself with things you do not understand, |
 | little one.                                                |
 *------------------------------------------------------------*/

// called by the constructor only
bool reset_driver();

// value set in reset_driver()
bool _will_work;

// these are all updated by poll()
// and returned by info functions
point _cursor_pos;
int _x_pixel;
int _y_pixel;
int _old_x_pixel;
int _old_y_pixel;
int _last_event;

// these values are used in poll(), to determine
// _left_double_click and _right_double_click
clock_t _double_click_period;
clock_t _last_left_click;
clock_t _last_right_click;

// these values are set in new_video_mode()
// and used in functions that use co-ordinates
int _mouse_pixels_per_col;
int _mouse_pixels_per_row;
int _mouse_pixels_per_x;

// changed by show_cursor and hide_cursor
// cursor is visible when mouse.visibility() == 0
int _visibility;
int _saved_visibility;
};


/*-----------------------------------------------------------------------*
 |                            The One and Only                           |
 *-----------------------------------------------------------------------*
 | You must use this mouse object called "mouse" in your programs,       |
 | instead of creating your own. If you ignore this, the mouse will      |
 | bite you.                                                             |
 *-----------------------------------------------------------------------*/
extern mouse_class mouse;

#endif
