#
# BETATRON high level library for platform and action arcade games.
# Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
#
# VGAPLASM.S: This file is part of the BETATRON library and can be used
#             and/or distributed only under the terms of the GNU Library
#             General Public License. See doc/readme.1st for details.
#



.globl	_pl_horline,_pl_verline,_pl_thruclip,_pl_solidclip
.globl	_pl_setRGBcolor, _pl_iswindows
.globl	_mx320x200
.globl	 _pl_is386, _pl_memsetw
.extern  _pl_a000h



_pl_is386:

	pushf

# 80286 or lower
	xorw	%ax,%ax
	pushw	%ax
	popf
	pushf
	popw	%ax
	andw	$0x0f000,%ax
	cmpw	$0x0f000,%ax
	je	not_386

# 80406, 80386 or 80286

	movw	$0x07000,%ax
	pushw	%ax
	popf
	pushf
	popw	%ax
	andw	$0x07000,%ax
	je	not_386


	movl  $1,%eax	 # epestrepse TRUE einai 386
	jmp   finnito

not_386:
	xorl	%eax,%eax	# epestrepse FALSE
finnito:
	popf			# apokatastise ta flags
   ret

.equ	 data ,  8
.equ	 value,  12
.equ	 len,	 16


# extern "C"  void pl_memsetw(void *data,short value, long len);

_pl_memsetw:
      pushl %ebp
      movl %esp,%ebp

      pusha
      pushw	   %es

       pushw %ds
       popw  %es

	movl data(%ebp),%edi
	movw value(%ebp),%bx
	movw	%bx,%ax
	shll  $16,%eax
	movw	%bx,%ax
	movl	len(%ebp),%ecx

	shrl	$1,%ecx
	jnc	skip2
	stosw
skip2:
	jecxz skip3
	rep
	stosl
skip3:
      popw    %es
      popa
      popl  %ebp
      ret


#;;;;;;extern "C" void mx320x200(char linesize);
_mx320x200:
	pushl	%ebp
	movl	%esp,%ebp

	pusha
	pushw %es

	movw _pl_a000h,%ax
	movw %ax,%es


#  垩  ᤫ mode 13h

	movw	$0x13,%ax
	int	$0x10

# 垩 chain4 mode   ⢘  㣞

	movw	$0x03c4,%dx	#SeqIndex
	movb	$04,%al #MemoryMode
	movb	$6,%ah	       # 0110b
	outw	%ax,%dx


# ᨠ   256  㣞 椞

	movb	$02,%al #MapMask
	movb	$15,%ah 	# 1111b
	outw	%ax,%dx
   xorl  %edi,%edi	 # arxi video ram
	xorl	%eax,%eax
	movl	$0x4000,%ecx
	rep
	stosl

# 垩 byte mode  垩 count by two

	movw	$0x03d4,%dx	#CrtIndex
	movb	$0x017,%al	#CrtModeCtrl
	movb	$0B11100011,%ah
	outw	%ax,%dx

# 垩 double word mode  count by 4

	movb	$0x014,%al	#UnderlineLoc
	xorb	%ah,%ah
	outw	%ax,%dx

# ੜ  graphics controller   ⢘  㣞 夘 

	movw	$0x03ce,%dx	#GraphIndex
	movb	$05,%al #GraphMode
	outb	%al,%dx
	incw	%dx
	inb	%dx,%al
	andb	$0B11101111,%al
	outb	%al,%dx
	decw	%dx
	movb	$06,%al #GraphMisc
	outb	%al,%dx
	incw	%dx
	inb	%dx,%al
	andb	$0B11111101,%al
	outb	%al,%dx

# ᢢ  㡦    video ram  

	movw	$0x03d4,%dx	#CrtIndex
	movb	$0x013,%al	#CrtOfs
	outb	%al,%dx
	incw	%dx
	movb	8(%ebp),%al    #linesize , linesize * 8 = Pixel      video ram
	outb	%al,%dx

	popw %es
	popa
	popl	%ebp
	ret






_pl_iswindows:
	pushl	%ebx
	pushl	%ecx
	pushl	%edx
	pushl	%edi
	pushl	%esi

	movw	$0x1600,%ax
	int	$0x2f
	cmpb	$0x01,%al
	je	windows
	cmpb	$0x0ff,%al
	je	windows 	     # windows version 2.x
	cmpb	$0,%al
	je	nextcheck
	cmpb	$0x080,%al
	jne	wdefault
nextcheck:
	movw	$0x4680,%ax
	int	$0x2f		 # multiplexer
	cmpb	$0x080,%al
	je	nowindows

wdefault:	       #      windows

windows:
	movb	$1,%al
	jmp	fin

nowindows:
	xorb	%al,%al
fin:
	popl  %esi
	popl  %edi
	popl  %edx
	popl  %ecx
	popl  %ebx
	ret








.equ	 x,	 8
.equ	 y,	 12
.equ	 len,	 16
.equ	 color,  20
.equ	 buf,	 24
.equ	 buflen, 28

_pl_horline:
	pushl  %ebp
	movl   %esp,%ebp

	pusha
	pushw  %es

	xorl   %eax,%eax
   xorl   %ecx,%ecx

	pushw	%ds
	popw	%es

	movl	buf(%ebp),%edi

	movzwl	buflen(%ebp),%eax
	movzwl	y(%ebp), %edx
	mull	%edx
	movzwl	x(%ebp),%ebx
	addl	%ebx,%eax
	addl	%eax,%edi	     #ds:di target


	movb	color(%ebp),%al
	movb	%al,%ah
	movw	%ax,%bx
	shll	$16,%eax
	movw	%bx,%ax

	movw	len(%ebp),%cx
	movw	%cx,%bx 	#{ kai ston bx to mikos }
	andw	$3,%bx		#{ bx:=length mod 4 }

	shrw	$2,%cx		#{ cx: 㡦  diples ⥜ }
	testw	%cx,%cx
	jz    Hlinego1
	rep
	stosl			#{ ੜ cx ᨠ pixel }

Hlinego1:
	testw	%bx,%bx
	jz	Hlinego
	movw	%bx,%cx
	rep
	stosb
Hlinego:


	popw	%es
   popa
	popl	%ebp
	ret


.equ	 x,	 8
.equ	 y,	 12
.equ	 height, 16
.equ	 color,  20
.equ	 buf,	 24
.equ	 buflen, 28




_pl_verline:
	pushl	%ebp
	movl	%esp,%ebp

   pusha

   xorl  %eax,%eax

	movl	buf(%ebp),%edi

	movzwl	buflen(%ebp),%eax
	movzwl	y(%ebp), %edx
	mull	%edx
	movzwl	x(%ebp),%ebx
	addl	%ebx,%eax
	addl	%eax,%edi	     #ds:di target

	movb	color(%ebp),%al

	movzwl	 buflen(%ebp),%edx
	movw	 height(%ebp),%cx
vlinecolumn:
	testw	%cx,%cx
	jz	vlinexit
	movb	%al,(%edi)
	addl	%edx,%edi
	decw	%cx
	jmp	vlinecolumn
vlinexit:

   popa
   popl  %ebp
   ret





.equ	   fromp,  8
.equ	       l,  12
.equ	   clipl,  16
.equ	   cliph,  20
.equ	      sx,  24
.equ	      sy,  28
.equ	     tox,  32
.equ	     toy,  36
.equ	     buf,  40
.equ	  buflen,  44



_pl_thruclip:
   pushl   %ebp
   movl    %esp,%ebp

   pusha


	xorl  %eax,%eax

	movl  fromp(%ebp),%esi
	movl	buf(%ebp)  ,%edi


	movzwl	buflen(%ebp),%eax
	movzwl	toy(%ebp), %edx
	mull	%edx
	movzwl	tox(%ebp),%ebx
	addl	%ebx,%eax
	addl	%eax,%edi	     #ds:di target


	movzwl	l(%ebp),%eax
	movzwl	sy(%ebp),%edx
	mull	%edx
	movzwl	sx(%ebp),%ebx
	addl	%ebx,%eax
	addl	%eax,%esi	     #ds:si source


	xorl   %ebx, %ebx
	xorl   %edx, %edx

	movw	buflen(%ebp),%bx
	subw	clipl(%ebp),%bx
			      #bx:distep

	movw	l(%ebp),%dx
	subw	clipl(%ebp),%dx
			      #dx: sistep

thruverline:
	cmpw	$0,cliph(%ebp)
	jz	exitthru
	movw	clipl(%ebp),%cx

thruhorline:
	testw	%cx,%cx
	jz	exitthruhor
	movb	(%esi),%al
	testb	%al,%al
	jz	thruskip
	movb	%al,(%edi)
thruskip:
	incw	%edi
	incw	%esi
	decw	%cx
	jmp	thruhorline
exitthruhor:

	addl	%ebx,%edi
	addl	%edx,%esi
	decw	cliph(%ebp)
	jmp	thruverline
exitthru:


   popa
   popl  %ebp
	ret


.equ	   fromp,  8
.equ	       l,  12
.equ	   clipl,  16
.equ	   cliph,  20
.equ	      sx,  24
.equ	      sy,  28
.equ	     tox,  32
.equ	     toy,  36
.equ	     buf,  40
.equ	  buflen,  44



_pl_solidclip:
   pushl   %ebp
   movl    %esp,%ebp

   pusha
   pushw   %es

   pushw   %ds
   popw    %es

	xorl  %ecx,%ecx

	movl	fromp(%ebp),%esi
	movl	buf(%ebp)  ,%edi

	movzwl	buflen(%ebp),%eax
	movzwl	toy(%ebp), %edx
	mull	%edx
	movzwl	tox(%ebp),%ebx
	addl	%ebx,%eax
	addl	%eax,%edi	     #ds:di target

	movzwl	l(%ebp),%eax
	movzwl	sy(%ebp),%edx
	mull	%edx
	movzwl	sx(%ebp),%ebx
	addl	%ebx,%eax
	addl	%eax,%esi	     #ds:si source

	xorl	%edx,%edx
	xorl	%ebx,%ebx

	movw	buflen(%ebp),%bx
	subw	clipl(%ebp),%bx
			      #bx:distep

	movw	l(%ebp),%dx
	subw	clipl(%ebp),%dx
			      #dx: sistep

solidverline:
	cmpw	$0,cliph(%ebp)
	jz	   exitsolid
	movw	clipl(%ebp),%cx

	shrw	$1,%cx
	jnc	solidskip1
	movsb
solidskip1:
	shrw	$1,%cx
	jnc	solidskip2
	movsw
solidskip2:
	testw	%cx,%cx
	jz	solidskip3
	rep
	movsl
solidskip3:

	addl	%ebx,%edi
	addl	%edx,%esi
	decw	cliph(%ebp)
	jmp	solidverline
exitsolid:


   popw   %es
   popa
   popl  %ebp
   ret




.equ	     color,   8
.equ		 R,   12
.equ		 G,   16
.equ		 B,   20


_pl_setRGBcolor:
   pushl %ebp
   movl  %esp,%ebp

   pushw  %ax
   pushw  %dx


	movw	$0x03c8,%dx	   #pelwrite kataxoritis
	movb	color(%ebp),%al
	outb	%al,%dx
	incw	%dx		 # peldata
	movb	R(%ebp),%al
	outb	%al,%dx
	movb	G(%ebp),%al
	outb	%al,%dx
	movb	B(%ebp),%al
	outb	%al,%dx

   popw  %dx
   popw  %ax
   popl %ebp
	ret






