/*
 ** BETATRON high level library for platform and action arcade games.
 ** Copyright (C) 1997  Liouros Thanasis, liouros@hotmail.com
 **
 ** PLTIMER.CC: This file is part of the BETATRON library and can be used
 **             and/or distributed only under the terms of the GNU Library
 **             General Public License. See doc/readme.1st for details.
 */



#include "pltimer.h"
#include <dos.h>
#include <mem.h>
#include <dpmi.h>
#include <stdio.h>
#include <go32.h>
#include <conio.h>
#include "pldpmi.h"


volatile unsigned long pl_dtime[3]; // metavlites gia xronometrisi


// idiotikes metavlites
static char TimerInstalled=0;	  // 1 ean exei egktastathei kai 0 ean den exei
static float ActualHz=0.0;	       // pragmatiki sixnotita klisis diakopis xronometrou
static short alias_cs;



static __dpmi_paddr oldint08;	    // deiktis sto diaxeristi tou bios
volatile char pl_oldint08adr[6]; // to idio me to pano, xrisimopoieitai aplos gia na
				 // sigoureuto oti i domi den exei kena

volatile unsigned long pl_cyclesno;   // posoi kikloi PIT exoun perasei mexri tora
volatile unsigned long pl_timercount=0; // PIT counter
volatile void (*pl_timeruserhandler)();

extern "C" void pl_int08handler();
extern "C" void pl_int08handler_end();
extern "C" pl_int08handler_save_ds();   // selector (short)

float pl_getActualHz()	{ return ActualHz; };
long pl_getTimerCount() { return pl_timercount;};


/*
------------------------------------------------------------------------------
InitTimer:
 嫘   㩜 ⤘    
 H diakopi xronometrou tha kaleitai rate fores to deuterolepto
 opou  18.206497192<=rate<=1200
   delta   ᝜ 殢.
------------------------------------------------------------------------------
*/


short pl_inittimer(float rate, void (*userhandler)())
{
unsigned short counter;
__dpmi_paddr newint08;
short dataseg;
short cs_sel=_go32_my_cs();
short ds_sel=_go32_my_ds();

// { ⢜   rate 夘 ⩘  樠  皜   夘}

 if ( (rate<MINHz) || (rate>MAXHz) ) return 0;
 if (TimerInstalled) return 0; // den mporo na egkatastiso ton idi egkatestimeno handler


 pl_timercount = (unsigned long) ( PITHz / rate);
 if (pl_timercount >=65536L) counter=0; else counter=pl_timercount;

 ActualHz = PITHz / (float)pl_timercount;
 pl_cyclesno=0;

 pl_timeruserhandler=userhandler;
// { 驜   handler }


 if (__dpmi_get_protected_mode_interrupt_vector(8,&oldint08)==-1) return 0;
 *((short *)(pl_oldint08adr+4))=oldint08.selector;
 *((long *)(pl_oldint08adr))=oldint08.offset32;

  if ( (alias_cs=__dpmi_create_alias_descriptor(cs_sel)) == -1) return 0;
  movedata(ds_sel,(long)&ds_sel,alias_cs,(long)&pl_int08handler_save_ds,2);
  __dpmi_free_ldt_descriptor(alias_cs);


 // { ⩫  handler }
 asm("cli");
 newint08.selector=cs_sel;
 newint08.offset32=(long)pl_int08handler;
 if (__dpmi_set_protected_mode_interrupt_vector(8,&newint08)==-1)
 {
   asm("sti");
   return 0;
 }


 outportb(0x43,0x36);	// { counter 0, LSB first then MSB, square wave, binary counter }
 asm("jmp 0");
 outportb(0x40,counter & 255);
 asm("jmp 0");
 outportb(0x40,counter >> 8);

// {  ⦪ handler ⮜  }
 TimerInstalled=1;

 lock_region(ds_sel,(void *)pl_dtime,sizeof(pl_dtime));
 lock_region(ds_sel,(void *)&pl_timeruserhandler,4);
 lock_region(ds_sel,(void *)&pl_cyclesno,4);
 lock_region(ds_sel,(void *)&pl_timercount,4);
 lock_region(ds_sel,(void *)pl_oldint08adr,6);
 lock_region(cs_sel,(void *)pl_int08handler_save_ds,(long)pl_int08handler_end - (long)pl_int08handler_save_ds);

 asm("sti");
 return 1;
};






/*{
------------------------------------------------------------------------------
TimerDone:
    ⩫  inittimer  
 . ᢢ ⨜  櫞 㩞  
⫨  18.2 hertz
------------------------------------------------------------------------------
}*/

short pl_timerdone()
{
 short cs_sel=_go32_my_cs();
 short ds_sel=_go32_my_ds();

// {   ៞ ⦪ handler 櫜 皜 }
 if (!TimerInstalled) return 0;

// { ⩫    handler }
 asm("cli");
 if (__dpmi_set_protected_mode_interrupt_vector(8,&oldint08)==-1)
 {
   asm("sti");
   return 0;
 }


 unlock_region(ds_sel,(void *)pl_dtime,sizeof(pl_dtime));
 unlock_region(ds_sel,(void *)&pl_timeruserhandler,4);
 unlock_region(ds_sel,(void *)&pl_cyclesno,4);
 unlock_region(ds_sel,(void *)&pl_timercount,4);
 unlock_region(ds_sel,(void *)pl_oldint08adr,6);
 unlock_region(cs_sel,(void *)pl_int08handler_save_ds,(long)pl_int08handler_end - (long)pl_int08handler_save_ds);


// { 矣   櫞  ⫨  18.2 hertz }

 outportb(0x43,0x36);	// { counter 0, LSB first then MSB, square wave, binary counter }
 asm("jmp 0");
 outportb(0x40,0);
 asm("jmp 0");
 outportb(0x40,0);

// { o  handler ⮜  }
 TimerInstalled=0;
 ActualHz=0;
 pl_timercount=0;
 pl_timeruserhandler=NULL;
 asm("sti");
 return 1;
};



